<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:44 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007862: Allow trait classes and multiple inheritance - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Ext Pack: Object-oriented features (ES 203 790)</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007862</td><td class="print">Ext Pack: Object-oriented features (ES 203 790)</td><td class="print">[All Projects] General</td><td class="print">public</td><td class="print">26-08-2019 12:58</td><td class="print">28-12-2020 13:04</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">V1.2.1 (published 2020-05)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">V1.3.1 (ongoing)</td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007862: Allow trait classes and multiple inheritance</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">A trait class is a form of abstract class that can not be created but only extended. It can only extend other trait classes.<br />
<br />
A normal class should be allowed to extend a list of trait classes beside its superclass. It inherits all members from all the trait classes it extends.<br />
<br />
If a class extends two classes which both provide a member with the same name, that member shall be inherited from the same *defining* class (the most concrete extended class defining or overriding that member). If a trait and a class both need to access the same field, that field shall be inherited from the same defining trait class.<br />
<br />
Fields of trait classes shall not have an initializer. Trait classes also do not have a constructor.<br />
<br />
Example:<br />
<br />
external function newGlobalId() return charstring;<br />
<br />
type class @trait Identifiable {<br />
&#160;&#160;private var charstring id;<br />
&#160;&#160;public function setId(charstring id) { <br />
&#160;&#160;&#160;&#160;this.id := id; <br />
&#160;&#160;}<br />
<br />
&#160;&#160;public function getId() return charstring {<br />
&#160;&#160;&#160;&#160;return id;<br />
&#160;&#160;}<br />
}<br />
<br />
type class MyIdentifiableClass extends Identifiable {<br />
&#160;&#160;create(charstring id) {<br />
&#160;&#160;&#160;&#160;setId(id);<br />
&#160;&#160;}<br />
}<br />
<br />
var Identifiable v_idObj := MyIdentifiableClass.create(&quot;1&quot;);<br />
var charstring v_id := v_idObj.getId();<br />
<br />
Example 2: parallel inheritance<br />
<br />
type class @trait A {<br />
&#160;&#160;function @abstract f();<br />
}<br />
<br />
type class @trait B {<br />
&#160;&#160;function @abstract f(); <br />
}<br />
<br />
type class C extends A, B {<br />
&#160;&#160;// illegal, as it inherits A.f() and B.f()<br />
}<br />
<br />
type class @trait B2 extends A {}<br />
<br />
type class C2 extends A, B2 { // legal, as it inherits only A.f()<br />
&#160;&#160;function f() { ... }<br />
}<br />
<br />
type class C3 extends A {<br />
&#160;&#160;function f() { ... }<br />
}<br />
<br />
type class D extends C2, C3 {<br />
&#160;&#160;// illegal, as it inherits C2.f() and C3.f()<br />
}</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7862.docx (146,209) <span class="italic">28-08-2019 12:10</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3862&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7862-2.docx (167,362) <span class="italic">28-08-2019 13:51</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3863&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7862-3.docx (148,469) <span class="italic">28-08-2019 14:17</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3864&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7862-4.docx (148,365) <span class="italic">07-10-2020 12:26</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3957&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7862-5.docx (148,418) <span class="italic">07-12-2020 13:18</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3966&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7862-6.docx (149,147) <span class="italic">09-12-2020 19:11</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3983&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">26-08-2019 12:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">26-08-2019 12:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">26-08-2019 12:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">26-08-2019 14:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; new</td></tr><tr class="print"><td class="print">27-08-2019 09:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0015466</td><td class="print"></td></tr><tr class="print"><td class="print">27-08-2019 11:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015469</td><td class="print"></td></tr><tr class="print"><td class="print">27-08-2019 12:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015470</td><td class="print"></td></tr><tr class="print"><td class="print">27-08-2019 14:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015477</td><td class="print"></td></tr><tr class="print"><td class="print">27-08-2019 14:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">28-08-2019 12:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7862.docx</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2019 12:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015482</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2019 12:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0015484</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2019 12:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015485</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2019 12:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">28-08-2019 12:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">28-08-2019 13:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0015487</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2019 13:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7862-2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2019 13:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015488</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2019 13:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Kristof.Szabados</td></tr><tr class="print"><td class="print">28-08-2019 14:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">File Added: CR7862-3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2019 14:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0015489</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2019 14:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Assigned To</td><td class="print">Kristof.Szabados =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">28-08-2019 14:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">28-08-2019 14:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">28-08-2019 14:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015490</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2019 14:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">17-12-2019 11:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; KristÃ³f Szabados</td></tr><tr class="print"><td class="print">17-12-2019 11:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">18-12-2019 07:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0015565</td><td class="print"></td></tr><tr class="print"><td class="print">18-12-2019 11:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015578</td><td class="print"></td></tr><tr class="print"><td class="print">18-12-2019 11:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0015580</td><td class="print"></td></tr><tr class="print"><td class="print">18-12-2019 11:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">KristÃ³f Szabados =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">14-08-2020 11:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; KristÃ³f Szabados</td></tr><tr class="print"><td class="print">06-10-2020 13:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">KristÃ³f Szabados =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">06-10-2020 13:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0015761</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2020 12:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7862-4.docx</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2020 12:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015774</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2020 12:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Kristof.Szabados</td></tr><tr class="print"><td class="print">07-10-2020 12:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">08-10-2020 13:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0015780</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2020 13:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Assigned To</td><td class="print">Kristof.Szabados =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">08-10-2020 13:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">08-10-2020 13:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">08-10-2020 15:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015784</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2020 15:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015785</td><td class="print"></td></tr><tr class="print"><td class="print">07-12-2020 13:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7862-5.docx</td><td class="print"></td></tr><tr class="print"><td class="print">07-12-2020 13:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; new</td></tr><tr class="print"><td class="print">07-12-2020 13:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015797</td><td class="print"></td></tr><tr class="print"><td class="print">07-12-2020 13:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">07-12-2020 13:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">new =&gt; confirmed</td></tr><tr class="print"><td class="print">09-12-2020 08:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015819</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2020 08:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; KristÃ³f Szabados</td></tr><tr class="print"><td class="print">09-12-2020 19:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">File Added: CR7862-6.docx</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2020 19:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0015828</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2020 19:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0015829</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2020 19:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Assigned To</td><td class="print">KristÃ³f Szabados =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">09-12-2020 19:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">10-12-2020 07:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015832</td><td class="print"></td></tr><tr class="print"><td class="print">10-12-2020 07:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">10-12-2020 07:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">10-12-2020 09:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0015839</td><td class="print"></td></tr><tr class="print"><td class="print">10-12-2020 09:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">10-12-2020 09:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">10-12-2020 09:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">17-12-2020 16:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">17-12-2020 16:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Product Version</td><td class="print"> =&gt; V1.2.1 (published 2020-05)</td></tr><tr class="print"><td class="print">17-12-2020 16:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; V1.3.1 (ongoing)</td></tr><tr class="print"><td class="print">28-12-2020 13:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015466)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-08-2019 09:41&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				so multiple extension is only allowed for extending trait classes, and this extension behaves as a copy-paste of the trait's content, right?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015469)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-08-2019 11:59&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I would consider it more as a sort of flattening where first you flatten the definition of each extended class (keeping track of the original class of each member) and then merge the resulting class bodies of the flattened classes into one effective superclass while removing duplicates that come from the same (non-flattened) class body.<br />
<br />
type class @trait A {<br />
&#160;&#160;var integer a;<br />
}<br />
<br />
type class @trait B {<br />
&#160;&#160;var integer b;<br />
}<br />
<br />
type class @trait C {<br />
&#160;&#160;var integer c;<br />
}<br />
<br />
type class @trait D extends B, C {<br />
}<br />
<br />
==&gt; D is the same (ignoring subtyping) as:<br />
<br />
type class @trait D {<br />
&#160;&#160;var integer a; // a is inherited via B and C, but only added once!<br />
&#160;&#160;var integer b;<br />
&#160;&#160;var integer c;<br />
}			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015470)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-08-2019 12:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				flattened B:<br />
<br />
type class @trait B {<br />
&#160;&#160;var integer a; [from A]<br />
&#160;&#160;var integer b; [from B]<br />
}<br />
<br />
flattened C:<br />
<br />
type class @trait C {<br />
&#160;&#160;var integer a; [from A]<br />
&#160;&#160;var integer c; [from C]<br />
}<br />
<br />
If we now add a class C2:<br />
<br />
type class @trait C2 {<br />
&#160;&#160;var integer c;<br />
}<br />
<br />
then <br />
<br />
type class @trait D2 extends C, C2 {<br />
}<br />
<br />
would result in a flattened class:<br />
<br />
type class @trait D2 {<br />
&#160;&#160;var integer a; [from A]<br />
&#160;&#160;var integer c; [from C]<br />
&#160;&#160;var integer c; [from C2]<br />
}<br />
<br />
which is illegal (it has c from C and C2)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015477)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-08-2019 14:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussions: maybe not allow fields in trait classes			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015482)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2019 12:20&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have uploaded a proposal.<br />
<br />
I have kept the possibility of fields (as the same problem already occurs with components and the same solution can be used).<br />
<br />
I also relaxed the parallel inheritance restriction somewhat insofar that if you inherit from one class A function A.f() and from another class you inherit B.f() which overrides A.f() (directly or indirectly) through extension, then this shall also be allowed.<br />
<br />
Consider the following rather typical scenario.<br />
<br />
type class @trait HasX {<br />
&#160;&#160;function @abstract getX() return integer;<br />
}<br />
<br />
type class @abstract A extends HasX {<br />
&#160;&#160;// implementation using getX()<br />
} <br />
<br />
type class @trait HasXImpl {<br />
&#160;&#160;var integer x;<br />
&#160;&#160;function getX() return integer {<br />
&#160;&#160;&#160;&#160;return x;<br />
&#160;&#160;}<br />
}<br />
<br />
type class AImpl extends A, HasXImpl {<br />
&#160;&#160;// inherits only HasXImpl.getX() because it overrides HasX.getX()<br />
&#160;&#160;create(integer x) {<br />
&#160;&#160;&#160;&#160;this.x := x;<br />
&#160;&#160;}<br />
}<br />
<br />
So, one version of an implementation can only 'win' over another if there is a clear overriding relationship between them (which can be established via topological sorting).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015484)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2019 12:29&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Shouldn't HasXImpl extend HasX for this to work?<br />
Now they are just 2 classes that happen to have functions with the same name.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015485)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2019 12:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015487)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2019 13:32&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The wording is a bit strange now.<br />
in 5.1.1.0 the new J restriction sounds like saying no 2 (even unrelated) classes can have fields with the same name (the same extending class would have to extend both classes for this to be problem, even then it would not be a problem with the fields, but the extension).<br />
<br />
restriction k sounds like implying a direct extension tree.<br />
<br />
restriction m is saying that each class can be extended only once (which not be very useful)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015488)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2019 13:53&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I made changes to the revisions j, k and m. Please review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015489)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2019 14:20&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added a note on the not so obvious way of making a backward incompatible change, please check.<br />
<br />
The rest of the text is fine, but maybe we should sleep on it to see if we can come up with a wording, that is not suggesting multiple inheritance support this much.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015490)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2019 14:40&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The note added by Kristof is fine. The proposal can be added to the specification, but since Kristof suggests postponing, I won't mark it as resolved yet.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015565)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-12-2019 07:41&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				To me the current text still sounds very much like a normal multiple inheritance feature, which we aggreed to not have as a general guideline in the beginning.<br />
<br />
Ok it is cumbersome for a multiple-inheritance, since one has to write his own initializer functions, and create some &quot;dummy&quot; class on the top of the hierarchy to be able to instantiate it ... yet it still is multiple-inheritance.<br />
<br />
Or I might miss some part that forbids this kind of understanding and emphasizes flattening.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015578)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-12-2019 11:10&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Yes, it is multiple inheritence but much more restrictive than C++ multiple inheritance, avoiding diamond problems and clashing definitions. <br />
<br />
Also, the general guidelines in the beginning were (as far as I remember) meant for the first version of the OO feature where we explicitly kept the possibility of multiple inheritance open, so I don't understand why this is relevant for this additional OO feature.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015580)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-12-2019 11:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion: It was agreed that some sort of multiple inheritance should be supported. The concrete implementation, e.g., interfaces or trait classes or something else, need to be discussed in 2020.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015761)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				06-10-2020 13:54&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF decision: Only JAVA-like interfaces without defaults.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015774)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-10-2020 12:27&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				updated with the agreed-on restrictions, please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015780)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2020 13:28&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Some notes:<br />
1)<br />
&quot;adding a new overriding function to an existing normal or trait class is semantically valid in its own context&quot;<br />
What is the purpose of a trait class overriding a function of an other trait class?<br />
As neither can have bodies, this sounds questionable.<br />
<br />
2)<br />
Other than the previous question why would it be non-backward compatible if a normal class extends two independend trait classes, that are added new overriding functions?<br />
As these functions can not have bodies, and have the same signature, if this repetition/oberriding is allowed, it just repeats that the extending normal classes have to have a function with that signature.<br />
<br />
3)<br />
&quot;type class C2 extends A, B2 { // legal, as it inherits only B2.f()&quot;<br />
and<br />
&quot;type class E extends A, C2 {<br />
&#160;&#160;// legal, it does not inherit A.f() as this is overriden by C2.f()<br />
&quot;<br />
It is actually not trivial. While I could agree it is not trivial why inheriting via 2 different inheritance trees of trait classes is allowed. As far as I understand the reason, is that both inheritance trees in the end define that there must be a function with that signature in the extending normal class, and none of the functions in the trait classes has bodies. As such it might be better to say, that it is legal since both traits being extended require the presence of a function with the exact same signature and there is no normal class extended.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015784)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2020 15:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				1) is for future expansion of the trait concept, if both traits add the same function, this shall be a clash, so one needs to override the other. <br />
<br />
But, of course, we could remove that restriction for now, would also need to be done in the example.<br />
<br />
I don't understand question 2.<br />
<br />
3) is in essence also to avoid confusion, if you inherit two functions of the same name from different sources, you would have to check whether they have the same parameters. With this, you can only inherit it from one source, so the question of comparison side-by-side inherited things becomes moot.<br />
<br />
Again, we can also remove this, it will have to be re-added once we allow trait-members with bodies, though.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015785)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2020 15:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Adding functions to traits is potentially non-backward compatible as it cannot be assured that all classes inheriting the trait directly or indirectly already implement that new function. Even if you implement it in all classes that are under your control, some other source can have used a class implementing the former version of the trait and not implement the new function. Thereby, you are potentially breaking the using code.<br />
<br />
Same is true for adding any members in any class (even private), as you can never know if a subclass already has a member of that name and thus would be broken by your change. This is normal, except for private members.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015797)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-12-2020 13:20&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have removed the trait-related restrictions not necessary for only-interface-traits and changed the examples accordingly. Please review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015819)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-12-2020 08:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				It looks fine by me. It is quite restrictive at moment, but it is possible to add more complicated features (like non-abstract functions on the trait level) in the future.<br />
<br />
I have only two technical comments:<br />
1. Since the restrictions j and k were added in this proposal, I would not mark them as &quot;Void&quot;, but remove completely so that we won't accidentally add them to the standard.<br />
2. The note for the restriction k should be moved to the semantic rules.<br />
<br />
Kristof, you revised the previous versions of the proposed changes. Could you please check this one as well?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015828)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-12-2020 19:16&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				For the first point I have removed restriction j and k (that were changed to void.<br />
<br />
For the second point I have just removed the note as the situation described in it is not possible.<br />
The note said: ... &quot;if they also extend an other (possibly independent) trait that also overrides the same function but with different formal parameters or return clause&quot;<br />
<br />
This is not possible as section 5.1.1.7 declares:<br />
- &quot;A method inherited from a superclass can be overridden by the subclass by redefining a function of the same name and with the same formal parameter list.&quot;<br />
- &quot;The return type of an overriding function shall be the same as the return type of the overridden function with the same template restrictions and modifiers&quot;			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015829)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-12-2020 19:17&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please check the new version.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015832)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-12-2020 07:33&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Well, I think that what Jacob meant is that developers have to be careful when adding new methods to classes and traits if these are extended in other projects that are not under their control. You are right that it would produce an error. However, it is true only if the developer can compile the whole code and that's not always the case.<br />
<br />
The question is if we need this kind of note or not. From my point of view, it is not necessary because (as Kristof pointed out) there are clear rules for parameters and return values of methods whose name is present on a superclass or supertrait level. Jacob, could you please comment the note issue? If you don't insist on having it, I think it is possible to resolve the CR.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015839)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-12-2020 09:21&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion: Note should be added in a more prominent place. This CR is resolved with version 6 of the resolution.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
