<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:15:47 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007438: Templates with variable bindings. - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Ext Pack: Advanced Matching (ES 203 022)</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007438</td><td class="print">Ext Pack: Advanced Matching (ES 203 022)</td><td class="print">New Feature</td><td class="print">public</td><td class="print">31-05-2016 13:55</td><td class="print">24-12-2016 12:26</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v1.1.1 (published 2017-07)</td><td class="print-category">Fixed in Version</td><td class="print">v1.1.1 (published 2017-07)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">Advanced Matching Package</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Spirent - Jacob Wieland </td></tr><tr class="print"><td class="print-category">TS version</td><td class="print" colspan="4"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007438: Templates with variable bindings.</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">In function languages, it is customary to use patterns of constructed data types to define the parameters of functions. These patterns can contain unbound variables which will be bound if the pattern matches, so that they can be used on the right-hand-side of the definition.<br />
<br />
Since TTCN-3 already has a powerful pattern language available, it would be very useful to allow a similar variable binding as a side-effect of matching.<br />
<br />
We propose the following syntax:<br />
<br />
&lt;matching mechanism&gt; -&gt; &lt;variable&gt;<br />
<br />
in all places where in a template body a matching mechanism is allowed at the moment. <br />
<br />
For example:<br />
<br />
type record Pair { integer a, integer b }<br />
<br />
template Pair pair(out integer a, out integer b) := {<br />
&#160;&#160;a := ? -&gt; a,<br />
&#160;&#160;b := ? -&gt; b<br />
}<br />
<br />
var integer a, b;<br />
var Pair p := ...;<br />
if (match(p, pair(a,b))) { /* do something with a and b */ }<br />
<br />
Of course, the assignment syntax could also be used in an inline template, as long as the variables used are declared in the context of the inline template.<br />
<br />
if (match(p, Pair:{ ? -&gt; a, ? -&gt; b }) { /* same semantics as above */ }<br />
<br />
The variable would be assigned the value that matched the corresponding matching  mechanism iff the whole template body matches. The variable needs to be of the correct type, depending on the place of the matching mechanism inside the template body.<br />
<br />
For convenience, parameterized templates would be allowed to declare out parameters to be used for variable binding.<br />
<br />
A still open question is what should happen if a template has multiple ways of matching the value (as could, for instance, happen with { *, pair(a,b), * } in a record of Pair). As checking this condition can only be done at runtime and is normally much more expensive than searching for the first match, I propose to keep that ambiguous so that the result can be the assignment for ANY match, thus forcing the user to define the templates in a non-ambiguous way.<br />
<br />
Alternatively, a construct could be introduced which allows multiply applying the match operation with the same template (e.g. in a template variable) until no new matching is found:<br />
<br />
type record of Pair Pairs;<br />
var Pairs p := ...;<br />
var @match template Pairs t := { *, pair(a, b), * }; // this would be kind of a lazy definition<br />
while (match(p, t)) { /* do something with a and b */ }<br />
<br />
Of course, these kinds of templates could also be used in receive statements or anywhere else where templates for matching are allowed (i.e. select cases).<br />
<br />
If passed as an actual in parameter, the formal parameter should be declared with a @match modifier so that it is clear that this template can only be used for matching. A template variable that is declared with the @match operator can not be used to be assigned to a normal template variable or used as a return template.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/ppt.gif" alt="pptx" />&#160;Template-Inline-Redirect-Ideas-160722.pptx (30,328) <span class="italic">22-07-2016 13:36</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3435&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR-7438-Templates-with-variable-bindings-V1.docx (30,289) <span class="italic">15-11-2016 13:21</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3521&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR-7438-Templates-with-variable-bindings-V2.docx (41,461) <span class="italic">15-11-2016 16:39</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3526&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR-7438-Templates-with-variable-bindings-V3.docx (49,638) <span class="italic">16-11-2016 11:03</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3530&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR-7438-Templates-with-variable-bindings-V4.docx (49,739) <span class="italic">17-11-2016 10:10</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3549&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR-7438-Templates-with-variable-bindings-V5.docx (50,836) <span class="italic">18-11-2016 10:09</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3565&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">31-05-2016 13:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">31-05-2016 13:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Clause Reference(s)</td><td class="print">TBD =&gt; Advanced Matching Package</td></tr><tr class="print"><td class="print">31-05-2016 16:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Description Updated</td><td class="print">bug_revision_view_page.php?rev_id=291#r291</td></tr><tr class="print"><td class="print">18-07-2016 10:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0013974</td><td class="print"></td></tr><tr class="print"><td class="print">18-07-2016 10:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">18-07-2016 10:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">19-07-2016 16:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Ext Pack: Advanced Matching (ES 203 022)</td></tr><tr class="print"><td class="print">22-07-2016 13:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: Template-Inline-Redirect-Ideas-160722.pptx</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2016 11:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Target Version</td><td class="print"> =&gt; v1.1.1 (published 2017-07)</td></tr><tr class="print"><td class="print">15-11-2016 13:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR-7438-Templates-with-variable-bindings-V1.docx</td><td class="print"></td></tr><tr class="print"><td class="print">15-11-2016 13:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">15-11-2016 16:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR-7438-Templates-with-variable-bindings-V2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">15-11-2016 16:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014254</td><td class="print"></td></tr><tr class="print"><td class="print">15-11-2016 16:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">15-11-2016 16:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">16-11-2016 11:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">File Added: CR-7438-Templates-with-variable-bindings-V3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">16-11-2016 11:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0014260</td><td class="print"></td></tr><tr class="print"><td class="print">16-11-2016 11:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">16-11-2016 11:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">16-11-2016 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0014261</td><td class="print"></td></tr><tr class="print"><td class="print">16-11-2016 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">17-11-2016 10:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR-7438-Templates-with-variable-bindings-V4.docx</td><td class="print"></td></tr><tr class="print"><td class="print">17-11-2016 10:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014294</td><td class="print"></td></tr><tr class="print"><td class="print">17-11-2016 10:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">17-11-2016 10:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v1.1.1 (published 2017-07)</td></tr><tr class="print"><td class="print">17-11-2016 10:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">17-11-2016 10:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">18-11-2016 09:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014326</td><td class="print"></td></tr><tr class="print"><td class="print">18-11-2016 09:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">18-11-2016 09:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; assigned</td></tr><tr class="print"><td class="print">18-11-2016 10:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR-7438-Templates-with-variable-bindings-V5.docx</td><td class="print"></td></tr><tr class="print"><td class="print">18-11-2016 10:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014328</td><td class="print"></td></tr><tr class="print"><td class="print">18-11-2016 10:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">18-11-2016 10:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">24-12-2016 12:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013974)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-07-2016 10:25&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Candidate for &quot;Advanced Matching&quot; extension package.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014254)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-11-2016 16:39&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please do a preliminary review, this is still in the drafting stage, but please check whether everything is understandable			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014260)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-11-2016 11:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				some corrections, formatting and text additions			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014261)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-11-2016 11:05&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please use version 3 for further updates			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014294)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-11-2016 10:12&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have reviewed again and made some small wording changes to not confuse the match operation with a template match.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014326)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-11-2016 09:48&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				BNF rules have to be added.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014328)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-11-2016 10:10&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				added missing BNF changes part, please review and resolve			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
