<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:16:12 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007437: It should be possible to assign the variant of a union to a variable and use such variant values for union operations - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007437</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">31-05-2016 13:07</td><td class="print">14-11-2016 16:23</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">KristÃ³f Szabados</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">no change required</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.8.1 (published 2016-07)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.9.1 (published 2017-05)</td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">6.2.5, C.3.2</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Spirent - Jacob Wieland     </td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007437: It should be possible to assign the variant of a union to a variable and use such variant values for union operations</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Consider the following use case:<br />
<br />
type union U { ... }<br />
type record of U RU;<br />
<br />
template RU containsV := { *, { V := X }, *}<br />
<br />
At the moment, there is no easy way to access X or to write a function which<br />
gets the list and the variant V and produces the union value which has variant V.<br />
<br />
What can be envisioned could be something like this:<br />
<br />
function getElementOfVariant(RU list, U.variant v) return U {<br />
&#160;&#160;for (var integer i := 0; i &lt; lengthof(list); i:= i+1) {<br />
&#160;&#160;&#160;&#160;if (ischosen(list[i], v)) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;return list[i];<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
}<br />
<br />
Thus, U.variant would be an implicit enumerated type containing the enumerated values that are the variant names of the union type while the ischosen operation would be overloaded so that it can always take a pair of U and U.variant as actual parameters and check, whether the given variant is the one chosen in the union value/template. The ischosen would get the two items as separate parameters because both actual parameters can be arbitrarily complex dotted notations and using dot-notation to combine them would be ambiguous.<br />
<br />
The construct u.variant (where u is a union value of type U) could be used to actually get the variant from a union value (so u.variant is always of type U.variant iff u is of union type U).<br />
<br />
All other restrictions of enumerated types would apply to the variant type of a union type.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">All this can be done already by programming it explicitly, but needs to be done for every union type anew. The proposed feature would give the user a generic solution for this problem.</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">31-05-2016 13:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">18-07-2016 10:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; KristÃ³f Szabados</td></tr><tr class="print"><td class="print">18-07-2016 10:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">16-08-2016 14:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014110</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2016 11:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">17-08-2016 11:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Product Version</td><td class="print"> =&gt; v4.8.1 (published 2016-07)</td></tr><tr class="print"><td class="print">17-08-2016 11:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.9.1 (published 2017-05)</td></tr><tr class="print"><td class="print">13-11-2016 16:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0014224</td><td class="print"></td></tr><tr class="print"><td class="print">14-11-2016 03:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014225</td><td class="print"></td></tr><tr class="print"><td class="print">14-11-2016 03:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014226</td><td class="print"></td></tr><tr class="print"><td class="print">14-11-2016 16:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014232</td><td class="print"></td></tr><tr class="print"><td class="print">14-11-2016 16:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">14-11-2016 16:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; no change required</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014110)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-08-2016 14:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Because the .variant would clash with the attribute retrieval operation, we propose to use <br />
<br />
&lt;union_type&gt;.enumerated to signify the enumerated type of the union variants<br />
and<br />
&lt;union_value&gt;.present to evaluate to the enumerated value of the present variant<br />
<br />
The following rule applies:<br />
<br />
If u is of union type U, then u.present is of type U.enumerated.<br />
<br />
For the ischosen operation with two arguments, the restriction must be that the first argument must be a value of a union type U and the second argument must be of type U.enumerated.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014224)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-11-2016 16:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Can't the initial task be solved by something like this:<br />
function getElementOfVariant(RU list, template U v) return U {<br />
&#160;&#160;for (var integer i := 0; i &lt; lengthof(list); i:= i+1) {<br />
&#160;&#160;&#160;&#160;if (match(list[i],v)) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;return list[i];<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
&#160;&#160;return list[0];<br />
}<br />
...<br />
var RU containsV := { { field1 := 1 }, {field2 := &quot;something&quot;}};<br />
var U temp := getElementOfVariant(containsV, {field1 := ?});<br />
log(&quot;result: &quot;, temp);<br />
temp := getElementOfVariant(containsV, {field2 := ?});<br />
log(&quot;result: &quot;, temp);<br />
<br />
Where U is a union of an integer and charstring field			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014225)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-11-2016 03:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				true, also with the new template with out parameters, it would be even easier to get access to the actual value:<br />
<br />
if (match(l,{*,{field:=? -&gt; v},*})) { /* do something with v */ }			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014226)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-11-2016 03:46&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				so, in essence, I propose to drop this issue			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014232)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-11-2016 16:23&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				See discussion.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
