<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:15:47 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007167: Matching mechanism to match multiple items in arrays, records and sets of single types - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Ext Pack: Advanced Matching (ES 203 022)</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007167</td><td class="print">Ext Pack: Advanced Matching (ES 203 022)</td><td class="print">New Feature</td><td class="print">public</td><td class="print">07-09-2015 10:53</td><td class="print">24-12-2016 12:59</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Tomas Urban</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v1.1.1 (published 2017-07)</td><td class="print-category">Fixed in Version</td><td class="print">v1.1.1 (published 2017-07)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">B.1.3</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Elvior</td></tr><tr class="print"><td class="print-category">TS version</td><td class="print" colspan="4"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007167: Matching mechanism to match multiple items in arrays, records and sets of single types</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">I one of our projects we had an interesting problems with matching incoming messages. The message contained a record of complex record entries and one of the string fields of each record element was required to contain a certain pattern.<br />
<br />
We ended up with using a rather complicated solution containing a check procedure (for general acceptance), for-loop for element check and continue statement + some guards for flow control. <br />
<br />
However, it would be nice if TTCN-3 contained a matching mechanism that would allow to specify properties of SEVERAL record of, set of or array items. Such a mechanism would be generally similar to AnyElementsOrNone with that difference that it would impose additional restrictions on the element content. Similarly to the AnyElementsOrNone, it could be optionaly ammended with a length restriction.<br />
<br />
Possible syntactical solutions:<br />
The following type is used in examples:<br />
type record of record {<br />
&#160;&#160;&#160;integer field1,<br />
&#160;&#160;&#160;charstring field2<br />
} RoR;<br />
<br />
<br />
1. Extension of the AnyElementsOrNone mechanism:<br />
&#160;&#160;&#160;a. using the with keyword: <br />
&#160;&#160;&#160;&#160;&#160;&#160;{ <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// standard field match (fixed values)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;{ field1 := 3, field2 := pattern &quot;test&quot; }, <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// 0..N matches where field2 of each element has to start with &quot;abc&quot;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;* with { field1 := ?, field2 := pattern &quot;abc*&quot; } <br />
&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;b. using the pattern keyword:<br />
&#160;&#160;&#160;&#160;&#160;&#160;{ <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// standard field match (fixed values)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;{ field1 := 3, field2 := pattern &quot;test&quot; }, <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// 0..N matches where field2 of each element has to start with &quot;abc&quot;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;* pattern { field1 := ?, field2 := pattern &quot;abc*&quot; } <br />
&#160;&#160;&#160;&#160;&#160;&#160;}<br />
2. Using the any keyword:<br />
&#160;&#160;&#160;&#160;&#160;&#160;{ <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// standard field match (fixed values)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;{ field1 := 3, field2 := pattern &quot;test&quot; }, <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// 0..N matches where field2 of each element has to start with &quot;abc&quot;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;any { field1 := ?, field2 := pattern &quot;abc*&quot; } <br />
&#160;&#160;&#160;&#160;&#160;&#160;}<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5"><a href='tag_view_page.php?tag_id=1' title=''>technically agreed</a></td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007174</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></span>&#160;</td><td class="print">New matching mechanism: matching by function&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007494</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></span>&#160;</td><td class="print">TRI and TCI extensions for advanced matching&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7167-1.docx (170,009) <span class="italic">15-11-2016 14:49</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3523&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7167-2.docx (156,818) <span class="italic">17-11-2016 09:54</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3548&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">07-09-2015 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas Urban</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">07-09-2015 16:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0013193</td><td class="print"></td></tr><tr class="print"><td class="print">21-09-2015 10:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.8.1 (ongoing)</td></tr><tr class="print"><td class="print">21-09-2015 11:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Relationship added</td><td class="print">related to 0007174</td></tr><tr class="print"><td class="print">21-09-2015 11:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0013200</td><td class="print"></td></tr><tr class="print"><td class="print">21-09-2015 11:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0013200</td><td class="print">bug_revision_view_page.php?bugnote_id=13200#r167</td></tr><tr class="print"><td class="print">22-09-2015 09:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Tag Attached: technically agreed</td><td class="print"></td></tr><tr class="print"><td class="print">22-09-2015 09:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0013232</td><td class="print"></td></tr><tr class="print"><td class="print">22-09-2015 09:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">22-09-2015 09:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">23-09-2015 15:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0013275</td><td class="print"></td></tr><tr class="print"><td class="print">23-09-2015 15:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0013276</td><td class="print"></td></tr><tr class="print"><td class="print">23-09-2015 15:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">23-09-2015 15:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">03-11-2015 11:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0013466</td><td class="print"></td></tr><tr class="print"><td class="print">03-11-2015 11:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">v4.8.1 (ongoing) =&gt; Next version (to be defined)</td></tr><tr class="print"><td class="print">05-11-2015 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">Part 01: TTCN-3 Core Language =&gt; Ext Pack: Advanced Matching (ES 203 022)</td></tr><tr class="print"><td class="print">05-11-2015 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Product Version</td><td class="print">v4.7.1 (published 2015-06) =&gt; </td></tr><tr class="print"><td class="print">05-11-2015 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">Next version (to be defined) =&gt; v1.1.1 (published 2017-07)</td></tr><tr class="print"><td class="print">15-12-2015 10:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">18-07-2016 14:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; KristÃ³f Szabados</td></tr><tr class="print"><td class="print">20-07-2016 14:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">KristÃ³f Szabados =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">15-08-2016 13:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">15-11-2016 14:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7167-1.docx</td><td class="print"></td></tr><tr class="print"><td class="print">15-11-2016 14:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014251</td><td class="print"></td></tr><tr class="print"><td class="print">15-11-2016 14:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">15-11-2016 14:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">16-11-2016 14:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Relationship added</td><td class="print">related to 0007494</td></tr><tr class="print"><td class="print">17-11-2016 09:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7167-2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">17-11-2016 09:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">17-11-2016 09:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014290</td><td class="print"></td></tr><tr class="print"><td class="print">17-11-2016 09:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">17-11-2016 09:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">17-11-2016 12:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">17-11-2016 12:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">24-12-2016 12:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">24-12-2016 12:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v1.1.1 (published 2017-07)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013193)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-09-2015 16:23&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Obviously, every idea has its time. I have been pondering the same problem for a while and wanted to propose some sort of repeat-statement (where * is just a very special repeat of ? with no length restriction.<br />
<br />
Ideas of mine were:<br />
<br />
A * [length(L..U)] (where A is a matching mechanism) - similar to BNF<br />
<br />
or<br />
<br />
A repeat [length(L .. U)]<br />
<br />
or <br />
<br />
repeat (A1, ..., An) [length(L .. U)]<br />
<br />
<br />
The existing AnyElementsOrNone (*) would then just be a shorthand of ? * (or the other ways). <br />
<br />
We could also borrow the #-repetition from the pattern-language (to have in-language-familiarity for similar constructs), i.e.<br />
<br />
A # ([lower], [upper]) with A #(,) being the same as A*.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013200)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				21-09-2015 11:49&#160;&#160;&#160;
				<br />(edited on:&#32;21-09-2015 11:50)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				alternatively repetition of a template element could be allowed, like:<br />
<br />
{{field1 := 3, field2 := pattern &quot;test&quot; }} this will match a record/set of with one element only<br />
<br />
{{ field1 := 3, field2 := pattern &quot;test&quot;} length(0..infinity)} this will match a record/set of with any number of elements, each obeying the inline template.<br />
<br />
Please note, the syntax is already allowed, in this case we need to amend only the text in clause B.1.4.1, especially Restriction a).<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013232)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-09-2015 09:38&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion: to specify repetitions of record/set of elements we shall reuse the #(n,m) [#(), #(n,)...) syntax from patterns. This will be language consistent and also allows defining different &quot;subsets&quot; of element repetitoons within a list. Exanmples of the syntax to be prepared for te different cases, e.g. record of record of record, combinations with length() etc.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013275)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				23-09-2015 15:15&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Syntactical Structure shall be:<br />
<br />
ArrayElementSpec ::= Minus | <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;PermutationMatch | <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TemplateBody [Repetition]<br />
<br />
Repetition ::= &quot;#&quot; &quot;(&quot; [SingleExpression] [&quot;,&quot; [SingleExpression]] &quot;)&quot;  <br />
<br />
If Repetition is present, the TemplateBody must be of the same root record of type as the surrounding template (i.e. if it is of root type record of T, the repeated template must also be of root type record of T).<br />
<br />
This allows (for the Repetition part): <br />
#() - 0 .. infinity, <br />
#(x) - x .. x,<br />
#(x,) - x .. infinity,<br />
#(x,y) - x .. y,<br />
#(,y) - 0 .. y,<br />
#(,) - 0 .. infinity (if we want to exclude this possibility, the rule becomes more complicated)<br />
<br />
The special BNF constructs {}, [] and {}+ can be modeled with #(), #(,1) and #(1,) respectively.<br />
<br />
EXAMPLE:<br />
<br />
type record of T S;<br />
template T a, b, c;<br />
template S s1 := { a, b, c }<br />
template S s2 := { permutation(a, *, c) length(5) }<br />
var integer x, y;<br />
<br />
template S t1 := { {a, b, c} #(x,y) } <br />
// matches any record of repeating elements matching a, b, c consecutively<br />
// for at least x, at most y times.<br />
<br />
template S t2 := { s1 #(x,y) } // same as t1<br />
<br />
template S t3 := { { (a, b, c) } # (x) } <br />
// matches any repetition of length x where each element conforms to <br />
// (a, b, c) (i.e. a or b or c).<br />
<br />
template S t4 := { (s1, s2) #(x,y) } <br />
// matches a sequence that can be partitioned into x up to y <br />
// sub-sequences where each sub-sequence matches s1 or s2.<br />
<br />
template S t5 := { p, {s1 #(0,1), s2 #(1,)} #(x), q } <br />
// matches a record of where first element matches p, <br />
// then is followed by a repetition of length x of a <br />
// repetition of an optional s1-sub-sequence followed by <br />
// a non-empty repetition of s2-sub-sequences and finally followed by <br />
// an element matching q.  <br />
<br />
template S t6 := { s1 &amp; s2 #(5) }<br />
// matches a record of which can be partititioned into 5 sub-sequences<br />
// where each-sub-sequence matches the concatenation-template s1 &amp; s2.<br />
<br />
As we can see, it is very easy to compose such templates from other templates and to combine it with existing matching mechanisms.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013276)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				23-09-2015 15:27&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please review examples in my last note			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013466)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-11-2015 11:58&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				To be part of the new extension on advanced matching mechanisms.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014251)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-11-2016 14:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Proposal uploaded. Please check.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014290)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-11-2016 09:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please review.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
