<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:09 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006793: Value Interface is underspecified/inconsistent for Templates - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 06: TTCN-3 Control Interface</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006793</td><td class="print">Part 06: TTCN-3 Control Interface</td><td class="print">Clarification</td><td class="print">public</td><td class="print">27-08-2014 13:15</td><td class="print">17-12-2014 11:43</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Tomas Urban</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">high</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">N/A</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.7.1 (published 2015-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.7.1 (published 2015-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">7.2.</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technologies - Jacob Wieland</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006793: Value Interface is underspecified/inconsistent for Templates</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">In section 7.2 of the TCI standard, the value interface is introduced for the purpose of encoding and decoding:<br />
<br />
&quot;The TCI specification defines a set of abstract data types. These describe, at a very high level, which kind of data shall be passed from a calling to a called entity. The abstract data types are used to determine:<br />
•<br />
how TTCN-3 data is passed from a TE to an encoder, to encode TTCN-3 value representations into a bitstring;<br />
and in the reverse case;<br />
•<br />
how data passed from a decoder to the TE shall be decoded from a bitstring into its TTCN-3 value<br />
representation&quot;<br />
<br />
In section 7.2.2 it is stated:<br />
<br />
&quot;The abstract TTCN-3 type and value representation consists of two parts:<br />
•<br />
an abstract data type<br />
Type<br />
that represents all TTCN-3 types in a TTCN-3 module;<br />
•<br />
different abstract data types that represent TTCN-3 values, i.e. TTCN-3 values of a given TTCN-3 type. This<br />
can be either values of TTCN-3 predefined types or of TTCN-3 user-defined types.&quot;<br />
<br />
This suggests that only value instances (not templates) are to be handled via these interfaces (and neglects the fact that templates can also be passed to external functions as parameters).<br />
<br />
In section 7.2.2.2. however, two additional non-mandatory functions are introduced (I guess this was added later) that contradict the above statement:<br />
<br />
&quot;In addition,<br />
Value<br />
can be used to represent matching mechanisms, which are used instead or inside values e.g. in<br />
template parameters or for template variables. Two additional operations:<br />
isMatchingSymbol<br />
(returns true for<br />
matching symbols) and<br />
valueToString (<br />
for printing value content in the same way as the log operation; can be<br />
used for displaying value content) are defined. These operations are not mandatory - it is up to a tool vendor to support<br />
them or not&quot;<br />
<br />
The following definitions in section 7.2.2.2 of methods on Values (except the two just mentioned) all seem to take the first statement for granted, i.e. that they are invoked on TTCN-3 values only. <br />
<br />
For instance, the semantics of the function getField() in section 7.2.2.2.11 is defined using the term length which is only defined for values and for omit (if taken from the function getLength()). Therefore, in our opinion, the term length for templates is unspecified. Several interpretations are possible, but are not specifically stated by the standard.<br />
<br />
Other functions for accessing parts of values (i.e. in string-values and especially in numeric-types) are also unspecified for Templates. <br />
<br />
A clarification of these inconsistencies/underspecifications would be helpful.<br />
<br />
For backward compatibility for our customers, we would favor the interpretation that getLength() for a list-value-notation template should give the number of items in the notation and getField(i) should give back the item at the given position i, even if items up to i are AnyElementsOrNone or Permutation which would count as a single item in regard to position. Though this would not be consistent with the lengthof() function and the index-notation in the TTCN-3 core language, it would be helpful for exploring such templates. (Otherwise, another way of exploration should be added to the standard).<br />
<br />
As already stated in CR 6448, a better template interface for exploring (or even building) templates (other than isMatchingSymbol and valueToString) is still needed. <br />
<br />
If the above interpretation for getLength() and getField() of RecordOfValue is not possible and the Value interface (except isMatchingSymbol and valueToString) shall only be applicable for actual TTCN-3 values and not templates, then it should at least be stated so specifically to avoid future misinterpretations.<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0006448</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">Part 01: TTCN-3 Core Language&#160;</td><td class="print">Rules for external function parameters&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0006812</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></span>&#160;</td><td class="print">Part 06: TTCN-3 Control Interface&#160;</td><td class="print">Abstract data classes for matching mechanisms&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR6793_v1.docx (49,652) <span class="italic">07-10-2014 14:41</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3097&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR6793_v2.docx (50,105) <span class="italic">08-10-2014 16:05</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3118&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">27-08-2014 13:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">27-08-2014 13:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0006448</td></tr><tr class="print"><td class="print">06-10-2014 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0012223</td><td class="print"></td></tr><tr class="print"><td class="print">06-10-2014 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">06-10-2014 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">07-10-2014 14:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR6793_v1.docx</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2014 14:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0012254</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2014 14:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">07-10-2014 14:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">07-10-2014 16:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0012261</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2014 08:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0012264</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2014 08:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">08-10-2014 08:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0012266</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2014 15:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0012288</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2014 16:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR6793_v2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2014 16:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0012293</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2014 16:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">08-10-2014 16:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0012305</td><td class="print"></td></tr><tr class="print"><td class="print">09-10-2014 09:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">09-10-2014 09:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">09-10-2014 09:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">09-10-2014 09:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.7.1 (published 2015-06)</td></tr><tr class="print"><td class="print">05-11-2014 15:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Relationship added</td><td class="print">related to 0006812</td></tr><tr class="print"><td class="print">17-12-2014 11:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0012561</td><td class="print"></td></tr><tr class="print"><td class="print">17-12-2014 11:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012223)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				06-10-2014 10:53&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				For checking the problem.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012254)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-10-2014 14:44&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think there's a misunderstanding in the interpretation of the rules added to TCI specification ver. 4.5.1. The dedicated abstract data types (such as RecordOfValue) were never intended to manipulate with matching mechanisms. So your assumption that &quot;the definitions in section 7.2.2.2 of methods on Values (except the two just mentioned) all seem to take the first statement for granted, i.e. that they are invoked on TTCN-3 values only&quot; is absolutely correct.<br />
<br />
The whole idea was that the data objects representing matching mechanisms are instances of the base Value abstract data type and never instances of the dedicated abstract data types, i.e. whenever the isMatchingSymbol operation returns true, the object cannot be cast to the dedicated abstract data type.<br />
<br />
This is a lightweight solution addressing the issue that there was absolutely no mechanism for representing templates occurring in parameters etc. I agree with you that a fully fledged framework for getting and modifying all possible properties of matching mechanisms would be needed, however it hasn't been so far implemented because of time constraints.<br />
<br />
In the attached proposal, I only addressed the issue raised in the CR and added some rules that leave less space for distinct interpretations. I assign the problem to György for cross-checking and I would like to hear your comments Jacob as well.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012261)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-10-2014 16:10&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have a problem with this NOTE: <br />
<br />
&quot;Constructive values such as records, sets, records of, sets of, arrays, unions and anytype values might contain a matching mechanism in one of their elements and still return false. In this case, it is always possible to use the dedicated abstract data type operations to access individual elements of the constructive value.&quot;<br />
<br />
It contradicts the preceding definition:<br />
<br />
&quot;... returns true if ...&quot; <br />
&quot;It is a record of, set of or array value containing a matching mechanism specified in clauses B.1.3.2 or B.1.3.3 of ES 201 8731 [1] in one of its elements&quot;<br />
<br />
Also, since the only specified way for accessing parts of RecordOfValue is the getField method which is dependent on the length, how is the semantics of length and getField for such a template-instance, e.g. if there is a AnyElementsOrNone in the list. It clearly must be different from the semantics of lengthof() and the index-notation (which are undefined in that case). This would have to be specified.<br />
<br />
Thus, I would either strike that NOTE or we need further specification.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012264)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2014 08:13&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Pls. check Jacob's comment.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012266)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2014 08:59&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				What contradiction do you see there? Could you please be more specific, because I couldn't find any.<br />
<br />
B.1.3.2 describes AnyElementsOrNone and B.1.3.3 describes permutation. As you know, a whole set of complicated rules is then used in the core language standard for length calculations and element access. The current TCI avoid these rules. According to the specification, the RecordOfValue and SetOfValue data types cannot be used for records of, sets of and arrays containing the mentioned matching mechanisms. Only the general Value data type is granted for these templates. This means that element access is not possible in these cases at all, because there's never an instance with a getField method.<br />
<br />
However, records of, sets of and arrays containing other matching mechanisms in their elements (e.g. AnyElement, range, pattern etc.) can be represented by a RecordOfValue and SetOfValue instance as there are no side effects on the length calculation and field access. And this is exactly the situation the note describes.<br />
<br />
Example:<br />
type record of integer RoI;<br />
template RoI m_t1 := { 1, * }; <br />
// cannot be transformed to RecordOfValue, because it contains AnyElementsOrNone<br />
// transformed to Value, isMatchingSymbol returns true<br />
template RoI m_t2 := { 2, ?, 6}<br />
// can be transformed to RecordOfValue, isMatchingSymbol returns false<br />
// RecordOfValue.getField(0) returns an IntegerValue instance<br />
// RecordOfValue.getField(1) returns a Value instance with isMatchingSymbol<br />
// returning true			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012288)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2014 15:46&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Ah, I didn't catch the restriction to clauses B.1.3.2 and B.1.3.3 (maybe that should be spelled out to AnyElementsOrOne and Permutation)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012293)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2014 16:07&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I added a new version of the proposal that contains names of the concerned matching mechanisms too. I hope it helps to increase readability of the rules.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012305)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2014 16:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Thanks, much more readable.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012561)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-12-2014 11:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added to the TCI specification draft 4.6.2.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
