<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:20 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006623: Allow lazy evaluation. - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006623</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">07-10-2013 11:51</td><td class="print">07-02-2014 06:38</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">high</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">N/A</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">5.4.1, 11, 15, 16</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technologies - Jacob Wieland</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006623: Allow lazy evaluation.</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Lazy expression/function application evaluation which delays the evaluation of an expression until its actual usage can have any number of applications.<br />
<br />
In security testing there is a concept called fuzzing where an operator can either generate one of a list of values randomly (and a different one for every invocation) or mutate a given value randomly, thereby simulating security attacks that the test system must be proof against. Lazy evaluation would allow a simple denotation of fuzz-templates which are only evaluated at the place of their usage, i.e. upon sending, when matching or converting to a value.<br />
<br />
Another application or lazy evaluation is optional code which may be active in one context but inactive in another (only determinable at runtime). Having to evaluate the non-active expressions puts unnecessary strain on the testing architecture and can lead to bad performance of the test system. To avoid this, at the moment, the code must be much more complicated than it would have to be using lazy evaluation and would need to replicate the decision-code (which of the different optional code-parts are active) in many places.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6623.doc (768,512) <span class="italic">09-10-2013 09:43</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2902&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6623_v2.doc (651,264) <span class="italic">10-10-2013 13:34</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2920&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6623_v3.doc (685,568) <span class="italic">11-10-2013 12:30</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2927&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6623_v4.doc (676,864) <span class="italic">26-11-2013 17:42</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2943&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6623_v5.doc (707,072) <span class="italic">28-01-2014 16:03</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2976&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">07-10-2013 11:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2013 11:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 5.4.1, 11, 15, 16</td></tr><tr class="print"><td class="print">07-10-2013 11:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Testing Technologies - Jacob Wieland</td></tr><tr class="print"><td class="print">07-10-2013 11:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">07-10-2013 11:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">07-10-2013 11:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">07-10-2013 11:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Priority</td><td class="print">normal =&gt; high</td></tr><tr class="print"><td class="print">07-10-2013 11:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.4.1 (published 2012-04)</td></tr><tr class="print"><td class="print">07-10-2013 12:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">v4.4.1 (published 2012-04) =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">09-10-2013 09:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR6623.doc</td><td class="print"></td></tr><tr class="print"><td class="print">09-10-2013 09:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011719</td><td class="print"></td></tr><tr class="print"><td class="print">09-10-2013 09:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">09-10-2013 09:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">09-10-2013 10:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">09-10-2013 12:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0011726</td><td class="print"></td></tr><tr class="print"><td class="print">09-10-2013 12:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">10-10-2013 10:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011747</td><td class="print"></td></tr><tr class="print"><td class="print">10-10-2013 13:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR6623_v2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">10-10-2013 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011753</td><td class="print"></td></tr><tr class="print"><td class="print">10-10-2013 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">10-10-2013 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">11-10-2013 12:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR6623_v3.doc</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 12:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011775</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 12:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">11-10-2013 12:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">11-10-2013 13:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011776</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 13:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0011776</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 13:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011777</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 13:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">11-10-2013 13:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">11-10-2013 14:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011783</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 14:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">11-10-2013 14:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">11-10-2013 14:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011783</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 14:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011785</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 15:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Edited: 0011785</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 15:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011787</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">11-10-2013 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">11-10-2013 15:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011788</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 16:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011791</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 16:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">11-10-2013 16:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">11-10-2013 16:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011792</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 16:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011794</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 16:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011795</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2013 17:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011796</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2013 10:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011797</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2013 10:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011797</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2013 10:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011797</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2013 10:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011797</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2013 10:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011797</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2013 10:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011797</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2013 10:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011797</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2013 17:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011798</td><td class="print"></td></tr><tr class="print"><td class="print">14-10-2013 10:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011799</td><td class="print"></td></tr><tr class="print"><td class="print">14-10-2013 10:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011799</td><td class="print"></td></tr><tr class="print"><td class="print">14-10-2013 12:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011801</td><td class="print"></td></tr><tr class="print"><td class="print">14-10-2013 13:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011803</td><td class="print"></td></tr><tr class="print"><td class="print">14-10-2013 13:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011804</td><td class="print"></td></tr><tr class="print"><td class="print">22-11-2013 13:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011815</td><td class="print"></td></tr><tr class="print"><td class="print">22-11-2013 13:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011815</td><td class="print"></td></tr><tr class="print"><td class="print">26-11-2013 15:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011837</td><td class="print"></td></tr><tr class="print"><td class="print">26-11-2013 17:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR6623_v4.doc</td><td class="print"></td></tr><tr class="print"><td class="print">26-11-2013 17:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011841</td><td class="print"></td></tr><tr class="print"><td class="print">26-11-2013 17:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">26-11-2013 17:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">28-11-2013 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011854</td><td class="print"></td></tr><tr class="print"><td class="print">28-11-2013 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">28-11-2013 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">28-11-2013 11:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011858</td><td class="print"></td></tr><tr class="print"><td class="print">28-11-2013 12:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0011858</td><td class="print"></td></tr><tr class="print"><td class="print">28-11-2013 14:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">28-01-2014 16:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011917</td><td class="print"></td></tr><tr class="print"><td class="print">28-01-2014 16:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR6623_v5.doc</td><td class="print"></td></tr><tr class="print"><td class="print">28-01-2014 16:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">v4.6.1 (published 2014-06) =&gt; v4.7.1 (published 2015-06)</td></tr><tr class="print"><td class="print">29-01-2014 11:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011918</td><td class="print"></td></tr><tr class="print"><td class="print">29-01-2014 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">29-01-2014 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">04-02-2014 13:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">04-02-2014 13:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">04-02-2014 13:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">07-02-2014 06:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011923</td><td class="print"></td></tr><tr class="print"><td class="print">07-02-2014 06:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">07-02-2014 06:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">v4.7.1 (published 2015-06) =&gt; v4.6.1 (published 2014-06)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011719)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-10-2013 09:51&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011726)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-10-2013 12:21&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				After personal discussion reassigned to Jacob.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011747)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-10-2013 10:41&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Results of the personal discussion with Jacob yesterday: actually we need two modifiers. In some cases evaluation shall be done at each case when a definition is used (e.g. fuzzy templates for security testing). In other cases evaluation shall be delayed, but done only once, at the first use (e.g. lazy parameter evaluation for performance testing, hoping that no evaluation will be needed at all). This has to be controlled by the user, only he knows its use case. <br />
<br />
Consequently we need two modifiers for these two different use cases.<br />
<br />
We could think about if the modifiers themselves should be put to the core or to the packages, as it was thought at the beginning?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011753)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-10-2013 13:40&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please review:<br />
<br />
fuzzy: lazy evaluation, always re-evaluate<br />
lazy: lazy evaluation, evaluate at most once<br />
<br />
- templates now can only be fuzzy<br />
- variables and parameters can be lazy or fuzzy<br />
- functions can no longer be fuzzy (not really necessary)<br />
<br />
restrictions are chosen in a way that does not conflict with existing features and that does not allow access to local variables that do not exist anymore when evaluating a fuzzy/lazy variable or parameter.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011775)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 12:33&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				See my amendments and comments in CR6623_v3.doc.<br />
<br />
Btw. once performance and security testing require different behavior and modifiers, we could return to the original idea and add @lazy to the performance package and @fuzzy to a new security package. What do you think? Could you also ask Dirk about it?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011776)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 13:01&#160;&#160;&#160;
				<br />(edited on:&#32;11-10-2013 13:22)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The restriction for fuzzy variables only being assigned completely has been introduced because otherwise, the implementation would need to know which parts of the expression need to be re-evaluated on the next usage and which not (otherwise, it can simple re-evaluate upon usage without any additional knowledge whatsoever). This overcomplicates things and so I would rather have this restriction.<br />
<br />
Lazy template declaration need not be restricted (in section 15, restriction c)) because they have not been introduced. There's only fuzzy templates and fuzzy/lazy template variables.<br />
<br />
Regarding 19.1. semantic description of assignment of lazy variables. <br />
<br />
Consider the following:<br />
<br />
var @lazy MyRecord x := f_initializeRecord(); <br />
x.i := 5;<br />
<br />
How should you implement the assignment of field i without first evaluating the x and then changing the value? Actually, if the right-hand-side contains the unchanged symbol, the x also must be evaluated before assignment. Only when the assignment is to x and not a sub-part of x and the right-hand-side does not contain the unchanged symbol would evaluation of x before assignment be unnecessary. <br />
<br />
Also, I don't understand your comment &quot;This would cause loss of tool performance and complicates feature for the user without obvoius benefit. For lazy it would just have reverse effect, re-evaluationg all fields all the time, that would not been re-evaluated for an ordinary variable or parameter.&quot;<br />
<br />
Where is tool performance lost? <br />
What fields are re-evaluated? (None, in my opinion)<br />
<br />
For fuzzy variables, if you have the restriction that no subparts of them can be assigned, the problem does not present itself. Otherwise, you would have the same problem, of course.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011777)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 13:23&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please review my remarks			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011783)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 14:21&#160;&#160;&#160;
				<br />(edited on:&#32;11-10-2013 14:24)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				&quot;The restriction for fuzzy variables only being assigned completely &quot;<br />
<br />
It is too restrictive, this is not they normal way, how variables are used in general. The tool need not keep track which parts has been assigned and which one has not. taking your example (modified):<br />
var @fuzzy MyRecord x := f_initializeRecord(); <br />
x.i := 5; //here x need to be evaluated for tool simplicity reasons  <br />
x.j := 42;//here x need NOT be re-evaluated before the assignment, just assign 42 to the field j<br />
y := x; //x is evaluated before the assignment<br />
z := x.j //x is evaluated before the assignment as well<br />
P.send (x) //x is evaluated again<br />
==&gt; it is enough to evaluate x if the whole x has been assigned a value in beforehand; but this doesn't mean that field assignments should be forbidden in overall <br />
------------------------------------------------------<br />
&quot;Regarding 19.1. semantic description of assignment of lazy variables&quot;<br />
<br />
you wrote: &quot;If only part of a lazy variable is assigned, both the variable and the right-hand-side are evaluated before assignment.&quot;<br />
<br />
Consider this as this is a very typical situation:<br />
var @lazy MyRecord v_MyRecord;<br />
v_MyRecord.f1 := f_initialize_f1();<br />
//function call is stored but it is useless to evaluate any of the fields<br />
...//v_MyRecord not used here<br />
v_MyRecord.f2 := f_initialize_f2(); //ditto<br />
...//v_MyRecord not used here<br />
v_MyRecord.f3 := f_initialize_f3(); //ditto<br />
if (b){P.send (v_MyRecord)} //this is the first place, where v_MyRecord really needs to be evaluated; all 3 function calls. But acc. to your proposal, up to this point *all fields* of the lazy variable should have been re-evaluated 3 times! resulting a worth performance than without @lazy!<br />
==&gt; it is enough to evaluate v_MyRecord at v_MyRecord.f1 if the whole v_MyRecord has been assigned a value in beforehand, like in your example<br />
x := f_initializeRecord(); x.i := 5;<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011785)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 14:59&#160;&#160;&#160;
				<br />(edited on:&#32;11-10-2013 15:00)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Have you considered a scope restriction too? In my opinion, expressions that contain variables declared on a lower scope or in a non-related scope shall not be referenced in expressions assigned to fuzzy and lazy variables, because there's a serious danger that at the point of evaluation, the memory allocated for such referenced variables has been already disposed. E.g.<br />
<br />
function f1(inout @lazy p)<br />
{<br />
&#160;&#160;&#160;// y is a local variable that will be disposed when the funcion returns<br />
&#160;&#160;&#160;var integer y := 5; <br />
&#160;&#160;&#160;p := y + 4;<br />
}<br />
<br />
function f2()<br />
{<br />
&#160;&#160;&#160;var @lazy integer x;<br />
&#160;&#160;&#160;f1(x);<br />
&#160;&#160;&#160;log(x); // the address of y is no longer available<br />
}<br />
<br />
Of course, it is possible to save the local memory block together with the entry point for lazy/fuzzy evaluation, but it might make disposing procedures impractically complex.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011787)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 15:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				@Tomas: lazy inout or out are not allowed (specifically because of this problem)<br />
<br />
@Gyorgy:<br />
<br />
&gt; &quot;The restriction for fuzzy variables only being assigned completely &quot;<br />
<br />
&gt; It is too restrictive, this is not they normal way, how variables are used in &gt; general. The tool need not keep track which parts has been assigned and which &gt; one has not. taking your example (modified):<br />
&gt; var @fuzzy MyRecord x := f_initializeRecord();<br />
&gt; x.i := 5; //here x need to be evaluated for tool simplicity reasons<br />
<br />
What would be the evaluation of x here?<br />
<br />
&gt; x.j := 42;//here x need NOT be re-evaluated before the assignment, just assign 42 to the field j<br />
<br />
What would be the evaluation of x here?<br />
<br />
&gt; y := x; //x is evaluated before the assignment<br />
<br />
&gt; z := x.j //x is evaluated before the assignment as well<br />
&gt; P.send (x) //x is evaluated again<br />
&gt; ==&gt; it is enough to evaluate x if the whole x has been assigned a value in beforehand; but this doesn't mean that field assignments should be forbidden in overall<br />
<br />
My problem is, I have no idea what the semantics of x is supposed to be after all these assignments. What happens to the values that WOULD have to be assigned by f_initializeRecord() because of the overwriting of these fields? Do they override the assignments, if so, the assignments have no effect. Do I have to keep the additional assignments extra somewhere and delay them over the evaluation of the original assignment (like a modifies)? This is all far too complicated - no one would understand that semantics either way.<br />
<br />
My view of fuzzy variables is simple: they store an unevaluated, unchangeable expression that will be evaluated every time, so that is in essence a bit like a macro variable.<br />
<br />
------------------------------------------------------<br />
&gt; &quot;Regarding 19.1. semantic description of assignment of lazy variables&quot;<br />
<br />
&gt; you wrote: &quot;If only part of a lazy variable is assigned, both the variable and the right-hand-side are evaluated before assignment.&quot;<br />
<br />
&gt; Consider this as this is a very typical situation:<br />
&gt; var @lazy MyRecord v_MyRecord;<br />
&gt; v_MyRecord.f1 := f_initialize_f1();<br />
&gt; //function call is stored but it is useless to evaluate any of the fields<br />
&gt; ...//v_MyRecord not used here<br />
&gt; v_MyRecord.f2 := f_initialize_f2(); //ditto<br />
&gt; ...//v_MyRecord not used here<br />
&gt; v_MyRecord.f3 := f_initialize_f3(); //ditto<br />
&gt; if (b){P.send (v_MyRecord)} //this is the first place, where v_MyRecord really needs to be evaluated; all 3 function calls. But acc. to your proposal, &gt; up to this point *all fields* of the lazy variable should have been re-evaluated 3 times! resulting a worth performance than without @lazy!<br />
&gt; ==&gt; it is enough to evaluate v_MyRecord at v_MyRecord.f1 if the whole v_MyRecord has been assigned a value in beforehand, like in your example<br />
&gt; x := f_initializeRecord(); x.i := 5;<br />
<br />
This is a total misinterpretation of my intention. Since every evaluation only happens at most ONCE for every lazy variable, it would simply mean that the already assigned fields of the variable are evaluated (if not evaluated already) whenever you assign a new field (that way you do not need to keep track of which fields already have been evaluated and which have not). Of course, if the overall variable is not used, this is worse than if you assigned all the fields in one assignment (because there, nothing would ever be evaluated before usage). <br />
<br />
So, assignment of f2 would evaluate rhs of f1 and f2. Assignment of f3 would evaluate rhs of f3. Usage of x would not evaluate anything anymore.This would not be worse than non-lazy, it would be exactly like non-lazy. <br />
<br />
But, I can see that this dynamic-lazy-approach that you seem to have in mind can add some value. <br />
<br />
It is clear, though, that, if a sub-part of a variable is already assigned something (because it or one of its parent has been assigned), then it needs to be evaluated before further assignment. Can we agree on this part?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011788)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 15:34&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				&gt; lazy inout or out are not allowed (specifically because of this problem)<br />
Excellent!<br />
<br />
But what about this:<br />
var @lazy integer x;<br />
while (...)<br />
{<br />
&#160;&#160;&#160;var integer y;<br />
&#160;&#160;&#160;... // compute y<br />
&#160;&#160;&#160;x := y + 1;<br />
}<br />
log(x); // x refers to y, but block where y is defined is no <br />
// longer valid at this point			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011791)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 16:25&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				@Tomas<br />
I think it's reasonable to say that all operands of the expression shall be visible at the place, where the variable/parameter is actually evaluated. As the feature is meant for performance testing, I don't think this would cause usability issues (only component variables are used anyway). But this is a reason to add the feature to the real time &amp; perf. package instead of the core.<br />
<br />
@Jacob<br />
@fuzzy<br />
You misunderstood. In cases, when x is initialized as a whole but not evaluated yet (two runtime flags), x is evaluated BEFORE x.i.<br />
<br />
Hence, for x.i := 5 the semantics is:<br />
x :=  f_initializeRecord();//delayed evaluation<br />
x.i := 5; //simple field assignment, no re-evaluation<br />
//and then<br />
x.j := 42; //simple field assignment, no re-evaluation<br />
<br />
Otherwise you would waste only tool performance for nothing, or even for worth testing results. pls. note, fuzzy doesn't mean random! You may fuzz test by shooting messages with a monotonously increasing value in it (for example, a port scanning attack). If fuzzy values are evaluated all the time, even when it is not necessary, this would result holes in the increasing value.<br />
<br />
Also note, that fuzz testing is a form of performance testing! The tool shall try as many possible attacks as it can for as short time period as it can. So, tool performance matter here. <br />
<br />
@lazy<br />
in this case the text has to be re-written that it cannot be misinterpreted.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011792)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 16:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Could you also consider recursive definitions:<br />
<br />
var @lazy integer i := 1;<br />
i := i + 1;<br />
log(i); // what will be the result?<br />
<br />
Or another example:<br />
<br />
var @lazy integer i;<br />
var @lazy integer j;<br />
i := j;<br />
j := i; // definition by a circle<br />
log(i); // infinite loop during resolving<br />
<br />
In my opinion, recursive references should not appear in lazy and fuzzy variables.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011794)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 16:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi Tomas, pls. note, only the time of the evaluation is delayed, not its &quot;content&quot;. t stick to your example:<br />
<br />
var @lazy integer i := 1;<br />
&#160;i := i + 1;<br />
<br />
is equal to:<br />
var @lazy integer i := 1;<br />
&#160;i := (i := 1) + 1;<br />
<br />
i := j; //it's not possible for normal variables either, because j is uninitialized.<br />
<br />
But<br />
var @lazy integer i;<br />
var @lazy integer j := 1;<br />
&#160;i := j;<br />
&#160;j := i;<br />
<br />
Would be equivalent to:<br />
var @lazy integer i;<br />
var @lazy integer j := 1;<br />
&#160;i := (j := 1); //i:= 1, 1 is stored in i here<br />
&#160;j := (i := 1)//j:=1			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011795)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 16:54&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				@Gyorgy/fuzzy<br />
<br />
I think what you are trying to accomplish can be easily accomplished by<br />
assigning the fuzzy template to a non-lazy/fuzzy variable (that way fixing the current value) and then overwriting the fields that you want to change. That would have a clear semantics in my view. I'm still not clear what your example does. Is the function call evaluated before the field assignment or not? If so, what is the difference to lazy?<br />
<br />
@Tomas:<br />
<br />
yeah, the inner-local-variable-problem was on my radar as well, but I have not found a solution for that (neither how to formulate the restriction nor how to enforce it).<br />
<br />
The recursitivity issue is not a big problem and cannot be avoided in my opinion. It is always possible to write down infinite recursions or endless loops. That cannot be avoided or thoroughly checked statically (semi-decidable problem) so I don't see how another way of doing so harms anyone.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011796)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-10-2013 17:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				@Gyorgy/recursion<br />
<br />
I think Tomas is right in his assessment. Since the time of evaluation is delayed until after the re-assignment of i (or the first assignment of j) is done, the evaluation of the right-hand-side i/j already points to the new initialization of i/j and not the original, overwritten one.<br />
<br />
Otherwise, for every re-initialization of a variable, one would have to check the right-hand-side for usages of that variable and then at least evaluate that variable before assigning (as otherwise the original assignment will be lost).<br />
<br />
Again, this seems to be very complicated (and pathological, no doubt), which is why I would opt for the easier-to-understand-and-implement version which may cause infinite recursion in such pathological cases (as is always the case for lazy evaluation, I think).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011797)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-10-2013 10:21&#160;&#160;&#160;
				<br />(edited on:&#32;12-10-2013 10:49)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Example extended, corrected:<br />
var @lazy integer i;<br />
&#160;var @lazy integer j := 1;//initialization is a must as the next assignment<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;//(i:=j) would cause runtime error without it<br />
&#160;&#160;i := j;<br />
&#160;&#160;j := i;<br />
&#160;&#160;j := 5;<br />
<br />
Is equivalent to:<br />
&#160;var @lazy integer i;<br />
&#160;var @lazy integer j := 1;<br />
&#160;&#160;i := (j := 1); //previous j:= 1 is executed here when executing the expression; <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// 1 is stored in j, nothing is stored in i<br />
&#160;&#160;j := (i := j ) //j is assigned to i when evaluating the expression;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;//as j contains 1 at this point, 1 is assigned to i;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;//the original assignment (j := i) is not executed at this point,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;//but delayed to the next use of j on the RHS<br />
&#160;&#160;j := 5;        //This overrides the previous delayed assignment with a new one;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;//yes, the stored j := i assignment is replaced here with a new<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;//delayed assignment, but what difference does it make?<br />
<br />
I can't see where is the recursion or problem here. Everything is done sequentially, only the time of the previous assignment is delayed.<br />
-----------------------------------------------------<br />
@difference between @lazy and @fuzzy (we have discussed this already)<br />
@lazy evaluation is delayed only until the first use on RHS or FIRST assignment to its part, but NOT re-evaluated at further use on RHS<br />
@fuzzy first evaluation is delayed until the first use on RHS or FIRST assignment to its part AND re-evaluated AT EACH use on RHS<br />
-----------------------------------------------------<br />
@fuzzy semantics<br />
What I say has also a clear semantics, but does not force the user to make &quot;dirty&quot; workarounds, which again,<br />
1) decreasing tool performance;<br />
2) you tend to forget that TTCN-3 is not meant for programming experts, but shall be a language that can also be used correctly by testers without programming experience (in fact, they may be about 90% of the users)! If we do not consider this, we will make a wrong language design;<br />
3) the user may not even be aware that he is using a @fuzzy template/variable; you also tend to forget that majority of the testers are using test frameworks that hides a lots of information from them (e.g. direct access of component variables that can be set/get via library functions only).<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011798)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-10-2013 17:00&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				GyÃ¶rgy, I am afaid that we have a different understanding how the RHS of lazy/fuzzy variables work. In my opinion, the RHS of assignment to a lazy/fuzzy variable is NOT evaluated at all, i.e. not used. The TE doesn't perform any calculations during the assignment, it simply stores an entry point for the expression and continues with a next command. This is actually the whole point of lazy/fuzzy variables: not to do anything with the RHS in case of assignment. Thus, applied to our sample code:<br />
<br />
var @lazy integer i;<br />
var @lazy integer j := 1;<br />
i := j; // value of j is not calculated at this point, because RHS of lazy assignments is not evaluated<br />
j := i; // i is not evaluated as well<br />
log(i); // evaluation occurs at this point, producing endless loop<br />
<br />
Also notice that in the example, the RHS is trivial. However, since the RHS might contain function calls with cyclic reference to a fuzzy/lazy variable burried deep inside, there's no way to discover this connection without very complex analysis of the RHS or without executing the function. And I don't believe this is intended.<br />
<br />
I also think that unlike standard assignments, assignments of lazy or fuzzy variables might contain uninitialized references on the RHS. These symbols have to be initialized in the moment when the fuzzy/lazy variable is used. Thus, the following code should work without a problem and print 5:<br />
var integer @lazy i;<br />
var integer @lazy j;<br />
i := j;<br />
j := 5;<br />
log(i);<br />
<br />
In order to resolve the problem with unresolvable cyclic references, I would propose one of the following rules:<br />
1. If a cyclic reference to a variable (or parameter) being resolved is discovered in the evaluated expression, the TE shall produce a runtime error.<br />
<br />
2. The expression on the RHS of lazy/fuzzy variable (or parameter) assignment shall not contain any direct or indirect reference to a lazy/fuzzy variable (or parameter).<br />
<br />
Both rules would solve the issue with unresolvable cyclic references. The first proposal deals with the actual problem, but its disadvantage is that it offers no protection agains the problem in compilation time. However, there are other similar issues that compilers do not detect, such as endless loops. With a good debugger, it should not be a big deal to discover the source of the error when it occurs.<br />
<br />
The second solution is capable of discovering issues in compilation time (with a good compiler). However, it might be too restrictive. I can imagine situations when chaining lazy/fuzzy variables would be useful.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011799)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-10-2013 10:52&#160;&#160;&#160;
				<br />(edited on:&#32;14-10-2013 10:54)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Tomas, we are talking about two different features here. I agree, if we proposed the feature you are describing, it would cause both technical and usability (for the user) problems. You are distinguishing use in an expression or in an operation/statement, and evaluation is invoked only by the second one; we are talking about a much simpler feature that does not make this distinction. Otherwise is would also be impossible to follow/debug what's happening for the user.<br />
<br />
The feature I'm talking about is the one in the CR resolution draft. It specifies: &quot;That means that evaluation is delayed during execution until the first actual usage, other than using it at the left hand side of an assignment or passing it to a fuzzy or lazy formal parameter.&quot;<br />
<br />
This means that in &quot;var @lazy integer j := 1&quot;, j:=1 is not evaluated, but in &quot;i := j&quot;, the previous j:=1 is evaluated, because this is the FIRST use &quot;other than using it at the left hand side of an assignment or passing it to a fuzzy or lazy formal parameter&quot;. For this reason, your example with j not initialized at declaration will cause an error (at the line of i:=j).<br />
<br />
This resolves possible cyclic issues and your proposed restrictions are not needed.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011801)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-10-2013 12:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I don't make a distinction where the symbol is used. The whole problem is in understanding of the word &quot;usage&quot; and &quot;usage&quot; in the following rule: &quot;That means that evaluation is delayed during execution until the first actual usage, other than using it at the left hand side of an assignment or passing it to a fuzzy or lazy formal parameter.&quot;<br />
<br />
We had this discussion last year and the conclusion was that the word &quot;use&quot; doesn't mean syntactical presence, but actual execution of a particular statement. My point is that assignment to a lazy/fuzzy variable doesn't constitute usage, because if the proposed rule is applied to i in i := j (i fullfils the condition of being a lazy variable on the LHS), it triggers delayed execution of the RHS containing j. It means that the expression is not evaluated at the moment of assignment, thus j is not &quot;used&quot; and the rule for evaluation of lazy variables cannot be applied to it.<br />
<br />
Your point would be valid, if the words &quot;using&quot; and &quot;usage&quot; were replaced with &quot;occurring&quot; and &quot;occurrence&quot;. However, even in this case, there might be a problem with component variables. Consider this:<br />
<br />
type component C<br />
{<br />
&#160;&#160;var @lazy i := 0;<br />
&#160;&#160;var @lazy j := 0;<br />
}<br />
<br />
function f1() return integer runs on C<br />
{<br />
&#160;&#160;return j;<br />
}<br />
<br />
function f2() return integer runs on C<br />
{<br />
&#160;&#160;return i;<br />
}<br />
<br />
<br />
testcase TC() runs on C<br />
{<br />
&#160;&#160;&#160;i := f1(); // j is referenced indirectly<br />
&#160;&#160;&#160;j := f2(); // i is referenced indirectly<br />
&#160;&#160;&#160;log(i);<br />
}<br />
<br />
Discovering such indirect references requires complex algorithms (my example is just for demonstration, the dependency might not be that obvious in a real code) and leaving them undetected lead to the cyclic reference problem described in my previous posts.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011803)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-10-2013 13:23&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have to fully agree with Tomas. My understanding of usage does not include usage on the right-hand-side of assignments to lazy variables (because that is the whole point of lazy variables that their right-hand-sides are only evaluated when the variable is used, not when they are assigned).<br />
<br />
Therefore, I think that Tomas is right in his assessment. We would have to agree whether the runtime or the compile time solution is more acceptable. <br />
<br />
In my opinion, runtime checking is enough, the second restriction could be used as the basis for warnings of cyclic-lazy-variable-dependence. Of course, if a compiler detects an obvious cyclic dependency of a lazy variable (that is used in a non-lazy context) to itself, it may already produce an error at compile-time.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011804)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-10-2013 13:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In regard to the access-to-lower-scope-variables, I think we need a restriction like:<br />
<br />
The right-hand-side of an assignment to a lazy/fuzzy variable shall only contain references to variables/constants/templates that are known in the scope of the variable declaration.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011815)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-11-2013 13:28&#160;&#160;&#160;
				<br />(edited on:&#32;22-11-2013 13:29)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Actually, we have two properties of lazy variables<br />
a) they are evaluated when used on the RHS<br />
b) expression on the RHS is not evaluated when there is a lazy variable on the LHS.<br />
<br />
Therefore, when there are lazy vars on both sides of an assignment, the two rules collide. Which one of the rules should take precedence? -&gt; is a matter of optimization decision.<br />
<br />
Actually, the requirement is to avoid evaluation of vars/parameters that are NEVER used. For tool performance reasons. If a value is assigned to a variable and the variable *is* used, the time of its evaluation is irrelevant from performance point of view -&gt; it requires the same computing resources. Assigning a value to a var and re-assigning it without using the first value is a rare case and a bad programming style that can be corrected in the code. You try to take into account this situation as well, by giving precedence to rule b), but this leads to extra complications and sometimes to a difficult-to-follow code behavior. This can be avoided if rule a) had the precedence above rule b). As a bonus, the code's behavior is much easier to understand, no implicit chains of var value assignments that actually never happen.<br />
<br />
As a compromise solution, we could also say that if a lazy var/parameter is used at both sides of an assignment, the lazy var used in the expression on the RHS is evaluated, but the expression itself does not.<br />
<br />
<br />
I don't fully understand Jacob's proposal regarding lower-scope-variables. For example, it is clear that a component var's value used in an evaluation, shall be its actual value at the time when the RHS is evaluated. This proposal would limit the usability of lazy component vars to zero. In performance testing component variables are used whenever possible, and local variables shall be avoided like a hot iron: the memory for component vars are allocated during tool initialization, when we have more time, while for local vars the memory is allocated during traffic generation, when we are lack of spare time. And memory operations are expensive.<br />
<br />
Example; please note, the bahaviour is trivial to follow even in this simple example:<br />
type component MyComp { var integer ci := 0; }<br />
<br />
function MyFuncDieIfZero() runs on MyComp return integer {<br />
&#160;&#160;if (ci==0) { testcase.stop; } // die if the component variable is zero<br />
&#160;&#160;return ci;<br />
}<br />
function MyLazyFunc(in @lazy integer pi) runs on MyComp {<br />
&#160;&#160;ci := 1;<br />
&#160;&#160;log(pi); // first use of pi -&gt; 3*MyFuncDieIfZero() is evaluated,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// as ci==1 at this point, 3*1=3 is logged<br />
&#160;&#160;ci := 2;<br />
&#160;&#160;log(pi); // second use of pi -&gt; not evaluated, the value 3 is used again<br />
}<br />
Calling the function:<br />
MyLazyFunc(3*MyFuncDieIfZero());<br />
&#160;&#160;// the MyFuncDieIfZero() function is not evaluated here;<br />
&#160;&#160;// as ci==0 at this point, it would die if it was evaluated<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011837)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-11-2013 15:28&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Let me see if I understand your concept of lazy variable correctly.<br />
<br />
Suppose we have a declaration <br />
<br />
var T x := E<br />
<br />
where E contains the variables x1, ... xn<br />
<br />
Then x is actually assigned the lambda closure <br />
<br />
(\\x1,...,xn.E)(eval(x1),...,eval(xn))<br />
<br />
so that later on eval(x) is the evaluation of E where the variables x1 to xn are substituted with their values when x was assigned (not when it is evaluated).<br />
<br />
If that is the case, then it does not matter whether or not the variables on the right-hand-side are lazy or not, they are evaluated before assignment, i.e. a use of a lazy variable on the right-hand-side is an actual use that triggers evaluation.<br />
<br />
This actually means that it does not matter when a lazy variable is evaluated after an assignment (before it is assigned again) - it will always yield the same result.<br />
<br />
In that case, we do not need any restriction in regard of which variables can be used on the right hand side of lazy variable assignments.<br />
<br />
For field/element assignments of lazy variables, it is still necessary to first evaluate the variable, i.e. field/element assignments are also a &quot;use&quot; of a lazy variable.<br />
<br />
I think I like this concept. It has fewer restrictions and it does not deviate from normal variables a lot, i.e. most variables whose right-hand-sides have no side-effectscan simply be turned into a lazy variables.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011841)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-11-2013 17:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				amended the proposal according to your comments, please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011854)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-11-2013 11:05&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Using the closure concept sounds interesting, though I didn't really meant this. Yes, you are right, in this case it is almost(or completely?) unimportant if a variable is lazy or not. In another words, this sounds like a tool optimization issue for me. Also, this may raise memory issues for the tools: the use case is the load testing scenarios, where - literally - millions of entities need to be simulated, and their data need to be stored; so tools have memory consumption issues already.<br />
<br />
What I meant is to give control to the user, i.e. declaring a var/param lazy or non-lazy should make a difference. In my &quot;half-way&quot; view, when a lazy var/parameter is evaluated - at its first use-, the values of the dependent data at the time of the evaluation, i.e. not at the time of the assignment, is used. Like in my example below with the component variable. Just the evaluation is done at the first use in all cases, independently of what is at the LHS (i.e. is not re-delayed and re-delayed when the LHS is also lazy).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011858)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-11-2013 11:50&#160;&#160;&#160;
				<br />(edited on:&#32;28-11-2013 12:06)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				sorry, I either don't udnerstand your concept or it suffers from the problem that occur if the variables used on the right-hand-side are either the variable being assigned or point to a lazy variable that again uses the variable being assigned (circularity) or not accessible/existent anymore in the scope of usage of the lazy variable (because the scope of these variables has already been left).<br />
<br />
also, it has kind of weird, unforseeable consequences in case that the variables being used by the lazy variable are changed after the assignment, so the value of the variable when being evaluated depends on the time of evaluation.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011917)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-01-2014 16:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please find the updated version in CR6623_v5.doc. I didn't change the sentence related to function return value evaluation in ~_v4 version, so hopefully it will be OK.<br />
<br />
Please review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011918)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-01-2014 11:07&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Section 5.4.2. EXAMPLE 6, the modulepar should be renamed to logComplexMessage (or even logMessage and the comment be amended accordingly. At the moment, the semantics is counter-intuitive to the natural-language semantics.<br />
<br />
Section 7.1. Restriction a) has a typo: experssion<br />
<br />
Otherwise, I consider this resolved.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011923)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-02-2014 06:38&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented with editorial corrections as proposed in v5 and last comment.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
