<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:38 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006412: system component shall be passed to functions with map/unmap statements - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006412</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">16-01-2013 12:39</td><td class="print">28-08-2013 14:59</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Thilo Lauer</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.4.1 (published 2012-04)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">16.1 Functions</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Devoteam - Thilo Lauer</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006412: system component shall be passed to functions with map/unmap statements</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">If map/unmap statements are used in a function, then the system component should also be passed to this function,<br />
&#160;&#160;(1) either as parameter <br />
&#160;&#160;(2) or by using keyword system to define the function's system component.<br />
<br />
Let's assume the following component definitions:<br />
&#160;&#160;type component UTRAN_PTC {<br />
&#160;&#160;&#160;&#160;var  UTRAN_Global_Type vc_UTRAN_Global;<br />
<br />
&#160;&#160;&#160;&#160;port UTRAN_AM_PORT          U_AM;<br />
&#160;&#160;&#160;&#160;port UTRAN_TM_PORT          U_TM;<br />
&#160;&#160;&#160;&#160;port UTRAN_UM_PORT          U_UM;<br />
&#160;&#160;&#160;&#160;...<br />
&#160;&#160;&#160;&#160;port UTRAN_VNG_PORT         U_VNG;<br />
&#160;&#160;&#160;&#160;...<br />
&#160;&#160;};<br />
<br />
&#160;&#160;type component UTRAN_SYSTEM {<br />
&#160;&#160;&#160;&#160;port UTRAN_AM_PORT          S_U_AM;<br />
&#160;&#160;&#160;&#160;port UTRAN_TM_PORT          S_U_TM;<br />
&#160;&#160;&#160;&#160;port UTRAN_UM_PORT          S_U_UM;<br />
&#160;&#160;&#160;&#160;...<br />
&#160;&#160;&#160;&#160;port UTRAN_VNG_PORT         S_U_VNG;<br />
&#160;&#160;};<br />
<br />
Example: <br />
The defintition of function f_UTRAN_PTC_Map below can generally be called in the context of different test cases <br />
with different system components (defining different system ports).<br />
Therefore if this function is defined as shown below, it can currently not be decided at compile time <br />
if the system component actually has the system ports used in the function's map statements:<br />
<br />
&#160;&#160;function f_UTRAN_PTC_Map(UTRAN_PTC p_Utran)<br />
&#160;&#160;{<br />
&#160;&#160;&#160;&#160;map(p_Utran:U_AM,    system:S_U_AM);<br />
&#160;&#160;&#160;&#160;map(p_Utran:U_TM,    system:S_U_TM);<br />
&#160;&#160;&#160;&#160;map(p_Utran:U_UM,    system:S_U_UM);<br />
&#160;&#160;&#160;&#160;// ... further map statements<br />
<br />
&#160;&#160;&#160;&#160;if (f_GetTestcaseAttrib_Qbased_Rsrq(testcasename())) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;map(p_Utran:U_VNG,  system:S_U_VNG);<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
<br />
Given the function definition above, errors with system port mappings can only be detected at runtime.<br />
<br />
<br />
To be able to do this checks at compile time, we suggest ...<br />
============================================================<br />
1.) either to pass the system component additionally as parameter:<br />
&#160;&#160;&#160;&#160;i.e. to change the function definition in the test suite to:<br />
&#160;&#160;<br />
&#160;&#160;function f_UTRAN_PTC_Map(UTRAN_PTC p_Utran, UTRAN_SYSTEM sys_Utran)  <br />
&#160;&#160;// *** added parameter: UTRAN_SYSTEM sys_Utran ***<br />
&#160;&#160;{<br />
&#160;&#160;&#160;&#160;map(p_Utran:U_AM,    sys_Utran:S_U_AM);<br />
&#160;&#160;&#160;&#160;map(p_Utran:U_TM,    sys_Utran:S_U_TM);<br />
&#160;&#160;&#160;&#160;map(p_Utran:U_UM,    sys_Utran:S_U_UM);<br />
&#160;&#160;&#160;&#160;// ... further map statements<br />
&#160;&#160;&#160;&#160;<br />
&#160;&#160;&#160;&#160;if (f_GetTestcaseAttrib_Qbased_Rsrq(testcasename())) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;map(p_Utran:U_VNG,  sys_Utran:S_U_VNG);<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
<br />
&#160;&#160;// function call:<br />
&#160;&#160;f_UTRAN_PTC_Map(p_Utran, system);  <br />
&#160;&#160;// *** keyword &quot;system&quot; passed as actual component parameter value here ***<br />
<br />
&#160;&#160;<br />
2.) or to change the TTCN-3 syntax for function definitions as shown below:<br />
<br />
&#160;&#160;function f_UTRAN_PTC_Map(UTRAN_PTC p_Utran) system UTRAN_SYSTEM<br />
&#160;&#160;// *** system UTRAN_SYSTEM added ***<br />
&#160;&#160;{ <br />
&#160;&#160;&#160;&#160;...<br />
&#160;&#160;}<br />
<br />
&#160;<br />
Solution 1.) requires a change in some ETSI/3GPP suites<br />
Solution 2.) requires a change in some ETSI/3GPP suites and in the TTCN-3 standard as well.<br />
<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0005922</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">why strong typing is not used in map and unmap?&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">16-01-2013 12:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">16-01-2013 12:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 16.1 Functions</td></tr><tr class="print"><td class="print">16-01-2013 12:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Devoteam - Thilo Lauer</td></tr><tr class="print"><td class="print">18-01-2013 11:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011324</td><td class="print"></td></tr><tr class="print"><td class="print">18-01-2013 11:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0005922</td></tr><tr class="print"><td class="print">08-07-2013 15:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">08-07-2013 15:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">08-07-2013 18:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">11-07-2013 15:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011550</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2013 15:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">11-07-2013 15:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">28-08-2013 14:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011626</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2013 14:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">28-08-2013 14:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">28-08-2013 14:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">28-08-2013 14:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011324)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-01-2013 11:44&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				A proposal for the solution of this issue can already be found in CR5922			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011550)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-07-2013 15:23&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				see proposal in 5922			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011626)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2013 14:58&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Resolved together with 5922			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
