<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:51 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006337: Excess use of const qualifiers in C++ mapping - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 06: TTCN-3 Control Interface</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006337</td><td class="print">Part 06: TTCN-3 Control Interface</td><td class="print">Technical</td><td class="print">public</td><td class="print">23-11-2012 08:20</td><td class="print">14-12-2012 07:30</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Tomas Urban</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.4.1 (published 2012-04)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print-category">Fixed in Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">10</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Elvior</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006337: Excess use of const qualifiers in C++ mapping</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">The current definition of C++ TCI mapping contains several methods where use of const qualifiers is too restrictive. The issue concerns various get methods of constructive value classes and classes for parameter handling. <br />
<br />
In case of value classes, it leads to writing an inefficient code. E.g. in order to change an existing value inside a record, one must create a copy of the existing field, set the value in the copy and use the copy to call the setField method.<br />
<br />
The most severely affected class is the TciParameterList class, especially if used in extended TRI calls. E.g. in order to set a value of an output parameter of an external functions, the following algorithm has to be used:<br />
1. Get all parameter from the parameter list and store them (the get method of the TciParameterList returns constants)<br />
2. Create a copy of the parameter that will be modified<br />
3. Create a copy of the TCI value object contained in the parameter copy (the getValue method again returns a constant)<br />
4. Modify the value contained in the TCI value object<br />
5. Call the setValue of the parameter object to set the new parameter value<br />
6. Clear the parameter list<br />
7. Use the push_back method to assign the parameter copy and all remaining parameters to the list (the parameter list class doesn't contain a method to change a parameter at a specified index).<br />
<br />
It is very clumsy. In my opinion, the algorith should be:<br />
1. Get the parameter be to modified from the list<br />
2. Get the TCI object embedded in the parameter<br />
3. Modify the value<br />
<br />
There's of course a good reason, why the const qualifier is used. The affected get methods are (in most cases) allowed in const objects too. It means that the current get methods cannot be simply modified by removing the const qualifier, because that would lead to compilations with existing TCI implementations. Fortunately C++ allows so called const overloading, so it is possible to create methods with the same name, parameters and return values, but different const qualifiers.<br />
<br />
Therefore I propose to add the following methods to C++ TCI mapping:<br />
<br />
1. To the TciParameter class (10.5.2.9):<br />
virtual TciValue &amp; getValue () = 0;<br />
<br />
2. To the TciParameterList class (10.5.2.10):<br />
virtual TciParameter *get (Tindex p_index) = 0;<br />
<br />
3. To the RecordValue class (10.5.3.11):<br />
virtual TciValue &amp;getField (const Tstring &amp;p_field_name) = 0;<br />
<br />
4. To the RecordOfValue class (10.5.3.12, the current get method shall be removed, because it doesn't work in const objects):<br />
virtual const TciValue &amp; getField (Tindex p_position) const = 0;<br />
virtual TciValue &amp; getField (Tindex p_position) = 0;<br />
<br />
5. To the UnionValue class (10.5.3.13):<br />
virtual TciValue &amp; getVariant (const Tstring &amp;p_variantName) = 0;<br />
<br />
6. To the AddressValue class (10.5.3.17):<br />
virtual TciValue &amp; getAddress () = 0;</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR_6337_v1.docx (136,585) <span class="italic">12-12-2012 08:09</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2767&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">23-11-2012 08:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">23-11-2012 08:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 10</td></tr><tr class="print"><td class="print">23-11-2012 08:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Elvior</td></tr><tr class="print"><td class="print">10-12-2012 13:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">10-12-2012 13:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">10-12-2012 16:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr><tr class="print"><td class="print">12-12-2012 08:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR_6337_v1.docx</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2012 08:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011238</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2012 08:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">14-12-2012 07:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011260</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2012 07:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">14-12-2012 07:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">14-12-2012 07:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr><tr class="print"><td class="print">14-12-2012 07:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011238)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-12-2012 08:10&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Proposed resolution attached.<br />
Please review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011260)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-12-2012 07:29&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented as proposed.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
