<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:32 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006089: receive statements on port arrays - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006089</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">16-05-2012 12:51</td><td class="print">29-11-2013 12:19</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">22</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technologies - Jacob Wieland</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006089: receive statements on port arrays</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Currently, in TTCN-3 there is a dichotomy between dynamically sized port arrays and static alt statements to check for message reception: If it is not known how many ports are in a port array, it is not possible to write down an alt statement which can receive messages over all these ports in parallel.<br />
<br />
Though this can be done by use of the default mechanism, we feel that this neither<br />
makes the TTCN-3 more readable and can lead to confusion (which defaults are actual defaults and which ones are dynamic-port-defaults).<br />
<br />
Therefore, we propose to generalize the reception statements (i.e. receive/trigger/getcall/getreply/catch) to work as well on port arrays.<br />
<br />
alt {<br />
[] &lt;port_array_ref&gt;.receive(X) { ... }<br />
}<br />
<br />
where n is the number of ports in the port array,<br />
would have the same semantics as<br />
<br />
alt {<br />
[] &lt;port_array_ref&gt;[0].receive(X) { ... }<br />
...<br />
[] &lt;port_array_ref&gt;[n-1].receive(X) { ... }<br />
}<br />
<br />
To facilitate distinction on which actual port the reception took place as well as allow a reaction on the same port, an optional 'port' clause (analogous to 'sender' and 'value') can be added to the assignment part of the receive statement.<br />
<br />
Example:<br />
<br />
Assuming, &lt;port_array_ref&gt; is a port array of PortType ports, this would be<br />
valid:<br />
<br />
var PortType p;<br />
<br />
alt {<br />
[] &lt;port_array_ref&gt;.receive(X) -&gt; port p { p.send(Y) }<br />
}<br />
<br />
This construct should work the same way on multi-dimensional port arrays as on single dimensional arrays.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6089.doc (400,384) <span class="italic">08-10-2013 18:36</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2900&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6089_resolution_v2.doc (472,064) <span class="italic">09-10-2013 16:16</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2913&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6089_resolution_v3.doc (491,520) <span class="italic">29-11-2013 12:18</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2961&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">16-05-2012 12:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">16-05-2012 12:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 22</td></tr><tr class="print"><td class="print">16-05-2012 12:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Testing Technologies - Jacob Wieland</td></tr><tr class="print"><td class="print">16-05-2012 16:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010627</td><td class="print"></td></tr><tr class="print"><td class="print">09-07-2012 16:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">09-07-2012 17:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010726</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010741</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">10-07-2012 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">10-07-2012 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr><tr class="print"><td class="print">10-07-2012 11:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010741</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 11:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Deleted: 0010726</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 13:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010751</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 13:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010752</td><td class="print"></td></tr><tr class="print"><td class="print">08-07-2013 18:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">v4.5.1 (published 2013-04) =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">12-07-2013 11:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">12-07-2013 13:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR6089.zip</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2013 13:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011577</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2013 13:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011578</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2013 13:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">12-07-2013 13:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">29-08-2013 11:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011635</td><td class="print"></td></tr><tr class="print"><td class="print">29-08-2013 11:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">29-08-2013 11:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">29-08-2013 11:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">29-08-2013 11:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011635</td><td class="print"></td></tr><tr class="print"><td class="print">29-08-2013 14:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011640</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2013 13:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011685</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2013 13:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">07-10-2013 13:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">07-10-2013 17:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011693</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2013 17:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011693</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2013 17:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011693</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2013 17:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">07-10-2013 17:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">08-10-2013 10:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011697</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2013 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">08-10-2013 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">08-10-2013 14:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011703</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2013 14:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">08-10-2013 14:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">08-10-2013 18:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Deleted: CR6089.zip</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2013 18:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR6089.doc</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2013 18:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011716</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2013 18:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">08-10-2013 18:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">09-10-2013 16:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR6089_resolution_v2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">09-10-2013 16:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011736</td><td class="print"></td></tr><tr class="print"><td class="print">09-10-2013 16:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">09-10-2013 16:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">10-10-2013 15:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011756</td><td class="print"></td></tr><tr class="print"><td class="print">10-10-2013 15:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">10-10-2013 15:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">29-11-2013 12:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR6089_resolution_v3.doc</td><td class="print"></td></tr><tr class="print"><td class="print">29-11-2013 12:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011865</td><td class="print"></td></tr><tr class="print"><td class="print">29-11-2013 12:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">29-11-2013 12:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">29-11-2013 12:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010627)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-05-2012 16:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				As an alternative syntax to make the feature more explicit, we could introduce the following:<br />
<br />
any &lt;port_array_ref&gt;.receive()<br />
<br />
So, this would be a mixture between any port.receive and &lt;port_ref&gt;.receive.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010741)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 11:40&#160;&#160;&#160;
				<br />(edited on:&#32;10-07-2012 11:46)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion 2012-07-10:<br />
The need for such feature is agreed. The solution could be made consistent for the different active objects, i.e. for ports, timers, components... and shall allow saving the index of the instance of an array as well. Also any port, any timer, any componanet shall be considered. Both access to the active objects and to the index of active objects should be considered. <br />
Analyse the different alternatives for further discussion.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010751)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 13:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Why would that be necessary to know the index of the timer/port? Since timers and ports are passed by reference, it would never be necessary to &quot;assign them back&quot; to their original index. What would the index be useful for otherwise if the port/timer can be assigned to an additional variable to store it for future use.<br />
<br />
To enlarge the construction to timers, we would need to introduce timer variables (which de-facto already exist as timer parameters), i.e. see the keyword timer also as a predefined type to be used in var-declarations.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010752)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 13:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				If really seen as necessary, the index-assignment notation could look like this:<br />
<br />
type component C {<br />
&#160;&#160;port P[10][10][10] p;<br />
}<br />
<br />
... runs on C {<br />
var integer i, j, k;<br />
<br />
alt {<br />
[] any p.receive(...) -&gt; port [i][j][k] { p[i][j][k].send(...) }<br />
}<br />
<br />
As the syntax is clearly distinguishable from a variable reference (as in -&gt; port p2), I think this would be a very readable and clear alternative. Also, it would not introduce any new keywords.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011577)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2013 13:49&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				added proposal for all receiving operations (receive, trigger, getcall, getreply, catch and check) both in text and in BNF.<br />
<br />
changes for components and timers to be done later			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011578)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2013 13:57&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				can you crosscheck?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011635)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-08-2013 11:14&#160;&#160;&#160;
				<br />(edited on:&#32;29-08-2013 11:15)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				My comments:<br />
1) I would prefer a resolution text containing only the clauses changed by this CR and only the changes related to this CR (not the whole standard)<br />
<br />
2) The syntax should more intuitively identify that a port array is meant; &quot;any p&quot; is not intuitive enough, a non-experts reader may miss the point easily; for example<br />
[] any Port.receive (MyTemplate);<br />
For similar cases we are already using the [-] syntax (when not a concrete element but the inner type of a record/set of is referred to); i.e.<br />
[] p[-].receive(Mytemplate)<br />
would explicitly show that the receive operation works over the whole port array, not on a single port only<br />
<br />
3) The need of saving the index of the port is above question, otherwise it would be impossible to respond to the message received over a port that is member of a port array.<br />
<br />
4) For saving the index I propose the syntax port i and port (i,j,k), as we are using this syntax already, when saving certain fields of the received message (see $22.2.2). I.e.<br />
<br />
[] p[-].receive(Mytemplate) -&gt; port i //single dimension port array<br />
or<br />
[] p[-].receive(Mytemplate) -&gt; port (i) //single dimension port array<br />
and <br />
[] p[-].receive(Mytemplate) -&gt; port (i,j,k) //3-dimensional port array<br />
<br />
5) The meaning of &quot;If the port array is nested, then the inner port arrays are iterated over first.&quot; is unclear to me (nesting means to me something in a record field or as a record of element). I suppose multi-dimensional arrays are meant here. I would propose:<br />
&quot;In case of multi-dimensional port arrays the port indices are iterated from the last index to the first index, i.e. [0,0,0] then [0,0,1] ... [0,1,0], [0,1,1] ... [1,0,0], [1,0,1] etc.&quot;<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011640)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-08-2013 14:41&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				My comments:<br />
<br />
1) This was done only because the CR is supposed to include also stuff for component and timer arrays and I didn't want a merge-nightmare between proposals later on. Of course, the final proposal will only contain the changed sections.<br />
<br />
2) The syntax you are proposing also is not intuitive to me - you still need to know what it should signify to understand it. I would opt for a thing similar to the 'all from' construct we introduced for permutation/subset, i.e. 'any from Port.receive'. This clearly distinguishes it both from 'any port.receive' and 'Port.receive'. Alternatively, it could be 'any port from P' which would make it clear to everybody, I think. Basically, this would then be a special case of the any port construction.<br />
<br />
3) The index is not necessary for reply if you can assign the port to a port variable instead. The index would only be necessary if you need to use the index information for something else on which your reply depends (i.e. some message for even, some other for odd ports).<br />
<br />
<br />
4) using tuples for index-variable assignment is fine with me. However, if indices are supposed to be assigned, always parantheses should be used (even for single index) to distinguish from port-variable assignment (which I would deem the much more common case and thus a much more useful syntax, especially for multi-dimensional arrays because I only need to declare one port variable instead of one integer variable per dimension and I don't have to pick the port from the array explicitly once more).<br />
<br />
you have to agree that for an n-dimensional port array P<br />
<br />
var integer i1, ..., in;<br />
<br />
[] any port from p.receive(...) -&gt; port (i1, ..., in) { p[i1]...[in].send(...) }<br />
<br />
demands a lot of unnecessary work for the user in contrast to:<br />
<br />
var P vp;<br />
<br />
[] any port from p.receive(...) -&gt; port vp { vp.send(...) }<br />
<br />
Also, here you see the additional advantage for the any-port-from-construct as opposed to the p[-]...[-] where you have to know (and care) how many dimensions there are in p.<br />
<br />
5) also, I have no problem with rewording the iteration procedure to make it more clear			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011685)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-10-2013 13:30&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please comment on my comments			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011693)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-10-2013 17:28&#160;&#160;&#160;
				<br />(edited on:&#32;07-10-2013 17:32)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi:<br />
1) OK<br />
2) &quot;any from P.receive&quot; looks OK for me and still not too long; any port from P seems to be somewhat long, but it is true, is absolutely clear. Also, we have to think about timer arrays, i.e. if I want to check if any timer from an array has expired. We should also add &quot;any from T.timeout&quot; or any timer from T.timeout. <br />
3) &amp; 4) For pure reply yes, a port variable would be an easy solution. But the response-case is usually not so simple. We often has to maintain the state machines of the ports, because the response depends on the (incoming message + port state). The state is most often a record of enumerated or record of integer, so to check the old state of a port and to store the new state after sending the response, the indices are needed anyway. In fact, multi-dimensional port arrays are used very rarely, if used at all. I haven't seen any yet. I think we should design the language for the majority of use-cases.<br />
<br />
<br />
So, in summary, I think that:<br />
- we cannot avoid a mechanism to store the port (timer) index. In most cases it will be a single-dimensional index, and the syntax should be optimized for this, but there should be a way to store multi-dimensional indexes as well. For example, we can say that an integer variable or an integer array - that has the same dimensions as the port/timer array itself - name shall be used to store the index. And probably, we could also allow using just an integer array name when referencing a port or timer from an array.  <br />
- we should keep the solution as simple as possible for the tool makers as well. For this reason one mechanism may be sufficient. On the other hand, port parameters are allowed, therefore allowing port variables as well may not be a tremendous extension for tool providers.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011697)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2013 10:48&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				So, the proposal is this, for an N-dimensional port array P:<br />
<br />
any [port] from P.receive(...) -&gt; port X<br />
<br />
where X can either be<br />
1) a port variable<br />
2) an integer variable, if N is 1<br />
3) an integer array variable of length N<br />
4) a tuple of integer variables with N components<br />
<br />
For easiest usage, we should then also allow for multi-dimensional arrays (case 2) also the syntax P[X], which is short for P[X[0]]...[X[N-1]]<br />
<br />
If the last is allowed, then I suppose cases 2 and 3 are really the only ones you need.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011703)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2013 14:04&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion: stay with 2) and 3) and the short form of using an integer array as a port index reference. Implement it for port, timer and component arrays. The syntax of storing the index need to be thought about  when reviewing the resolution draft.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011716)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2013 18:36&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please crosscheck			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011736)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-10-2013 16:18&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				CR6089_resolution_v2.doc, please review. Hope its self explaining, where I though explanation is useful, added it in a comment.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011756)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-10-2013 15:27&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In principle okay. I still don't think that the new keyword mechanism really needs to be only for modifiers (for me, the @-symbol is more like a keyword-escape-mechanism), but I can think we can discuss that for the future.<br />
<br />
I left out the .running and .alive constructs originally because they are not really problematic (they are not blocking and can be solved with a for-loop over the array) while the problem for the blocking constructs cannot be solved with a for-loop. But, if you really also want them in there, I have no problem with that.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011865)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-11-2013 12:19&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				As proposed with additions/editorials in v4			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
