<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:18:09 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006008: Match omit Ð¼Ñ‹ undefined value - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006008</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Clarification</td><td class="print">public</td><td class="print">19-01-2012 17:18</td><td class="print">10-07-2012 13:59</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Nikolay Pakulin</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">N/A</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">won't fix</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">B 1.1, 6.3</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">ISPRAS, STF 433</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006008: Match omit Ð¼Ñ‹ undefined value</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">The following test case is a refined case when a record, initialized by an array, is matched back agains that array.  The pecularity of the test case is that the array contains an undefined element.  According to clause 6.3.2.2 corresponding optional field of the record becomes *omit*. <br />
<br />
So, the question actually is: how to match an omitted value against an undefined value.  What output should the test case produce -- whether full values match or not, whether omitted value matched undefined?</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">module match_omit_undefined {<br />
&#160;&#160;&#160;&#160;type record Record {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;integer a optional<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;type record length(1) of integer Array;<br />
&#160;&#160;&#160;&#160;type component MTC {}<br />
&#160;&#160;&#160;&#160;<br />
&#160;&#160;&#160;&#160;testcase TC_match_omit_undefined() runs on MTC<br />
&#160;&#160;&#160;&#160;{<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;var Array array := {-};<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// recrd.a must be set to omit<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// TTCN3, v.4.3.1<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// Clause 6.3.2.2: If an element with an undefined value is assigned to an optional element of the record, this will <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// cause the optional element to be omitted.<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;var Record recrd := array;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;var boolean v_match_structured_values := match(recrd, array);<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;var boolean v_match_omit_undefined := match(recrd.a, array[0]);<br />
&#160;&#160;&#160;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;log(&quot;Result of matching missing elements: &quot;, v_match_omit_undefined);<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;log(&quot;Result of matching structured values: &quot;, v_match_structured_values);<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;control {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;execute(TC_match_omit_undefined())<br />
&#160;&#160;&#160;&#160;}<br />
}</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0006165</td><td class="print">closed&#160;</td><td class="print">&#160;</td><td class="print">Add recof2setof predefined function&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">19-01-2012 17:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=704">Nikolay Pakulin</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">19-01-2012 17:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=704">Nikolay Pakulin</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; B 1.1, 6.3</td></tr><tr class="print"><td class="print">19-01-2012 17:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=704">Nikolay Pakulin</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; ISPRAS, STF 433</td></tr><tr class="print"><td class="print">19-01-2012 17:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=704">Nikolay Pakulin</a></td><td class="print">Note Added: 0010546</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 09:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Relationship added</td><td class="print">related to 0006165</td></tr><tr class="print"><td class="print">10-07-2012 13:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010754</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 13:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; closed</td></tr><tr class="print"><td class="print">10-07-2012 13:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">open =&gt; won't fix</td></tr><tr class="print"><td class="print">10-07-2012 13:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010546)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=704">Nikolay Pakulin</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-01-2012 17:21&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The title of the CR should read: &quot;Match omit vs undefined value&quot;.<br />
Cyrillic &quot;Ð¼Ñ‹&quot; crawled in due to automatic keyboard layout switcher.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010754)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 13:59&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				There is no statement that undefined content is changed to omit. According to clause 11.1 restriction d) and e) the assignment recrd := array and both match operations above shall cause an error.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
