<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:39 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005922: why strong typing is not used in map and unmap? - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005922</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">22-08-2011 15:19</td><td class="print">28-08-2013 14:58</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Andrus Lehtmets</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">TTCN-3 Edition 4.3.1: Core Language</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Elvior    </td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005922: why strong typing is not used in map and unmap?</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Why strong typing is not used in map and unmap<br />
<br />
This makes it impossible to resolve system type during compile time. <br />
<br />
This is important when using port parameters, because otherwise it is impossible to perform any compile time check regarding parameter types an number of parameters.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">Ina: Wrt. strong typing in map: we have the concept of consistent connections in TTCN-3, which also apply to the usage of map and unmap. That has been designed by intend. Please explain scenarios why (and how) you like to sharpen this.<br />
<br />
TomÃ¡Å¡ Urban: The problem is that TSI type declaration is a part of test case declaration and it is visible only within its scope. So if you use map(self:PCO2, system:PCO1) param(v_test1, v_test2) inside a function called from the test case (which is a common situation in many test suites), there's no way how to find out what is the system port type in compile time and it is therefore necessary to link parameters in runtime. We have no technical issues with implementing this solution, but it means that some errors in the code won't be discovered during compilation. Strong typing would resolve this problem. It could be applied only if the param clause is present (meaning there would be no backward compatibility problems with legacy mapping/unmapping calls which don't contain parameters) and it would determine the required type of the system port: map(self:PCO2, system:PCO1) param MyPortType (v_test1, v_test2).<br />
<br />
</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0006412</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">system component shall be passed to functions with map/unmap statements&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5922.doc (753,664) <span class="italic">29-09-2011 14:10</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2574&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5922-v2.doc (1,268,736) <span class="italic">11-07-2013 15:21</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2831&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5922-v3.doc (1,292,800) <span class="italic">28-08-2013 14:57</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2870&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">22-08-2011 15:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=509">Andrus Lehtmets</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">22-08-2011 15:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=509">Andrus Lehtmets</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; TTCN-3 Edition 4.3.1: Core Language</td></tr><tr class="print"><td class="print">22-08-2011 15:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=509">Andrus Lehtmets</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Elvior    </td></tr><tr class="print"><td class="print">27-09-2011 12:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">27-09-2011 12:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">27-09-2011 12:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">27-09-2011 12:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.4.1</td></tr><tr class="print"><td class="print">27-09-2011 16:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010254</td><td class="print"></td></tr><tr class="print"><td class="print">29-09-2011 10:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010292</td><td class="print"></td></tr><tr class="print"><td class="print">29-09-2011 14:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR5922.doc</td><td class="print"></td></tr><tr class="print"><td class="print">29-09-2011 14:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010299</td><td class="print"></td></tr><tr class="print"><td class="print">29-09-2011 14:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">30-11-2011 11:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010437</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2011 11:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">02-12-2011 09:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0010498</td><td class="print"></td></tr><tr class="print"><td class="print">02-12-2011 09:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">02-12-2011 14:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010526</td><td class="print"></td></tr><tr class="print"><td class="print">02-12-2011 14:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">06-12-2011 10:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010531</td><td class="print"></td></tr><tr class="print"><td class="print">16-12-2011 05:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0010539</td><td class="print"></td></tr><tr class="print"><td class="print">16-12-2011 05:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">Edition 4.4.1 =&gt; v4.7.1 (published 2015-06)</td></tr><tr class="print"><td class="print">11-07-2012 16:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0010843</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2012 16:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">13-07-2012 11:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010916</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2012 14:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">13-07-2012 15:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0010934</td><td class="print"></td></tr><tr class="print"><td class="print">16-07-2012 10:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010936</td><td class="print"></td></tr><tr class="print"><td class="print">16-07-2012 10:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0010936</td><td class="print"></td></tr><tr class="print"><td class="print">18-01-2013 11:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0006412</td></tr><tr class="print"><td class="print">08-07-2013 18:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">v4.5.1 (published 2013-04) =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">09-07-2013 11:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011456</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2013 15:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR5922-v2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2013 15:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011549</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2013 15:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">11-07-2013 15:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">28-08-2013 14:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR5922-v3.doc</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2013 14:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011625</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2013 14:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">28-08-2013 14:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">28-08-2013 14:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">28-08-2013 14:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010254)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-09-2011 16:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I propose the following solution.<br />
<br />
1) disallow parameterized map/unmap for unknown mtc/system-ports.<br />
2) - allow system clauses also on function/altstep definitions (where system compatibility must be the same as runs on compatibility)<br />
&#160;&#160;&#160;&#160;- allow mtc clauses (analogously to system clauses) for function/altstep definitions (where mtc compatibility must also be the same as runs on compatibility)<br />
<br />
For backward compatibility, it shall still be allowed to call a function/altstep without system/mtc clause from a context with system/mtc clause, as long as the restrictions on the runs on compatiblity are adhered to.<br />
<br />
Like for runs-on clauses, it shall not be possible to call a function/altstep with a system/mtc clause from a context without system/mtc clause (respectively).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010292)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-09-2011 10:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion 2011-09-29: proposal is basically agreed; map operation using parameters shall use the system keyword.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010299)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-09-2011 14:11&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				uploaded proposal, please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010437)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-11-2011 11:16&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Jens, pls. review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010498)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-12-2011 09:04&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Proposal looks good for me. However, I am not sure about backwards compatability. The additional restrictions may invalid older test suites. GyÃ¶rgy, please have a look at this.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010526)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-12-2011 14:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I may be biased by the earlier discussions that the whole mtc and system checking stuff shall be an option to the user. I.e. it shall be able to introduce it with minimal effort into its code and no checking shall be mandatory. From the proposed text only the additional restrictions to the<br />
16.1.1	Invoking functions<br />
and<br />
16.2.1	Invoking altsteps<br />
clauses seem to be potentially problematic as they can also be understood that these checks are always mandatory (while they are mandatory for the tools only IF any of these clauses present).<br />
<br />
I'm, still not quite sure about the practical usability of these additions. They become absolutely useless as soon as the user has two MTC or two TSI types with the same port instance definition(s). In this case he/she cannot use the mtc clause e.g. in activated defaults that will check the messages on that common port instance(s).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010531)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				06-12-2011 10:12&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I don't understand the objection/doubts. If two component types have the same instance definitions, then they are compatible and so don't pose a problem when checking.<br />
<br />
The additional restrictions have been modeled after the existing ones for the runs-on clause so they are consistent with the already existing features and totally backward compatible. If code does not use system/mtc clauses it is as valid as before. Only if the new map-param-statement shall be used do they get any relevance.<br />
<br />
In principle, this will only lead to a very meagre number of new system/mtc clauses, i.e. only those functions need it that use these map statements (which are normally called directly from the testcase where mtc and system type are known anyway) need them.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010539)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-12-2011 05:21&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Since resolution is not yet agreed, it is moved to 2012			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010843)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-07-2012 16:21&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				GyÃ¶rgy, please check the comments from Jacob.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010916)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-07-2012 11:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think that the proposal is too restrictive. The component type in the mtc and system clauses would be used to check only the port consistency in map operations when mtc nad/or system ports are mapped. But in this case:<br />
<br />
1) Why ALL definitions shall be compatible for mtc and system component compatibility? (clause 6.3.3 item 3) and 4)) Why it is not sufficient if port definitions are compatible?<br />
<br />
2) Why a function or altstep with an mtc and/or a system clause cannot be called from a function or altstep without mtc or system clause? The feature provided by mtc and system clauses<br />
- is local to the map operation<br />
- is totally different from the runs on clause; runs on identifies a component type on which the given function should run. While an mtc clause identifies a &quot;foreign&quot; component, the given function is just references a port of it. In case of system, even no TTCN-3 code is running on TSI. So, trying to compare mtc and system clauses to runs on clauses is the same as comparing apples with avocado: they are simply different things.<br />
<br />
So, I don't understand, why the simple example below should be disallowed?:<br />
<br />
function f() runs on PTC {// why mtc and system clauses would be needed here, when they are not used to anything?<br />
&#160;var PTC v_PTC := PTC.create;<br />
&#160;makeMaps();<br />
&#160;makeConnections(v_PTC)<br />
}<br />
<br />
function makeMaps() runs on PTC mtc MTC system TSI {<br />
&#160;&#160;map (mtc:P, system:P)//the mtc and system clauses are needed only to check this statement<br />
}<br />
<br />
function makeConnections(PTC p_PTC ) runs on PTC mtc MTC {<br />
&#160;&#160;connect (p_PTC:COORD, mtc:COORD); //the mtc clause is used only to check this statement<br />
}<br />
<br />
From a practical perspective, the restrictive approach is useless, because no user (no Ericsson user) will be able or will want to introduce mtc and system clauses throughout the WHOLE existing code, practically for nothing; while, if mtc and system clauses would be required only at the places, where they are REALLY needed, the feature would be used!			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010934)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-07-2012 15:46&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I agree with GyÃ¶rgy. I would prefer if it was still possible to call functions with mtc and system clause from functions that don't contain these clauses. Of course if both caller and callee contain the clauses then compatibility check should be still performed.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010936)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-07-2012 10:35&#160;&#160;&#160;
				<br />(edited on:&#32;16-07-2012 10:50)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				What you propose would negate anything to be gained from the new construct, i.e. being able to check statically, whether a map statement will be semantically correct at runtime or not. If a function is called from a context which does not know its system type, then no static analysis can determine if the system type required by the calling function (via system clause) is compatible with the one in the runtime context of the calling one, i.e. if the ports to be mapped to actually exist and have the right attributes.<br />
<br />
So, the restrictions I proposed are SPECIFICALLY designed to grant exactly this possibility - to allow static correctness analysis of map statements outside of testcase definitions (i.e. in functions or altsteps).<br />
<br />
Also, the scenario that Gyorgy describes Ericsson would be faced with is totally unrealistic. Only those functions that directly or indirectly use a map statement (like the function f() in your example which incidentally DOES use a map statement, albeit indirectly) need to be augmented with the system clause (all others need not be changed at all) - which should be very few. <br />
The rules are simple. If a function causes a map statement, then it should ensure its correctness. If a function causes a connect statement, then it should ensure its correctness.<br />
<br />
In principle, I could live with lessening the restriction - thus yielding a warning during static analysis like today if the system type of the calling function is unknown or cannot be safely determined -, but then for consistency reasons, it should be lessened for the runs on clause as well, as there the same arguments can be used, i.e. that runtime checks are totally sufficient (for some people).<br />
<br />
Finally, the argument about the restrictions regarding non-ports is totally academic, as using a full-fledged component type as system type does not make sense (and therefore is a misleading use of a type) as the system has no behaviour that could access its timers/variables/constants (and they cannot be accessed by anyone else either). To alleviate the fears of possible backward incompatibilities of such strange usages, the restrictions between system clauses could, of course, be limited to the port declarations only.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011456)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-07-2013 11:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Shall this be further discussed? <br />
<br />
Summing up the concerns:<br />
- define mtc/system compatibility only regarding to port declarations<br />
- allow clause-less behavior to call clause-having behavior even though this can lead to runtime errors<br />
<br />
For consistency's sake, I would propose to have the same lessing of presence-of-clause-restriction for the runs-on clause as otherwise no user will ever understand why the restriction is (unnecessarily) enforced in one place but not in the others which to them are very much alike.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011549)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-07-2013 15:22&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please check			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011625)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2013 14:57&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented with editorial corrections			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
