<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:18:53 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005835: BNF rule for PatternElement is ambiguous, Example is wrong - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005835</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">30-11-2010 17:12</td><td class="print">01-12-2010 16:46</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">B.1.5.2, A.1.6.1.3</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technologies - Jacob Wieland</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005835: BNF rule for PatternElement is ambiguous, Example is wrong</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">In the rule for PatternElement in the BNF, the last branch (PatternChar) creates an ambiguity as that can be any char and thus, every Pattern can be derived to a sequence of PatternChar, even those that should be derived by using the other alternatives in PatternElement.<br />
<br />
Especially for those PatternElement constructs which contain more than one character, this leads to unresolvable problems (if the ambiguity is not removed somehow).<br />
<br />
I guess the intention was that PatternChar should be any character which is not one of the characters in the &quot;first set&quot; of the other alternatives in PatternElement. Thus, the following characters need to be excluded &quot;\&quot;, &quot;?&quot;, &quot;*&quot;, &quot;|&quot;, &quot;+&quot;, &quot;[&quot;, &quot;{&quot;, &quot;&quot;&quot; and &quot;#&quot;<br />
<br />
Consequently, I think that the example in B.1.5.2 <br />
<br />
template charstring RegExp4 := pattern &quot;{Reg&quot;; <br />
<br />
should be changed to<br />
<br />
template charstring RegExp4 := pattern &quot;\{Reg&quot;;<br />
<br />
Finally, it should be forbidden to use reference expressions in referenced variables/parameters/module parameters (i.e. all entities which are unknown at compile time). I.e. if a referenced charstring value contains a reference-like expression, it is treated as if it was just the sequence of the characters of the reference. Meaning: if I have a variable v which contains &quot;{a}&quot;, then referencing it via pattern &quot;{v}&quot; will match only the charstring &quot;{a}&quot; and not any referenced 'a'. If this is the intention of the standard anyway, then it needs to be clarified.<br />
<br />
Consequently, the stuff in EXAMPLE 3 (which is wrong in any case as it is missing at least one 'pattern') should be forbidden. But, maybe there are only some typos in Ref6, where Ref1 should be Ref4 and Ref2 should be Ref5.<br />
<br />
I guess what the example was really supposed to be was this:<br />
<br />
template charstring Ref0:= &quot;My String&quot;;<br />
template charstring Ref1:= &quot;{Re&quot;;<br />
template charstring Ref2:= &quot;f0}&quot;;<br />
template charstring Ref3:= pattern &quot;{Ref1}{Ref2}&quot;;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;//this matches &quot;{Ref0}&quot;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;//i.e. there is no further dereferencing<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;//as Ref1 and Ref2 do not contain a reference<br />
<br />
template charstring Ref4:= pattern &quot;{Ref0}&quot;;<br />
template charstring Ref5:= &quot;&quot;;<br />
template charstring Ref6:= pattern &quot;{Ref4}{Ref5}&quot;;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;//this matches &quot;My String&quot; â€“ here Ref0 is dereferenced, because Ref4 contains <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;//the reference expression {Ref0} with the reference Ref0<br />
template charstring RegExp7 := pattern &quot;{Reg&quot; &amp; &quot;Exp1}&quot;;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;//note the difference to Ref6: in this case the fragments of the<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;//pattern are joined before any evaluation, i.e. this template will match the string &quot;ab&quot; </td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">child of</span>&#160;</td><td class="print">0005805</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">BNF rule for PatternElement is ambiguous, Example is wrong&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">30-11-2010 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2010 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">30-11-2010 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">30-11-2010 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; B.1.5.2, A.1.6.1.3</td></tr><tr class="print"><td class="print">30-11-2010 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Testing Technologies - Jacob Wieland</td></tr><tr class="print"><td class="print">30-11-2010 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Issue generated from: 0005805</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2010 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Relationship added</td><td class="print">child of 0005805</td></tr><tr class="print"><td class="print">01-12-2010 16:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009904</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 16:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">01-12-2010 16:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">01-12-2010 16:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.3.1 (not yet published)</td></tr><tr class="print"><td class="print">01-12-2010 16:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.3.1 (not yet published)</td></tr><tr class="print"><td class="print">01-12-2010 16:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009904)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-12-2010 16:44&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Example corrected as proposed. In addition, RegExp7 removed as this is part of Example 2 and not of Example 3.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
