<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:18:44 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005601: Erroneous example on matching attributes - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005601</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Clarification</td><td class="print">public</td><td class="print">12-07-2010 12:17</td><td class="print">15-12-2010 00:07</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">15.7.4</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">L.M.Ericsson</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005601: Erroneous example on matching attributes</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">The example in $15.7.4:<br />
&#160;&#160;&#160;&#160;type record R {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;record of integer ri optional<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;template R r:=<br />
&#160;&#160;&#160;&#160;{ 	<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ri := * length (1 .. 6) ifpresent // any value containing 1, 2, 3, 4,  <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// 5 or 6 provided it is present<br />
&#160;&#160;&#160;&#160;}<br />
<br />
is not correct:<br />
- according to the BNF length and ifpresent cannot be applied together;<br />
- not the numbers 1..6 but lists of 1..6 elements are allowed;<br />
<br />
The example should be changed to:<br />
&#160;&#160;&#160;&#160;template R r:=<br />
&#160;&#160;&#160;&#160;{ 	<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ri := { * length (1 .. 6) } ifpresent // any value containing 1, 2, 3, 4, 5 or 6 elements, provided it is present<br />
&#160;&#160;&#160;&#160;}<br />
<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">12-07-2010 12:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2010 12:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 15.7.4</td></tr><tr class="print"><td class="print">12-07-2010 12:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; L.M.Ericsson</td></tr><tr class="print"><td class="print">12-07-2010 16:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">12-07-2010 16:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.3.1 (not yet published)</td></tr><tr class="print"><td class="print">30-08-2010 11:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">30-08-2010 11:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Benjamin Zeiss</td></tr><tr class="print"><td class="print">31-08-2010 11:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Note Added: 0009662</td><td class="print"></td></tr><tr class="print"><td class="print">01-09-2010 10:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Assigned To</td><td class="print">Benjamin Zeiss =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">01-09-2010 11:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009672</td><td class="print"></td></tr><tr class="print"><td class="print">01-09-2010 17:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Note Added: 0009683</td><td class="print"></td></tr><tr class="print"><td class="print">01-09-2010 17:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">01-09-2010 17:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">01-09-2010 17:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">01-09-2010 17:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Status</td><td class="print">resolved =&gt; feedback</td></tr><tr class="print"><td class="print">01-09-2010 17:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Resolution</td><td class="print">fixed =&gt; reopened</td></tr><tr class="print"><td class="print">01-09-2010 17:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Status</td><td class="print">feedback =&gt; resolved</td></tr><tr class="print"><td class="print">01-09-2010 17:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; fixed</td></tr><tr class="print"><td class="print">14-12-2010 14:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009964</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2010 14:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009965</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2010 14:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Deleted: 0009965</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2010 14:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Deleted: 0009964</td><td class="print"></td></tr><tr class="print"><td class="print">15-12-2010 00:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Edited: 0009672</td><td class="print"></td></tr><tr class="print"><td class="print">15-12-2010 00:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009975</td><td class="print"></td></tr><tr class="print"><td class="print">15-12-2010 00:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">15-12-2010 00:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.3.1 (not yet published)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009662)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				31-08-2010 11:41&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Actually, I don't see why this example should be erroneous. Taking the 4.2.2 EBNF as reference, the template definition is derived from rule 93. TemplateDef. If we take<br />
<br />
&#160;&#160;&#160;&#160;template R r:=<br />
&#160;&#160;&#160;&#160;{<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ri := * length (1 .. 6) ifpresent // any value containing 1, 2, 3, 4,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// 5 or 6 provided it is present<br />
&#160;&#160;&#160;&#160;}<br />
<br />
it can be derived as follows (skipping a few unimportant steps):<br />
<br />
TemplateDef -&gt; <br />
TemplateKeyword BaseTemplate AssignmentChar TemplateBody<br />
<br />
Let's concentrate on the TemplateBody.<br />
<br />
TemplateBody -&gt; <br />
FieldSpecList -&gt; <br />
&quot;{&quot; FieldSpec &quot;}&quot; -&gt; <br />
&quot;{&quot; FieldReference AssignmentChar TemplateBody &quot;}&quot;<br />
<br />
Let's concentrate on the right TemplateBody as FieldReference AssignmentChar will derive to &quot;ri := &quot; - I think we can agree on that.<br />
<br />
TemplateBody -&gt; <br />
SimpleSpec ExtraMatchingAttributes -&gt; <br />
SingleValueOrAttrib ExtraMatchingAttributes -&gt; <br />
MatchingSymbol ExtraMatchingAttributes -&gt; <br />
AnyOrOmit ExtraMatchingAttributes -&gt; <br />
&quot;*&quot; ExtraMatchingAttributes -&gt; <br />
&quot;*&quot; (LengthMatch IfPresentMatch) -&gt; <br />
&quot;*&quot; StringLength &quot;ifpresent&quot; -&gt; <br />
&quot;*&quot; &quot;length&quot; &quot;(&quot; SingleConstExpression [&quot;..&quot; UpperBound] &quot;)&quot; &quot;ifpresent&quot; <br />
-&gt; ...<br />
<br />
I think now it should be clear that the sentence is derivable if I did not make any bad mistake. Just in case, I have tested the syntactical snippet in the TRex parser and it accepts it as well. <br />
<br />
To summarize: length and ifpresent can be applied together, because the third alternative in rule<br />
<br />
117. ExtraMatchingAttributes ::= LengthMatch | IfPresentMatch | (LengthMatch IfPresentMatch)<br />
<br />
allows it in exactly the notation specified in the example.<br />
<br />
If the person reviewing this does not find a mistake here, I suggest to close as resolved.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009672)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-09-2010 11:22&#160;&#160;&#160;
				<br />(edited on:&#32;15-12-2010 00:06)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				You are correct, the BNF allows this.<br />
<br />
But, the example still should be changed as the comment does not match<br />
the code: <br />
<br />
// any value containing 1, 2, 3, 4,<br />
// 5 or 6 provided it is present<br />
<br />
should be changed to<br />
<br />
// any value containing 1, 2, 3, 4,<br />
// 5 or 6 elements, provided it is present<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009683)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-09-2010 17:07&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I agree. Changing to resolved and assigning to Ina.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009975)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-12-2010 00:07&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Comment changed as proposed			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
