<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:18:36 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005347: Subtyping rules when referencing fields of structured types - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005347</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Clarification</td><td class="print">public</td><td class="print">14-09-2009 11:15</td><td class="print">01-07-2011 15:58</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">always</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.1.1 (published 2009-06)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.3.2 (interim 2011)</td><td class="print-category">Fixed in Version</td><td class="print">v4.3.2 (interim 2011)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">6.2.1.1, 6.2.2.1, 6.2.5.1</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">L.M.Ericsson</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005347: Subtyping rules when referencing fields of structured types</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">This is not covered by the current text. Proposed rules are:<br />
-when referencing a field, the type constraint of the field shall be part of the new type; example:<br />
type record R { x integer optional (1,2), y integer optional (1,2)}<br />
type R.x X //=&gt; R.x is defining the type integer X (1,2)<br />
<br />
- when referencing a field, any type constraint of the structured type shall be ignored; examples:<br />
1)<br />
type record R1 { x integer optional }<br />
type R1 R2 ( {}, { x := omit }, { x := 4 }, { x := 5 } )<br />
type R2.x X2;<br />
<br />
If the constraint of the record type would be &quot;transformed back&quot; to constraint of the referenced field, X2 would be:<br />
&#160;X2 -&gt; type integer X2 (&lt;empty&gt;, omit, 4, 5)<br />
that is not a valid type definition.<br />
<br />
2)If the constraint of the record type is &quot;transformed back&quot; to a constraint of the referenced field:<br />
<br />
type record R3 { x integer optional, y integer optional } ({x:=1,y:=2}, {x:= 2,y:=1}, {x:=omit, y:=2}, {x:=1, y:=omit})<br />
<br />
R3 should have the same value space as R. But it does not have.<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif" alt="zip" />&#160;CR5347.zip (735,241) <span class="italic">03-09-2010 13:11</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2442&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5347_resolution_v2.doc (110,592) <span class="italic">25-05-2011 14:38</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2485&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5347_resolution_v3.doc (71,680) <span class="italic">25-05-2011 14:56</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2486&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5347_resolution_v4.doc (73,216) <span class="italic">01-07-2011 15:56</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2551&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">14-09-2009 11:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">14-09-2009 11:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">14-09-2009 11:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">14-09-2009 11:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 6.2.1.1, 6.2.2.1, 6.2.5.1</td></tr><tr class="print"><td class="print">14-09-2009 11:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; L.M.Ericsson</td></tr><tr class="print"><td class="print">07-12-2009 14:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.2.1 (not yet published)</td></tr><tr class="print"><td class="print">04-01-2010 13:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009156</td><td class="print"></td></tr><tr class="print"><td class="print">04-01-2010 13:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">Edition 4.2.1 (not yet published) =&gt; Edition 5.1.1 (not yet published)</td></tr><tr class="print"><td class="print">22-03-2010 17:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; </td></tr><tr class="print"><td class="print">22-03-2010 17:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; new</td></tr><tr class="print"><td class="print">23-03-2010 12:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">23-03-2010 12:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">23-03-2010 15:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009265</td><td class="print"></td></tr><tr class="print"><td class="print">24-03-2010 11:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009274</td><td class="print"></td></tr><tr class="print"><td class="print">24-03-2010 11:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009274</td><td class="print"></td></tr><tr class="print"><td class="print">24-03-2010 12:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">03-09-2010 13:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR5347.zip</td><td class="print"></td></tr><tr class="print"><td class="print">03-09-2010 13:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009711</td><td class="print"></td></tr><tr class="print"><td class="print">03-09-2010 13:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">03-09-2010 13:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">03-09-2010 13:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.3.1 (not yet published)</td></tr><tr class="print"><td class="print">03-09-2010 13:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">14-12-2010 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009970</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2010 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">14-12-2010 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print">Edition 4.3.1 (not yet published) =&gt; </td></tr><tr class="print"><td class="print">14-12-2010 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">Edition 4.3.1 (not yet published) =&gt; Edition 4.3.2 (interim)</td></tr><tr class="print"><td class="print">25-05-2011 11:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; feedback</td></tr><tr class="print"><td class="print">25-05-2011 11:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">fixed =&gt; reopened</td></tr><tr class="print"><td class="print">25-05-2011 11:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010047</td><td class="print"></td></tr><tr class="print"><td class="print">25-05-2011 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">feedback =&gt; assigned</td></tr><tr class="print"><td class="print">25-05-2011 13:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010047</td><td class="print"></td></tr><tr class="print"><td class="print">25-05-2011 14:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010047</td><td class="print"></td></tr><tr class="print"><td class="print">25-05-2011 14:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5347_resolution_v2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">25-05-2011 14:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010047</td><td class="print"></td></tr><tr class="print"><td class="print">25-05-2011 14:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010047</td><td class="print"></td></tr><tr class="print"><td class="print">25-05-2011 14:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR5347_resolution_v3.doc</td><td class="print"></td></tr><tr class="print"><td class="print">25-05-2011 15:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010062</td><td class="print"></td></tr><tr class="print"><td class="print">25-05-2011 15:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">25-05-2011 15:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">01-07-2011 15:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR5347_resolution_v4.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2011 15:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0010186</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2011 15:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">01-07-2011 15:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; fixed</td></tr><tr class="print"><td class="print">01-07-2011 15:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.3.2 (interim)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009156)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-01-2010 13:49&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				We should discuss if defining a synonym for a nested type definition is a wanted feature of TTCN-3 or not. <br />
<br />
Depending on the outcome, (1) we may exclude type synonyms for nested type definitions or (2) we have to develop a solution. However this is not trivial as pointed out in the examples.<br />
<br />
Hence, postponed to 2010.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009265)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				23-03-2010 15:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				For consistency, the type R.x should include all values that can be<br />
assigned to field x in type R. Thus, it should include all values<br />
described by the subtypeSpec of field x, as well as the special 'value' omit.<br />
<br />
For that, one would need (the idea of) a special type construct like<br />
<br />
&#160;&#160;&#160;&#160;type integer X optional (1,2);<br />
<br />
Entities declared with this type automatically include the special value omit<br />
and thus can be used for the purpose of storing values the same values as<br />
field x.<br />
<br />
The problem with this solution is, of course, that suddenly, a type<br />
(which normally only describes non-special values), now also contains omit.<br />
That means that the semantics of the template restrictions for this type<br />
need clarification:<br />
- template(value) R.x =&gt; all values of R.x except omit<br />
&#160;&#160;(as opposed to all of R.x for non-optional field x) <br />
- template(omit) R.x =&gt; all values of R.x including omit<br />
&#160;&#160;(as opposed to all of R.x PLUS omit for non-optional field x)<br />
- template(present) R.x =&gt; the same as normally<br />
<br />
However, the beauty of the solution lies in the consistency:<br />
It is always possible to use an entity of type R.x to field x in R and the<br />
other way around which is the definition of a compatible type.<br />
If the 'optional' would disappear from the type definition, R.x would be<br />
compatible to field x, but field x would not be compatible to R.x.<br />
<br />
While in my opinion, it would be nice to define the above type X as written<br />
also in TTCN-3, it is not really necessary, as one can always just refer<br />
to R.x instead or define X as:<br />
<br />
&#160;&#160;&#160;&#160;type R.x X;<br />
<br />
to arrive at the same semantics for X.<br />
<br />
If this solution is acceptable, the following needs to be done:<br />
<br />
- describe the semantics of R.x in the section describing dotted notation<br />
&#160;&#160;on types<br />
<br />
- clarify the semantics of the different kinds of declarations,<br />
&#160;&#160;especially var/const/parameter/template(value)/template(omit)<br />
<br />
- define the semantics of a StructFieldSpec with an optional type which does not have an optional modifier:<br />
&#160;&#160;- either this has the same semantics as if the optional modifier were present <br />
&#160;&#160;- or this situation is forbidden<br />
<br />
- arrays and record of/set of types of such an optional type should also be<br />
&#160;&#160;- either forbidden or<br />
&#160;&#160;- explicitly allowed with the expected semantics (i.e. that they can<br />
&#160;&#160;&#160;&#160;contain omit as elements) to avoid confusion.<br />
<br />
- generelly, matching mechanisms for such a type include the same matching<br />
&#160;&#160;mechanisms as those for field x, i.e. also omit, * and ifpresent.<br />
<br />
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<br />
<br />
If this solution is unacceptable, R.x could be X without the optional part<br />
(this is the proposed solution 1) from the CR)<br />
with the drawback that not all fields x can be used as R.x, i.e.<br />
R.x is compatible with field x, but not the other way around.<br />
<br />
Though this is somewhat confusing at first hand, it would still be a<br />
useful definition. It has the advantage that no additional clarifications<br />
or restrictions would need to be introduced, as now R.x can only contain values<br />
again.<br />
<br />
The proposed solution 2) from the CR is either not consistent or is alike to <br />
the first solution proposed here, therefore needs no further discussion.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009274)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-03-2010 11:04&#160;&#160;&#160;
				<br />(edited on:&#32;24-03-2010 11:06)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Currently record/st fields have 3 ortogonal properties:<br />
- name<br />
- type (=valid value set)<br />
- optionality<br />
<br />
Optionality is the propoerty of the field itself and not of the type (of the field).<br />
<br />
What would happen if making optionality property of the type instead of property of the field?<br />
---------------<br />
In case of simple types:<br />
1) optionality would not be part of TTCN-3 built-in types, otherwise the &quot;optional&quot; in<br />
&#160;&#160;type record MyRec ( integer f1 optional);<br />
&#160;&#160;type integer MyOptInt optional;<br />
would not make sense<br />
but this would mean that the user defined type<br />
&#160;&#160;type integer MyOptint optional;<br />
would extend the built in integer type with one more value that is strange and contradicts the current logic of TTCN-3 (sub)typing.<br />
<br />
2) &quot;omit&quot; is member of the built-in types and optional in the record/set field definition shows if omit is accepted in that field or not. Thus &quot;optional&quot; in fields would become a special form of subtyping. In this case<br />
type integer MyOptInt optional;<br />
would make no sense as &quot;integer&quot; already includes &quot;omit&quot;.<br />
<br />
But what is worse, in<br />
&#160;&#160;type record MyRec {integer f1};<br />
field f1 should also accept &quot;omit&quot; as omit is member of integer.<br />
<br />
This also would mean, that if someone wants to define a type without optional, he/she should write<br />
&#160;&#160;type integer MyInt (-infinity..infinity);<br />
<br />
So, this alternative 2) would not be acceptable as would change the semantics of already existing codes.<br />
<br />
<br />
Looking at this from the another perspective:<br />
When using simple type variables/parameters in expressions and assigning them to record/set fields, tools today can check the type compile time and shall check if the value is bound runtime. If omit is made a value, tools shall also check that - if the value is bound - it does not contain an omit value (except when assigned to optional fields, where omit is allowed).<br />
<br />
This, in practical terms, would alomos double the runtime checks tools has to do, thus decreasing tool performance.<br />
<br />
-------------------<br />
In case of structured types:<br />
structured types are unlike the built-in simple types, do not contain any value by definition, the legal set of values are defined by the user. In another words, they are built-in type-construction mechanisms but not built-in types. Therefore, in case of structured types, if he users wants to include &quot;omit&quot; into the value set of his/her type, should specify it directly, like<br />
&#160;&#160;type union MyUnion { integer a1, integer a2 } optional;<br />
<br />
However, this would not be consistent to the definition of simple types, where &quot;optional&quot; would be forbidden (as omit would already been included into the built-in types).<br />
<br />
========================<br />
So, to sum up: IF omit would be made a special value in the language, this would increase language complexity; I cannot see a consistent way to handle it; it would open the way for new kind of errors, that could be checked runtime only, thus causing test case error instead of compile time errors, increase tool complexity and as a consequence, decrease tool performance;<br />
Example error:<br />
&#160;&#160;type record MyRec {integer f1 (-infinity..infinity)};<br />
...<br />
&#160;&#160;var integer v_int := omit;<br />
&#160;&#160;var MyRec v_MyRec;<br />
&#160;&#160;v_MyRec.f1 := v_int;<br />
<br />
On the other hand the advantages would be minimal. Therefore I think that this is acceptable, hence we shall go the another way.<br />
========================<br />
<br />
When quoting e.g. a record field, only the type property of the field is referenced. E.g.<br />
&#160;&#160;type record MyRec1 {integer f1 optional (-2..2) };<br />
&#160;&#160;type record MyRec2 {integer F1          (-2..2) };<br />
<br />
Myrec1.f1 and MyRec2.F1 both denotes the type integer(-2..2), though both the name and the optionality propoerties of the referenced fields do differ (but as mentioned above, they are ortogonal to the type propoerty).<br />
<br />
All subtype specs. applied to the outer type are ignored as they are not property of the fields at all, it is a property of the outer type. E.g.<br />
&#160;&#160;type record MyRec3 {integer f1 optional (-2..2), integer f2 } ({omit,1},{1,1});<br />
also denotes the type integer(-2..2), though, when this type is used in field f1 of MyRec3, it cannot take the value e.g. -2.<br />
<br />
But this is consistent of using named types in fields, e.g.<br />
&#160;type integer MyInt (-2..2);<br />
&#160;type record MyRec4 {MyInt f1 optional, integer f2 } ({omit,1},{1,1});<br />
When used in MyRec4, f1 cannot take the value e.g. -2 either, though the type MyInt contains -2 in it value set.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009711)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-09-2010 13:14&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please review the changes in the document, changes are in sections: 6.2.1.1, 6.2.2.1, 6.2.3.2 and 6.2.5.1			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009970)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-12-2010 15:29&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Not yet finally agreed - hence shifted to 2011 for consideration.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010047)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-05-2011 11:39&#160;&#160;&#160;
				<br />(edited on:&#32;25-05-2011 14:40)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Reviewing resolution... see my changes in CR5347_resolution_v2.doc.<br />
<br />
I oppose to &quot;track back&quot; the contraint applied to the outer type to the inner type for the following reasons:<br />
<br />
1) would be backward incompatible; up to know this was not specified explicitly, there are tool implementations ignoring the constraints of the outer type; for the users of these tools the narrower approach would be a non-backward compatible change.<br />
<br />
2) According to the current mapping rules, ASN.1 table constraint is mapped to TTCN-3 but relation constraint is ignored. To be consistent with the narrower approach, relation constraint should also be mapped that would result smaller value sets than today, i.e. would be non-backward compatible.<br />
example:<br />
MY-CLASS ::= CLASS {<br />
&amp;Argument OCTET STRING,<br />
&amp;identifier INTEGER UNIQUE }<br />
WITH SYNTAX { INFORMATION &amp;Argument WITH ID &amp;identifier }<br />
<br />
myObject-1 MY-CLASS ::= {INFORMATION '00'H WITH ID 1}<br />
myObject-2 MY-CLASS ::= {INFORMATION 'FF'H WITH ID 2}<br />
<br />
MySET MY-CLASS ::= { myObject-1 | myObject-2 }<br />
<br />
MyMessage := SEQUENCE {<br />
&#160;&#160;idField MY-CLASS.&amp;identifier ( {MySET} ),<br />
&#160;&#160;valueField MY-CLASS.&amp;Argument ( {MySET} <a href="mailto:{@id">{@id</a>Field} )<br />
}<br />
This, in fact denotes the constraint ({1,'00'H},{2,'FF'H}) to the SEQUENCE.<br />
<br />
But its equivalent TTCN-3 type today is:<br />
type record { integer idField (1,2), octetstring valueField ('00'O,'FF'O)};<br />
this allowes the values {2,'00'O} and {1,'FF'O}, that are illegal values according to the ASN.1 spec. and are used for negative testing!<br />
<br />
3) types are often defined as embedded types and used later to define values/templates or other types. If using the narrower understanding, it is not possible to extend the set of values later, while with the broader understanding it is possible to resrict the derived type, if needed.<br />
example:<br />
type record MyRec1 { record { integer fInner (1..10)} fOuter }({{1}},{{2}})<br />
type MyRec1.fOuter MyRec2 //this type is a record with an integer (1..10) field<br />
type MyRec1.fOuter MyRec3 ({1},{2}) //this one is a record where the field can take the values 1 and 2 only<br />
<br />
But it is not possible the opposite way. Pls. note, often this is the only way to use parameterized ASN.1 types in TTCN-3 -&gt; the parameterized type itself is not importable, but the embedding type using the parameterized type with an actual parameter is imported and, referencing its field, the given instance of the parameterized type can be used in TTCN-3.<br />
<br />
4) What about record of types? To be consistent, in case of record of record of-s, the length restriction applied to the outer record of should also be applied to the inner record of...<br />
example:<br />
type record length (5) of record of integer ConstrainedRecordOfInt;<br />
type ConstrainedRecordOfIntg[-] ConstrainedInt; //for consistency this should be a record of restricted to 5 elements...<br />
<br />
5) The omit and the record of length transition problem could be handled by extra rules and explanations in the standard, but this would, complicate the language unnecessarily, again something with several exception rules...<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010062)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-05-2011 15:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Reviewed by Gyorgy and Jacob, need a final GO from the STF.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010186)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-07-2011 15:57&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented basically as proposed.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
