<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:18:19 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005262: Partially constrained structured types - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005262</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">01-07-2009 14:51</td><td class="print">30-11-2011 09:33</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.1.1 (published 2009-06)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.4.1 (published 2012-04)</td><td class="print-category">Fixed in Version</td><td class="print">v4.4.1 (published 2012-04)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">new 6.2.13</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">L.M.Ericsson</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005262: Partially constrained structured types</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Today the standard allowes restricting structured types by a value list notation. This means that all the allowed concrete values shall be listed. Especially in case of record/set types with several fields it is not desired and not possible in practice. In these cases very often the need is just to limit the content of 1-2 fields. This could be easily achieved in the language if - borrowing the semantics of modified teplate bodies - the fields not listed in the values (of the subtype list) are considered not further restricted (i.e. any previous restriction is just inherited. Example:<br />
type record MyRec { integer int (0..255), charstring uname, charstring pswd }<br />
type MyRec MyRecRestricted ({uname := &quot;rethy&quot;, pswd := &quot;xyz&quot;},{uname := &quot;gyorgy&quot;, pswd := &quot;zyx&quot;})<br />
The type MyRecRestricted allows records with field int containing an integer between 0 and 255 and with the combined content of the string fields uname and pswd {rethy,xyz} and {gyorgy,zyx} only.<br />
<br />
Pls. note, that this extension would allow to put logical constraints on combinations of record/set fields that would be a powerfull mechanism in case of several real-life propotocols. This extension would also allow to transform ASN.1 table constraints that are ignored today.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0005938</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></span>&#160;</td><td class="print">Type restriction by template list&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5262_resolution_v1.doc (119,808) <span class="italic">27-09-2011 18:08</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2565&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">01-07-2009 14:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2009 14:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">01-07-2009 14:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">01-07-2009 14:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; new 6.2.13</td></tr><tr class="print"><td class="print">01-07-2009 14:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; L.M.Ericsson</td></tr><tr class="print"><td class="print">09-12-2009 15:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009125</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2009 15:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 5.1.1 (not yet published)</td></tr><tr class="print"><td class="print">22-03-2010 17:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; </td></tr><tr class="print"><td class="print">22-03-2010 17:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; new</td></tr><tr class="print"><td class="print">23-03-2010 12:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">23-03-2010 12:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">23-03-2010 19:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009270</td><td class="print"></td></tr><tr class="print"><td class="print">31-08-2010 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009663</td><td class="print"></td></tr><tr class="print"><td class="print">01-09-2010 16:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR5262.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-09-2010 17:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">01-09-2010 17:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009682</td><td class="print"></td></tr><tr class="print"><td class="print">03-09-2010 10:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009705</td><td class="print"></td></tr><tr class="print"><td class="print">03-09-2010 10:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009705</td><td class="print"></td></tr><tr class="print"><td class="print">03-09-2010 12:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">03-09-2010 12:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009710</td><td class="print"></td></tr><tr class="print"><td class="print">03-09-2010 13:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">03-09-2010 13:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.3.1 (not yet published)</td></tr><tr class="print"><td class="print">03-09-2010 13:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">14-12-2010 15:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009969</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2010 15:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">14-12-2010 15:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; assigned</td></tr><tr class="print"><td class="print">14-12-2010 15:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print">Edition 4.3.1 (not yet published) =&gt; </td></tr><tr class="print"><td class="print">14-12-2010 15:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">Edition 4.3.1 (not yet published) =&gt; Edition 4.3.2 (interim)</td></tr><tr class="print"><td class="print">27-09-2011 14:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">Edition 4.3.2 (interim) =&gt; Edition 4.4.1</td></tr><tr class="print"><td class="print">27-09-2011 17:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010258</td><td class="print"></td></tr><tr class="print"><td class="print">27-09-2011 18:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5262_resolution_v1.doc</td><td class="print"></td></tr><tr class="print"><td class="print">27-09-2011 18:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">28-09-2011 11:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010260</td><td class="print"></td></tr><tr class="print"><td class="print">28-09-2011 13:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">29-09-2011 09:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010288</td><td class="print"></td></tr><tr class="print"><td class="print">29-09-2011 10:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010291</td><td class="print"></td></tr><tr class="print"><td class="print">29-09-2011 12:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010291</td><td class="print"></td></tr><tr class="print"><td class="print">29-09-2011 12:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010298</td><td class="print"></td></tr><tr class="print"><td class="print">29-09-2011 12:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Deleted: CR5262.doc</td><td class="print"></td></tr><tr class="print"><td class="print">29-09-2011 12:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">30-09-2011 09:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0010306</td><td class="print"></td></tr><tr class="print"><td class="print">30-09-2011 09:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">30-09-2011 11:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">30-09-2011 11:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010308</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2011 09:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0010417</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2011 09:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">30-11-2011 09:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.4.1</td></tr><tr class="print"><td class="print">10-07-2013 17:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Relationship added</td><td class="print">related to 0005938</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009125)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-12-2009 15:42&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				A proposal has to be developed first - hence postponed to 2010.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009270)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				23-03-2010 19:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Proposal: allow templates also in SubtypeSpec<br />
<br />
The BNF needs to be changed in the following way:<br />
<br />
49 SubTypeSpec ::= AllowedValues [StringLength] | StringLength<br />
/* STATIC SEMANTICS - AllowedValues shall be of the same type as the field being subtyped */<br />
50 AllowedValues ::= &quot;(&quot; (ValueOrRange {&quot;,&quot; ValueOrRange}) | CharStringMatch &quot;)&quot;<br />
51 ValueOrRange ::= RangeDef | ConstantExpression | Type<br />
<br />
to<br />
<br />
49 SubTypeSpec ::= AllowedValuesSpec [StringLength] | StringLength<br />
/* STATIC SEMANTICS - AllowedValuesSpec shall be of the same type as the field being subtyped */<br />
50 AllowedValuesSpec ::= &quot;(&quot; (TemplateOrRange {&quot;,&quot; TemplateOrRange}) | CharStringMatch &quot;)&quot;<br />
51 TemplateOrRange ::= RangeDef | TemplateBody | Type <br />
<br />
Also, the text of 6.1.2.1 needs to be changed accordingly:<br />
<br />
6.1.2.1	Template List subtyping<br />
TTCN-3 permits the specification of a list of distinguished templates as listed in table 3. The templates in the list shall be valid templates for the type being constrained and the set of values matching at least one of these templates shall be a subset of the values defined by the type being constrained. The subtype defined by this list restricts the allowed values of the subtype to those values matched by the templates in the list. The templates in the list shall only (directly or indirectly) reference other templates or constant expressions. Constants used in the template expressions shall meet with the restrictions in clause 10. <br />
<br />
6.2.13.2	List subtyping of structured types and anytype<br />
List subtyping is possible when defining a new type based on an existing parent type, but not directly at the declaration of the first parent type (see table 3).<br />
Subtypes defined by a list subtyping restrict the allowed values of the subtype to the values matched by the templates in the list. In case of list subtyping of record, set, record of, set of, union and anytype types, the list may contain both templates and subtypes of the parent types of the type being constrained. The collection of templates denoted by the type(s) referenced in the list become instances of the new subtype. All expressions of the expanded list (i.e. after resolving the type references) shall be valid template expressions of the first parent type. The templates in the list shall only (directly or indirectly) reference other templates or constant expressions. Constants used in the template expressions shall meet with the restrictions in clause 10. <br />
<br />
Generally, all references to 'value list' in regard to the matching mechanism or subtyping should be replaced in the whole text by the more appropriate term 'template list' so it cannot be confused with the frequently used term 'value list notation'. Also, the 'value list' matching mechanism is already explicitely allowed to contain template expressions which is all the more reason to rename it properly.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009663)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				31-08-2010 11:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The changes I have proposed would allow the example given in the CR to be valid.<br />
<br />
In case of real-life protocols with lots of fields where only a few fields should be restricted, the following approach could be taken:<br />
<br />
given the following definition:<br />
<br />
type record PDU {<br />
&#160;&#160;T1 f1,<br />
&#160;&#160;...<br />
&#160;&#160;Tn fn<br />
}<br />
<br />
we would add these definitions:<br />
<br />
template PDU basePDU := ?;<br />
template PDU restrict(T1 f1 := -, ... Tn fn := -) modifies basePDU := {<br />
&#160;&#160;f1 := f1,<br />
&#160;&#160;...<br />
&#160;&#160;fn := fn<br />
}<br />
<br />
Then, we could define our restricted type(s) like this:<br />
<br />
type PDU RestrictedPDU (<br />
&#160;&#160;restrict(...), // give the fields that should be restricted as parameters<br />
&#160;&#160;restrict(...),<br />
&#160;&#160;restrict(...),<br />
&#160;&#160;...<br />
&#160;&#160;restrict(...)<br />
);<br />
<br />
If you don't want the additional generic template, you could also use inline templates:<br />
<br />
type PDU RestrictedPDU (<br />
&#160;&#160;modifies basePDU := { ... },<br />
&#160;&#160;modifies basePDU := { ... },<br />
&#160;&#160;...<br />
&#160;&#160;modifies basePDU := { ... }<br />
)<br />
<br />
<br />
Of course, if these ways are seen as too clumsy, we could additionally define that in SubtypeSpec, all (implicitly) omitted fields are automatically ? or * for optional fields, yielding the same result.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009682)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-09-2010 17:05&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009705)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-09-2010 10:17&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion and agreement on 01-09:<br />
- Subtype constraint shall allow templates, resolvable at compile time (e.g. parameterzized templates shall be called with literal values and constains resolvable at comile time only)<br />
- Allow partial definition of subtype constraints<br />
- Fields missing in the subtype constraints are automatically and implicitly gets with ? and * constraint<br />
<br />
E.g. the following both will be legal (but have different semantical meaning):<br />
type MyRec MyRecRestricted ({uname := &quot;rethy&quot;, pswd := &quot;xyz&quot;},{uname := &quot;gyorgy&quot;, pswd := &quot;zyx&quot;})<br />
type MyRec MyRecRestricted ({uname := (&quot;rethy&quot;,&quot;gyorgy&quot;), pswd := (&quot;xyz&quot;,&quot;zyx&quot;)})<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009710)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-09-2010 12:18&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009969)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-12-2010 15:00&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Not yet finally agreed - shifted to 2011 for consideration			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010258)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-09-2011 17:59&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Types are static in TTCN-3 to allow as deep compile time checking as possible. Also type constraints shall be resolvable compile time. Therefore any template used in a type constraint should have similar limitations as constants used in type constraints: should use only literals and constants obeying restriction b) of clause 10, predefined functions except of rnd , operators specified in clause 7.17.1, and other templates obeying the previous limitations. And, of course, it could only use the specific value, value list, complemented value list, AnyValue or AnyValueOrNone matchings. Seems to be much ado for almost nothing: for simple types range and list notations solve this task on a sufficient level today.<br />
For structured types, in addition, this<br />
- would make the semantics of templates different when used in type constraints or elsewhere in the code, implicitly supposing ? and * when used in type constraints and <br />
- force the user to declare named templates unnecesarily, causing extra work and decreising readibility (the user cannot really see what the type definition is).<br />
<br />
See proposed resolution in CR5262_resolution_v1.doc			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010260)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-09-2011 11:18&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think you somehow misunderstood my proposal. To clarify: <br />
<br />
First, the restrictions implying compile-time resolvability are already in the proposal, I just did not want to re-iterate the same restrictions as for constants used in type definitions.<br />
<br />
Second, only literal compound expressions shall be interpreted as containing implicit ? or * fields (kind or as a shorthand notation for an inline-modifies construct). If actual named templates are used as a subtype constraint, they shall have the same semantics as everywhere else. <br />
<br />
Third, no one forces the user to define named templates. Everything can be done with inline constructs, if so desired. This allows exactly for the effects desired by the CR, but also much, much more.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010288)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-09-2011 09:38&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				This CR is submitted two years ago. Basically my proposal is to handle it in two steps: cover the requested functionality (basically something similar but not fully equivalent to the ASN.1 table constraint) by this CR and open a new CR for the constraints by templates part that still needs some work to do. This would prevent further delay in resolving the originally requested feature.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010291)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-09-2011 10:19&#160;&#160;&#160;
				<br />(edited on:&#32;29-09-2011 12:37)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion 2011-09-29: de-couple the two features: type constraint by partially defined values and type constraints by template into separate CRs and try to resolve both for v4.4.1.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010298)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-09-2011 12:39&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Resolution draft for the partially defined value part is in CR5262_resolution_v1.doc. Pls. review.<br />
<br />
(the file CR5262.doc is moved to CR5938 under the name &quot;CR5938_initial_draft.doc&quot;)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010306)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-09-2011 09:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Resolution is fine with me. Assigned to Ina for integration into core language.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010308)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-09-2011 11:10&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Acc. to review the proposal is OK.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010417)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-11-2011 09:33&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				as proposed.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
