<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:20:29 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0002975: Allow specification of non-optional templates - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0002975</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">04-03-2008 10:01</td><td class="print">24-04-2008 19:06</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print"><font STYLE="text-decoration: line-through">user324</font></td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v3.4.1 (published 2008-09)</td><td class="print-category">Fixed in Version</td><td class="print">v3.4.1 (published 2008-09)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">A.1.6.5, A.1.6.1.4, 11.2, 5.4.1.2, 16.1</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technologies - Jacob Wieland</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0002975: Allow specification of non-optional templates</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">At the moment, it is not possible to declare a template parameter, template variable or template return type in such a way that it describes only templates which do not match the special value 'omit', i.e. templates which can only be used for non-optional fields.<br />
<br />
Since expressions containing matching mechanisms can only be passed to parameters with a template modifier, the type 'template T' must, at the moment be interpreted as: all expressions of type T which match values of type T or the value 'omit', so that they can be used to be assigned to optional fields. However, since there is no way to say that an arbitrary template expression does _not_ match 'omit', a compiler needs to produce a warning whenever a template parameter (or template variable or template return value) is assigned to a non-optional field, since this can lead to a runtime-error. Static checking to avoid this situation is nearly impossible and at best takes a very high computational effort (for a small gain).<br />
<br />
Therefore, the following solution is proposed to enhance the expressivity of the<br />
TTCN-3 type language:<br />
<br />
Allow the keyword 'ispresent' to be put (optionally) behind every occurrence of the keyword 'template'. The semantics of the type 'template ispresent T' would be all expressions of type T which do not match the special vaule 'omit'. This would mean that such a template can be safely used in an assignment to a non-optional field. Also, each non-optional field of a template would automatically have the type 'template ispresent T', if the field was declared as  of type T.<br />
<br />
As far as I can see, the following rules have to be changed in the BNF in<br />
the following way:<br />
- TemplateRestriction ::= &quot;(&quot; OmitKeyword &quot;)&quot; | IsPresentKeyword<br />
- PreDefFunctionIdentifier ::= Identifier | IsPresentKeyword<br />
<br />
and one new rule introduced:<br />
<br />
- IsPresentKeyword ::= &quot;ispresent&quot;<br />
<br />
This approach would have the advantage that no new identifier needs to be reserved, causing minimal backward compatibility issues for old Testsuites, their semantics would stay unchanged.<br />
<br />
Alternatively, I would propose the new keyword 'present' instead of using 'ispresent'. This would have the drawback that a new keyword needs to be reserved (causing possible backward compatibility issues for old testsuites, <br />
i.e. maintenance overhead for converting them to newer TTCN-3). But, the <br />
PreDefFunctionIdentifier rule need not be changed in the BNF. For this alternative, change all 'ispresent' occurrences in the above description to 'present' and remove the change for the rule for PreDefFunctionIdentifier.<br />
<br />
The name of the new modifier ispresent/present was chosen to match the semantics of the already existing constructs 'ispresent(field)' and '&lt;template&gt; ifpresent', where 'present' always means 'not omit'. Thus, the semantics of the new construct would be easily understandable for users of TTCN-3.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">Section 16.1. about functions also needs to be changed to align it with the BNF.<br />
In the section, only the keyword 'template' is allowed in the return clause, but the BNF states, that it also allows a 'RestrictedTemplate'.<br />
</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;TemplateRestrictions.doc (31,744) <span class="italic">14-03-2008 12:23</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1383&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/generic.gif" alt="?" />&#160;PreciseTemplates.ttcn (7,076) <span class="italic">14-03-2008 16:03</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1385&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif" alt="zip" />&#160;CR_2975_Allow_specification_of_non-optional_templates_02.zip (848,125) <span class="italic">22-04-2008 12:24</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1428&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif" alt="zip" />&#160;CR_2975_Allow_specification_of_non-optional_templates_03.zip (831,254) <span class="italic">22-04-2008 16:15</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1433&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_2975_Allow_specification_of_non-optional_templates_04.doc (1,650,176) <span class="italic">22-04-2008 19:53</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1436&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/generic.gif" alt="?" />&#160;TemplateRestrictionsTest.ttcn (14,519) <span class="italic">22-04-2008 19:53</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1437&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_2975_Allow_specification_of_non-optional_templates_05.doc (1,660,928) <span class="italic">23-04-2008 19:18</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1448&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">04-03-2008 10:01</td><td class="print"><font STYLE="text-decoration: line-through">user324</font></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">04-03-2008 10:01</td><td class="print"><font STYLE="text-decoration: line-through">user324</font></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">04-03-2008 10:01</td><td class="print"><font STYLE="text-decoration: line-through">user324</font></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">04-03-2008 10:01</td><td class="print"><font STYLE="text-decoration: line-through">user324</font></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; A.1.6.5, A.1.6.1.4, 11.2, 5.4.1.2, 16.1</td></tr><tr class="print"><td class="print">04-03-2008 10:01</td><td class="print"><font STYLE="text-decoration: line-through">user324</font></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Testing Technologies - Jacob Wieland</td></tr><tr class="print"><td class="print">10-03-2008 14:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Note Added: 0005186</td><td class="print"></td></tr><tr class="print"><td class="print">10-03-2008 14:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.1.1 (not yet published)</td></tr><tr class="print"><td class="print">14-03-2008 12:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: TemplateRestrictions.doc</td><td class="print"></td></tr><tr class="print"><td class="print">14-03-2008 16:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">File Added: PreciseTemplates.ttcn</td><td class="print"></td></tr><tr class="print"><td class="print">17-03-2008 09:47</td><td class="print"><font STYLE="text-decoration: line-through">user324</font></td><td class="print">Note Added: 0005244</td><td class="print"></td></tr><tr class="print"><td class="print">21-04-2008 08:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">21-04-2008 08:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">Edition 4.1.1 (not yet published) =&gt; Edition 3.4.1 (not yet published)</td></tr><tr class="print"><td class="print">22-04-2008 12:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">File Added: CR_2975_Allow_specification_of_non-optional_templates_02.zip</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 12:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Note Added: 0005492</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 15:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR_2975_Allow_specification_of_non-optional_templates_03.zip</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 16:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Deleted: CR_2975_Allow_specification_of_non-optional_templates_03.zip</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 16:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR_2975_Allow_specification_of_non-optional_templates_03.zip</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 16:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0005497</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 16:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0005498</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 16:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Thomas DeiÃŸ</td></tr><tr class="print"><td class="print">22-04-2008 19:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">File Added: CR_2975_Allow_specification_of_non-optional_templates_04.doc</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 19:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">File Added: TemplateRestrictionsTest.ttcn</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 19:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Note Added: 0005509</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 19:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Assigned To</td><td class="print">Thomas DeiÃŸ =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">23-04-2008 19:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR_2975_Allow_specification_of_non-optional_templates_05.doc</td><td class="print"></td></tr><tr class="print"><td class="print">23-04-2008 19:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">23-04-2008 19:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">24-04-2008 19:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">24-04-2008 19:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 3.4.1 (not yet published)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005186)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-03-2008 14:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				related to introduction of restricted templates in edition 3.3.<br />
Potentially related to discussion of usage of valueof.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005244)
			</td>
		</tr>
		<tr>
			<td class="print">
				<font STYLE="text-decoration: line-through">user324</font>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-03-2008 09:47&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have a problem with the PreciceTemplates example:<br />
<br />
template(omit) templates should also not be allowed to contain matching mechanisms (i.e. no ifpresent and no complement, as used in your examples), otherwise, you can pass such a template to a template(omit) parameter of a generic template(value) template and still get a runtime error if you send this 'value'.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005492)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2008 12:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF349, Thomas:<br />
First draft for review. The major change is a new clause (15.8) on template restrictions, some other changes are in the BNF and in the explanation of template parameters.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005497)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2008 16:17&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Uploaded my comemnts in CR_2975_Allow_specification_of_non-optional_templates_03.zip. There are text enhancements only, no principal issues.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005498)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2008 16:19&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Thomas, I assigned it to you for review but Ina should also review it.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005509)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2008 19:56&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Removed irrelevant clauses, rules in BNF that need to be changed are highlighted, some minor corrections to changes proposed by Gyorgy.<br />
Supplementary TTCN-3 file uploaded, this can be seen as tests for this feature.<br />
<br />
After crosscheck by Ina, there should be another final crosscheck by Gyorgy.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
