<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:20:28 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0002151: Local Timers - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0002151</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Clarification</td><td class="print">public</td><td class="print">15-10-2007 13:40</td><td class="print">24-04-2008 19:45</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v3.4.1 (published 2008-09)</td><td class="print-category">Fixed in Version</td><td class="print">v3.4.1 (published 2008-09)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">$23</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">&#160;&#160;&#160;&#160;&#160;</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0002151: Local Timers</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">According to the TTCN-3 core spec â€œany timer.timeoutâ€ or â€œall timer.stopâ€ within an activated default behaviour is not to be applied to a local timer. This is not obvious on the first view in the spec and not what a user with TTCN-2 background would expect. <br />
Example:<br />
altstep defaultBehaviour() runs on somePTC { <br />
&#160;&#160;[] any timer.timeout {<br />
&#160;&#160;&#160;&#160;all timer.stop;<br />
&#160;&#160;}<br />
}<br />
<br />
function myFunction() runs on somePTC { <br />
&#160;&#160;&#160;&#160;timer localTimer := 1.0;<br />
&#160;&#160;&#160;&#160;alt {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;[] somePCO.receive(ExpectedMsg)) {}<br />
&#160;&#160;&#160;&#160;}<br />
}<br />
Function myFunction will wait forever when ExpectedMsg is not coming, even when defaultBehaviour is activated.<br />
ïƒž localTimer needs to be handled explicitly in myFunction:<br />
<br />
function myFunction() runs on somePTC { <br />
&#160;&#160;&#160;&#160;timer localTimer := 1.0;<br />
&#160;&#160;&#160;&#160;alt {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;[] somePCO.receive(ExpectedMsg)) {}<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;[] localTimer.timeout {}<br />
&#160;&#160;&#160;&#160;}<br />
}<br />
Note: misinterpretations in this case may lead to unexpected run-time behaviour and probably to compiler incompatibilities which may be hard to find.<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">One possible solution, of course, would be using component timers for general guarding purposes and for protocol timers. When local timers are used, also a default has to be activated locally by passing the local timer as parameter to the default.<br />
<br />
However, existing TTN-2 code may not be written in this style and these restrictions can make conversion a difficult and resource-consuming task. Hence, we shall consider changing the TTCN-3 semantics (in fact the hypothetical model of timer handling). Namely, timer semantics could be similar to semantics of defaults: running and expired timer lists are lists of the component instance; to execute operations on timers individually still requires visibility of the timerâ€™s name at the place of the operation, but any timerâ€¦ and all timerâ€¦ operations are executed on all timers on the list, independently where they have been declared. Note, that timers with the same name can be declared and started in a testcase, in different functions and altsteps; hence timer names shall be put on the list prefixed with the name of the entity is has been declared in (similarly to default variables).<br />
<br />
There are two options to carry out the changes in the text of the standards (beyond Part-1 also Part-4 may be affected):<br />
-	if no tool vendor supports the current semantics, the standard(s) can simply be changed;<br />
-	otherwise a new TTCN-3 language string shall be defined for the coming edition of TTCN-3, and an optional language clause shall be allowed for TTCN-3 modules (like module MyModule language &quot;TTCN 3:2007&quot; {â€¦}). When a module is using this language string, the new semantics apply; if it is using an elder language string or not using a language string, the semantics defined today apply. <br />
</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR-2151-Local-Timers-part-1-JG-080313.doc (186,368) <span class="italic">13-03-2008 14:16</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1377&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR-2151-Local-Timers-part-1-RG-080422.doc (172,032) <span class="italic">22-04-2008 17:28</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1434&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR-2151-Local-Timers-part-4-Resolution.doc (133,632) <span class="italic">24-04-2008 12:53</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1452&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR-2151-Local-Timers-part-4-Resolution-v2.doc (133,632) <span class="italic">24-04-2008 15:02</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1453&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">15-10-2007 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">15-10-2007 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">15-10-2007 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">15-10-2007 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; $23</td></tr><tr class="print"><td class="print">15-10-2007 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt;      </td></tr><tr class="print"><td class="print">15-10-2007 19:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0003633</td><td class="print"></td></tr><tr class="print"><td class="print">15-10-2007 19:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">18-10-2007 13:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">18-10-2007 13:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 3.3.1 (not yet published)</td></tr><tr class="print"><td class="print">03-12-2007 13:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0004230</td><td class="print"></td></tr><tr class="print"><td class="print">03-12-2007 13:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Target Version</td><td class="print">Edition 3.3.1 (not yet published) =&gt; Edition 4.1.1 (not yet published)</td></tr><tr class="print"><td class="print">13-03-2008 14:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0005225</td><td class="print"></td></tr><tr class="print"><td class="print">13-03-2008 14:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR-2151-Local-Timers-part-1-JG-080313.doc</td><td class="print"></td></tr><tr class="print"><td class="print">13-03-2008 18:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0005228</td><td class="print"></td></tr><tr class="print"><td class="print">14-03-2008 09:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0005231</td><td class="print"></td></tr><tr class="print"><td class="print">14-03-2008 09:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0005232</td><td class="print"></td></tr><tr class="print"><td class="print">21-04-2008 08:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">Edition 4.1.1 (not yet published) =&gt; Edition 3.4.1 (not yet published)</td></tr><tr class="print"><td class="print">22-04-2008 17:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR-2151-Local-Timers-part-1-RG-080422.doc</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2008 17:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0005504</td><td class="print"></td></tr><tr class="print"><td class="print">24-04-2008 12:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0005550</td><td class="print"></td></tr><tr class="print"><td class="print">24-04-2008 12:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR-2151-Local-Timers-part-4-Resolution.doc</td><td class="print"></td></tr><tr class="print"><td class="print">24-04-2008 12:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Thomas DeiÃŸ</td></tr><tr class="print"><td class="print">24-04-2008 14:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Note Added: 0005551</td><td class="print"></td></tr><tr class="print"><td class="print">24-04-2008 14:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Assigned To</td><td class="print">Thomas DeiÃŸ =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">24-04-2008 15:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0005552</td><td class="print"></td></tr><tr class="print"><td class="print">24-04-2008 15:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR-2151-Local-Timers-part-4-Resolution-v2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">24-04-2008 15:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">24-04-2008 15:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">24-04-2008 15:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">24-04-2008 19:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">24-04-2008 19:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 3.4.1 (not yet published)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0003633)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-10-2007 19:08&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The meaning of &quot;local timer&quot; here is a timer local to the enclosing scope - but not local to the default.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0004230)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-12-2007 13:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Question to the vendors about their implementation of any/all timer.timeout.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005225)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-03-2008 14:15&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The attachment is a first draft of changes in part 1 if the CR is accepted.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005228)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-03-2008 18:19&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Awaiting steering committee decision<br />
<br />
Check also clause 12			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005231)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-03-2008 09:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				As part of the resolution of this CR also the lifetime of a timer object has to be clarified:<br />
<br />
- Option 1: A timer is destroyed when the scope unit is left.<br />
<br />
- Option 2: A timer is destroyed when a component is destroyed.<br />
<br />
Option 2 has implications on alive components.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005232)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-03-2008 09:53&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The lifetime of a timer is already questioned in CR 2753 - the CRs should be resolved together			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005504)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2008 17:30&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I propose to change just the place of the word &quot;individual&quot; in $23.1 Note2 in the file CR-2151-Local-Timers-part-1-RG-080422.doc			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005550)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-04-2008 12:52&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Attached resolution for part 4 includes the corrected figures that resolve the CR. Text need not to be changed in part 4.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005551)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-04-2008 14:53&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				proposal checked: ok.<br />
editorial: change timerID -&gt; timerId			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005552)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-04-2008 15:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Editorial Changes Done!			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
