<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:19:21 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0002012: runs on self clause in function reference types - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0002012</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">18-09-2007 10:53</td><td class="print">10-12-2009 10:05</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">high</td><td class="print-category">Severity</td><td class="print">feature</td><td class="print-category">Reproducibility</td><td class="print">N/A</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.1.1 (published 2009-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.1.1 (published 2009-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">new clause(s)</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">L.M.Ericsson - Gyorgy Rethy</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0002012: runs on self clause in function reference types</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Function References (will) allow(s) calling testcases, functions and altsteps via their references (pointers) using the apply operation. In this case type compatibility is checked, and the type of the reference used in the apply operation shall be compatible with the runs on clause of the entity in which the apply operation is employed.<br />
When writing library functions, some details of the behaviour are use-case dependent and hence the user of the library shall be able to customize it (e.g. send out or wait for a co-ordination message at certain points, while other applications do not need this). This customization can be done by inserting hook points (see the if statement in the function f_LibraryFunctionNow in the example below) into the library functions/altsteps where user defined (so called callback ~) functions are called via reference, if the user stipulates so. <br />
However, the callback function type definition (see CallbackFunctionRefRunsonUserCT below) shall refer to a component type in its runs on clause, which causes a problem. Normally, each library is using its own component type definition, which declares all component constants, variables, timers and ports used by the library (see Library_CT definition in the example below). The user, when writing its own code, shall just extend the library component type(s) with its own constants, variables, timers and ports (see User_CT definition below). Several library component types can be extended simulaneously when defining the user component type. Callback function type definitions shall not use the Library_CT type in their runs on clauses as the user shall be able to use its own declarations within them and they are not defined in Library_CT but in User_CT.<br />
In principle, library functions could also extend a pre-defined (initially empty) user component type however, this is not a solution to the given problem. In this case all user and library components would be forced to run on one single component type throughout the whole test configuration that is very unpractical and resource-consuming; also, libraries have multiple levels (e.g. application libraries that are built on core libraries), where library functions on the higher level shall be able to see the library definitions of the lower library level. Hence, such kind of a turn-about component type extension is not realizable.<br />
In summary, the current runs on compatibility rules of the language do not support using callback functions.<br />
<br />
EXAMPLE 1:	Using function/altstep references with runs on clauses<br />
module RunsOn_UserCT<br />
{<br />
// THIS MODULE DESCRIBES THE SITUATION TODAY, WITHOUT RUNS ON SELF<br />
<br />
type function CallbackFunctionRefRunsonUserCT () runs on User_CT;<br />
<br />
type component Library_CT<br />
{<br />
&#160;&#160;var CallbackFunctionRefRunsonUserCT v_CallbackRef_UserCT := null;<br />
&#160;&#160;var integer v_Lib;<br />
}<br />
<br />
type component User_CT extends Library_CT <br />
{<br />
&#160;&#160;var integer v_User;<br />
&#160;&#160;port COORDINATION_PT CP;<br />
}<br />
<br />
function f_MyCallbackFunction () runs on User_CT<br />
{/*application/dependent behaviour*/}<br />
<br />
function f_LibraryFunctionNow () runs on Library_CT<br />
{<br />
&#160;&#160;&#160;&#160;if (v_CallbackRef_UserCT &lt;&gt; null)<br />
&#160;&#160;&#160;&#160;{<br />
&#160;&#160;&#160;&#160;&#160;&#160;// Calling the user callback function via reference causes semantic<br />
&#160;&#160;&#160;&#160;&#160;&#160;// ERROR today as the callback function type is using runs on User_CT<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;v_CallbackRef_UserCT.apply()<br />
&#160;&#160;&#160;&#160;}<br />
}// end f_LibraryFunction<br />
<br />
function f_MyUserFunctionNow () runs on User_CT<br />
{<br />
&#160;&#160;v_CallbackRef_UserCT := refers (f_MyCallbackFunction);<br />
&#160;&#160;f_LibraryFunctionNow();<br />
&#160;&#160;<br />
}//end f_MyUserFunctionNow<br />
<br />
}  // end of module<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">Proposed solution:<br />
The solution in general is the following: function and altstep type definitions need not specify a concrete component type in their runs on clauses. This is identified by &quot;runs on self&quot; (this syntax uses no new TTCN-3 keyword!). In &quot;normal&quot; cases assignments are checked by inspecting the TYPE of the left and right hand values and their runs on clauses shall be the same or compatible. In the case the type of the left hand value is using &quot;runs on self&quot;, the runs on clause of the right hand value's type is checked AGAINST the RUNS ON CLAUSE of the testcase/function/altstep in which the assignment is present.<br />
After this check this reference can safely be used within the given test component to call a function/altstep in any of the functions that is executed on this component (either library or user). No further check is needed at function invocation using the apply operation. See example 2 below.<br />
<br />
EXAMPLE 2:	Using &quot;runs on self&quot;<br />
module RunsOn_Self<br />
{<br />
// THIS MODULE DESCRIBES THE PROPOSED SOLUTION WITH USING RUNS ON SELF<br />
<br />
//=========================================================================<br />
// Function Types<br />
//=========================================================================<br />
<br />
// Only function and altstep types may have &quot;runs on self&quot;; nor testcases,<br />
// neither function/altstep/testcase definitions shall have it<br />
type function CallbackFunctionRefRunsonSelf () runs on self;<br />
<br />
//=========================================================================<br />
//Component Types<br />
//=========================================================================<br />
type component Library_CT<br />
{<br />
&#160;&#160;// These declarations are OK<br />
&#160;&#160;var CallbackFunctionRefRunsonSelf v_CallbackRef_self := null;<br />
&#160;&#160;var integer v_Lib;<br />
}<br />
<br />
type component User_CT extends Library_CT <br />
{<br />
&#160;&#160;var integer v_User;<br />
}<br />
<br />
//=========================================================================<br />
// Functions<br />
//=========================================================================<br />
<br />
//-------------------------------------------------------------------------<br />
//EXAMPLE 2: WITH RUNS ON SELF <br />
//-------------------------------------------------------------------------<br />
<br />
//----------------------Solution-------------------------------------------<br />
<br />
function f_LibraryFunction () runs on Library_CT<br />
{<br />
&#160;&#160;// Direct call of the callback function still would cause semantic ERROR<br />
&#160;&#160;f_MyCallbackFunction();<br />
&#160;&#160;<br />
&#160;&#160;if (v_CallbackRef_self != null)<br />
&#160;&#160;{<br />
&#160;&#160;&#160;&#160;// Calling a function via reference that has a &quot;runs on self&quot; in its header<br />
&#160;&#160;&#160;&#160;// is always allowed with the exception of functions/altsteps without runs<br />
&#160;&#160;&#160;&#160;// on clause<br />
&#160;&#160;&#160;&#160;v_CallbackRef_self.apply();<br />
&#160;&#160;}<br />
}// end f_LibraryFunction<br />
<br />
function f_MyUserFunction () runs on User_CT<br />
{<br />
&#160;&#160;// This is allowed as f_MyCallbackFunction has runs on clause compatible<br />
&#160;&#160;// with the runs on clause of this function (f_MyUserFunction)<br />
&#160;&#160;// The use of function/altstep references with &quot;runs on self&quot; in their<br />
&#160;&#160;// headers is limited to call them on the given component instance; i.e.<br />
&#160;&#160;// allowed: assignments, parameterization and activate (the actual function's<br />
&#160;&#160;//          runs on is compared to the runs on of the function in which<br />
&#160;&#160;//          the operation is executed)<br />
&#160;&#160;// not allowed: start, sending and receiving<br />
&#160;&#160;// no check is needed for apply!<br />
&#160;&#160;v_CallbackRef_self := refers (f_MyCallbackFunction);<br />
&#160;&#160;<br />
&#160;&#160;// This is allowed as Library_CT is a parent of User_CT<br />
&#160;&#160;// Pls. note, as the function is executing on a User_CT<br />
&#160;&#160;// instance, it shall never cause a problem of calling<br />
&#160;&#160;// a callback function with &quot;runs on User_CT&quot; from it.<br />
&#160;&#160;f_LibraryFunction();<br />
&#160;&#160;<br />
}//end f_MyUserFunctionNow<br />
<br />
function f_MyCallbackFunction () runs on User_CT<br />
{/*application/dependent behaviour*/}<br />
<br />
} // end of module<br />
However, the function/altstep reference value of a type using &quot;runs on self&quot; shall never leave the test component in which its actual value was assigned. Hence it is NOT allowed to:<br />
- assign it to a function/altstep reference (constant, template, variable, formal parameter) using a concrete component type in the runs on clause of its type definition;<br />
- start a PTC using a function reference with runs on self in its type definition;<br />
- sending and receiving of function/altstep references using runs on self (neither directly nor embedded in structured types).<br />
The detailed rules of using &quot;runs on self&quot; are given in the example below.<br />
<br />
EXAMPLE 3:	Rules of using &quot;runs on self&quot;<br />
module RunsOn_Self_Rules<br />
{<br />
// THIS MODULE DESCRIBES THE PROPOSED SOLUTION WITH USING RUNS ON SELF<br />
<br />
//=========================================================================<br />
// Function Types<br />
//=========================================================================<br />
<br />
// Only function and altstep types may have &quot;runs on self&quot;; nor testcases,<br />
// neither function/altstep/testcase definitions shall have it<br />
type function CallbackFunctionRefRunsonLib () runs on Library_CT;<br />
type function CallbackFunctionRefRunsonUser () runs on User_CT;<br />
type function CallbackFunctionRefRunsonSelf () runs on self;<br />
<br />
//=========================================================================<br />
//Component Types<br />
//=========================================================================<br />
type component Library_CT<br />
{<br />
&#160;&#160;// These declarations are OK<br />
&#160;&#160;var CallbackFunctionRefRunsonSelf v_CallbackRef_self := null;<br />
&#160;&#160;var CallbackFunctionRefRunsonLib  v_CallbackRef_LibCT := null;<br />
&#160;&#160;var integer v_Lib;<br />
}<br />
<br />
type component User_CT extends Library_CT <br />
{<br />
&#160;&#160;var CallbackFunctionRefRunsonUser v_CallbackRef_UserCT := null;<br />
&#160;&#160;var integer v_User;<br />
}<br />
<br />
//=========================================================================<br />
// Functions<br />
//=========================================================================<br />
<br />
//-------------------------------------------------------------------------<br />
//EXAMPLE 2: WITH RUNS ON SELF <br />
//-------------------------------------------------------------------------<br />
<br />
//-----------------------Rules of using runs on self-----------------------<br />
<br />
<br />
function f_Lib() runs on Library_CT<br />
{<br />
&#160;&#160;log(v_Lib);<br />
}<br />
<br />
function f_User() runs on User_CT<br />
{<br />
&#160;&#160;log(v_Lib);<br />
&#160;&#160;log(v_User);<br />
}<br />
<br />
function f_LibParameterizedwLib (CallbackFunctionRefRunsonLib par_fRef)<br />
runs on Library_CT<br />
{}<br />
function f_LibParameterizedwUser (CallbackFunctionRefRunsonUser par_fRef)<br />
runs on Library_CT<br />
{}<br />
function f_LibParameterizedwSelf (CallbackFunctionRefRunsonSelf par_fRef)<br />
runs on Library_CT<br />
{}<br />
<br />
function f_UserParameterizedwLib (CallbackFunctionRefRunsonLib par_fRef)<br />
runs on User_CT<br />
{}<br />
function f_UserParameterizedwUser (CallbackFunctionRefRunsonUser par_fRef)<br />
runs on User_CT<br />
{}<br />
function f_UserParameterizedwSelf (CallbackFunctionRefRunsonSelf par_fRef)<br />
runs on User_CT<br />
{}<br />
<br />
<br />
function f_LibraryFunction2() runs on Library_CT<br />
{<br />
&#160;&#160;var Library_CT vl_PTC_LibCT := Library_CT.create;<br />
<br />
// --------ASSIGNMENTS AND FUNCTION CALLS--------<br />
<br />
&#160;&#160;// allowed by definition<br />
&#160;&#160;f_Lib();<br />
&#160;&#160;<br />
&#160;&#160;// allowed because of the previous<br />
&#160;&#160;v_CallbackRef_self := refers(f_Lib);<br />
&#160;&#160;<br />
&#160;&#160;// allowed by definition<br />
&#160;&#160;v_CallbackRef_LibCT := refers(f_Lib);<br />
&#160;&#160;<br />
&#160;&#160;// semantic ERROR: NOT ALLOWED because it may refer to non-existent objects<br />
&#160;&#160;f_User();<br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED because of the previous!!!<br />
&#160;&#160;// One of the most important points of the proposal<br />
&#160;&#160;v_CallbackRef_self := refers(f_User); <br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED because it refers to non-existent v_User<br />
&#160;&#160;v_CallbackRef_LibCT := refers(f_User); <br />
&#160;&#160;<br />
&#160;&#160;// allowed by definition (even if it actually points to f_User)<br />
&#160;&#160;v_CallbackRef_self.apply();<br />
&#160;&#160;<br />
&#160;&#160;// allowed by definition<br />
&#160;&#160;v_CallbackRef_LibCT.apply();<br />
&#160;&#160;<br />
&#160;&#160;// allowed because of the previous<br />
&#160;&#160;v_CallbackRef_self := v_CallbackRef_LibCT;<br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED because v_CallbackRef_LibCT can be exported from this<br />
&#160;&#160;// component !!!<br />
&#160;&#160;v_CallbackRef_LibCT := v_CallbackRef_self;<br />
<br />
// --------COMPONENT HANDLING--------<br />
&#160;&#160;<br />
&#160;&#160;// allowed by definition<br />
&#160;&#160;vl_PTC_LibCT.start(f_Lib());<br />
&#160;&#160;<br />
&#160;&#160;// allowed by definition<br />
&#160;&#160;vl_PTC_LibCT.start(derefers(v_CallbackRef_LibCT)()); <br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED because f_User() refers to User_CT<br />
&#160;&#160;vl_PTC_LibCT.start(f_User());<br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED by definition<br />
&#160;&#160;// Another cardinal point of the proposal<br />
&#160;&#160;vl_PTC_LibCT.start(derefers(v_CallbackRef_self)());<br />
<br />
// --------PARAMETERIZATION--------<br />
&#160;&#160;// This is obviously OK as both the variable and the parameter type has<br />
&#160;&#160;// the same type (using runs on Library_CT)<br />
&#160;&#160;f_LibParameterizedwLib(v_CallbackRef_LibCT);<br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED as the parameter (of the type CallbackFunctionRefRunsonLib!)<br />
&#160;&#160;// can be exported from the component within f_LibParameterizedwLib<br />
&#160;&#160;f_LibParameterizedwLib(v_CallbackRef_self);<br />
&#160;&#160;<br />
&#160;&#160;// This is OK for the same reason as the assignment &lt;v_CallbackRef_self :=<br />
&#160;&#160;// v_CallbackRef_LibCT;&gt; is allowed; note, use of the parameter is restricted<br />
&#160;&#160;// within the function f_LibParameterizedwSelf;<br />
&#160;&#160;f_LibParameterizedwSelf(v_CallbackRef_LibCT);<br />
&#160;&#160;<br />
&#160;&#160;// This is obviously OK as both the variable and the parameter type has<br />
&#160;&#160;// the same type (using runs on self)<br />
&#160;&#160;f_LibParameterizedwSelf(v_CallbackRef_self);<br />
&#160;&#160;<br />
<br />
&#160;&#160;// Makes no sense as no definition with runs on User_CT is known during<br />
&#160;&#160;// writing library functions<br />
&#160;&#160;f_LibParameterizedwUser(/*...*/)<br />
}<br />
<br />
function f_UserFunction() runs on User_CT<br />
{<br />
&#160;&#160;var User_CT vl_PTC_UserCT := User_CT.create;<br />
&#160;&#160;<br />
&#160;&#160;// --------ASSIGNMENTS AND FUNCTION CALLS--------<br />
<br />
&#160;&#160;// allowed because of compatibility<br />
&#160;&#160;f_Lib();<br />
&#160;&#160;<br />
&#160;&#160;// allowed because of the previous<br />
&#160;&#160;v_CallbackRef_self := refers(f_Lib);<br />
&#160;&#160;<br />
&#160;&#160;// allowed by definition<br />
&#160;&#160;v_CallbackRef_LibCT := refers(f_Lib);<br />
&#160;&#160;<br />
&#160;&#160;// allowed by definition<br />
&#160;&#160;v_CallbackRef_UserCT := refers(f_User);<br />
<br />
&#160;&#160;// allowed by definition<br />
&#160;&#160;f_User();<br />
&#160;&#160;<br />
&#160;&#160;// allowed because of the previous<br />
&#160;&#160;v_CallbackRef_self := refers(f_User);<br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED because f_User() refers to User_CT and v_CallbackRef_LibCT's<br />
&#160;&#160;// type refers to its parent, Library_CT<br />
&#160;&#160;// Pls. note that v_CallbackRef_LibCT can be e.g. started on a PTC of the<br />
&#160;&#160;// type Library_CT<br />
&#160;&#160;v_CallbackRef_LibCT := refers(f_User);<br />
&#160;&#160;<br />
&#160;&#160;// allowed by definition<br />
&#160;&#160;v_CallbackRef_self.apply();<br />
&#160;&#160;<br />
&#160;&#160;// allowed because of the previous<br />
&#160;&#160;v_CallbackRef_self := v_CallbackRef_UserCT; <br />
<br />
&#160;&#160;// allowed because of compatibility<br />
&#160;&#160;v_CallbackRef_LibCT.apply(); <br />
&#160;&#160;<br />
&#160;&#160;// allowed because of the previous<br />
&#160;&#160;v_CallbackRef_self := v_CallbackRef_LibCT; <br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED because v_CallbackRef_self can refer to a function with<br />
&#160;&#160;// runs on User_CT and v_CallbackRef_LibCT can be exported from this<br />
&#160;&#160;// component<br />
&#160;&#160;v_CallbackRef_LibCT := v_CallbackRef_self;<br />
&#160;&#160;<br />
// --------COMPONENT HANDLING--------<br />
<br />
&#160;&#160;// allowed because of compatibility<br />
&#160;&#160;vl_PTC_UserCT.start(f_Lib()); <br />
&#160;&#160;<br />
&#160;&#160;// allowed by definition<br />
&#160;&#160;vl_PTC_UserCT.start(f_User()); <br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED by definition<br />
&#160;&#160;vl_PTC_UserCT.start(derefers(v_CallbackRef_self)());<br />
&#160;&#160;<br />
&#160;&#160;// allowed because of compatibility<br />
&#160;&#160;vl_PTC_UserCT.start(derefers(v_CallbackRef_LibCT)());<br />
<br />
// --------PARAMETERIZATION--------<br />
&#160;&#160;// This is obviously OK as both the variable and the parameter type has<br />
&#160;&#160;// the same type (using runs on Library_CT)<br />
&#160;&#160;f_UserParameterizedwLib(v_CallbackRef_LibCT);<br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED as the parameter (of the type CallbackFunctionRefRunsonLib!)<br />
&#160;&#160;// can be exported from the component within f_UserParameterizedwLib<br />
&#160;&#160;f_UserParameterizedwLib(v_CallbackRef_self);<br />
&#160;&#160;<br />
&#160;&#160;// This is OK for the same reason as the assignment &lt;v_CallbackRef_self :=<br />
&#160;&#160;// v_CallbackRef_UserCT;&gt; is allowed; note, use of the parameter is<br />
&#160;&#160;// restricted within the function f_UserParameterizedwSelf;<br />
&#160;&#160;f_UserParameterizedwSelf(v_CallbackRef_UserCT);<br />
&#160;&#160;<br />
&#160;&#160;// This is obviously OK as both the variable and the parameter type has<br />
&#160;&#160;// the same type (using runs on self)<br />
&#160;&#160;f_UserParameterizedwSelf(v_CallbackRef_self);<br />
&#160;&#160;<br />
<br />
&#160;&#160;// NOT ALLOWED as the parameter (of the type CallbackFunctionRefRunsonUser!)<br />
&#160;&#160;// can be exported from the component within f_UserParameterizedwLib<br />
&#160;&#160;f_UserParameterizedwUser(v_CallbackRef_self)<br />
}<br />
<br />
function f_MyFunctionNoRunson()<br />
{<br />
&#160;&#160;var Library_CT vl_PTC_LibCT := Library_CT.create;<br />
&#160;&#160;var User_CT vl_PTC_UserCT := User_CT.create;<br />
&#160;&#160;<br />
// --------ASSIGNMENTS AND FUNCTION CALLS--------<br />
<br />
&#160;&#160;// allowed because of compatibility<br />
&#160;&#160;vl_PTC_LibCT := vl_PTC_UserCT;<br />
&#160;&#160;<br />
&#160;&#160;// NOT ALLOWED<br />
&#160;&#160;vl_PTC_UserCT := vl_PTC_LibCT; <br />
&#160;&#160;<br />
&#160;&#160;// allowed<br />
&#160;&#160;var CallbackFunctionRefRunsonSelf vl_CallbackRef_self :=<br />
&#160;&#160;refers(f_MyFunctionNoRunson);<br />
<br />
// --------COMPONENT HANDLING--------<br />
// No new case above those shown above <br />
<br />
// --------PARAMETERIZATION--------<br />
// Makes sense only in case of function/altstep references without runs on<br />
// clause that is out of scope of these examples <br />
<br />
}<br />
<br />
} // end of module<br />
</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0000412</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=530">Tibor CsÃ¶ndes</a></span>&#160;</td><td class="print">Function reference&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_Exx  runs on self.doc (150,016) <span class="italic">18-09-2007 10:53</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=983&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">18-09-2007 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">18-09-2007 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">18-09-2007 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">18-09-2007 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR_Exx  runs on self.doc</td><td class="print"></td></tr><tr class="print"><td class="print">18-09-2007 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; new clause(s)</td></tr><tr class="print"><td class="print">18-09-2007 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; L.M.Ericsson - Gyorgy Rethy</td></tr><tr class="print"><td class="print">19-09-2007 11:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Severity</td><td class="print">major =&gt; feature</td></tr><tr class="print"><td class="print">19-09-2007 11:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Summary</td><td class="print">runs on self clause of function reefrrnce types =&gt; runs on self clause in function reference types</td></tr><tr class="print"><td class="print">13-10-2007 18:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">13-10-2007 18:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; developer_u</td></tr><tr class="print"><td class="print">17-10-2007 11:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0003656</td><td class="print"></td></tr><tr class="print"><td class="print">17-10-2007 12:42</td><td class="print"><font STYLE="text-decoration: line-through">user10</font></td><td class="print">Assigned To</td><td class="print">developer_u =&gt; Thomas DeiÃŸ</td></tr><tr class="print"><td class="print">18-10-2007 13:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">18-10-2007 13:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.1.1 (not yet published)</td></tr><tr class="print"><td class="print">17-10-2008 15:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Relationship added</td><td class="print">related to 0000412</td></tr><tr class="print"><td class="print">12-12-2008 09:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Note Added: 0007674</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2008 09:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Assigned To</td><td class="print">Thomas DeiÃŸ =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">10-03-2009 10:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">10-03-2009 10:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">10-03-2009 10:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.1.1 (not yet published)</td></tr><tr class="print"><td class="print">10-12-2009 10:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">10-12-2009 10:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009133</td><td class="print"></td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0003656)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-10-2007 11:22&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				To be considered together with CR 412 and also deferred to 2008			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0007674)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-12-2008 09:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				solution included in the one for CR412			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009133)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-12-2009 10:05&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Included into the Behaviour Types package, ES 202 785 V1.1.1			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
