  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0008155</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Technical</td>
<td class="print">public</td>
<td class="print">12-12-2022 14:20</td>
<td class="print">15-01-2024 12:22</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Matthias Simon</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Jens Grabowski</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">won't fix</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print"></td>
<td class="print-category">Fixed in Version</td>
<td class="print"></td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">n/a</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Nokia - Matthias Simon</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0008155: Issue with the number of elements
of templates</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">How do I get the number of elements of a
string or list?<br />
For example of a hexstring template:<br />
<br />
    template hexstring s := '1*F'H<br />
    for (var integer i := 0; i&lt;lengthof(s); i := i + 1) {<br />
        log(s[i]);<br />
    }<br />
<br />
I would expect the number of elements in this template would be 3 (as
suggested by clause 15.6.1). However lengthof produces a (justified)
runtime error and sizeof is deprecated.<br />
<br />
Is there a mechanism for retrieving the number of elements in a string
or list in TTCN-3 or do we need a new predefined function?</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-12-2022 14:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-12-2022 13:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016442</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-12-2022 13:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-12-2022 13:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-12-2022 13:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016443</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-11-2023 16:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Matthias Simon</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-11-2023 16:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016541</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-11-2023 10:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Added: 0016544</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-11-2023 23:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv
Adamis</a></td>
<td class="print">Note Added: 0016558</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-11-2023 23:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv
Adamis</a></td>
<td class="print">Note Added: 0016559</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-11-2023 23:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv
Adamis</a></td>
<td class="print">Note Deleted: 0016559</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-11-2023 23:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv
Adamis</a></td>
<td class="print">Note Edited: 0016558</td>
<td class="print">bug_revision_view_page.php?bugnote_id=16558#r623</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-11-2023 08:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Added: 0016571</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-11-2023 08:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Assigned To</td>
<td class="print">Matthias Simon =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-11-2023 08:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-11-2023 08:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; won't fix</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-01-2024 12:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016591</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-01-2024 12:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016442)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-12-2022 13:03   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">TTF discussion: Has to be studied. Cannot be resolved
for the next version. To be shifted into 2023.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016443)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-12-2022 13:12   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">TTF discussion: lenghtof function needs to be
revised.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016541)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">07-11-2023 16:26   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">TTF discussion: Resolution will be based on an
optional parameter.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016544)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-11-2023 10:49   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">We should reconsider our resolution, because a new
proposal has come up (method-syntax).<br />
<br />
Following options are available for discussion (only the first 3 are
relevant in my opinion):<br />
<br />
1. Optional Parameter<br />
   Example: lengthof({1,*,5}, true) // true uses new lengthof
behaviour<br />
   + Backwards compatible<br />
   - Surprising users can get surprising runtime errors, because
behavior is aligned with length-constraint-assignment-rules<br />
   - Clumsy design (but seldom used, most users won't notice)<br />
<br />
2. Just Change Behavior<br />
   Example: lengthof({1,*,5}) // returns 3<br />
   + Expected behavior aligned with index-access-rules<br />
   + easy to understand, good design<br />
   - Backwards incompatible (but only for rare corner cases, for fix an
easy fix is available)<br />
<br />
3. Method Syntax:<br />
   Example: {1,*,5}.lengthof()<br />
   + Does not pollute existing namespaces<br />
   + Easy to understand<br />
   - Method syntax is not very common in TTCN-3<br />
   - Grammar needs restructuring<br />
   - two different lengthof functionalities is confusing<br />
<br />
4. New Syntax:<br />
   Random Example: lengthof @lastindex ({1,*,5})<br />
   + Backwards compatible<br />
   + Could be easy to understand,<br />
   + New syntax could unlock other features (e.g. a[lengthof] :=
23)<br />
   - New syntax increases language complexity<br />
   - We have no proposal how such syntax could look like<br />
<br />
4. New Function:<br />
   Example: lastindex({1,*,3})<br />
   + Easy to understand, no confusion about different lengthof
behaviors<br />
   + Could unlock other features by circumventing making lengthof
issue<br />
   - Backwards incompatible, due to new keywords<br />
<br />
5. Using length<br />
   Example: length({1,*,3})<br />
   + Backwards compatible<br />
   + Could reduce keywords by making lengthof superfluous<br />
   - Having two different length functions is confusing</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0016558)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv
Adamis</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-11-2023 23:48   <br />
(edited on: 08-11-2023 23:50)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Ericsson can accept backward incompability, so the
lengthof() function can be extended (without adding an extra optional
parameter) to reach the desired behaviour also for templates instead of
resulting in a run-time error.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016571)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-11-2023 08:25   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Summary:<br />
A deeper investigation is required, because the situation is
unclear.<br />
There seem to be contradictions between the lengthof-spec and its
examples; also between binary-string values/templates and indexing
rules, ...<br />
<br />
A new CR for this topic will be created.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016591)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-01-2024 12:22   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">No action required at the moment.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
