  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0007774</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">04-06-2018 14:27</td>
<td class="print">18-12-2018 11:49</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Thilo Lauer</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Tomas Urban</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">no change required</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.9.1 (published 2017-05)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print"></td>
<td class="print-category">Fixed in Version</td>
<td class="print"></td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">TTCN-3 Standard, Part 1 completely</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">    Devoteam - Thilo Lauer</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0007774: Is replace function applicable to
variables/templates of string/record of types with values containing
matching mechanisms</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">Can the replace function be used for
variables or templates assigned by a matching-mechanism/symbol
(OmitValue, AnyValue, AnyValueOrNone, AnyElementOrNone, ValueList,
Complement, Permutation, Superset, Subset)?<br />
<br />
We would like to get a clarification as the standard is here too
unspecific currently.<br />
<br />
Please note:<br />
we are NOT(!) voting for permitting replace for variables/templates of
string/record of types with values containing matching
mechanisms/symbols.<br />
We simply want to get a clarification how to handle such cases if
permitted.<br />
<br />
For a number of examples, please see the uploaded file.</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print">see the uploaded file</td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR_replace AnyValueOrNone in strings, rec. of, etc.
(clarification).docx (28,357) <span class="italic">04-06-2018
14:27</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3752&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-06-2018 14:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo
Lauer</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-06-2018 14:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo
Lauer</a></td>
<td class="print">File Added: CR_replace AnyValueOrNone in strings, rec.
of, etc. (clarification).docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-06-2018 14:45</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015107</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-06-2018 14:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0015107</td>
<td class="print">bug_revision_view_page.php?bugnote_id=15107#r481</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-07-2018 14:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-07-2018 14:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-07-2018 14:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0015135</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-07-2018 14:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-07-2018 09:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0015154</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-07-2018 09:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-07-2018 09:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-07-2018 10:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015155</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-07-2018 10:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-07-2018 10:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-10-2018 14:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-10-2018 14:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-10-2018 16:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0015259</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-10-2018 16:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Edited: 0015259</td>
<td class="print">bug_revision_view_page.php?bugnote_id=15259#r489</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-10-2018 16:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Edited: 0015259</td>
<td class="print">bug_revision_view_page.php?bugnote_id=15259#r490</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-10-2018 16:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Edited: 0015259</td>
<td class="print">bug_revision_view_page.php?bugnote_id=15259#r491</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-12-2018 11:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0015292</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-12-2018 11:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-12-2018 11:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; no change required</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0015107)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">05-06-2018 14:45   <br />
(edited on: 05-06-2018 14:50)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">According to the standard, the first parameter of the
replace function must be a value. Therefore, any list that contains a
matching mechanism is not allowed.<br />
<br />
This is apparent from the signature given in section C.4.3:<br />
<br />
replace(<br />
 in any_string_or_sequence_type inpar,<br />
 in integer index,<br />
 in integer len,<br />
 in any_string_or_sequence_type repl<br />
) return any_string_or_sequence_type<br />
<br />
And also from the first sentence of the description:<br />
<br />
"This function replaces the substring or subsequence of value inpar at
index index of length len with the string or<br />
sequence value repl and returns the resulting string or sequence."<br />
<br />
If you compare that, for instance with the substr function:<br />
<br />
substr(<br />
 in template (present) any_string_or_sequence_type inpar,<br />
 in integer index,<br />
 in integer count<br />
) return input_string_or_sequence_type<br />
<br />
the difference should become clear.<br />
<br />
So, as far as I can see, the standard is already clear in that
regard.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015135)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">16-07-2018 14:32   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF does not a see a need for further clarification.
Devoteam should check comment from Jacob.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015154)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-07-2018 09:51   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Answer from Mr. Lauer regarding feedback (received via
Email on 17.07.18):<br />
<br />
Dear Mr. Grabowski,<br />
<br />
Thanks for your request regarding our CR.<br />
<br />
Recently we had a request from one of our customers, who wants to
compile the following code:<br />
<br />
    function f_Check_UE_NetworkCap_CIOT(UE_NetworkCap
p_UE_NetworkCap,<br />
                                          UE_NetworkCap_ToBeTested
p_ToBeTested) return Boolean<br />
<br />
      {<br />
        var template (present) B8_Type v_Expected := ?; // seems not to
be allowed, see examples 1 and 2 below<br />
<br />
        ...<br />
<br />
        v_Expected := replace (v_Expected, 1, 1, f_ConvertBoolToBit
(pc_HCCPCIoT));<br />
<br />
        ...<br />
      }<br />
<br />
      }<br />
<br />
<br />
The substr() statement allows AnyElementOrNone and AnyElement but no
example is given in the standard. Here are some of our examples:<br />
<br />
Example 1: substr(?,1,2); // What is the result? Seems to be not allowed
as ? (=any value) is not used as matching symbol inside a string<br />
Example 2: substr(*,1,2); // What is the result? Seems to be not allowed
as ? (=any value) is not used as matching symbol inside a string<br />
<br />
Example 3: substr(pattern "?*A",1,2); // What is the result? Seems to be
allowed, result = "*A"; "*" = literal char, acc. to C.4.2<br />
Example 4: substr(pattern "*?*A",1,2); // What is the result? Seems to
be allowed, result = "?*" = literal chars , acc. to C.4.2<br />
<br />
If examples 3 and 4 are allowed, it is possible to define:<br />
<br />
a:=substr(pattern "*?*",1,2); // result is a characterstring of length 2
(not a template): result = "?*"<br />
b:=replace(a,0,2,"asdf"); // result: b = "asdf"<br />
c:=substr(pattern "*?*",0,1) &amp; b; // result: c = "*asdf"<br />
<br />
But using replace as a shortcut for the statements above - to our
standard interpretation - is not allowed:<br />
<br />
d:=replace(pattern"*?*",1,2,"asdf"); // result: should be: d = "*asdf",
but this is currently not allowed.<br />
<br />
There are a number of combinations between substring, replace, stringop
(&amp;) operating on values and/or (matching) templates<br />
that are not yet described clearly enough in the current standard.<br />
<br />
<br />
Especially stringop (&amp;) allows much with templates:<br />
<br />
Let us point to another example in the current standard:<br />
<br />
    Section 15.11: Concatenating templates of string and list
types<br />
<br />
<br />
    EXAMPLE 1: Composing templates of binary string types<br />
<br />
<br />
    template bitstring mw_mybit := '010'B &amp; ? &amp; '1'B &amp; ?
length(1) &amp; '1'B;<br />
<br />
             // results in the template '010*1?1'B<br />
<br />
             // note that &amp; ? &amp; turns to * within the resulting
bitstring as the original ?<br />
<br />
             // stands for a bitstring of any length<br />
<br />
<br />
    "? (any value) stands for a bitstring of any length"<br />
    is a bit imprecise: ? (any value) stands here for a bitstring of
length 1 .. infinite.<br />
<br />
    Replacing it by an * (any value or none) modifies the original
pattern part to: a bitstring of length 0 .. infinite - which is slightly
different.<br />
<br />
    Of course one can declare this to be the meaning of bitstring
template concatenation ...<br />
<br />
    ... and in case of stringop (&amp;) it was made obvious by an
example.<br />
<br />
<br />
Our point here is, that there are a number of combinations of substring,
replace, stringop (&amp;) operating on values and/or (matching)
templates ...<br />
... that are not specified clearly enough - but they should be.
Especially such "subtle" stringop details (as shown above) do not become
obvious as long as there is no explicit example.<br />
<br />
We can live with such imprecisions, but they rise the probability that
compilers work differently - and users have different interpretations of
the same TTCN-3 code.<br />
<br />
General statements only helps, if they are valid in any case.<br />
If general statements only describe the general direction, you have to
deal with a lot of exceptions, that are often not or poorly defined
...<br />
<br />
Hope this helps.<br />
Regards,<br />
<br />
Thilo Lauer<br />
Principal Consultant<br />
Solution Architect</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015155)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-07-2018 10:33   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I don't concur with that analysis.<br />
<br />
? stands for any value, that means also bitstrings of length 0, not only
with length &gt; 0. The equivalent on the pattern level for that is *,
so example 1 is fully correct and there is nothing imprecise in (that
part of) the text.<br />
<br />
One could argue that the replace function could have the same strange
allowance for dealing with occurrences of only the metacharacters ? and
*, but in my opinion already the usage of substr on pattern is
questionable as you change the semantics of the metacharacters to normal
characters.<br />
<br />
Thus, if at all, the standard should be changed that substr on a pattern
again yields a pattern so that the semantics of the characters are
retained. But, of course, that would be a backward incompatible change,
so that will not happen.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0015259)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-10-2018 16:26   <br />
(edited on: 11-10-2018 16:29)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">1. replace (v_Expected, 1, 1, f_ConvertBoolToBit
(pc_HCCPCIoT))<br />
<br />
This is an invalid code and shall not be compiled as the first formal
parameter of the replace function is a value parameter. Because the
declaration of the inpar is not completely standard, this is explicitly
stated in the section C.4.3. The section 5.4.2 of the core language
specification clearly states what actual parameters can be passed to in
formal value parameters:<br />
<br />
Actual parameters that are passed by value to in formal value parameters
shall be variables, literal values, module parameters, constants, value
variables, invocations of value returning (external) functions, formal
value parameters (of in, inout or out parameterization) of the current
scope or expressions composed of the above.<br />
<br />
2. The substr function examples:<br />
Example 1 and 2 are invalid, as the type context of the matching symbol
is not set. If the AnyValue template was typed, then the error would
occur because of other restriction mentioned in C.4.2 (AnyValue is not
listed as a valid content of inpar)<br />
Example 3 and 4 work as described and the following code as well. The
replace function indeed doesn't work, but the original CR didn't request
the change of its functionality! The question was if the rules were
clear enough. If it is necessary to change the replace function
functionality, a new CR should be submitted.<br />
<br />
3. String concatenation<br />
As Jacob pointed out, the following statement is absolutely wrong: "?
(any value) stands here for a bitstring of length 1 .. infinite".
There's no reason why "match(''B, ?)" should yield false as empty
bitstring is not the same thing as an omitted bitstring. Naturally, all
subsequent conclusions are incorrect as well, including the statement
that different interpretations are possible. This is simply not the
case.<br />
<br />
My conclusion is that the presented examples failed to demonstrate any
ambiguity or imprecision in the TTCN-3 core language standard.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015292)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-12-2018 11:49   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF decision: The presented examples failed to
demonstrate any ambiguity or imprecision in the TTCN-3 core language
standard. No change seems to be necessary.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
