  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Ext Pack: Object-oriented features (ES 203 790)
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0007679</td>
<td class="print">Ext Pack: Object-oriented features (ES 203 790)</td>
<td class="print">[All Projects] General</td>
<td class="print">public</td>
<td class="print">09-06-2017 05:07</td>
<td class="print">07-05-2018 12:34</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Jacob Wieland - Spirent</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Jens Grabowski</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">major</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print"></td>
<td class="print-category">Fixed in Version</td>
<td class="print"></td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0007679: Class Concept to be added</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">Currently the language already contains
certain kinds of object classes like components, ports and timers which
are passed by reference and used with object-oriented-like syntax in
their operations (start,stop,running,send,receive,etc.)<br />
<br />
Also, there is a demand to allow user-defined objects with encapsulated
state and behavior that is not visible/accessible and public
functionality that allows manipulation of that state.<br />
<br />
Thus, a class concept shall be introduced to TTCN-3 that addresses this
demand but also allows the expression of the existing concepts as
special kinds of classes.<br />
<br />
Features that the class concept need to encompass (to allow mapping of
the old concepts to the new ones):<br />
- constructors (create)<br />
- readonly (dynamic) properties (like running, alive, started)<br />
- methods without parameter lists (like stop, kill)<br />
- events (like timeout, receive, getcall, getreply, catch, done, killed,
check) with additional output channels (-&gt; value, sender,
param)<br />
- polymorphic methods (like send, call, reply, raise)<br />
<br />
The basic builtin class hierarchy would be:<br />
object<br />
- active object<br />
- - timer<br />
- - component<br />
- port<br />
- - message port<br />
- - procedure port<br />
- - mixed port (maybe extending both message and procedure port)<br />
<br />
The instances of classes, in contrast to the values of data types are
objects that are always passed by reference-value, i.e. the value that
is passed to in parameters is a reference to the object given as actual
parameter, not a copy of that object.<br />
<br />
Members of objects can be accessed via dotted notation.<br />
<br />
The basic syntax of a class definition could be something like:<br />
<br />
type class &lt;name&gt; [extends &lt;super_classes&gt;] {<br />
  &lt;member declarations&gt;<br />
}<br />
<br />
It has to be discussed how clashing function definitions from two or
more superclasses are to be handled.<br />
<br />
Forcing the user to override these functions (with allowed access to the
super-implementations) is probably the best way with the following
restrictions.<br />
<br />
Two classes containing a function of the same name can only be inherited
together if the signature of the function is the same (or the formal
parameter list of one is a prefix of the other and all additional formal
parameters are either out parameters or in parameters with a default).
If a function is overriding a function in an ancestor, its formal
parameter list must the formal parameter list of the overriden function
from as a prefix and all additional parameters must either be out
parameters or in parameters with a default.<br />
<br />
Example:<br />
<br />
type class A {<br />
  function f(integer a)...<br />
}<br />
<br />
type class B {<br />
  function f(integer a, float b :- 0.0) ...<br />
}<br />
<br />
type class C extends A, B {<br />
  function f(integer a, float b, charstring c := "") ...<br />
}<br />
<br />
These restrictions ensure that whether an object of class C is used as
an object of class A (in which only f(integer) can be called) or of
class B (in which f(integer) and f(integer,float) can be called) all
different versions of calling f are valid instances of the lowest
function definition (the one in C).<br />
<br />
For other non-private members than functions, the same restrictions as
for members of component types apply, i.e. they have to be unique in
their class hierarchy.<br />
<br />
Special classes can be declared external. Both the state and the
function of these classes are implemented outside of the language and
their functionality provided via the Platform Adapter
(x)triExternalFunction (the external functions get the object reference
as their first parameter).<br />
This allows platform native implementations like Collection types or
other libraries to be lifted in an abstract way into TTCN-3 without the
need to reimplement them in TTCN-3, providing the functionality without
great loss of efficiency or tool independence.<br />
<br />
Types defined by class definition are subtypes of their superclasses,
e.g. their instances can be used as instances of their superclasses as
well.<br />
<br />
A component or port type definition is a syntactic shortcut of a class
definition extending either the base component/port type (if no
supertypes are given) or their supertypes with special functions that
depend on the new component/port type. In case of the component type,
the start function is overridden to allow only behaviors that run on
that component type to be started.<br />
<br />
type port P message { in &lt;in_types&gt;; out &lt;out_types&gt;;
}<br />
<br />
would be equivalent with something like:<br />
<br />
type class P extends 'message port' {<br />
  @implicit function<br />
  send&lt;&lt;in_types&gt; I, A&gt;(template(value) I msg,<br />
             template(present) A 'to' := null);<br />
  @implicit @event<br />
  function receive&lt;&lt;out_types&gt; O, A&gt;(template(present) O
msg,<br />
                                     template(present) A 'from' :=
?,<br />
                                     out T 'value',<br />
                                     out A 'sender') return
boolean;<br />
}<br />
<br />
where MessagePort is defined like:<br />
<br />
type class 'message port' extends 'port' {<br />
// message port specifics<br />
}<br />
<br />
type class 'port' extends 'active object' {<br />
  @implicit function checkstate(charstring state_kind) return
boolean;<br />
  @implicit function 'stop';<br />
  @implicit function halt;<br />
  @implicit function start;<br />
  @implicit function clear;<br />
}<br />
<br />
type class 'active object' extends 'object' {<br />
  @implicit function 'running' return boolean;<br />
}</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007731</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></span> </td>
<td class="print">Draft document for Object-oriented Extension </td>
</tr>
<tr class="even">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007693</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></span> </td>
<td class="print">component members with visibility and functions inside
the components </td>
</tr>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0006801</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></span> </td>
<td class="print">Visibility of component definitions </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> ToC-Draft-OO2.docx (29,920) <span
class="italic">04-09-2017 12:11</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3675&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/generic.gif"
alt="?" /> OO-Presentation.pptm (56,122) <span class="italic">07-09-2017
14:43</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3682&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> OO-Draft-3.docx (29,595) <span class="italic">25-10-2017
08:30</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3688&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> MTS-203790-00F_ed111v001.docx (168,418) <span
class="italic">26-10-2017 09:16</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3705&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-06-2017 05:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-06-2017 05:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-06-2017 05:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-06-2017 13:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Description Updated</td>
<td class="print">bug_revision_view_page.php?rev_id=423#r423</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">25-07-2017 14:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0014752</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">25-07-2017 16:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014759</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">25-07-2017 16:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014763</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">25-07-2017 16:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014764</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">25-07-2017 17:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0014759</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14759#r430</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">26-07-2017 08:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0014763</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14763#r432</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">26-07-2017 08:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0014764</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14764#r434</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-09-2017 09:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Ext Pack: Object-oriented
features (ES 203 790)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-09-2017 09:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Category</td>
<td class="print">New Feature =&gt; General</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-09-2017 12:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: ToC-Draft-OO2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-09-2017 14:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: OO-Presentation.pptm</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-10-2017 13:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0014851</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">25-10-2017 08:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: OO-Draft-3.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">25-10-2017 08:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Julien Deltour</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">25-10-2017 08:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014857</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">26-10-2017 09:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien
Deltour</a></td>
<td class="print">File Added: MTS-203790-00F_ed111v001.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">27-10-2017 11:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007693</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">27-10-2017 11:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0006801</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-12-2017 15:42</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien
Deltour</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007731</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-12-2017 15:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien
Deltour</a></td>
<td class="print">Note Added: 0014925</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-12-2017 15:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien
Deltour</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-12-2017 15:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien
Deltour</a></td>
<td class="print">Assigned To</td>
<td class="print">Julien Deltour =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-12-2017 15:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien
Deltour</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-05-2018 12:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-05-2018 12:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014752)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-07-2017 14:34   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF discussion: Jacob will provide a TTCN-3 OO code
example.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0014759)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-07-2017 16:21   <br />
(edited on: 25-07-2017 17:07)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">As per our discussion, we have identified a
distinction between object-oriented operations between inter-component
calls and intra-component calls.<br />
<br />
Inter-component operations are start, running, done, stop, kill, killed,
alive<br />
<br />
An inter-component method call is the calling of a member-function
inside a component context (or thread) to one of the components'
objects. The set of components' objects are the component itself and all
objects that it has created (component ports and timers as well as local
objects) except other components.<br />
<br />
For example:<br />
<br />
external type class Stack&lt;T&gt; {<br />
  function push(T i);<br />
  function T pop();<br />
}<br />
<br />
type component StackComponent&lt;T&gt; {<br />
  var Stack&lt;T&gt; v_stack := Stack&lt;T&gt;.create;<br />
<br />
}<br />
<br />
In this scenario, a function that runs on StackComponent&lt;T&gt; would
be allowed to call v_stack.push(t) and t := v_stack.pop()<br />
<br />
I think it should be allowed to share references to inner-component
objects, but only behavior running on the owning component is allowed to
access the members while other behavior can only pass the reference
around and compare it with other references of compatible type. This is
similar to sharing component references where all you can access are the
inter-component operations but not the members of the referenced
component.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0014763)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-07-2017 16:44   <br />
(edited on: 26-07-2017 08:32)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">For port types, all port operations
(send,receive,stop,halt,running,etc.) are (external) (generic) members
that can be used inside the owning component.<br />
<br />
type class MessagePort&lt;I,O&gt; {<br />
  @implicit<br />
  function send(template(value) O msg, (ComponentType,address)
'to');<br />
  <br />
  @implicit<br />
  @event<br />
  function receive(template(present) I msg,<br />
                   out I 'value',<br />
                   out (Componenttype,address), 'sender')<br />
    return boolean;<br />
  <br />
  @remote<br />
  function start, stop, halt;<br />
  <br />
  @remote<br />
  function running return boolean;<br />
}<br />
<br />
A declaration<br />
<br />
type port P message { in I1, I2; out O1, O2 }<br />
<br />
would be equivalent with<br />
<br />
type class P extends MessagePort&lt;(I1,I2), (O1, O2)&gt;;<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0014764)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-07-2017 16:54   <br />
(edited on: 26-07-2017 08:36)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">For the moment, we have opted not to include multiple
class inheritance into the OO language part.<br />
<br />
A component type which extends multiple component types T1, ..., Tn will
be mapped to a class derived from the first type T1 with all fields only
inherited from T2,...,Tn copied into the class body.<br />
<br />
For example:<br />
<br />
type component A {<br />
  var integer a;<br />
}<br />
<br />
type copmponent B extends A {<br />
  var integer b;<br />
}<br />
<br />
type component C extends A {<br />
  var integer c;<br />
}<br />
<br />
type component D extends B, C {<br />
  var integer d;<br />
}<br />
<br />
would result in the following type class definitions:<br />
<br />
type class A extends ComponentType {<br />
  var integer a;<br />
}<br />
<br />
type class B extends A {<br />
  var integer b;<br />
}<br />
<br />
type class C extends A {<br />
  var integer c;<br />
}<br />
<br />
type class D extends B {<br />
  var integer d;<br />
  var integer c;<br />
  // a from C is not copied because it is already inherited via B<br />
}<br />
<br />
For this to work, there needs to be a restriction on 'private' members
that their names cannot clash (i.e. the same restriction as for
non-private members applies). I think we should provide a new visibility
modifier @invisible for that to avoid confusion with the normal
understanding of 'private' (i.e. a name that is not visible anywhere
outside the context which declares it).<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014851)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">24-10-2017 13:48   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF decision: Textual proposal re-checked by Jacob and
then assigned to Julien. Julien will put the text into the draft
document.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014857)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-10-2017 08:40   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Please integrate the text from the latest Draft into
the draft document.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014925)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien
Deltour</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-12-2017 15:43   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Full draft document has been created in a specific
CR.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
