  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0006731</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Technical</td>
<td class="print">public</td>
<td class="print">14-04-2014 11:34</td>
<td class="print">04-01-2015 20:37</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Tomas Urban</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">N/A</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.6.1 (published 2014-06)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.7.1 (published 2015-06)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.7.1 (published 2015-06)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">5.4</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Elvior</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0006731: Passing parameters by
reference</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">It doesn't seem to be completely obvious,
if inout parameters are passed by reference or if an assignment to a
parameter is made when entering a parameterized context and another from
the parameter when exiting the parameterized context.<br />
<br />
Let's demonstrate the issue on the simple example:<br />
type component C {<br />
  var integer vc_int := 0;<br />
}<br />
<br />
function f(inout intenger p_int) runs on C {<br />
  vc_int := 10;<br />
  log(p_int); // will it print 0 o 10?<br />
}<br />
<br />
testcase TC() runs on C {<br />
  f();<br />
}<br />
<br />
The definition in 3.1 seems to point in the direction of passing by
reference: inout parameterization: kind of parameterization where the
actual parameter is bound to the formal parameter when the parameterized
object is invoked. However, there are other rules that seem to favour
the other approach, e.g. the recently added restriction 5.4.2.j. This
restriction wouldn't make much sense when passing by reference as it
would simply pass the pointer to the original variable and the language
contains means for checking if the value is defined (the isbound
function). However, assignment of uninitialized values is forbidden, so
the rule is perfectly justified for the two-way assignment
interpretation.<br />
<br />
I think it would be worth of considering to describe the mechanisms
connected with inout assignments more exactly. Special attention should
be paid to the situations when the inout parameters can be passed to
external entities (and memory sharing typical for passing by reference
is difficult to achieve) such as calling external functions,
parameterized mapping etc. and sharing with testing code running in
parallel (component.start call).<br />
<br />
In case the decision is made in favour of passign by reference, it would
be necessary to formalize rules for type compatibility and
template/value compatibility. That's because when passing by reference,
no value assignment actually takes place.<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0006813</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></span> </td>
<td class="print">Passing fields or elements of a component variable as
inout parameter </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6731_resolution_v1.doc (94,720) <span
class="italic">18-06-2014 12:20</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3047&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6731_resolution_v2.doc (98,816) <span
class="italic">08-10-2014 11:32</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3111&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6731_resolution_v3.doc (166,400) <span
class="italic">08-10-2014 13:50</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3114&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6731_resolution_v4.doc (166,400) <span
class="italic">08-10-2014 16:40</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3122&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6731_resolution_v5.doc (175,616) <span
class="italic">09-10-2014 09:27</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3124&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6731_resolution_v6.doc (175,616) <span
class="italic">09-10-2014 11:05</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3125&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6731_resolution_v7.doc (179,200) <span
class="italic">09-10-2014 15:43</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3131&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6731_resolution_v8.doc (179,200) <span
class="italic">04-11-2014 09:26</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3152&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6731_resolution_v9.doc (180,736) <span
class="italic">04-11-2014 11:22</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3155&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-04-2014 11:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-04-2014 09:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012035</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 09:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012118</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 09:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 09:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 09:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.7.1 (published 2015-06)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 09:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0012118</td>
<td class="print">bug_revision_view_page.php?bugnote_id=12118#r33</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 09:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0012118</td>
<td class="print">bug_revision_view_page.php?bugnote_id=12118#r34</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 11:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0012118</td>
<td class="print">bug_revision_view_page.php?bugnote_id=12118#r38</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 12:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR6731_resolution_v1.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 12:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012121</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 12:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 12:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 12:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Deleted: CR6731_resolution_v1.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 12:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR6731_resolution_v1.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 12:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0012118</td>
<td class="print">bug_revision_view_page.php?bugnote_id=12118#r39</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 15:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012130</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 15:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 15:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 08:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Axel Rennoch</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 08:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 11:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">File Added: CR6731_resolution_v2.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 11:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Note Added: 0012278</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 11:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Assigned To</td>
<td class="print">Axel Rennoch =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 11:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 11:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 13:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6731_resolution_v3.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 13:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012283</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 14:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Axel Rennoch</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 16:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Note Added: 0012294</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 16:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Assigned To</td>
<td class="print">Axel Rennoch =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 16:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 16:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 16:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012297</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 16:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012299</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 16:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR6731_resolution_v4.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 16:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012303</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 16:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 16:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 16:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.7.1 (published 2015-06)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 09:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 09:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 09:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 09:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6731_resolution_v5.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 09:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012310</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 09:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 11:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6731_resolution_v6.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 12:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012315</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 12:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Axel Rennoch</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 12:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 13:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012322</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 15:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012327</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 15:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6731_resolution_v7.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 15:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012328</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2014 08:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Assigned To</td>
<td class="print">Axel Rennoch =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2014 08:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2014 08:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Note Added: 0012335</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2014 08:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2014 09:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012338</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2014 09:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2014 10:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012344</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2014 10:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012349</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2014 10:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Edited: 0012349</td>
<td class="print">bug_revision_view_page.php?bugnote_id=12349#r85</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2014 10:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012350</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2014 10:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012353</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2014 10:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012354</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">03-11-2014 13:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012377</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-11-2014 15:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012379</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">03-11-2014 16:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012383</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-11-2014 16:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2014 08:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6731_resolution_v8.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2014 08:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Deleted: CR6731_resolution_v8.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2014 09:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6731_resolution_v8.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2014 09:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012387</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2014 09:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2014 10:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012390</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2014 11:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR6731_resolution_v9.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2014 11:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012392</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2014 11:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2014 11:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-11-2014 07:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-11-2014 07:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-11-2014 07:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-11-2014 07:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6731_resolution_v10.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-11-2014 08:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012411</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-11-2014 08:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-11-2014 08:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-11-2014 08:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-11-2014 16:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0006813</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-11-2014 16:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012438</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-11-2014 16:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Deleted: CR6731_resolution_v10.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-11-2014 16:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-11-2014 16:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-01-2015 20:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012612</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-01-2015 20:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012035)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-04-2014 09:19   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I'm pretty sure the only way this can go in general is
the assignment-semantics as otherwise, passing a variable of one type as
an actual parameter to a formal parameter of a type-compatible type
would probably be hard to achieve. However, if the types are the same,
passing-by-reference is mostly equivalent to the
assignment-semantics.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0012118)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-06-2014 09:04   <br />
(edited on: 18-06-2014 12:25)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I agree with Jacob. Assignment-semantics was the
original assumption, because TTCN-3 is an abstract language. It simply
doesn't know things like pointer. We have references to active TTCN-3
objects only, like timers, components, ports, but not to data objects.
Also, a term like passing-by-reference is not defined, so we should
avoid using it.<br />
<br />
I think the sources of the problem are<br />
- using the word "bound" in the definitions of all kinds of
parameterization; "bound" itself may be interpreted both as "assigning"
and "connecting" and for in parameters it is used in the sense of
"assigning" (otherwise it would be impossible to prevent changing the
original value of the actual parameter), while for inout and out is used
in the sense of "connecting";<br />
- the definition of inout parameterization seems to be incomplete; i.e.
it mentions nothing more than "bounding" the actual parameter to the
formal parameter that really gives the impression of
pointer-passing.<br />
<br />
I suppose, in the example<br />
testcase TC() runs on C {<br />
  f(vc_int);<br />
}<br />
was meant. Actually, according to Note1 to the definition of inout
parameterization, the example shall print 10.<br />
<br />
I will propose correction to the text.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012121)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-06-2014 12:16   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">See the proposed solution in
CR6731_resolution_v1.doc.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012130)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-06-2014 15:11   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Result of STF discussion: the proposal should be more
detailed. Possible improvements:<br />
- defining the term "passing by reference" and its implications<br />
- type compatibility rules for passing by reference (especially
constraint handling)<br />
- some examples<br />
- check the situation in the existing TTCN-3 tools</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012278)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2014 11:35   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">- addition of an inital definition of "passing by
reference"<br />
- extended note for "inout" and "out" parameterization</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012283)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2014 13:59   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Since Axel defined the term "passing by reference", I
added it to several other rules so that the concept can be really used.
I also defined what "passing by value" means. The terms are defined on
an abstract level (no pointers and other implementation details are
mentioned).<br />
<br />
The system now resembles the one used in modern programming languages,
the in and out parameterization use passing by value and inout passing
by reference. Some current or proposed rules were not completely
compatible with these concepts, so I had to modify them.<br />
<br />
I also added an example demonstrating the difference between the two
principles of parameter passing.<br />
<br />
Axel, could you please check if there are no inconsistencies in my
proposal? If so, we can continue our discussion if it is acceptable to
solve the CR this way.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012294)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2014 16:08   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">The proposal is fine for me. We may move the second
sentence of the defintions "passing by .." to a NOTE.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012297)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2014 16:25   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">So, in my opinion it follows for inout
parameterization that the type of the formal and actual parameter need
to be the same, otherwise, there could develop some very confusing
situations:<br />
<br />
type integer I1 (0 .. 5);<br />
type integer I2 (5 .. 10);<br />
<br />
var integer i := 5;<br />
<br />
f(i, i);<br />
<br />
function f(inout I1 i1, inout I2 i2) {<br />
  i1 := 0; // causes an error because it violates constraint of I2<br />
  i2 := 10; // causes an error because it violates constraint of
I1<br />
}<br />
<br />
I'm also not sure what happens if one actual parameter contains another
one.<br />
<br />
Consider the following:<br />
<br />
type record R {<br />
  record {<br />
    integer i<br />
  } f<br />
}<br />
<br />
var R rr := ... ;<br />
<br />
f2(rr, rr.f.i);<br />
<br />
where f2 is defined like this<br />
<br />
function f2(inout R r, inout integer i) {<br />
  r := { f := { i := x } } // is parameter i changed here or not?<br />
  i := i + 1; // does this still change r or not?<br />
}</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012299)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2014 16:29   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Ah, the first restriction is already in the proposal,
my bad. The other question still remains, though.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012303)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2014 16:40   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">CR6731_resolution_v4.doc: only cosmetic editorial
changes.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012310)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2014 09:28   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I am afraid I have to reopen this CR. As Jacob pointed
out there are unresolved questions regarding elements of structured
types that are passed by reference. I tried to address these issues in
the next version of the proposal.<br />
<br />
Jacob, if you have time, could you please take a look at it and comment
it?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012315)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2014 12:02   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Axel, could you please check the last additions to the
proposed resolution?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012322)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2014 13:13   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I would not know how to implement this (easily).<br />
<br />
Also, if I understand it correctly, this would have the following
implication.<br />
<br />
type union U {<br />
  record {<br />
    integer i<br />
  } v1,<br />
  record {<br />
    float f<br />
  } v2<br />
}<br />
<br />
var U u := { v1 := { i := 5 } }<br />
<br />
f(u, u.v1.i);<br />
<br />
where<br />
<br />
function f(U pu, integer pi) {<br />
  pu := { v2 := { f := 5.0 } } // =&gt; pi is undefined<br />
  pi := 5 // =&gt; pu == { v1 := { i := 5 } }<br />
}<br />
<br />
This, in my opinion, is highly uninituitive. It also breaks the rule
that a variable that has been ininitalized cannot be un-initialized
again.<br />
<br />
I would define the semantics in such a way that pi keeps its value and
does not have any impact on pu after pu was severed from pi anymore. pi
can still be used inside the function, but is thrown away after f is
left.<br />
<br />
This is much more in sync with the copy-back approach that we
interpreted the standard up-till now (and is also far easier to
implement as pi does not have to know where it resides in its
superstructure while in the proposed solution, it does to be able to do
the appropriate expansion).</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012327)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2014 15:14   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Jacob, you understand the proposal correctly.<br />
<br />
It is quite easy to implement using structured pointers. Instead of
saving the address of the element itself, the tool can store the whole
reference chain, i.e. in your example pi would be represented as {
address of u, index of v2, index of i }. Dereferencing such pointers is
not that fast as in case of classical pointers, but it should not
constitute a major performance bottleneck.<br />
<br />
I actually understand your concern that it is not intuitive. However, it
is difficult to find any intuitive solution. When using copy-back
approach, it behaves also in an unexpected way, especially for people
used to passing by reference (and copying has other cons, such as
wasting of resources).<br />
<br />
There are two alternative approaches we could consider.<br />
<br />
1) Element detaching instead of complete deleting. That's what Jacob
proposes, i.e. that the elements that become disconnected from the
original value (by omitting, truncating or selecting other variant)
continue to live their own life after disconnection. That's the approach
used for objects in languages with garbage collector, so the principle
is quite well known. The question is if it is suitable for TTCN-3. I
have some objections against this:<br />
a) It doesn't seem to be intuitive either as restoring the original
structure of the structured object doesn't reconnect the object.<br />
b) We define passing by reference as sharing the data content by the
actual and formal parameter, but this wouldn't apply in this case.<br />
c) It might be difficult to implement in tools that do not use garbage
collection (e.g. C++ based tools) as they would have to simulate garbage
collector functionality.<br />
d) It would require to change the definitions again and create
additional rules.<br />
<br />
2) References cannot be used after the referenced element is no longer
valid. This is probably simpler to implement and explain in the rules,
but a) and b) from the former paragraph are still valid.<br />
<br />
In my opinion the proposed solution is the least "evil" one and I would
pick it as the resolution of this CR. However, I am open to further
discussion.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012328)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2014 15:47   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Two small additions to the proposal
(CR6731_resolution_v7.doc):<br />
- rules for using references in actual parameters<br />
- rules for order of passing values from out formal parameters to actual
parameters</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012335)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 08:52   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">checked and can be set to resolved.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012338)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 09:04   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Gyorgy, please take a final look at it before we mark
it as resolved. Since Jacob raised some objections, a person different
from the authors of the proposed changes should set the final
verdict.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012344)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 10:07   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I think the unintuitive-ness is my biggest concern, as
well as the fact that we took great pains to introduce restrictions so
that no variable that was at any point initialized can become
uninitialized again.<br />
<br />
This way, we introduce such a case through the back-door and what makes
it worse, it is not apparent in the context of the variable at all
(since the function does not know what its actual parameters will be)
and can be caused by the assignment of a different variable. No
flow-analysis checking for initialization of variables before usage
would work anymore.<br />
<br />
As non-garbage-collection frameworks have to take care of
garbage-collection themselves, anyway, I am sure, it will be quite easy
to find out that the reference to the variable is lost and therefore it
can be collected (by whatever mechanism, if any) after the function is
left again.<br />
<br />
The unintuitive-ness of the non-reconnection-issue is granted, though I
think only to those not thinking about implementations of
data-structures. Both in the C-pointer-world as in the
object-oriented-world no-one would expect a reconnect once a
sub-structure is replaced with a different sub-structure. Anyway, if a
NOTE explaining that special situation is added to the standard,
confusion there can be avoided. This is, of course, true also for the
other approach, but there the other drawbacks mentioned above are not
addressed.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012349)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 10:38   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Technically, we still don't allow to uninitialize
variables. Only formal inout parameters can become uninitialized and
only in cases when they refer to an element located in an optional part
of a structured value. The existing tools most likely implement flow
analysis in such a way that disappearance of the optional part of
structured values is considered and I see no reason, why this approach
cannot be extended to parameters passed by reference.<br />
<br />
If you are concerned about the back door problem, we should first
discuss if passing by reference is suitable at all, because this problem
will always exist when two different references share the same data
content.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012350)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 10:41   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Thinking about this further, I think what you are
proposing is actually called normally 'call-by-name', i.e. that in the
parameterized body, the references to the formal-inout-parameters are
replaced not by the references to the actual parameters but by the
actual parameters themselves (i.e. the pu would be replaced by the
expression u and pi would be replaced by the expression). That way, you
would get your proposed semantics. This, of course, should not be called
call-by-reference since those people knowing the term from other context
will not understand the proposed call-by-name semantics. Thus, if you go
that way - accepting all the drawbacks - please name and describe the
concept accordingly.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012353)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 10:44   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">At the moment, no variable can become uninitialized by
the disappearance of a sub-structure of another variable. So,
flow-analysis tools do not have to take into account that a variable can
become uninitialized, but only has to keep track of sub-structures. In
principle, you are right, flow analysis is already pretty impossible
even without this additional complication, but I don't think making it
more complicated will help matters there.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012354)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 10:50   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Of course, we could simply forbid this kind of
situation altogether. I.e. passing a variable and a sub-structure of the
same variable both as inout parameter to a function could be forbidden
to avoid these semantic uncertainties. Though this might introduce
backward-incompatiblities, the actual (probably pathological) situations
where something like this occurs now are not clearly defined anyway and
could lead to different behaviors in different tools, so I don't see a
big problem there.<br />
<br />
Thinking about this some more, we should also think about what happens
if a variable and its sub-structure are passed to an inout and an out
parameter. Does the out-copy-back-assignment win or lose according to
parameter order or does copy-back always occur?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012377)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">03-11-2014 13:43   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I think the main point is to define the rules clearly.
At this point in time (TTCN-3 is 15 years old), we shall avoid backward
incompatible restrictions.<br />
<br />
Let discuss the possible alternatives further.<br />
<br />
It seems to me that there is no disagreement regarding the unstructured
case (new example 6). But, see below...<br />
<br />
The complicated thing is when passing a structure and also its element
as read-write-able parameters. I agree, from a (framework) function
writer's point of view it may be strange and unexpected if some
parameters can be made implicitly uninitialized by certain parameter
combinations...<br />
<br />
There are more ways to go:<br />
- either specify a special exception for this case (too many exceptions
already in the language)<br />
- allow side effects, notify users about them.<br />
- define a rule disallowing side effects in both cases (when the same
value is passed to two different inout parameters and when a structure
and its element are also passed as inout parameters), i.e. seemingly a
value passed in, a value passed out, no side effect inside. This will
complicate tool implementations but probably the safest for the
users.<br />
<br />
<br />
<br />
out parameters' behaviour should not be a problem, as they are passed by
value, i.e. changing an out parameter within the called function shall
not change the inout parameter's value immediately, within the function.
An interesting effect that dependig on the above decision, it may or may
not overwrite the inout parameter's (or its elemen's) value when leaving
the function.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012379)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">03-11-2014 15:19   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I would opt for variant 3 (disallowing). It is a
pathological case and will probably lead to unexpected behavior (and up
till now, different behavior for each implementation).<br />
<br />
And, I think that this should include out parameters as well (mixing
them with inout in a shared structure). If only out parameters are used,
there is no problem.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012383)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">03-11-2014 16:14   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF discussion: passing a sructure and a member of
that structure to two different inout parameters of a function at the
same time should be disallowed.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012387)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-11-2014 09:35   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Modification in the last version of the
document:<br />
1. Restriction saying that elements of a structure cannot be passed by
reference if the structure is also passed by reference.<br />
2. Restriction saying that distinct alternatives of union and anytype
values cannot be passed by reference.<br />
<br />
These restrictions should prevent the situation when an already
initialized inout parameter value becomes uninitialized through
modification of another inout parameter.<br />
<br />
I also removed the rules that were related to the now-disallowed
behaviour and moved the section on structured values into the section
describing actual parameters where it logically belongs.<br />
<br />
Please review.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012390)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-11-2014 10:30   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">No objections from me.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012392)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-11-2014 11:23   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">In CR6731_resolution_v9.doc only editorials and the
new note to the actual parameter restrictions is deleted as superfluous,
in agreement with Tomas.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012411)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">05-11-2014 08:01   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">One more restriction is necessary to prevent the
situation when both parent structure and its field/element are available
as a reference: the combination of runs on and component variable field
passed to an inout parameter.<br />
<br />
The restriction n) has been added to 5.4.2 and original restriction n)
was changed to o). Please review.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012438)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">05-11-2014 16:22   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">It is agreed that a new restriction on component
variabes has more chance to invalidate existing and working test suites,
therefore we need user feedback on it. Hence it will not be included
into this CR but new CR 6813 has been created. CR6731_resolution_v9.doc
continues to be the final agreed version.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012612)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-01-2015 20:37   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Added to V4.6.3</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
