  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0006412</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Technical</td>
<td class="print">public</td>
<td class="print">16-01-2013 12:39</td>
<td class="print">28-08-2013 14:59</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Thilo Lauer</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">major</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.4.1 (published 2012-04)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.6.1 (published 2014-06)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.6.1 (published 2014-06)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">16.1 Functions</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Devoteam - Thilo Lauer</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0006412: system component shall be passed
to functions with map/unmap statements</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">If map/unmap statements are used in a
function, then the system component should also be passed to this
function,<br />
  (1) either as parameter<br />
  (2) or by using keyword system to define the function's system
component.<br />
<br />
Let's assume the following component definitions:<br />
  type component UTRAN_PTC {<br />
    var UTRAN_Global_Type vc_UTRAN_Global;<br />
<br />
    port UTRAN_AM_PORT U_AM;<br />
    port UTRAN_TM_PORT U_TM;<br />
    port UTRAN_UM_PORT U_UM;<br />
    ...<br />
    port UTRAN_VNG_PORT U_VNG;<br />
    ...<br />
  };<br />
<br />
  type component UTRAN_SYSTEM {<br />
    port UTRAN_AM_PORT S_U_AM;<br />
    port UTRAN_TM_PORT S_U_TM;<br />
    port UTRAN_UM_PORT S_U_UM;<br />
    ...<br />
    port UTRAN_VNG_PORT S_U_VNG;<br />
  };<br />
<br />
Example:<br />
The defintition of function f_UTRAN_PTC_Map below can generally be
called in the context of different test cases<br />
with different system components (defining different system
ports).<br />
Therefore if this function is defined as shown below, it can currently
not be decided at compile time<br />
if the system component actually has the system ports used in the
function's map statements:<br />
<br />
  function f_UTRAN_PTC_Map(UTRAN_PTC p_Utran)<br />
  {<br />
    map(p_Utran:U_AM, system:S_U_AM);<br />
    map(p_Utran:U_TM, system:S_U_TM);<br />
    map(p_Utran:U_UM, system:S_U_UM);<br />
    // ... further map statements<br />
<br />
    if (f_GetTestcaseAttrib_Qbased_Rsrq(testcasename())) {<br />
      map(p_Utran:U_VNG, system:S_U_VNG);<br />
    }<br />
  }<br />
<br />
Given the function definition above, errors with system port mappings
can only be detected at runtime.<br />
<br />
<br />
To be able to do this checks at compile time, we suggest ...<br />
============================================================<br />
1.) either to pass the system component additionally as parameter:<br />
    i.e. to change the function definition in the test suite to:<br />
  <br />
  function f_UTRAN_PTC_Map(UTRAN_PTC p_Utran, UTRAN_SYSTEM
sys_Utran)<br />
  // *** added parameter: UTRAN_SYSTEM sys_Utran ***<br />
  {<br />
    map(p_Utran:U_AM, sys_Utran:S_U_AM);<br />
    map(p_Utran:U_TM, sys_Utran:S_U_TM);<br />
    map(p_Utran:U_UM, sys_Utran:S_U_UM);<br />
    // ... further map statements<br />
    <br />
    if (f_GetTestcaseAttrib_Qbased_Rsrq(testcasename())) {<br />
      map(p_Utran:U_VNG, sys_Utran:S_U_VNG);<br />
    }<br />
  }<br />
<br />
  // function call:<br />
  f_UTRAN_PTC_Map(p_Utran, system);<br />
  // *** keyword "system" passed as actual component parameter value
here ***<br />
<br />
  <br />
2.) or to change the TTCN-3 syntax for function definitions as shown
below:<br />
<br />
  function f_UTRAN_PTC_Map(UTRAN_PTC p_Utran) system UTRAN_SYSTEM<br />
  // *** system UTRAN_SYSTEM added ***<br />
  {<br />
    ...<br />
  }<br />
<br />
 <br />
Solution 1.) requires a change in some ETSI/3GPP suites<br />
Solution 2.) requires a change in some ETSI/3GPP suites and in the
TTCN-3 standard as well.<br />
<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0005922</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></span> </td>
<td class="print">why strong typing is not used in map and unmap? </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-01-2013 12:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo
Lauer</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-01-2013 12:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo
Lauer</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; 16.1 Functions</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-01-2013 12:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo
Lauer</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; Devoteam - Thilo Lauer</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-01-2013 11:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011324</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-01-2013 11:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0005922</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-07-2013 15:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-07-2013 15:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-07-2013 18:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.6.1 (published 2014-06)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-07-2013 15:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011550</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-07-2013 15:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-07-2013 15:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-08-2013 14:58</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0011626</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">28-08-2013 14:58</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-08-2013 14:58</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">28-08-2013 14:58</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.6.1 (published 2014-06)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-08-2013 14:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011324)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-01-2013 11:44   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">A proposal for the solution of this issue can already
be found in CR5922</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011550)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-07-2013 15:23   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">see proposal in 5922</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011626)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">28-08-2013 14:58   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Resolved together with 5922</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
