  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0006318</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">21-09-2012 10:10</td>
<td class="print">26-11-2013 16:57</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Tomas Urban</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.4.1 (published 2012-04)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.6.1 (published 2014-06)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.6.1 (published 2014-06)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">8.2</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Elvior</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0006318: Assignment of global templates
and module parameters</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">I couldn't find any rules in the current
standard saying when assignments of globally defined objects (i.e.
static templates and module parameters) shall take place during
execution. In my opinion, that gives vendors too much space for
interpretation resulting in different approaches for executing such
assignments, e.g.:<br />
<br />
1. At the beginning of control part<br />
2. When a global object is first referenced<br />
3. At the beginning of the lowest block containing the first reference
to a global object<br />
<br />
Let's demonstrate it on an example:<br />
<br />
module M<br />
{<br />
 function f() return integer {<br />
  log("in function");<br />
  return 1;<br />
 }<br />
 template integer t := f();<br />
 type port P message{ inout integer; }<br />
 type component C { port P; }<br />
 testcase TC() runs on C {<br />
  log("in test case");<br />
  p.send(t);<br />
 }<br />
 control {<br />
  log("in control");<br />
  execute(TC());<br />
 }<br />
}<br />
<br />
In case of the first approach, the log would look like this:<br />
in function<br />
in control<br />
in test case<br />
<br />
In case of the second approach, thel log would lool like this:<br />
in control<br />
in test case<br />
in function<br />
<br />
In case of the third approach, thel log would lool like this:<br />
in control<br />
in function<br />
in test case<br />
<br />
If the first approach is used, then the global object declaration cannot
contain calls that are not allowed in the control block. E.g. LTE test
suite contains global templates that reference functions with
testcase.stop inside and istantiating these templates in the control
block can lead to trouble. This approach also makes unnecessary calls
(instantiating templates that are actually never used).<br />
<br />
If the second approach is used, then there's a danger that the template
is referenced in a place mentioned in the chapter 16.1.4. In such a case
it is possible that its declaration contains a function call that is
forbidden by the restrictions listed in 16.1.4. If the template has been
already referenced before, the statement will be executed without any
problem (because the value has been already assigned and the forbidden
function is actually not called). However, in case it is the first
template reference, an error will occur during the function call. Such
an approach is in my opinion unacceptable, because it can lead to
different test case results that are dependent only on execution
path.<br />
<br />
The third approach doesn't suffer from any of the above mentioned
problems, but it produces "unnatural" execution order and it might be
difficult to explain it to users.</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0006606</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></span> </td>
<td class="print">Allow usage of deterministic external functions in
snapshot evaluation </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR-6318-resolution-V1.doc (70,144) <span
class="italic">19-12-2012 13:49</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2789&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR-6318-resolution-V2.doc (70,656) <span
class="italic">21-12-2012 12:06</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2798&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6318-Resolution-V3-JG.doc (90,624) <span
class="italic">30-08-2013 10:35</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2880&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6318-Resolution-V4-JW.doc (89,600) <span
class="italic">30-08-2013 13:44</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2881&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6318-Resolution-V5.doc (89,600) <span
class="italic">10-10-2013 10:00</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2918&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-09-2012 10:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-09-2012 10:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; 8.2</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-09-2012 10:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; Elvior</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-09-2012 12:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011154</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-12-2012 13:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-12-2012 13:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-12-2012 16:42</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.5.1</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-12-2012 10:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0011213</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-12-2012 10:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-12-2012 13:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0011220</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-12-2012 07:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0011262</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-12-2012 07:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-12-2012 12:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011279</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-12-2012 14:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">File Added: CR6014-resolution-v3.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-12-2012 14:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0011282</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-12-2012 14:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-12-2012 13:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">File Deleted: CR6014-resolution-v3.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-12-2012 13:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">File Added: CR-6318-resolution-V1.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-12-2012 11:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011296</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-12-2012 11:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-12-2012 11:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-12-2012 11:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; Edition 4.5.1</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-12-2012 10:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-12-2012 10:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-12-2012 10:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-12-2012 10:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-12-2012 10:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-12-2012 12:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0011311</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-12-2012 12:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">File Added: CR-6318-resolution-V2.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-12-2012 12:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-01-2013 11:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">closed =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-01-2013 11:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-01-2013 11:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011318</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-01-2013 12:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-01-2013 12:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Assigned To</td>
<td class="print">Ina Schieferdecker =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-01-2013 12:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0011319</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-01-2013 11:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011323</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-05-2013 15:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">Edition 4.5.1 =&gt; v4.7.1 (published 2015-06)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-07-2013 18:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">v4.5.1 (published 2013-04) =&gt;</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-08-2013 16:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011642</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2013 10:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">File Added: CR6318-Resolution-V3-JG.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2013 10:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0011654</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2013 10:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2013 13:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR6318-Resolution-V4-JW.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2013 13:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011659</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2013 13:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011660</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2013 13:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2013 13:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2013 14:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011663</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2013 14:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2013 14:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2013 14:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2013 16:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011665</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2013 16:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2013 16:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2013 16:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Ina Schieferdecker =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2013 10:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0006606</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2013 10:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR6318-Resolution-V5.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2013 10:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011744</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2013 10:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2013 10:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2013 10:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2013 10:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0011745</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2013 15:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2013 15:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011757</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2013 15:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2013 15:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">26-11-2013 16:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0011839</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">26-11-2013 16:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">26-11-2013 16:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.6.1 (published 2014-06)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">26-11-2013 16:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011154)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">28-09-2012 12:09   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Since global templates are like constants, they should
normally not produce any behavior or side-effects. Therefore, the same
restrictions as for the usage of functions during alt-guard-evaluation
should be imposed.<br />
<br />
With this approach, it becomes irrelevant when the template is
instantiated whether early at module-loading time or lazy at
first-usage.<br />
<br />
If the use of a template shall produce a behavior, it should be
parameterized and the behavior given as actual parameter. Then, the
evaluation time is clearly the point of usage. This approach can even be
used together with default parameter values.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011213)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-12-2012 10:14   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Section "16.1.4 Invoking functions from specific
places" defines the restrictions for the usage of functions during
alt-guard evaluation.<br />
<br />
If I interprete 16.1.4 correctly, then he same restrictions apply for
invoking functions in templates, template fields, in-line templates or
as actual parameters.<br />
<br />
The text of 16.1.4 is:<br />
<br />
"Value returning functions can be called in communication operations (in
templates, template fields, in-line templates, or<br />
as actual parameters), in guards of alt statements or altsteps (see
clause 20.2), and in initializations of altstep local<br />
definitions (see clause 16.2). To avoid side effects that cause changing
the state of the component or the actual snapshot<br />
and to prevent different results of subsequent evaluations on an
unchanged snapshot, the following operations shall not<br />
be used in functions called in the cases specified above:"<br />
<br />
Thus, the solution provided by Jacob is already implemented in the
standard. Assigned to Tomas to crosscheck.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011220)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-12-2012 13:07   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Jens, I am afraid that I cannot agree your conclusion.
16.1.4 sets restrictions on function calls used in three syntactical
constructions: communication operations, guards and altstep local
definitions. It doesn't set any restriction on global template
definitions.<br />
<br />
We could of course add "and in declarations of global templates" to the
mentioned sentence ("Value returning functions ... "), but I don't think
it can be done because of problems with backwards compatibility. In
particular, I am sure that there are test suites that contain external
function calls in global template definitions. Using the same
restrictions as for alt guards means that such test suites would stop
working. However, allowing external functions has unfortunately an
unpleasant side efect: the order of global template assignments will
start to matter and it will be required to specify rules for execution
order.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011262)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-12-2012 07:50   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Assigned to Jens to implement the changes discussed at
yesterday's meeting.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011279)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-12-2012 12:56   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I think the problem with external functions is that it
is unknown whether they have side effects or not.<br />
<br />
Maybe a way should be introduced to declare an external function
side-effect-free and then allowing these functions both inside templates
as well as the other special function-invocation-places.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011282)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-12-2012 14:37   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Proposal for Resolution uploaded.<br />
Assigned to GyÃ¶gy for crosschecking.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011296)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-12-2012 11:19   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Its Ok with one typo: in the first inserted text
"paramterization" should be parameterization (first e is missing)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011311)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-12-2012 12:05   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Implemented with small editorials as in v2.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011318)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-01-2013 11:52   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Sorry, but the resolution is not understandable.<br />
<br />
What does "the place of their declaration" mean for global templates in
regard to their initialization TIME. Up till now, the order of global
declarations (which are essentially unordered) does not imply any
initialization order. Also, no restriction when these templates shall be
initialized (or if at all) before their use exists. The whole point of
this CR was to clarify this (if really necessary) to avoid divergences
between tools.<br />
<br />
This has not been achieved by the solution as the place of a declaration
does not tell us anything about the time of its initialization.<br />
<br />
Also, if one would assume that all global templates shall be initialized
before execution, the proposed solution would mean that parameterized
templates are partially initialized before execution and the fields
affected by parameterization are initialized at the place of their
use.<br />
<br />
This, in my view, is completely unacceptable behavior. No one would
expect this behavior and it is backward incompatible for parameterized
templates that call external functions (but not with one of the
parameters) and assume this function call is done for every new instance
of the template.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011319)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-01-2013 12:04   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Please check</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011323)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-01-2013 11:13   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Counter proposal.<br />
<br />
In my understanding, the only problem that really exists (in regard to
this issue) is the question whether it should be allowed to use
templates using not-allowed constructs in the snapshot-evaluation-part
of an alt-statement (i.e. in the guard expression or in the
event-part).<br />
<br />
Since it is definitely more convenient to allow this, I would propose to
specify that all instances of global templates that are referenced in
the snapshot-evaluation part of an (explicit or implicit) alt statement
must be instantiated at the latest before the first evaluation of the
snapshot of that alt statement and should otherwise be instantiated in
the order of the appearance of their usage (from left to right).<br />
<br />
Otherwise standardizing the instantiation order of global templates has
wide-ranging ramifications. First of all, a global order must be
established (i.e. over all modules), as otherwise, the order of
unrelated templates would still be arbitrary. This would force every
tool to always instantiate all global templates even though they are
potentially not used by any testcase that is being run, i.e. performance
optimizations are not possible in that regard anymore.<br />
<br />
This new proposed solution thus solves two problems. It allows usage of
any template inside the snapshot-evaluation part and assigns (a new)
clear semantic meaning to such usage. It also leaves possibilities for
tools to optimize template instantiation in regard to the testcases
being executed.<br />
<br />
If the order of external function calls is relevant to the user, they
should write the TTCN-3 code accordingly so that order is enforced (e.g.
by parameterizing the templates with the results of such calls).<br />
<br />
Also, this proposal has no backward compatibility drawbacks (unlike the
other) as the semantics of behavior of functioning existing code is not
affected by it.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011642)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-08-2013 16:31   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF discussion 2013-08-29: A text to be included into
the templates clause saying that users are strongly advised to adhere to
the restrictions of 16.1.4 (functions called at specific places) for all
function calls inside global constants, templates and module parameters,
to avoid non-deterministic behavior and const/template/modulepar
values.<br />
These limitations cannot be made mandatory for backward compatibility
reason, hence the advice.<br />
It is also agreed that external functions producing deterministic output
will be allowed in 16.1.4.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011654)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-08-2013 10:37   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Resolution in file "CR6318-Resolution-V3-JG.doc".
Assigned to Jacob for cross-checking.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011659)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-08-2013 13:47   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Removed the changes to the paragraph describing the
full speficiation/initialization of templates in their declaration. We
agreed that that was unnecessary.<br />
<br />
Fixed typos (adviced -&gt; advised)<br />
<br />
Made description of non-deterministic functions more explicit (also
regarding out parameters).</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011660)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-08-2013 13:48   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">please review my changes</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011663)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-08-2013 14:14   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">In general OK with me but one comment.<br />
<br />
While clause 16.1.4 item j) disallows inout and out parameters, the new
text of item e) says: "where the resulting values for actual inout or
out parameters or the return value may differ for different invocations
with the same actual in and inout parameters".<br />
<br />
j) and new e) seems to be contradicting. It seems it would be enough to
write: "where the return value may differ for different invocations with
the same actual parameters"</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011665)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-08-2013 16:04   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">no, the calling of out/inout functions is only
disallowed for the top-level call (note 8, I think). Inside a function,
calling other functions with inout/out parameters is allowed. The same
should be true for external functions to be consistent and therefore,
the determinism also needs to be established for the inout/out
parameters.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011744)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2013 10:02   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">It is note 6; I have added to it in
CR6318-Resolution-V5.doc that the non-recursivity is meant for
restriction j) to be unambiguous in this. With this minor amendment it
is OK with me. Tomas, Jacob, pls, check if the resolution is OK with
you.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011745)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2013 10:09   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Very elegant solution. It allows tool vendors to add
proper warnings/errors (depending on compiler settings) in problematic
cases and still preserves backwards compatibility. I like it.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011757)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2013 15:30   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">fine with me</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011839)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">26-11-2013 16:56   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">as proposed</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
