  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0006009</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">19-01-2012 17:23</td>
<td class="print">21-12-2012 10:48</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Bogdan Stanca-Kaposta</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.5.1 (published 2013-04)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.5.1 (published 2013-04)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">B.1.5.2, A.1.6.1.3</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Bogdan Stanca-Kaposta (Testingtech)
STF433</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0006009: Charstring Pattern Reference
Parts should not be allowed</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">The two templates from section B.1.5.2
Reference expression / EXAMPLE 2 should not be accepted since only a
part of a reference is given.<br />
<br />
pattern "{Reg"<br />
<br />
is not a valid pattern expression (see BNF 113.PatternElement) since the
brace is neither closed nor escaped<br />
<br />
Solution: either has to be either escaped or pattern keyword should be
removed<br />
<br />
template charstring RegExp4 := pattern "\{Reg"<br />
  or<br />
template charstring RegExp4 := "{Reg"<br />
<br />
so the templates<br />
<br />
template charstring RegExp4 := pattern "{Reg";<br />
template charstring RegExp5 := pattern "Exp1}";<br />
template charstring RegExp6 := pattern "{RegExp4}{RegExp5}";<br />
// matches the string "{RegExp1}" only (i.e. shall not be handled as a
reference expression<br />
// after insertion)<br />
<br />
have to be changed to:<br />
<br />
template charstring RegExp4 := pattern "\{Reg";<br />
template charstring RegExp5 := pattern "Exp1\}";<br />
template charstring RegExp6 := pattern "{RegExp4}{RegExp5}";<br />
// matches the string "{RegExp1}" only (i.e. shall not be handled as a
reference expression<br />
// after insertion)<br />
<br />
<br />
109.CharStringMatch ::= PatternKeyword PatternParticle {"&amp;"
PatternParticle}<br />
110.PatternParticle ::= Pattern | ReferencedValue<br />
111.PatternKeyword ::= "pattern" 112.Pattern ::= """ {PatternElement}
"""<br />
113.PatternElement ::= ("\" ("?" | "*" | "\" | "[" | "]" | "{" | "}"
|<br />
ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼ï¿¼"""<br />
"w" )) |<br />
| "|" | "(" | ")" | "#" | "+" | "d" |<br />
| "t" | "n" | "r" | "s" | "b"<br />
("?" | "*" | "\" | "|" | "+"<br />
) | ("[" ["^"] [{PatternChar ["-" PatternChar]}]<br />
ï¿¼ï¿¼"]") |<br />
("{" ReferencedValue "}") |<br />
("\" "N" "{" (ReferencedValue | Type) "}") |<br />
(""" """) |<br />
("(" PatternElement ")") |<br />
("#" (Num |<br />
("(" Num "," [Num] ")") | ("(" "," Num ")")<br />
)) |<br />
PatternChar<br />
114.PatternChar ::= Char | PatternQuadruple</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print">see also mantis issue 0005835</td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0006169</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></span> </td>
<td class="print">The pattern char grammar has been mixed up </td>
</tr>
<tr class="even">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0006014</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></span> </td>
<td class="print">Simplifications request for escaping chars inside the
string pattern </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6009_resolution_v1.doc (104,448) <span
class="italic">11-07-2012 17:54</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2679&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6009_resolution_v2.doc (87,552) <span
class="italic">12-07-2012 11:08</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2688&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-01-2012 17:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-01-2012 17:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; B.1.5.2, A.1.6.1.3</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-01-2012 17:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; Bogdan Stanca-Kaposta (Testingtech) STF433</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-07-2012 16:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core
Language</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-07-2012 12:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010747</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-07-2012 12:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-07-2012 12:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-07-2012 12:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.5.1</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-07-2012 17:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010747</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-07-2012 17:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR6009_resolution_v1.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-07-2012 17:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010852</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-07-2012 17:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 11:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a></td>
<td class="print">File Added: CR6009_resolution_v2.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 11:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a></td>
<td class="print">Note Added: 0010869</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 12:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010881</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 12:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010881</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 13:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a></td>
<td class="print">Note Added: 0010884</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 14:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010887</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 14:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010887</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 14:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a></td>
<td class="print">Note Edited: 0010884</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 15:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010889</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 16:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010892</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 16:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0010896</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 18:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010905</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 18:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010906</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 18:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010887</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 18:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010887</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 18:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010887</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 18:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010906</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 19:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010906</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 19:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010906</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">13-07-2012 09:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010908</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">13-07-2012 10:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0010908</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-12-2012 09:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-12-2012 10:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0006169</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-12-2012 11:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0006014</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-12-2012 11:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0011273</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-12-2012 11:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-12-2012 15:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a></td>
<td class="print">Note Added: 0011295</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-12-2012 10:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011304</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-12-2012 10:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-12-2012 10:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0011306</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-12-2012 10:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-12-2012 10:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-12-2012 10:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; Edition 4.5.1</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0010747)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-07-2012 12:28   <br />
(edited on: 11-07-2012 17:17)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF discussion 2012-07-10:<br />
Check if there is an ambiguity in the current text and examples.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010852)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-07-2012 17:57   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The comment is not valid as lonely curly brackets do
not have metacharacter meaning (table B.1 clearly shows that only
{reference} has a metacharacter meaning).<br />
<br />
This clarification and some examples for this has been added to the
proposed text in CR6009_resolution_v1.doc. Pls. review it.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010869)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 11:18   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">proposed change base on v1 which complies also with CR
6014<br />
<br />
Treating curly brackets with two meaning inside the same context is
error prone<br />
<br />
Consider a long string which contains a single opening { and afterwards
some normal alphanumeric characters. If the { has no special meaning,
then it would be natural for someone else to add } (intended as }
literal) at a later place.<br />
<br />
Suddenly, the pair of brackets { and } gets the reference meaning.<br />
<br />
This rule will therefore make such code unmaintainable.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0010881)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 12:27   <br />
(edited on: 12-07-2012 12:32)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">A few years ago I would agree. But now, actually,
adding this restriction would cause existing code containing single {
without \ to fail. Also, if adding a } to an existing list of characters
randomly, it is of very little probability that the new "reference"
would match an existing charstring or univ. charstring value or
template. It is much more probable, that this simply would cause a
semantic checking error. In the rare cases when the new "reference"
imitates an existing definition, it will cause a fail or inconc verdict
that the testers do debug during functional testing anyway.<br />
<br />
So, I stick to leave the standard backward compatible as to my
experience the users are much more sensitive to backward compatibility
than to correct a new error; even a simplest change takes huge time:
write a TR, checking out the code from the version handling system, make
the correction, checking the code in, possibly making a new product
release if this is in a SW library, administer the TR - all together
takes at least half a day, while the technical change is just a few
minutes. Also, "old" existing code is normally not touched, just
executed as regression test cases. Users expect from a new version of
the tool to compile and execute their existing millions of lines of code
seemlessly, without changing anything. For this reason even the smallest
non-backward compatible change is a very sensitive issue, it shall give
a significant value for the user.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0010884)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 13:30   <br />
(edited on: 12-07-2012 14:57)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I would propose to escalate this to the TTCN-3 users
list.<br />
<br />
This feature probably has never been used (since not all tools - if any
- implement this rule), and I think that the standard changes should
improve the life of the other 99.9% that use this special feature of the
charstring pattern.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0010887)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 14:34   <br />
(edited on: 12-07-2012 18:52)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Where are you taking those strange figures from? I do
not know myself how many TTCN-3 users are there as tool vendors do not
publish their figures (but I would be interested about your source
myself). I know only that our tool Titan do implements patterns as
specified today and we have millions of lines of TTCN-3 code and about
3600 active licenses in the company. I really hope that this is just 0,1
% of all TTCN-3 users on the world :-)... but at the same time I have
some doubt ...<br />
<br />
So, as explained earlier, for Ericsson only the backward-compatible
proposal in CR6009_resolution_v1.doc is acceptable.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010889)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 15:49   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Actually, we do not believe that anyone would use this
feature willingly as it is simply confusing and will thus yield bad
code. We can of course speak only for our users (and extrapolate from
that) which use a tool where we explicitly decided not to implement this
strange feature and in the last 10 years, no one has complained about
missing it.<br />
<br />
From my experience with regexp languages in general (and other
languages), it is not normal that a part of an expression changes its
semantics dependent on another part of the expression which can come
MUCH MUCH MUCH later.<br />
<br />
Most importantly, the rule about the single { or } also violates the
normal compositionality rule for regular expressions, namely that you
can compose two valid regular expressions by concatenation and always
get a valid regular expression as the result.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010892)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 16:03   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Also, pragmatically, no one forces Ericsson to REMOVE
the existing feature from their tool, thereby maintaining the
possibility for their users to keep their code untouched. As there are
also other non-standard-compliant features in existence in that tool, I
don't see the relevance to keep the feature in the standard in its
current form which can only cause more problems than it solves.<br />
<br />
Thus, only for publishing new globally standardized testsuites, this can
become an issue and there it is relevant to tag the testsuite with the
TTCN-3 edition anyway.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010896)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 16:36   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Even though I am technically on your side, a non
backwards compatible change requires an agreement from MTS. After our
last non backwards compatible change that we introduced accidentally and
which caused problems, I doubt that we will get the agreement.<br />
<br />
One way of working towards a removal in the future would be to move the
problematic parts into the Annex G "Depreciated language features". I
don't know if it can be done here and if this is acceptable for
Ericsson.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010905)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 18:34   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Jacob, your comment is totally misleading. You are
talking about composing references from different patterns that I also
think would be a bad code design.<br />
<br />
But the feature discussed here is to use a single curly bracket without
escaping it (a.k.a escaping is optional). And as this feature has been
in the language for a long time and a huge amount of code may use this
feature (i.e. matching a single curly bracket as a literal character,
without escaping), we do not agree to change the language in a
non-backward compatible way without resolving an error and without any
major benefit. We do not agree to move this feature to be a deprecated
one.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0010906)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 18:49   <br />
(edited on: 12-07-2012 19:48)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Secondly, this change would cause other technical
problems. E.g.<br />
<br />
const charstring user:= "me";<br />
const charstring passw:= "a{bc";<br />
template charstring temp := pattern "*{user};{passw}*";<br />
...<br />
p.send(me);<br />
p.send(passw);<br />
p.receive(temp);<br />
<br />
this code is working fine today, isn't it? By making escaping for single
curly brackets mandatory, this code would become invalid and the use
case could not be solved at all, as no one knowns when and at which
position passw is containing a curly bracket (pls. note, if there is a
pair of curly brackets in passw, the code is still working as references
are resolved only once, i.e. the reference {passw} is resolved but then
the content of passw is processed literally, i.e. if passw contained
"{abc}", temp will match the string containing "me;{abc}").<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0010908)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">13-07-2012 09:56   <br />
(edited on: 13-07-2012 10:22)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">No, referencing a charstring *value* (not a pattern)
from a pattern automatically quotes all characters in the charstring
value which would be special characters in a charstring pattern (to
interpret the value as its literal value). Only in the regexp function
is a charstring value reinterpreted as a regular expression.<br />
<br />
So, even if the feature would be deprecated, the code you provided would
still be as valid. The resulting pattern would be: pattern "*me;a\{bc*"
which has your desired semantics.<br />
<br />
Therefore, I still think that making the feature of single unquoted { or
} deprecated is a good compromise which will not break any code, but
allow tools to warn users about (or prevent them from) such potentially
harmful code. It will not change any semantics whatsoever, but will only
deprecate some syntax which is now valid.<br />
<br />
The problem of missing compositionality is especially harmful
considering the regexp function which can (unfortunately) also take
charstring values and reinterpret them as regular expressions. Here, it
is even more probable that someone will simply concatenate two or more
charstring values which for them are all valid regular expressions (to
be arbitrarily received from somewhere) and then give them to the regexp
function only to find out at runtime that the resulting regular
expression was not valid.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011273)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-12-2012 11:33   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">This issue is a part of several related problems
concerning the pattern template rules. The STF 446 has decided to solve
these issues by opting for such rule that efficiently excludes any
possibility of errors caused by invalid pattern format. Tool vendors can
still include their own tool-specific format checks, e.g. warning users
when certain characters do not form a valid metacharacters.<br />
<br />
Please take a look at resolution a of CR 6014. The STF 446 identified a
potential problem mentioned in the discussion concerning automatic
escaping of referenced strings inserted into patterns and added such a
functionality to the draft.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011295)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=699">Bogdan
Stanca-Kaposta</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-12-2012 15:28   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Maybe I missed some of the comments/discussions
Threads on this bug. Would it be possible to comment how the
{\referenceName} may solve the problem raised in this bug.<br />
<br />
Thank you!<br />
<br />
STF451</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011304)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-12-2012 10:17   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I think that this issue has been handled in 6014 (main
text part) and 6169 (BNF), hence this one can be closed with resolution
fixed and by a note saying that the technical solution is contained in
the above CRs.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011306)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-12-2012 10:48   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Technical solution in 6169 and 6014 - hence
closed.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
