  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 06: TTCN-3 Control Interface
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0005986</td>
<td class="print">Part 06: TTCN-3 Control Interface</td>
<td class="print">Technical</td>
<td class="print">public</td>
<td class="print">16-12-2011 16:22</td>
<td class="print">12-07-2012 16:13</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Mateusz Pusz</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">major</td>
<td class="print-category">Reproducibility</td>
<td class="print">N/A</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">won't fix</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.5.1 (published 2013-04)</td>
<td class="print-category">Fixed in Version</td>
<td class="print"></td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">10.5.3.9-10</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Mateusz Pusz/freettcn</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0005986: Invalid TCI interface for
octetstring</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">That issue is a follow up of <a
href="/mantis/view.php?id=5945" class="resolved"
title="[closed] Missing types in TCI C++ mappings">0005945</a> and
exactly that part:<br />
"Tchar is not defined in the standard too and it is used in
OctetstringValue and HexstringValue interfaces (10.5.3.9-10)."<br />
<br />
It seems that Tchar is not a good solution here and should be removed
from the specification. Here is why...<br />
<br />
Lets assume:<br />
<br />
var hexstring string1;<br />
string1 := '1234'H;<br />
string1[1] := '1'H; // is valid and will end up with '1134'H;<br />
<br />
ORG_ETSI_TTCN3_TCI::HexstringValue::setHex(1, '1'); // is valid and will
end up again with '1134'H;<br />
<br />
Now lets look at another type:<br />
<br />
var octetstring string2;<br />
string2 := '1234'O;<br />
string2[1] := '11'O; // is valid and will end up with '1211'O;<br />
<br />
// but how TCI should behave?<br />
// we cannot pass<br />
ORG_ETSI_TTCN3_TCI::OctetstringValue::setOctet(1, '11'); // &lt;----
compilation error<br />
<br />
// maybe index of a TTCN type should not be equal to index of TCI
type?<br />
ORG_ETSI_TTCN3_TCI::OctetstringValue::setOctet(2, '1');<br />
ORG_ETSI_TTCN3_TCI::OctetstringValue::setOctet(3, '1'); // but that is
not he best idea<br />
// and of course getOctet() has to use the same indices<br />
<br />
// or maybe Tchar should be treated as an integer and not a char<br />
ORG_ETSI_TTCN3_TCI::OctetstringValue::setOctet(1, 0x11);<br />
// but in such a case hexstring should also be modfied to work like
that:<br />
ORG_ETSI_TTCN3_TCI::HexstringValue::setHex(1, 0x01);<br />
// also getOctet() and getHex() should return similar values<br />
<br />
From current TCI definition it is not possible to understand what the
standard really means here.<br />
<br />
It would be much better to use Tinteger value here because it is
directly suggesting the usage scenario. In such a case Tchar type is not
needed anywhere and should be removed from the standard.<br />
<br />
Alternatively Tchar can be renamed to Tbyte. The same underlying (1 byte
long) type will be used, but it will provide totally different meaning
suggesting usage of integral values instead of characters. In such a
case TCI interface description should be extended with exact information
how to use it.</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print">See also no.3 here <a
href="http://list.etsi.org/scripts/wa.exe?A2=ind1110&amp;L=ttcn3&amp;T=0&amp;P=393">http://list.etsi.org/scripts/wa.exe?A2=ind1110&amp;L=ttcn3&amp;T=0&amp;P=393.</a>
[<a
href="http://list.etsi.org/scripts/wa.exe?A2=ind1110&amp;L=ttcn3&amp;T=0&amp;P=393"
target="_blank">^</a>]</td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-12-2011 16:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz
Pusz</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-12-2011 16:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz
Pusz</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; 10.5.3.9-10</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-12-2011 16:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz
Pusz</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; Mateusz Pusz/freettcn</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-07-2012 16:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 06: TTCN-3 Control
Interface</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-07-2012 18:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010777</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-07-2012 18:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-07-2012 18:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-07-2012 18:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.5.1</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 16:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0010895</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 16:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 16:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; won't fix</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010777)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-07-2012 18:24   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF discussion 2012-07-10: to be checked</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010895)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 16:12   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">TChar is used in TCI for BitString, HexString, and
OctetString in getBit, getHex, and getOctet to return the bit, hex, and
octet at a given position as a character.<br />
<br />
It is NOT used to set a bit, octet, or hex respectively. For that,
integer is used instead - see setBit, setOctet, and setHex.<br />
<br />
Hence, the examples given above work differently, but will work if the
operations are used as defined.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
