  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0005898</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">15-06-2011 16:50</td>
<td class="print">01-12-2011 15:36</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Wolfgang Seka</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.4.1 (published 2012-04)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.4.1 (published 2012-04)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">201 873-1 cl. 7.1 (??); 201 873-1 cl.
15.9</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">stf160 - Wolfgang</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0005898: Clarification about comparision
of optional fields with values</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">It seems at least not to be obvious in the
core language what happens when an optional field of a record is omit
and it is used in comparision with a value ("==");<br />
this causes a runtime error with at least one compiler therefore
clarification is important for tool compatibility.<br />
Furthermore it would be quite costly to get a runtime error in this
case.</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print">Example:<br />
type record MyRecord_Type {<br />
   integer field1,<br />
   integer field2 optional<br />
};<br />
<br />
template (value) MyRecord_Type cs_MyRecord := {<br />
   field1 := 1,<br />
   field2 := omit<br />
};<br />
<br />
var MyRecord_Type v_MyRecord := valueof(cs_MyRecord);<br />
<br />
=&gt;<br />
if (v_MyRecord.field2 == 3) { ... } /* shall be allowed i.e. the
expression shall result in false and there shall be no runtime error
*/<br />
<br />
if (v_MyRecord.field2 == omit) { ... } /* is this allowed ?? (would be
equivalent "if (not ispresent(v_MyRecord.field2)) { ... }" or "if (not
isvalue(v_MyRecord.field2)) { ... }" */<br />
<br />
in principle there is the same situation with "!=" (but that can be
derived from "not (... == ...)")<br />
<br />
There is a similar situation in context of the match operation<br />
<br />
if (match(v_MyRecord.field2, (2, 3))) { ... } /* I would assume that
this is allowed but the standard says "The match operation allows to
compare a value (specified in form of an expression) with a template"
*/<br />
<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR5898_resolution_v2.doc (92,160) <span
class="italic">30-09-2011 14:22</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2585&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR5898-proposal_v3.doc (121,856) <span
class="italic">01-12-2011 10:29</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2638&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-06-2011 16:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-06-2011 16:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; 201 873-1 cl. 7.1 (??); 201 873-1 cl. 15.9</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-06-2011 16:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; stf160 - Wolfgang</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-06-2011 16:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010133</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">28-06-2011 16:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010133</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-06-2011 16:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010133</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">28-06-2011 16:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core
Language</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-06-2011 12:45</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010142</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-06-2011 12:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010142</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-06-2011 11:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010155</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-06-2011 14:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-06-2011 14:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">27-09-2011 13:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.4.1</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-09-2011 16:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010142</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">28-09-2011 16:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010142</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-09-2011 16:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Deleted: 0010155</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-09-2011 11:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010309</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-09-2011 11:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR5898_resolution_v1.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-09-2011 11:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-09-2011 13:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0010312</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-09-2011 14:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0010313</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-09-2011 14:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-09-2011 14:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR5898_resolution_v2.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-09-2011 15:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010316</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-09-2011 15:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010316</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-09-2011 15:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0010316</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-09-2011 15:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Deleted: CR5898_resolution_v1.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-09-2011 15:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-10-2011 12:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a></td>
<td class="print">Note Added: 0010321</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-11-2011 08:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010411</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-11-2011 08:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010412</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-11-2011 09:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010420</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-11-2011 14:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-12-2011 10:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR5898-proposal_v3.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-12-2011 10:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010461</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-12-2011 10:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-12-2011 10:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-12-2011 10:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Deleted: CR5898-proposal_v3.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-12-2011 10:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR5898-proposal_v3.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-12-2011 15:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0010488</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-12-2011 15:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-12-2011 15:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-12-2011 15:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; Edition 4.4.1</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-12-2011 15:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0010133)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">28-06-2011 16:26   <br />
(edited on: 28-06-2011 16:35)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The question is not strictly related to the equality
operator itself. For consistency reasons, the two examples below shall
behave the same way:<br />
1) direct use<br />
if (v_MyRecord.field2 == 3)...<br />
<br />
2) use via parameterization<br />
function f(in integer pl_int) return boolean {<br />
  return pl_int == 3<br />
}<br />
if(f(v_MyRecord.field2))...<br />
<br />
Therefore the question is, if a pure integer value (parameter) can
accept omit or not. The answer is clearly defined in clause 6.1.0:<br />
"a) integer: a type with distinguished values which are the positive and
negative whole numbers, including zero.<br />
    Values of integer type shall be denoted by one or more digits; the
first digit shall not be zero unless the value is 0; the value zero
shall be represented by a single zero."<br />
There is no omit in the value set of the integer type and it cannot be
assigned to integer. In another words, the above example 2) shall cause
an error when calling function f() with a missing .field2 field.
Therefore example 1) shall do the same.<br />
<br />
Btw., any extension of the simple types with virtual "values" (like
"omit") would cause performance degradation of the tools and increase
the size of the generated code that may be critical in case of several
telecom applications, as we have discussed earlier by email. I have
asked our developers, it really would...<br />
<br />
If clarification is felt to be needed, I propose to clarify this in the
restrictions part of clause 7 (btw. it seems that restriction a) of
clause 7 and restriction a) of clause 7.1 claims almost the same, in 7.1
it explicitly mentions that operands are values, but the two
restrictions could be merged).<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0010142)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-06-2011 12:45   <br />
(edited on: 28-09-2011 16:25)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF discussion on 29-06-2011: Comparision mechanism
for structured value fields could be extended: in the first step the
presence of corresponding fields could be checked; if any field present
in one value is missing in the other value, equality returns false; if
the corresponding present fields have equal values, equality returns
true, otherwise it returns false.<br />
<br />
Also, to solve the problem in the generic case isvalue() shall be
extended to be error-safe, e.g. if a field inside an omitted field is
referenced, it shall not cause an error -&gt; A new CR on this has to be
submitted.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010309)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-09-2011 11:53   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Pls. review CR5898_resolution_v1.doc.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010312)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-09-2011 13:59   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I am sorry, but I think that the resolution adds more
confusion then clarification.<br />
<br />
Either we handle OMIT like a value, or not.<br />
<br />
If we handle OMIT like a value, OMIT values (e.g., optional record
fields set to OMIT), can be freely used in relational operators. Even
OMIT == OMIT will evaluate to true.<br />
<br />
If we do not handle OMIT like a value, OMIT values can not be used in
relational operators at all. E.g.,<br />
<br />
type record MyRecord_Type {<br />
   integer field1,<br />
   integer field2 optional<br />
};<br />
<br />
template (value) MyRecord_Type cs_MyRecord := {<br />
   field1 := 1,<br />
   field2 := omit<br />
};<br />
<br />
if (v_MyRecord.field2 == 3) { ... } // will result in a runtime
error<br />
if (v_MyRecord.field2 == omit) { ... } // will also result in a runtime
error<br />
<br />
The current solution sometimes handles OMIT like a value and sometimes
not.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010313)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-09-2011 14:00   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Reassigned to GyÃ¶rgy for discussion.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0010316)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-09-2011 15:01   <br />
(edited on: 30-09-2011 15:02)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Thinking it further, the case of comparing two omitted
fields shall not be allowed. In this case the user shall check if at
least one of the optional fields is present (writing a function for this
is not really an issue. Otherwise the user will - and existing code does
-, consider that the content of the optional field is a value and it may
cause an error at other places anyway.<br />
For example<br />
type set S1 { integer a1 optional};<br />
type set S2 { integer b1 optional, integer b2 optional };<br />
type set S3 { integer c1 };<br />
...<br />
var S1 vl_S1 := { a1 := omit }<br />
var S2 vl_S2 := { b1 := omit, b2 := 5 }<br />
var S3 vl_S3 := { c1 := 3 }<br />
...<br />
if(S1.a1==S2.b1){P.send(S1.a1)}//send would cause an error<br />
if(S1.a1==S2.b2){P.send(S1.a1)}//this will work in this case, because
S2.b2 is present<br />
if(S1.a1==S3.c1){P.send(S1.a1)}//this always will work<br />
<br />
CR5898_resolution_v2.doc contains a proposed resolution according to
this.<br />
<br />
It needs STF discussion and decision.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010321)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a>   </td>
</tr>
<tr class="odd">
<td class="print">01-10-2011 12:11   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I don't understand why comparing two omitted fields
shall not be allowed and I don't agree to this with a similar argument
as by Jens: When I can compare an omitted field with another field there
shall be no restriction. From telecommunication's point of view that
even may make sense.<br />
E.g. I receive message twice and want to check whether some field is the
same in both message: "if (m1.field == m2.field)"<br />
When this is allowed for optional fields in general and even when field
is omitted in one of the messages people will not have in mind to
separately handle the case of the field being omitted in both messages.
=&gt; At some (later) point in time we will get a runtime error.<br />
So - it is not the question whether this can easily avoided by e.g. some
function or not.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010411)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-11-2011 08:31   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I don't think that mis-using the == operator to test
for value-ness before sending (instead of the proper isvalue function)
should be an argument to keep this restriction.<br />
<br />
Also, if equality is not allowed on omit, then all your if-send
statements would cause a runtime-error (at the == check) anyway. So, if
existing code would really assume that this restriction existed before,
then this would not be the way to exploit this.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010412)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-11-2011 08:37   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The CR resolution is unacceptable. Either comparison
with omit is totally disallowed or totally allowed, but singling out the
special case where almost EVERYONE intuitively would assume that it
would be true to be an error does neither make sense nor does it help
the user in any way avoid problems at runtime.<br />
<br />
If comparison with omit would be disallowed totally, I would go so far
as forbidding it even at static level, i.e. comparison with optional
fields should then be disallowed, forcing the user to use valueof()
around them to make it explicit that they are aware that the field might
be omit and forcing them to check for presentness beforehand.<br />
<br />
Still, I don't think this is the way to go.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010420)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-11-2011 09:48   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">From usability point of view you are correct. But in
this case the wording shall be very cautious to emphasis that the
operands of == and != are not only values but also the fields attribute
that the field is absent.<br />
The text says today:<br />
""Operands of equality (==) and non-equality (!=) shall be values of the
same root type and the values being compared ..."<br />
this wording shall completely be re-phrased.<br />
<br />
A note shall also be added saying, that if two fields are equal, this
does not mean that they are present (i.e may not be values).<br />
<br />
What about missing fields of different types?<br />
type record MyRec { integer f1 optional, charstring f2 optional }<br />
const MyRec c_myRec := { omit, omit }<br />
...<br />
if (c_myRec.f1 == c_myRec.f2 ) //???; true, false, error?<br />
I think it shall be error (in whith case it can be checked compile
time)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010461)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">01-12-2011 10:20   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">implemented proposal to also allow comparison between
field references and between field references and values.<br />
<br />
Still forbidden: omit == x, x == omit, omit == omit.<br />
For this ispresent() shall be used.<br />
<br />
Also amended the general restrictions part of Expressions section to be
consistent with the Semantic Descriptions part.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010488)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">01-12-2011 15:35   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Implemented as proposed.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
