  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0005835</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Technical</td>
<td class="print">public</td>
<td class="print">30-11-2010 17:12</td>
<td class="print">01-12-2010 16:46</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.3.1 (published 2011-06)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.3.1 (published 2011-06)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">B.1.5.2, A.1.6.1.3</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Testing Technologies - Jacob Wieland</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0005835: BNF rule for PatternElement is
ambiguous, Example is wrong</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">In the rule for PatternElement in the BNF,
the last branch (PatternChar) creates an ambiguity as that can be any
char and thus, every Pattern can be derived to a sequence of
PatternChar, even those that should be derived by using the other
alternatives in PatternElement.<br />
<br />
Especially for those PatternElement constructs which contain more than
one character, this leads to unresolvable problems (if the ambiguity is
not removed somehow).<br />
<br />
I guess the intention was that PatternChar should be any character which
is not one of the characters in the "first set" of the other
alternatives in PatternElement. Thus, the following characters need to
be excluded "\", "?", "*", "|", "+", "[", "{", """ and "#"<br />
<br />
Consequently, I think that the example in B.1.5.2<br />
<br />
template charstring RegExp4 := pattern "{Reg";<br />
<br />
should be changed to<br />
<br />
template charstring RegExp4 := pattern "\{Reg";<br />
<br />
Finally, it should be forbidden to use reference expressions in
referenced variables/parameters/module parameters (i.e. all entities
which are unknown at compile time). I.e. if a referenced charstring
value contains a reference-like expression, it is treated as if it was
just the sequence of the characters of the reference. Meaning: if I have
a variable v which contains "{a}", then referencing it via pattern "{v}"
will match only the charstring "{a}" and not any referenced 'a'. If this
is the intention of the standard anyway, then it needs to be
clarified.<br />
<br />
Consequently, the stuff in EXAMPLE 3 (which is wrong in any case as it
is missing at least one 'pattern') should be forbidden. But, maybe there
are only some typos in Ref6, where Ref1 should be Ref4 and Ref2 should
be Ref5.<br />
<br />
I guess what the example was really supposed to be was this:<br />
<br />
template charstring Ref0:= "My String";<br />
template charstring Ref1:= "{Re";<br />
template charstring Ref2:= "f0}";<br />
template charstring Ref3:= pattern "{Ref1}{Ref2}";<br />
       //this matches "{Ref0}"<br />
       //i.e. there is no further dereferencing<br />
       //as Ref1 and Ref2 do not contain a reference<br />
<br />
template charstring Ref4:= pattern "{Ref0}";<br />
template charstring Ref5:= "";<br />
template charstring Ref6:= pattern "{Ref4}{Ref5}";<br />
       //this matches "My String" â€“ here Ref0 is dereferenced, because
Ref4 contains<br />
       //the reference expression {Ref0} with the reference Ref0<br />
template charstring RegExp7 := pattern "{Reg" &amp; "Exp1}";<br />
       //note the difference to Ref6: in this case the fragments of
the<br />
       //pattern are joined before any evaluation, i.e. this template
will match the string "ab"</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">child of</span> </td>
<td class="print">0005805</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></span> </td>
<td class="print">BNF rule for PatternElement is ambiguous, Example is
wrong </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-11-2010 17:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-11-2010 17:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-11-2010 17:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-11-2010 17:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; B.1.5.2, A.1.6.1.3</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-11-2010 17:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; Testing Technologies - Jacob Wieland</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-11-2010 17:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Issue generated from: 0005805</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-11-2010 17:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Relationship added</td>
<td class="print">child of 0005805</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-12-2010 16:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0009904</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-12-2010 16:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-12-2010 16:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-12-2010 16:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; Edition 4.3.1 (not yet published)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-12-2010 16:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.3.1 (not yet published)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-12-2010 16:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009904)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">01-12-2010 16:44   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Example corrected as proposed. In addition, RegExp7
removed as this is part of Example 2 and not of Example 3.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
