  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0003627</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">New Feature</td>
<td class="print">public</td>
<td class="print">24-06-2008 12:55</td>
<td class="print">12-12-2008 11:43</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Pavel Yakovenko</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Thomas DeiÃŸ</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">always</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">won't fix</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v3.3.2 (published 2008-04)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.1.1 (published 2009-06)</td>
<td class="print-category">Fixed in Version</td>
<td class="print"></td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">6.2.9, F.3</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Pavel Yakovenko, ISPRAS</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0003627: Bring "inout all" back with
relaxed semantics</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">Propose:<br />
<br />
1) Clear "deprecated" notice from port "inout all" statement (clause
F.3).<br />
2) Declare that "inout all" covers any arbitrary type (clause
6.2.9).<br />
<br />
Problem description:<br />
<br />
One of the approaches to map classes (C++, UML, etc) to TTCN-3 is to put
every class into separate module and represent every class instance as a
separate parallel component. Public class methods are mapped to
signatures. Accesses to public class data members are translated into
get/set signatures. At the same time we may want to hide communication
operations into proxy functions that are not tied to a component (i.e.
do not have runs on clause). Proxy function must have two additional
parameters: a reference to accessed component instance and a reference
to a port which is used to send procedure call and receive reply.<br />
<br />
The problem is in the set of ports that calling component must have to
access other components. If class ClassA invokes methods from ClassB and
ClassC then corresponding component for ClassA must declare two ports
â€“ one for ClassB and one for ClassC. The more different classes are
used the more different ports component must declare.<br />
<br />
This issue could be solved if â€œinout allâ€? in the port type
declaration would cover all possible types defined in the whole test
suite (not in the current module). This would eliminate the need to have
lots of ports to access class methods and would also remove the
necessity to pass port instance to a proxy function.<br />
<br />
Example:<br />
Suppose we have ClassA, ClassB and ClassC classes and ClassA inokes
methods from opther two classes.<br />
<br />
class ClassB<br />
{<br />
  public: int f() {return 1;}<br />
}<br />
<br />
class ClassC<br />
{<br />
  public: int g() {return 2;}<br />
}<br />
<br />
class ClassA<br />
{<br />
  ClassB m_B;<br />
  ClassC m_C;<br />
<br />
  void h()<br />
  {<br />
     int v = m_B.f() + m_C.g();<br />
  }<br />
}<br />
<br />
Currently we need to put two ports into component declaration for ClassA
and pass port instance to every proxy function (look at the Part1 in the
attached InOutAll.ttcn)<br />
<br />
Having â€œinout allâ€? cover any arbitrary type makes TTCN-3 code more
structured. We may put port declaration to access class operations into
a â€œrootâ€? component type and declare every component as an extension
of the â€œrootâ€? one. Proxy functions are declared as running on
â€œrootâ€? component hence we may remove port instance from the list of
formal parameters (look at the Part2 in the attached
InOutAll.ttcn).<br />
<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print">1) Making "inout all" to cover arbitrary
types doesn't influence type checking in any way. All invoked signatures
and templates still must be visible in the module.<br />
<br />
2) Keeping current semantics of "inout all" doesn't help.<br />
Yes, we may declare PT port type with "inout all" in every module and
use one and the same port to invoke operations on every component. But
still we must pass port reference to proxy function since component
ClassA.CT and ClassB.CT are not compatible and we may not declare
f_proxy with "runs on".<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/generic.gif"
alt="?" /> InOutAll.ttcn (3,871) <span class="italic">24-06-2008
12:55</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=1528&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR_3627_TD_18_July_2008.doc (61,952) <span
class="italic">18-07-2008 14:41</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=1573&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif"
alt="zip" /> CR_3627_Bring_inout_all_back.zip (29,018) <span
class="italic">13-08-2008 05:36</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=1589&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-06-2008 12:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=96">Pavel
Yakovenko</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-06-2008 12:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=96">Pavel
Yakovenko</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-06-2008 12:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=96">Pavel
Yakovenko</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-06-2008 12:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=96">Pavel
Yakovenko</a></td>
<td class="print">File Added: InOutAll.ttcn</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-06-2008 12:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=96">Pavel
Yakovenko</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; 6.2.9, F.3</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-06-2008 12:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=96">Pavel
Yakovenko</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; Pavel Yakovenko, ISPRAS</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-07-2008 09:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Note Added: 0006320</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-07-2008 09:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Assigned To</td>
<td class="print">Ina Schieferdecker =&gt; Thomas DeiÃŸ</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-07-2008 09:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-07-2008 11:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=96">Pavel
Yakovenko</a></td>
<td class="print">Note Added: 0006336</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-07-2008 14:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Note Added: 0006339</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-07-2008 14:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">File Added: CR_3627_TD_18_July_2008.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-07-2008 14:42</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Note Added: 0006340</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-07-2008 14:42</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">13-08-2008 05:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Note Added: 0006503</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">13-08-2008 05:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">File Added: CR_3627_Bring_inout_all_back.zip</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">13-08-2008 05:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Note Added: 0006504</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">13-08-2008 05:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">13-08-2008 05:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; won't fix</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-12-2008 11:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.1.1 (not yet published)</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0006320)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-07-2008 09:20   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The proposal refers to the use of proxy functions and
it is stated that these are not tied to component and therefore do not
have a runs on clause. No reason is given in the proposal why the runs
on clause should be avoided.<br />
<br />
Assuming that the proxy functions have a runs on clause, the problem
could be solved quite simply: Assume there is a class A, providing a set
of methods. A port type Port_A can be defined to call these methods and
a corresponding component CT_A type with such a port pt_A can be defined
too. The proxy function would then have clause 'runs on CT_A' allowing
to access the port pt_A without having to pass it as parameter. The
actual test component types used in behaviour functions would then be
defined as extensions of CT_A and of other component types CT_B, CT_C,
etc if methods of other classes would have to be invoked, too. Using
this approach there would be no need to reintroduce 'inout all'.<br />
<br />
For further processing of the CR an explanation we need an explanation
why the runs on clause has to be avoided.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0006336)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=96">Pavel
Yakovenko</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-07-2008 11:33   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Yes, that's what I propose but "runs on ROOT" instead
of "runs on CT_A" (see example 2 in the InOutAll.ttcn).<br />
<br />
If we add "runs on CT_A" to a proxy function of class A then we must add
CT_A component to the extension list of every component that calls any
operation from class A. This is very inconvenient from my point of view
especially when writing code manually. Imagine extensions lists with
tens of elements in it.<br />
<br />
And it doesn't differ much from adding pt_A port to the body of the
calling component. In fact what extension mechanism does for us in this
case is that it hides from the user addition of pt_A to the body of
calling component. But actually it does more job - it adds all the
component elements from parent component to the extended one. As a
result extended component contains lots of members that are never used
(except communication port) but we need to pay attention to possible
name clashes. That is we need to make ports, port types, and other
component elements (like "this" varaible storing class members) globally
unique. For example we must declare this_A in class A instead of simply
"this" and this_B for class B, because if class C calls both A and B it
must extend component CT_C with CT_A and CT_B and having two "this"
members (from A and B) will result in compile error.<br />
<br />
Now imagine if we have ROOT component with "inout all" port. It has only
one component member (instance of that dispatching port), all components
extend ROOT component and may use that port to communicate between each
other as long as "inout all" covers transmited signature. We do not need
to put every communicated component into the extension list, we do not
need to care about name clashes since they may not occur.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0006339)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-07-2008 14:40   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Ok, argument understood.<br />
<br />
One might have to use a more sophisticated mapping, actually one
separating between the interface of a class from the implementation of a
class, see the attached file CR_3627_TD_18_July_2008.doc. This should
help to limit the amount of elements in the component types. And this
should also help to avoid the name clashes among the 'this' component
variables. Still, the extends clauses would be longer, agreed.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0006340)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-07-2008 14:42   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">explanation from Pavel received. Discussion within STF
can continue.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0006503)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a>   </td>
</tr>
<tr class="odd">
<td class="print">13-08-2008 05:33   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">email from Pavel, August 12th, 2008:<br />
...<br />
Your suggestion to split interface and realization works well. I think
increasing number of ports is an acceptable tradeoff over changing
language semantics in this case. So let's close the case.<br />
...</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0006504)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a>   </td>
</tr>
<tr class="odd">
<td class="print">13-08-2008 05:38   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Alternative mapping of classes to component types
solves the original problem without reintroducing 'inout all'. Therefore
the CR can be closed as won't fix. The attached zip file contains a more
detailed explanation of the alternative mapping and some example.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
