# Work Sessions November 18th to 22nd, 2024

## Agenda

* Review maintenance CRs and migrate them to GitLab.
* Review questionnaires and discuss potential work items for the new major
  release.

## Discussions

### Structure of core language and extension documents

**Core Language**

We discussed reducing the size of the TTCN-3 core language by:

* moving predefined functions, useful types and such into some kind of standard
  library document.--- NO! WHY? What would be the advantage of it? 
* Removing or deprecating features that could be substituted by other features
  (e.g. arrays). --- If it will be only a shorthand of record of length (fixed value) then ok
* Moving features that are not used by the majority of users, but are
  complementing the language into extension documents (e.g. procedure based
  communication).
* Introducing new language concepts, that simplify the language (e.g. advanced
  parameterization, closures, ...). NO, more details (adv/disadv) needed


**Extensions**

Further we discussed how to reorganize language extensions into smaller
self-contained features and whether to aggregate them into a single language
extension document.

**Backward Compatibility**

The question how to handle backward compatibility was not discussed in detail.
A combination of various strategies is probable:
* Redefine features as short-hand notation.
* Make features optional by moving them to extensions.
* Deprecate features.
* Break compatibility and rely on existing language tags.
* Provide tool for automatic conversion.

# Coding style

We should extend the ruleset for coding style of TTCN-3 examples (and conformance tests).  -- Isn't it too large work?

# Templates

Refining templates pose a big challenge for backward compatibility, but also
many opportunities for simplification. We discussed several ideas without going
too much into detail during this session:

## Template Evaluation

Various evaluation strategies for templates are required. However, the current
approach of lazy, fuzzy, var, const or parameterized templates is neither
intuitive nor well understood. Examples:

```ttcn3
function f(inout integer i) return integer {
    var integer j := i;
    i++;
    return j;
}

control {
    var integer i := 0;
    var integer a := f(i);
    var integer b := f(i);

    log(a, b, i); // 0, 1, 2

    template Point t(integer p) := {
        x := a,       // eager evaluation (during definition)
        y := f(i),    // eager evaluation (during definition)
        z := p + f(i) // deferred evaluation (during invocation)
    };

    log(t(b), i); // {x := 0, y := 2, z := 4}, 4
}
```

Different evaluation strategies could be modeled with help of new language
features. For example lazy evaluation of previous template could be achieved by
using closures:

```ttcn3
template Point t := function (integer p) return Point {
    x := a,
    y := f(i),
    z := p + f(i),
};
```

Details need to be worked out in future discussions. -- if possible :)


## Special Template Symbols

`all from`, `permutation`, `complement`, `subset`, `superset`, ..., do not need
to be part of the core language. They could be implemented as library
functions, as language extensions or even by user-defined dynamic matching. -- Only to be moved to extension, but NOT functions, user-defined (???) dynamic (???) matchning. Semantics and syntax must be kept.


## Inline Templates

Inline templates consist of an optional type annotation part and a template literal.
A dedicated notion for inline templates is not necessary, as they type
annotations could be promoted to a type-conversion operator and template
literals are already part of the language.

//since now there is no type-conversion operator this is not true -- AG
it is NOT type-conversion, but some kind of casting; inline templates are needed, used frequently


## Modified Templates

Modified template and modified inline template syntax might be unified and simplified.  - HOW?


## List Templates

See [List Types](#list-types).


## Differentiation of Values and template values

Differencing between value and template value complicates the language and its specification.

One simplification is to extend the type system to handle templates as proper type.
Example:

```ttcn3
var template integer i := 1;
```

`i` is a variable of type `template integer`. This type could be a variant-type of `integer` and matching symbols.

Another simplification is to remove the differentiation between values and
templates all together. For example: `var integer i := 1` would a shorthand for
`var template(value) integer i := 1`.  

I guess it would be useful in the opposite direction value:= (value)template  - discussion needed, for us the existing definition is ok
This could also improve on compiler-pleasing 
// it is not a point how complicated the compiler is; the language shall be easy-to-use
through `valueof` and on
operations such as `omit`, `present`, ...


# Type System

We discussed several aspects of the type system to identify opportunities for
simplification:

* Substitute `anytype` with `any`. Type switch (---?????) from OOP extension would be a
  good addition. - anytype will be in an extension; not to make backward incompatible solutions just for fun; would clash with any timer, any component, etc.
* Arrays
  * remove custom indexing. -- ok
  * should become short-hand notation.  -- ok
* `set` and `set of` should be reviewed (compatibility with records,
  replacement possible?) -- record of and set of are different ROI := {1,2,3}  SOI1:={1,2,3} SOI2 := {1,3,2} SOI1==SOI2 but ROI != SOI2
* Should automatic typing be extended to unions and generics or should it
  rather be moved to an extension? NO
* Map type:
  * Could be harmonized with `HashMap` from OOP extension.
  * One could find overlap of `unmap` operations confusing.  -- Unmap can be used for ports and maps; new keyword would have been better; but now will cause backward incompability
  * Some corner cases need clarification (e.g. `h[*] := {}`). ---????
* Sections describing type system could be simplified by introducing better
  type terminolgy (subtyping, type-alias, equality, assignment, component
  variables, ...). -- If only definition harmonisation, then ok; if meaning changes, not


## List Types

Semantics of list types need harmonization and simplification.

**`lengthof`**

```ttcn3
lengthof('12*'H)  // 3
//NO: shall cause runtime error - AG
lengthof({1,2,?}) // 3
lengthof({1,2,*}) // causes runtime error

// Templates cannot be iterated or modified safely
var template record of integer c := {1,2,*};
c[lengthof(c)] := 5; // lengthof causes error
```


**uninitialized elements**

```ttcn3
control {
    var record of integer a := {1,2,_}, b := {1,2,_,_};
    log(equal(a, b)); // true
    log(a==b);        // implementation dependent (false)
}

function equal(record of integer a, record of integer b) return boolean {
    if (lengthof(a) != lengthof(b)) {
        return false;
    }
    for i := 0 to lengthof(a) {
        if (a[i] != b[i]) {
            return false;
        }
    }
    return true
}
``` Shall be defined clearly, if the last elements are undefined it counts in the size/length or not

```ttcn3
var record of integer a := {1,9};
a := {_,2,_} // how many elements will `a` have; 2 or 3?
             // Is d equal to {1,2} or to {1,2,_}?
```

```ttcn3
var record of integer a := {1,2};
a[4] := 5;
log(a); // {1,2,_,_,5}

var charstring b := '12';
b[4] := 5; // causes runtime error

var record of integer c := {1,2,_}; // lengthof(c) == 3
c := c & {3,4};                     // lengthof(c) == ?

```


## Language Features

Procedure based communication might be moved to an extension document.

Some port control operations might be moved to an extension document or even be
removed. Further discussion is needed.

`checkstate` is used to wait for a port to be ready. Further discussion is
needed, whether `checkstate` could be improved or even removed.

The `receive` part of `check` operation could be removed probably. //check(template) is a shorthand of check(receive(template)) ?? shall be checked if parsr can handle it in a simple way

The `trigger` could be substituted by `check`. // no, the trigger takes the value out of the queqe, while check do not

Decoded field references, `decmatch`, `@decode` could be simplified. It needs to be checked whether `=>` can be removed. //=> is used in OOP for a different purpose. One of them shall be be modified (probably in OOP)

We discussed whether `goto` could be removed or substituted by named loops.

Component's `call` operation might be moved into an extension document.

External actions (`action`) do not need to be part of the core language. //Shall be, this is how something can be written to screen during execution

Modifiers (pe.g. `@deterministic`, `@nocase`, `@nodefault`, ...) or often overlooked. Further discussion is needed whether there's opportunity to generalize them.  //@deterministis - fuzzy/lazy; the other two are useful

Attributes might be simplified:
  * remove `display`
  * move reading and writing attributes to extension
  * multiple encodings is complicated and could be removed


## Module organization

`import` will be simplified if possible. // supported only import all 
This would make `group` superfluous. However groups are used to structure  //group of instructions are useful
modules and groups are also used by some language mappings.  
Simplifying import would further require to discuss importing of imports.

Visibility features (`friend`, `private`, `protected`) are used by testers,  //in many other languages these 3 categories exist
seldom. It's used primarily by framework developers. Possible improvements need
further discussion.


## TCI/TRI/xTRI

Might be merged into a single document. Language mappings for C and Java will
become non-normative, the other language mappings will be removed.

The future for mappings of XML to TLI needs further discussion.

## Extensions

Language features that were neither removed nor moved into the core, will
probably be merged into a common extensions document.

* Performance and real-time extension:
  * `wait` --> core  //discussion needed
  * `timestamp` --> core  //discussion needed
  * remaining features --> extension
* Configuration and Deployment features mostly stay as they are.
* Advanced parameterisation:
  * Type parameterisation: Could use some refinement (automatic type interence,
    parametric type inference, generic types in ports, ...).
  * Value parameterisation of types: Could be removed.
* Behaviour types:
  * Behaviour types (and closures) will probably move to core to help
    simplification.  // Further rationale is needed, just for fun is not enough
  * Deferred behaviour will be removed.  
* Continuous signals will probably go to historic state
* Advanced matching:
  * Dynamic matching will probably move to core.  //needs further discussion
  * Other features need further discussion.
* Object oriented features:
  * Exception-feature will probably move to core  //But how?
  * Some type operations (`=>`, `select class`) probably, too  //select class without class?; => is used for another purpose in core
  * If and in what form user defined object will be merged into core is not
    clear yet.  // What is user defined object?
