# TTF40 Working Session at Ericsson, Budapest

## Range-based loop alignment

We discussed proposed changes for issue #23 and and #30 and came to a
resolution that fixes most misalignments with only minor changes to the current
behaviour:

- Automatic type inference will be included, but no new BNF productions will be
  added.
- Templates will not be included in for-range-loop declarations, to avoid open
  edge cases with `lengthof`.
- The perception for assignment of an uninitialized iterator variable will be
  added.
- The examples will be reorganized to reflect above changes.


## Support for XML

Since there have not been any objections to the proposal, we will proceed as
proposed.


## Style Guide for Examples

We agreed that a common style guide for examples (and potentially conformance
tests) would be beneficial. In issue #47 we will collect various alternatives
and compile a proposal.


## Lazy/fuzzy Evaluation

We discussed the current state of template evaluation and its implementation in
different tools. We recognized the validity of the different use-cases for
all different types of template and aggreed that the current specification is
not clear enough and needs to be revised.

One cause for confusion is the meaning of "parameterization". It is not clear
if this means parameterization in the sense of formal and actual parameters or
if it is used a general term for any kind of referring to a source of values
(constants, functions, ...).  
Issue #49 will be used to identify and clarify the different usage of the term
parameterization.

Further discussion and proposals for template evaluation and deprecation of
`@lazy`/`@fuzzy` will be made in issue #48.


## Type Terminology

We agreed that the current terms do not serve us well and should be revised.
Harmonization of charstring should be taking into account and its consequences
need to be studied.

Issue #50 will be used to track the progress on this topic.


## Structured Types

The discussion the following structured types will be tracked by issue #51.

### `set` and `set of`

We discussed that `set` and `set of` are used in practice, but their
differences to `record` and `record of` are not part of the language
specification.

### `anytype` and `any`

We discussed use-cases and limitations of `anytype` and `any`.

`anytype` is widely used various language mapping but has the limitation to be
contrained to a single module. `any` is more flexible, but does not allow
explicit selection of types and it's use is limited to external functions only.

We agreed to merge `any` and `anytype`. The new open type will be called
`anytype` since it is older and more established.

We new anytype will contain the types of all modules. Rules for resolving name
clashes have to be defined. Probably the same rules as for resolving name
clashes in module imports:

```ttcn3
module A { type integer T; type charstring S }
module B { type boolean T }
module C {
    import from A all;
    import from B all;

    type anytype.S s;   // OK, since S is unique
    type anytype.T t;   // ERROR: name clash between A.T and B.T
    type anytype.A.T t; // OK
}
```

The new anytype shall allow implicit selection of types, like `any` does:

```ttcn3
var anytype a;
a := 1;
a := "hello";

var charstring s := a; // OK, since `charstring` is selected
```

The new anytype shall also allow subtyping like `any` would have done:

```ttcn3
type anytype BoolOrString (boolean, charstring);

var BoolOrString b;
b := true;     // OK
b := "hello";  // OK
b := 1;        // ERROR: integer is not part of the subtype
```

This new behaviour models what is known as "sum types", "variant types",
"tagged unions", ... and helps to specifiy polymorphic functions such as `substr`:

```ttcn3
type anytype listtype (hexstring, octetstring, bitstring, charstring);

external function substr(inout listtype s, integer start, integer length) return listtype;

// NOTE: Generic types like `record of T` have to be figured out yet.
```


### Arrays

Custom indexing for arrays will be removed from the language specification. An
array will be a shorthand for a record with fixed length.

It was discussed further whether to restrict the usage of arrays to
declarations and formal parameters only and to forbid their use in
field-definitions:

```
type record R {
    integer a[5]
}
```

This proposal was rejected, since it people are used to it and the benefit of
this restriction is not convincing.

### Map-types

We discussed the current specification of map-types and whether its custom
syntax and reuse of the keywords `map` and `unmap` is the right decision. One
alternative would be specifying list types as mere "standard library
implementation" without special syntax (like it was done with containers in
C++).

We could not see the benefits of changing the current specification and decided
to keep it as it is, but at least review the specification of `unmap` to delete
elements.

## Automatic types

We discussed whether automatic type inference should stay part of the core
language specification or be moved to a "convenience extension package".

Concern was raised that automatic typing might lead to lower code quality and that
such feature would create unnecessary implementation effort for tool vendors.

Speaking in favor of automatic typing, it was argued that implementation effort
is only minimal since type inference is already implemented in every tool
anyway. It was also argued that automatic typing can also lead to
higher code quality by improving readablity and preventing potential errors
rooted in type compatibility during assignment:

```ttcn3
type record PolarCoord {
    float r;
    float phi;
}

type record CartesianCoord {
    float x;
    float y;
}

type port P {
    inout PolarCoord;
}

function getCoord() return CartesianCoord {
    return {x := 1.0, y := 2.0};
}

// ...

var PolarCoord p := getCoord(); // the CartesianCoord is automatically
                                // converted to PolarCoord.
                                // A tool cannot warn about such errors, since
                                // it does not know the testers inention.
p.send(p);
```

We postponed the decision for now, since it is not a critical issue.

## Type Semantics

During discussion if its possible to import the same module twice (no, it's
not), it became apparent that we need to introduce new concepts to the language
type system.

The definition of __type synonym__, __type alias__, __subtype__ need to be reviewed.

This could include __type compatibility__, __type equivalence__ and __strong typing__.

Currently there are two uses for __strong typing__:

- in `inout` parameters to ensure the underlying type of a call by reference
  value is not changed.
- in port communication to ensure that the encoding of a value is as expected.

Issue $52 will be used to track the progress on this topic.

## Expressions

We discussed that operators such as `+`, `<@`, ... are unproblematic and do not
need much review.

It should be reviewed which function-like operators such as `ischoosen` could
be demoted from operator to simple predefined-function.

Some cases could be difficult, because they look like normal functions, but are
not. For example the parameter of `ischoosen` is not evaluated but rather used
as a symbol to be checked for selection:

```ttcn3
var anytype a := { integer := 1 };
log(ischoosen(a.charstring)); // Output: false
log(someFunction(a.charstring)); // ERROR: charstring is not selected.
```

Further work on this topic will be continued in issue #53.

## Definition of Templates

Templates are __the__ central concept of TTCN-3. The evolution of the language,
however, has led to a situation where the standard has become difficult to
understand. For example, when talking about "values" sometimes the term refers
to a concrete value without matching symbols, sometimes to a concrete value or
the value of a template. When talking about "templates" sometimes the term
refers to a value of template type, sometimes just to the template-type.

For the next major release we agreed to refine the terminology and how
templates are specified.

Issue #54 will be used to track the progress on this topic.


## List type semantics

Index-access, length, concatenation, value list assignment, assignment-lists,
handling of uninitialized elements and templates needs harmonization.


Issue #22 will track that progress.


## Interleave

Interleave is required for certain used cases. Waiting for some messages to
arrive during error-handling, to name one example. However in its current state
it's too easy to create extremly complex and opaque behaviour.

Issue #55 will be used to discuss possible improvements.


## `map` and `unmap`

We want to keep `map param` and `unmap param` as they are. However we agreed to
drop support for the legacy operations `triMap` and `triUnmap`, since they are
just a special case of the more general operations `triMapParam` and
`triUnmapParam`.

Issue #56 will be used to track the progress on this topic.

## `with` statements and attributes

Similar to the import statment, the `with` statement should be simplified.

We discussed that the `with` statement is useed for attaching attributes to
module-definitions of modules or groups and to types and their fields directly.

"Allrefs" seem not to be used in practice, as is the `display` attribute and
multi-encodings.

Issue #57 will provide a proposal for simplification without losing
expressibility.


# Groups

Groups are useful for documentation, structuring modules and for attaching
common attributes.

Group won't become a scope unit, because it would break compatibility and not
bring much value.


## Structure of the major release

In issue #58 we will propose an initial draft for the structure of the next
major release of TTCN-3.

## Migration Guide

Issue #59 provides a possible structure for the migration guide.

## Named-loops

Issue #32 has been revoked and closed. Named loops don't bring much benefit,
since the standard already provided a way to break out of nested loops using
`goto`, which is more intuitive and flexible.


## Macros

After extensive discussion we came to the conclusion that preprocessing macros
should stay part of the core language specification.

It should be reviewd, though, since the some macros (`__SCOPE__` and
`__MODULE__`) cannot be used as macro but rather as a predefined constant.

## Goto

We had mixed feelings about `goto`. On the one hand its use is discouraged in
many environments, on the other hand, it can a be a powerful tool (given it's
properly specified and used).

Goto could be a candidate for previously mentioned convenience extension.
Further discussion is needed.


## Convenience extension

Many language features strictly speaking are not necessary, but provide the
convenience of writing less code, providing modern programming patterns, ...

An extension package could help us providing the best of both worlds: A core
language specification containing only the most essential features and an
extension package providing all the convenience features.

At the moment we cannot say if enough features can be moved to an extension,
we'll see when we get there.

## Other issues

We discussed many smaller issues covering clarifications or language features
that need to be discussed after the major part of the core language has been
revised. Some of those issues have been closed and may be reopened when needed.

