  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - TTCN-3 Change Requests
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0008113</td>
<td class="print">TTCN-3 Change Requests</td>
<td class="print">New Feature</td>
<td class="print">public</td>
<td class="print">17-08-2022 07:14</td>
<td class="print">16-12-2024 12:49</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Matthias Simon</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Jens Grabowski</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">resolved</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">New Extension</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">For STF discussion</td>
<td colspan="4" class="print"></td>
<td></td>
</tr>
<tr class="even print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Nokia -- Matthias Simon</td>
<td></td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0008113: Type traits and user defined
methods</td>
</tr>
<tr class="odd print">
<td class="print-category">Description</td>
<td colspan="5" class="print">Type traits allow to compose behavior in a
lightweight, but powerful way.<br />
<br />
## Methods<br />
<br />
This extensions allows to specify methods for any user defined types.
The<br />
receiver type is specified using the "for" keyword. Inside the behavior
the<br />
receiver value is accessible via "this" symbol:<br />
<br />
        module Example {<br />
        type integer Timestamp<br />
        function year() for Timestamp return string {<br />
            return int2str(1970+this/SECONDS_PER_YEAR);<br />
        }<br />
<br />
        control {<br />
            const Timestamp t := 1660681400;<br />
            log(t.year()) // logs "2022"<br />
        }<br />
    }<br />
<br />
<br />
## Traits<br />
<br />
A trait is a set of methods and can be defined using the "trait"
keyword:<br />
<br />
    trait Stringer {<br />
        function String() charstring;<br />
    }<br />
<br />
A variable of a trait type can hold any value that implements the
trait:<br />
<br />
    module Example {<br />
<br />
        type record Point2D { integer x, integer y }<br />
        function string() for Point3D return charstring {<br />
            return sprintf("(%d|%d)", this.x, this.y)<br />
        }<br />
<br />
        type record Point3D { integer x, integer y, integer z }<br />
        function string() for Point2D return charstring {<br />
            return sprintf("(%d|%d|%d)", this.x, this.y, this.z)<br />
        }<br />
<br />
        trait Stringer {<br />
            function string() charstring;<br />
        }<br />
<br />
        function logPoints(Stringer s) {<br />
            log(s.string())<br />
        }<br />
<br />
        control {<br />
            var Point2D p1 := {1,2};<br />
            var Point3D p2 := {1,2,3}<br />
<br />
            logPoints(p1); // okay because Point2D implements Stringer
trait<br />
            logPoints(p2); // okay because Point3D also implements
Stringer trait<br />
        }<br />
    }<br />
<br />
<br />
## Embedding<br />
<br />
When the field name is omitted, the field is called an embedded
field:<br />
<br />
    type integer Timestamp;<br />
    external function year() for Timestamp return charstring;<br />
<br />
    type record Date {<br />
        Timestamp, // embedded field<br />
        charstring zone // regular field<br />
    }<br />
<br />
<br />
An embedded field is accessible by its type name:<br />
<br />
    var Data d := { Timestamp := 1660681400, zone := "GMT+2" };<br />
    d.Timestamp := d.Timestamp + 3600;<br />
<br />
<br />
Embedded fields must be unique:<br />
<br />
    type record Date {<br />
        Timestamp,<br />
        Timestamp // not allowed.<br />
    }<br />
<br />
<br />
Methods of an embedded field are promoted and become methods of the
embedding type:<br />
<br />
    var Data d := { Timestamp := 1660681400, zone := "GMT+2" };<br />
    log(d.year()); // year is a promoted method implemented by the
Timestamp type<br />
<br />
<br />
Conflicting promoted methods have to be resolved explicitly:<br />
<br />
    type integer Duration;<br />
    external function year() for Duration return charstring;<br />
<br />
    type record Event {<br />
        Timestamp,<br />
        Duration<br />
    }<br />
<br />
    // Timestamp and Duration both provide a "year"-method. Event type
need<br />
    // to resolve this conflict explicitly:<br />
    function year() for Event return charstring {<br />
        return sprintf("start=%s, duration=%s", this.Timestamp,
this.Duration)<br />
    }<br />
<br />
<br />
## Notes and Open Questions<br />
<br />
* Should we call it "trait" or rather "interface" like in Java, C# and
Go?<br />
* Should we support default implementations for traits (requires
"implements" keyword)?<br />
</td>
</tr>
<tr class="even print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="odd print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="odd print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2022 07:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2022 07:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Description Updated</td>
<td class="print">bug_revision_view_page.php?rev_id=587#r587</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2022 09:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016228</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2022 09:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Matthias Simon</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2022 09:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-11-2022 08:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Added: 0016267</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-11-2022 08:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Edited: 0016267</td>
<td class="print">bug_revision_view_page.php?rev_id=595</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-11-2022 08:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Edited: 0016267</td>
<td class="print">bug_revision_view_page.php?rev_id=596</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-11-2022 08:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Edited: 0016267</td>
<td class="print">bug_revision_view_page.php?rev_id=597</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-11-2022 09:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Edited: 0016267</td>
<td class="print">bug_revision_view_page.php?rev_id=600</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-11-2022 09:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Deleted: 0016267</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-11-2022 09:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Added: 0016287</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-11-2022 10:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Edited: 0016287</td>
<td class="print">bug_revision_view_page.php?bugnote_id=16287#r602</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-11-2022 10:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0016290</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-11-2022 12:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Edited: 0016287</td>
<td class="print">bug_revision_view_page.php?bugnote_id=16287#r603</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-12-2022 08:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016363</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-12-2022 09:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Added: 0016382</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-12-2022 14:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Added: 0016388</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-12-2022 11:45</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016437</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-11-2023 13:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016552</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-11-2023 13:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Matthias Simon =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">26-01-2024 16:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=769">Olivier
Genoud</a></td>
<td class="print">Note Added: 0016607</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-12-2024 12:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016726</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-12-2024 12:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-12-2024 12:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016228)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-08-2022 09:53   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">TTF discussion: CR should be splitted into Methods
&amp; Traits and Embedded Fields. Matthias will make more complete
proposals. Questions to be answered are related to import and type
compatibility.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0016287)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-11-2022 09:52   <br />
(edited on: 10-11-2022 12:50)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">What syntax for defining methods do your prefer?<br />
<br />
# Free floating (like in Go, Perl, ...)<br />
<br />
Example:<br />
    function F() for T runs on C return boolean {<br />
        return this &gt; 5;<br />
    }<br />
<br />
Variations:<br />
    function F() with T ...<br />
    function F() extends T ...<br />
    function F() on T ...<br />
    function F() to T ...<br />
    function F() at T ...<br />
    function F() in T ...<br />
    function F() -&gt; T ...<br />
    function F() =&gt; T ...<br />
    on T function F() ...<br />
    function for T F() ...<br />
<br />
     <br />
# Qualified names (like in C++)<br />
<br />
Example:<br />
    function T::F() runs on C return boolean {<br />
        return this &gt; 5;<br />
    }<br />
<br />
Variations:<br />
    function T.F() ...<br />
    function T:F() ...<br />
<br />
<br />
# Nested declarations (like in Java, Python, ...)<br />
<br />
Example:<br />
    type record T {<br />
        integer x,<br />
        function F() runs on C return boolean { return true },<br />
        integer y<br />
    }<br />
<br />
    type integer I8 (-127..128) {<br />
        function F() runs on C return boolean { return true };<br />
    }<br />
<br />
<br />
# Dedicated method block<br />
<br />
Example:<br />
    type record T {<br />
        integer x,<br />
        integer y<br />
    } with {<br />
        function F() runs on C return boolean { return true };<br />
    }<br />
<br />
    type integer I8 (-127..128) with {<br />
        function F() runs T return boolean { return true };<br />
    }<br />
<br />
Variations:<br />
    type integer I8 extends { ... }<br />
    type integer I8 implements { ... }<br />
    type integer I8 group { ... }<br />
    type integer I8 bind { ... }<br />
    type integer I8 connect { ... }<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016290)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-11-2022 10:46   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">This is a topic for a discussion.<br />
<br />
Free floating syntax resembles what we already have in TTCN-3. It can
extend built-in types as well. However, there are two major problems
that are not easy to resolve (valid for qualified names too):<br />
1. Import of traits, especially when they are defined in a different
module than the type (could be resolved by dedicated import rules)<br />
2. Violation of scoping principles of TTCN-3: So far all lower scopes
are declared inside a definition. Using free floating could lead to
traits with the same name but different functionality being present in
more than one module and we would need a whole set of rule for handling
that.<br />
<br />
For these reasons, I would prefer an encapsulation approach. Out of the
proposed options I like nested declarations more, because the syntax
doesn't use excess symbols.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016363)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">07-12-2022 08:26   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">TTF discussion: Open questions are related to syntax
and semantics. Unclear where to put this CR. May become part of core
language or may become part of the OO extension. Resolution of issues
should be discussed in the scope of language renovation.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016382)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-12-2022 09:01   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Split of embedded fields part: <a
href="http://oldforge.etsi.org/mantis/view.php?id=8154">http://oldforge.etsi.org/mantis/view.php?id=8154</a>
[<a href="http://oldforge.etsi.org/mantis/view.php?id=8154"
target="_blank">^</a>]</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016388)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-12-2022 14:37   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Split of methods part: <a
href="http://oldforge.etsi.org/mantis/view.php?id=8156">http://oldforge.etsi.org/mantis/view.php?id=8156</a>
[<a href="http://oldforge.etsi.org/mantis/view.php?id=8156"
target="_blank">^</a>]</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016437)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-12-2022 11:45   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">TTF discussion: Proposal will not be finalized and
agreed upon until end of year. Proposal will be prepared until end of
the year. To be shifted into the next TTF.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016552)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-11-2023 13:01   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">TTF discussion: To be discussed in the scope of OO
features in new major release.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016607)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=769">Olivier
Genoud</a>   </td>
</tr>
<tr class="odd">
<td class="print">26-01-2024 16:27   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">We assume/expect that this CR will not become part of
the core language but will become part of an extension or be added to an
extension (e.g. OO extension).</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016726)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">16-12-2024 12:49   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Discussion continues in Gitlab</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
