  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0008070</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">New Feature</td>
<td class="print">public</td>
<td class="print">06-12-2021 16:01</td>
<td class="print">03-01-2023 11:50</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Matthias Simon</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Jens Grabowski</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print"></td>
<td class="print-category">Fixed in Version</td>
<td class="print"></td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">19.2 The If-else statement</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Matthias Simon - Nokia</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0008070: If-else statements with
initializers</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">SUMMARY<br />
<br />
Allow initializers in conditional statements, similar to for loops: if
(init-statement; condition). This statement simplifies common code
patterns and helps developers keep scopes tight.<br />
<br />
<br />
MOTIVATION<br />
<br />
In many cases we check a return value and perform conditional operations
on this value. TTCN-3 code looks like this usually:<br />
<br />
    type record of charstring Users<br />
    var Users ret := getUsers()<br />
    if (lengthof(ret) &gt; 0) {<br />
        // do something with "users"<br />
    }<br />
<br />
<br />
There are two issues, because the variable "ret" leaks into surrounding
scope:<br />
<br />
1) You must take extra care not to access variables outside intended
scope:<br />
<br />
    type record of charstring Users<br />
    var Users ret := getUsers()<br />
    if (lengthof(ret) &gt; 0) {<br />
        // do something with "users"<br />
    }<br />
<br />
    var Users users = ret;<br />
    log(users[0]) // ERROR: index out of bounds, or worse.<br />
<br />
<br />
2) You cannot reuse variable "ret" with different types in the same
scope anymore:<br />
<br />
    var Users ret := getUsers()<br />
    if (lengthof(ret) &gt; 0) {<br />
        // ...<br />
    }<br />
<br />
    var float ret := rnd() // ERROR: "ret" already defined.<br />
    if (ret &gt; 0.5) {<br />
        // ...<br />
    }<br />
<br />
<br />
PROPOSAL<br />
<br />
**Semantic Description**<br />
<br />
    if "(" [ VarInstance ";"] BooleanExpression ")" StatementBlock<br />
<br />
The branching of the control flow is decided upon the value of the
Boolean expressions - the condition. A statement<br />
block - and only one - will be executed, if its condition evaluates to
true.<br />
<br />
An optional variable (or constant) can be declared and initialized
before being used in the if statement. The scope of the variable is
limited to the statement block, i.e. it is only visible inside the
statement block.<br />
<br />
<br />
**Examples**<br />
<br />
    // Example 1: improved getUsers<br />
    type record of charstring Users<br />
    if (var Users ret := getUsers(); lengthof(ret) &gt; 0 ) {<br />
        // do something with "users"<br />
    }<br />
<br />
    // Example 2: else-if statements<br />
    if (var charstring ret := hostname(); ret == "localhost") {<br />
        // do something with ret (charstring)<br />
    } else if (var float ret := rnd(); rnd &gt; 0.4) {<br />
        // do something with ret (float)<br />
    } else {<br />
        // "ret" variable is not accessible in this scope<br />
    }<br />
<br />
<br />
OPEN QUESTIONS<br />
<br />
Should we allow initializers in switch-statements as well?<br />
<br />
    switch (var Person p := createPerson(); p.Name)<br />
    {<br />
        case ("Alice") { /* ... */ }<br />
        case ("Bob") { /* ... */ }<br />
        case else { /* ... */ }<br />
    }<br />
<br />
What are the scopes of variable "p".<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR8070.docx (118,037) <span class="italic">11-12-2022
12:26</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=4092&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">06-12-2021 16:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-12-2021 09:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0016146</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-08-2022 14:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core
Language</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2022 11:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Matthias Simon</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2022 11:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2022 11:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016235</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-12-2022 12:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">File Added: CR8070.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-12-2022 12:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Note Added: 0016376</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-12-2022 12:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Assigned To</td>
<td class="print">Matthias Simon =&gt; Axel Rennoch</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-12-2022 12:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-12-2022 12:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Note Added: 0016383</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-12-2022 12:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-12-2022 12:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-12-2022 12:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Assigned To</td>
<td class="print">Axel Rennoch =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">03-01-2023 11:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0016446</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-01-2023 11:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016146)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-12-2021 09:07   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I support this proposal. It could be a number of
declarations, too.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016235)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-08-2022 11:17   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">TTF dicussion: Scope of variables needs to be studied.
If we go for this approach, variables may be added to all constructs
that define their own scope unit.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016376)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias
Simon</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-12-2022 12:26   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">The first version of the resolution uploaded. Please
check and let me know what should be changed or added.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016383)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-12-2022 12:31   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">The solution files looks correct.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0016446)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">03-01-2023 11:50   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Implemented as proposed.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
