  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Ext Pack: Object-oriented features (ES 203 790)
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0007692</td>
<td class="print">Ext Pack: Object-oriented features (ES 203 790)</td>
<td class="print">[All Projects] General</td>
<td class="print">public</td>
<td class="print">09-07-2017 12:18</td>
<td class="print">18-04-2018 09:51</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">KristÃ³f Szabados</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">KristÃ³f Szabados</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print"></td>
<td class="print-category">Fixed in Version</td>
<td class="print"></td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0007692: Exception handling with less code
and less performance overhead</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">There are many kinds of testing scenarios,
where a few issues are to be expected because of the purpose of the
test.<br />
For example when we need to check what happens if the SUT is driven to
very high loads for several hours/days, or when the upper limit of
stable parallel connections/bandwith is tested.<br />
In these cases the SUT not being able to handle a few messages in a
large timeframe can be expected and should not stop the test from
execution.<br />
<br />
In TTCN-3 it is already possible to use exception handling to write the
needed safe code.<br />
The code parts in question need to be executed on parallel components,
and exception handling done via ports.<br />
But this has a high overhead in performance and in code size.<br />
It would be better if the try-catch style mechanism of other languages
would be available.<br />
TTCN-3 already has the raise and catch keywords, that could be
used.<br />
<br />
<br />
Lets see a trivial example to demonstrate the idea: We wish to divide 2
numbers safely.<br />
<br />
Right now one can do this by:<br />
- Defining a signature for the function that will do the safe
division.<br />
    signature MySafeDivision(in integer Par1,in integer Par2)<br />
    return integer<br />
    exception(charstring);<br />
<br />
- defining some templates:<br />
  template MySafeDivision MySafeDivisionTemplate1 := {<br />
    Par1 := ?,<br />
    Par2 := 0<br />
  }<br />
  template MySafeDivision MySafeDivisionTemplate2 := {<br />
    Par1 := ?,<br />
    Par2 := ?<br />
  }<br />
<br />
- the function that will do the safe division:<br />
  function getSafeDivisionCall() runs on MyComponent {<br />
    while (true) {<br />
      alt {<br />
        [] Port0.getCall(MySafeDivisionTemplate1) {<br />
           Port0.raise(MySafeDivision, "Error: division by zero");<br />
        }<br />
        [] Port0.getCall(MySafeDivisionTemplate2) { ... }<br />
        ...<br />
      }<br />
    }<br />
  }<br />
<br />
- At the location where we wish to do the safe division:<br />
  myComponentVar := MyComponent.create;<br />
  myComponentVar.start(getSafeDivisionCall());<br />
  connect(self:Port0, myComponentVar:Port1);<br />
  Port0.call(/*actual template to be used*/);<br />
  alt{<br />
    [] Port0.catch(MySafeDivision, charstring:"Error: division by zero")
{<br />
      // some sort of error handling<br />
    }<br />
    [] Port0.getReplay(...) {<br />
      // handling for the good case<br />
    }<br />
    [] Port0.catch(timeout) {<br />
      // handle running out of time<br />
    }<br />
  }<br />
<br />
---<br />
<br />
The above example solves the task at hand and as a pattern it could be
used for more complex situations.<br />
But it involves lots of code and communication between parallel
components.<br />
<br />
If TTCN-3 would support exception handling the same could be solved like
this:<br />
- the safe division function:<br />
  function MySafeDivision(in integer Par1,in integer Par2) return
integer exception(charstring) {<br />
    if (Par2 == 0) {<br />
      raise(charstring:"Error: division by zero");<br />
    }<br />
    return Par1 / Par2;<br />
  }<br />
<br />
- At the location where we wish to do the safe division:<br />
  ...<br />
  try {<br />
    result := MySafeDivision(x, y);<br />
  } catch (charstring v_exception) {<br />
    log("There was an exception:", v_exception, ", but execution can
continue safely");<br />
  }<br />
  ...<br />
<br />
This solution has the same safety and granularity.<br />
Using much less code ... that also makes it much easier to see what is
happening in the code.<br />
Using much less resources ... there is no need for a parallel component
and remote procedure calls, etc...<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007731</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></span> </td>
<td class="print">Draft document for Object-oriented Extension </td>
</tr>
<tr class="even">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007561</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></span> </td>
<td class="print">Allow finally block or shutdown hook </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7692.docx (279,126) <span class="italic">28-07-2017
14:11</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3672&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7692_v2.docx (281,583) <span class="italic">05-09-2017
11:38</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3677&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7692_v3.docx (288,770) <span class="italic">08-09-2017
09:48</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3684&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> MTS-203790-00F_ed111v001_with_exceptions_v2.docx (180,702)
<span class="italic">26-10-2017 08:48</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3704&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> MTS-203790-00F_ed111v001_with_exceptions_v4.docx (182,754)
<span class="italic">31-03-2018 09:11</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3735&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-07-2017 12:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-07-2017 09:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014729</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-07-2017 14:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-07-2017 14:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-07-2017 14:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0014737</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-07-2017 12:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007561</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">28-07-2017 12:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Ext Pack: Object-oriented
features (ES 203 790)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-07-2017 12:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Category</td>
<td class="print">New Feature =&gt; General</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">28-07-2017 14:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7692.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-07-2017 14:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014796</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-09-2017 11:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7692_v2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-09-2017 11:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014814</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-09-2017 07:45</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-09-2017 09:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7692_v3.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-09-2017 09:58</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014824</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">26-10-2017 08:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added:
MTS-203790-00F_ed111v001_with_exceptions_v2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">26-10-2017 08:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014878</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">26-10-2017 14:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014896</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">26-10-2017 14:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">26-10-2017 14:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">31-03-2018 09:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added:
MTS-203790-00F_ed111v001_with_exceptions_v4.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">31-03-2018 09:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0015073</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-04-2018 09:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Kristof.Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-04-2018 09:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-04-2018 09:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">Kristof.Szabados =&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-04-2018 09:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0015088</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-04-2018 14:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR7731-TRI-TCI-1.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-04-2018 14:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Deleted: CR7731-TRI-TCI-1.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-04-2018 08:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007731</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-04-2018 09:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0015096</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-04-2018 09:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-04-2018 09:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014729)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-07-2017 09:57   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Unfortunately, this isn't really true about the
granularity.<br />
<br />
If an exception occurs on one component, only that component state can
be affected, i.e. only that component's data can be in a possibly
inconsistent state.<br />
<br />
The call/getreply/catch pattern is much safer in that regard, as it can
not lead to the caller getting into an inconsistent state because the
control flow is in their hands (and not in the hands of the called
function).<br />
<br />
Just some things that need to be considered/addressed.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014737)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">24-07-2017 14:15   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">To be discussed in the STF.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014796)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">28-07-2017 14:13   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I have uploaded a first draft of the proposal.<br />
<br />
Please Note 0: still work in progress.<br />
<br />
Please Note 1: for the time being I had to start from the core standard,
but the final version will be part of the Object Oriented extension ...
modification will be needed<br />
<br />
Please Note 2: for the time being I had to start from the concepts of
the core standard. These should be updated/harmonized with the concepts
of the Object Oriented extension once they are available.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014814)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">05-09-2017 11:38   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">some editorial fixes and added the changes to external
functions</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014824)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-09-2017 09:58   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">After feedback from Jacob there were some fixes:<br />
- a ',' is needed between the types in the exception list<br />
- "[{" is not useful in the syntactical structure examples<br />
- the exception list must have at least one element<br />
- the exception list might not be exhaustive, for backward
compatibility.<br />
  (but is recommended to be updated to precisely communicate to callers
(user/tool) what exceptions to prepare for, or even to expect the
possibility of exceptions)<br />
- Statementblock -&gt; statement block<br />
- there is no need for '('')' after the raise keyword.<br />
- some re-phrasing to make the sentences easier to read.<br />
- added note to draw attention to exceptions are caught precisely by
their type, so even for literals it is advised to write them down.<br />
- added note saying that an exception not handled latest in the testcase
results in a dynamic error ... where the error is not the throwing of
the exception, but not handling it.<br />
- it became disallowed to raise an exception or use return statement in
a finally block (for now), as that might result in un-intuitive
behaviour.<br />
- raising exceptions are not allowed in certain places (together with
other execution altering operations) where they could alter snapshot
semantics.<br />
<br />
We received one more feedback that the "finally" keyword might not be
the best choice as the Object-oriented extension might use it in a
slightly different meaning.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014878)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">26-10-2017 08:48   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">uploaded the same content in the new extension package
format (work in progress)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014896)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">26-10-2017 14:41   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Could you please check the latest version
(MTS-203790-00F_ed111v001_with_exceptions_v2.docx).<br />
<br />
I tried to use the list of extensions style present in the advanced
parameterization ... should I restructure the text?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015073)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">31-03-2018 09:12   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">improved the text (fixed typos, phrases, some
numbering, etc..)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015088)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-04-2018 09:05   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Updated CR 7731 based on these changes
(MTS-203790-00F_ed111v002.docx)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015096)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-04-2018 09:51   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Solved as part of the OO extension (CR 7731)</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
