  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0007607</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Technical</td>
<td class="print">public</td>
<td class="print">09-02-2017 14:00</td>
<td class="print">30-12-2017 20:55</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Tomas Urban</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.9.1 (published 2017-05)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.10.1 (published 2018-05)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.10.1 (published 2018-05)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">21.1.1</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">STF 521</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0007607: Additional restriction for the
connect operation</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">The current rules for the connect
operation allow to establish a connection where no communication is
possible without violating the current restrictions. Let's demonstrate
it on an example:<br />
<br />
type port P message { in integer; }<br />
type component C { port P p; }<br />
testcase TC() runs on C system C {<br />
  var C v_ptc := C.create;<br />
  connect(self:p, v_ptc:p);<br />
}<br />
<br />
The rule 21.1.1.c says the connect operation is allowed if outlist-PORT1
subsetof inlist-PORT2 and outlist-PORT2 subsetof inlist-PORT1, which is
fulfilled as the empty outlists are valid subsets of inlists.<br />
<br />
However, since no messages can be sent over such a connection from
either side, it should not be allowed to create it. For that reason, I
propose to extend the restriction c) by adding an additional condition:
"where at least one of the outlists is not empty".</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007677</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></span> </td>
<td class="print">Additional restriction for the disconnect
operation </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-02-2017 14:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-02-2017 14:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014525</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-02-2017 09:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014526</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-04-2017 17:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1021">szabados</a></td>
<td class="print">Note Added: 0014594</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-04-2017 09:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014595</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-04-2017 10:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014596</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-04-2017 14:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014597</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-04-2017 15:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014598</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-04-2017 15:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Edited: 0014598</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14598#r411</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-04-2017 16:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014599</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-04-2017 16:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0014599</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14599#r413</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-05-2017 10:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014612</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">03-05-2017 11:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014613</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">06-06-2017 11:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">06-06-2017 11:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">06-06-2017 11:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0014621</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-06-2017 20:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007677</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-06-2017 08:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014673</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-06-2017 08:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-06-2017 08:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-06-2017 08:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-12-2017 20:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-12-2017 20:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Product Version</td>
<td class="print">=&gt; v4.9.1 (published 2017-05)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-12-2017 20:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.10.1 (published 2018-05)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-12-2017 20:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.10.1 (published 2018-05)</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014525)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-02-2017 14:14   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">A similar problem affects the restriction d on the
mapping operation. In this case, the additional rule should state that
either outlist-PORT1 or inlist-PORT2 (or both of them) shall not be
empty.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014526)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-02-2017 09:37   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">This would be a valid but useless restriction. The
actual resulting problem only occurs once you try to send something over
the port at which point a (probably even static) error would occur. As
long as you don't use the connection to send something, it doesn't pose
an actual problem.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014594)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1021">szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-04-2017 17:39   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I'm for extending the restriction.<br />
<br />
I just registered a request for Titan to report these situations.<br />
This is something that we can detect statically and save potentially
hours of debugging for our users.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014595)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-04-2017 09:40   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">How can this be a debugging problem? Does Titan not
check whether a message over a port can be sent statically? Once you try
to send a message over a port that is not allowed to be sent, the
(probable) error in the port definition will become apparent and can be
fixed. No debugging involved.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014596)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-04-2017 10:59   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I agree that it is not a problem for sending. However,
in the case of receiving operations an unexperienced user might wonder
why no messages are ever delivered to a legally mapped/connected port.
If he/she gets a static error when compiling the connect operation, it
will save a lot of time.<br />
<br />
We had this case some time ago and it really took some time to find the
cause of the problem which occurred after removing some messages from
the port list (the test suite worked well before). Of course it was an
error of the person who made this change and didn't thought it through,
but with proper compiler support, it would have been discovered
earlier.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014597)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-04-2017 14:51   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">But what would this restriction help you in that case?
Did the person remove ALL the types in the out list of the connected
port or just some? In the latter case, the additional restriction would
not help you at all.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014598)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-04-2017 15:09   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The person didn't remove all types from the port type,
but unfortunately the removed types were the only ones which were
present in the other port type in-list.<br />
<br />
I admit it is not a usual issue, but I don't see any harm having an
additional restriction here. Our compiler does detect the problem and
issues a warning, but since the common approach of typical users to
warnings is to ignore them, I would prefer an outright error during
compilation of the connect (or map operation). It just doesn't seem
reasonable to allow connections that are completely useless.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0014599)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-04-2017 16:01   <br />
(edited on: 21-04-2017 16:02)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">But then this is already covered with the current
restriction in place.<br />
<br />
The out-list of port A was X and the in-list of B was Y and Y was not a
superset of X, then the restriction is violated and connect should be
reported as erroneous. Or what am I missing?<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014612)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">03-05-2017 10:40   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I am sorry, Jacob. I wrote the comment without
checking the exact details. You are indeed correct that the described
situation is covered by the current restrictions.<br />
<br />
It turns out that the problem our testers had concerned mapped ports.
They actually did delete (or rather commented out) the whole in-list of
the system port. It happened by accident, it was not an intentional
change. The mapped component port had no out-list, because it was used
only for notifications. The adapter still kept enqueuing messages which
led to a runtime error during a test session. It took them some time to
figure out the reason.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014613)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">03-05-2017 11:00   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">sorry, can you just give the problematic example in
TTCN-3 form to better understand the issue. I am still confused.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014621)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">06-06-2017 11:33   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF dicussion: check, if a note is sufficient for this
issue.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014673)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-06-2017 08:15   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Resolved as a part of the resolution o <a
href="/mantis/view.php?id=7677" class="resolved"
title="[closed] Additional restriction for the disconnect operation">0007677</a>.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
