  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0007435</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">New Feature</td>
<td class="print">public</td>
<td class="print">03-05-2016 17:00</td>
<td class="print">12-12-2016 16:48</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Jacob Wieland - Spirent</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.8.1 (published 2016-07)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.9.1 (published 2017-05)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.9.1 (published 2017-05)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">19.1, 22.2.2, 22.2.3, 22.3.2, 22.3.4,
22.3.6, A</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Spirent - Jacob Wieland</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0007435: @decoded modifier is not
compositional enough</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">In case that a decoded payload again
contains a decoded payload (both matched with the decmatch construct),
it should be possible to assign also the inner decoded value to a
variable in the receive-statement.<br />
<br />
As an inline syntax in the value-assignment notation, I could imagine
two variants:<br />
<br />
Variant 1:<br />
v_inner := @decoded &lt;outer_payload&gt;.@decoded
&lt;inner_payload&gt;<br />
<br />
where &lt;outer_payload&gt; is the extended field reference of the
payload field in the root type and &lt;inner_payload&gt; is the extended
field reference of the payload field in the decoded outer payload
type.<br />
<br />
Variant 2:<br />
<br />
v_inner := @decoded (@decoded
&lt;outer_payload&gt;).&lt;inner_payload&gt;<br />
<br />
Additionally, it should be possible to also use the @decoded syntax on
the right-hand-side of an assignment:<br />
<br />
v_inner := @decoded v_outer.&lt;inner_payload&gt;<br />
<br />
Of course, here, the problem of multiple layers where the inner layer
shall be accessed directly without having to assign the outer layer to a
variable, also exists.</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print">I am afraid that it might not be as easy
as it seems. At the moment, the type of the first payload is dependend
on the target variable type. However, if we allow the intermediate
level(s), their types are not known. Please check the following
example:<br />
<br />
):<br />
<br />
type record PDU {<br />
  PduHeader header,<br />
  bitstring outerPayload<br />
}<br />
<br />
type record OuterPayload1 {<br />
  OuterPayloadHeader header,<br />
  bitstring innerPayload<br />
}<br />
<br />
type record InnerPayload1 {<br />
  InnerPayloadHeader header,<br />
  integer data1,<br />
  charstring data2<br />
}<br />
<br />
...<br />
var template PDU vmw_pdu;<br />
var InnerPayload1 v_inner;<br />
... //vmw_pdu is initialized<br />
p.receive(vmw_pdu) -&gt; value (v_inner := @decoded
outerPayload.@decoded innerPayload);<br />
<br />
In the example, it seems that the intention is to decode @decoded
outerPayload to a value of the OuterPayload1 type. However, the compiler
has no type information at the compilation time and cannot perform
static analysis of the composed @decoded statement. Runtime-resolved
vmw_pdu template doesn't help in this case, at least not during static
analysis.<br />
<br />
It would be possible to allow strong typing of the @decoded modifier as
follows:<br />
p.receive(vmw_pdu) -&gt; value (v_inner := @decoded:OuterPayload1
outerPayload.@decoded innerPayload);<br />
<br />
In this case there would be no obstacle for having multilayer @decoded
modifier in standalone assignment statements:<br />
<br />
var template PDU vmw_pdu;<br />
var PDU v_pdu;<br />
var InnerPayload1 v_inner;<br />
p.receive(vmw_pdu) -&gt; value v_pdu;<br />
v_inner := @decoded:OuterPayload1 v_pdu.outerPayload.@decoded
innerPayload);<br />
<br />
Is such a solution satisfactory?</td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7435-1.docx (45,364) <span class="italic">21-07-2016
16:35</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3431&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7435-2.docx (47,781) <span class="italic">22-07-2016
08:19</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3432&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7435-3.docx (32,114) <span class="italic">29-08-2016
14:49</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3507&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">03-05-2016 17:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-07-2016 10:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-07-2016 10:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-07-2016 09:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-07-2016 09:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Additional Information Updated</td>
<td class="print">bug_revision_view_page.php?rev_id=297#r297</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-07-2016 11:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013987</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-07-2016 11:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0013987</td>
<td class="print">bug_revision_view_page.php?bugnote_id=13987#r299</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-07-2016 11:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0013987</td>
<td class="print">bug_revision_view_page.php?bugnote_id=13987#r300</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-07-2016 14:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-07-2016 14:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0014010</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-07-2016 14:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-07-2016 21:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014015</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-07-2016 10:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014025</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-07-2016 14:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014030</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-07-2016 14:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-07-2016 15:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-07-2016 15:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-07-2016 16:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR7435-1.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-07-2016 16:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014032</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-07-2016 16:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-07-2016 16:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">22-07-2016 08:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR7435-2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">22-07-2016 08:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014033</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">22-07-2016 10:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014034</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 11:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core
Language</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 11:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Product Version</td>
<td class="print">=&gt; v4.8.1 (published 2016-07)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 11:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.9.1 (published 2017-05)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-08-2016 14:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7435-3.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-08-2016 14:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-08-2016 14:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-08-2016 14:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014194</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2016 11:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014198</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-11-2016 13:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-11-2016 13:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-11-2016 13:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-11-2016 13:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-11-2016 13:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-12-2016 16:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014392</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-12-2016 16:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-12-2016 16:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.9.1 (published 2017-05)</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0013987)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-07-2016 11:11   <br />
(edited on: 19-07-2016 11:14)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I think this syntax is a bit confusing (because the
@decoded at the beginning refers to the last item in the whole
chain).<br />
<br />
Maybe we should switch to a pure @decoded-selector which would look a
bit like an anytype usage:<br />
<br />
&lt;extended-field-ref&gt;.@decoded.&lt;toplevel-type-reference&gt;<br />
<br />
in the example this would be:<br />
<br />
v_inner := @decoded
outerPayload.@decoded.OuterPayload1.innerPayload<br />
<br />
or, alternatively<br />
v_inner :=
outerPayload.@decoded.OuterPayload1.innerPayload.@decoded.InnerPayload1<br />
<br />
The latter expression is fully context-free and self-contained (if
outerPayload is a variable) and could also be used in a type-less
environment like a log (in a typed environment, it is redundant, so
maybe would help in type-checking).<br />
For less redundancy, the last type-selection could be optional if the
type of the whole expression is known from the context (e.g. the type of
the lhs), which would yield:<br />
<br />
v_inner :=
outerPayload.@decoded.OuterPayload1.innerPayload.@decoded<br />
<br />
When using the type-cast-syntax, I would propose to do it like
this:<br />
<br />
&lt;type&gt;:@decoded &lt;ref&gt;<br />
<br />
which would yield in our example:<br />
<br />
v_inner := @decoded (OuterPayload1:@decoded
outerPayload).innerPayload<br />
<br />
or as a context-free expression:<br />
<br />
InnerPayload1:@decoded (OuterPayload1:@decoded
outerPayload).innerPayload<br />
<br />
I.e. the type-prefix must only be added if the type of the @decoded
expression is not known from its context.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014010)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-07-2016 14:52   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Agreement Jacob and Tomas:<br />
<br />
&lt;extended-field-ref&gt;.@decoded.&lt;toplevel-type-reference&gt;<br />
<br />
in the example this would be:<br />
<br />
v_inner := @decoded
outerPayload.@decoded.OuterPayload1.innerPayload<br />
<br />
or, alternatively<br />
v_inner :=
outerPayload.@decoded.OuterPayload1.innerPayload.@decoded.InnerPayload1<br />
<br />
The latter expression is fully context-free and self-contained (if
outerPayload is a variable) and could also be used in a type-less
environment like a log (in a typed environment, it is redundant, so
maybe would help in type-checking).<br />
<br />
Check also for acceptance for short form:<br />
v_inner := outerPayload.OuterPayload1.innerPayload.InnerPayload1<br />
<br />
Assigned to Kristof for crosscheck within Ericsson.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014015)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-07-2016 21:40   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">If I understand correctly the syntaxes with @decoded()
would conflict with the current standard, according to which the
parameter when present would need to describe the encoding format of the
universal charstring field.<br />
<br />
regarding the syntax the "type-cast" looks better to me, as it is much
easier to see what belongs to where. 2-3 or more embedding with the .
notation and users will need to group the expression into its parts on
paper.<br />
<br />
I don't think the type prefix must be denied if the type is known from
the context. Tools could ignore it if they want, the users could use it
to make the expression more intuitively readable, and it could be used
as a form to make the intent more explicit.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014025)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-07-2016 10:13   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The casting syntax doesn't contain a conflict. I would
contain two pair of parenthesis if used with encoding:<br />
<br />
InnerPayload1:@decode("UTF-8") (OuterPayload1:@decode("UTF-8")
outerPayload).innerPayload<br />
<br />
For me, it is less readable than dot notation as two parts of the inner
payload (InnerPayload1 type and innerPayload field) are separated. The
distance will grow if the protocol contains more items.<br />
<br />
In order to increase readability, we could introduce a different lexical
symbol for the dot notation so that the user can see when decoding takes
place from the syntax. Yesterday we discussed two possible symbols (:
and -&gt;) with Jacob, but they were rejected, because they already have
different meaning in TTCN-3. One possible candidate would be tilde (~).
Its common meaning is "approximately" or "similar to" which would quite
well fit its intended meaning in TTCN-3. Another possibility would be a
direction sign, e.g. =&gt; or &gt;&gt;. If a symbol different than dot
is used, we could skip using the @decoded modifier at all and use just
the short syntax. Please see the following examples:<br />
<br />
v_inner := outerPayload~OuterPayload1.innerPayload~InnerPayload1<br />
v_inner :=
outerPayload~("UTF-8")OuterPayload1.innerPayload~("UTF-8")InnerPayload1<br />
<br />
v_inner :=
outerPayload=&gt;OuterPayload1.innerPayload=&gt;InnerPayload1<br />
v_inner :=
outerPayload=&gt;("UTF-8")OuterPayload1.innerPayload=&gt;("UTF-8")InnerPayload1<br />
<br />
v_inner :=
outerPayload&gt;&gt;OuterPayload1.innerPayload&gt;&gt;InnerPayload1<br />
v_inner :=
outerPayload&gt;&gt;("UTF-8")OuterPayload1.innerPayload&gt;&gt;("UTF-8")InnerPayload1<br />
<br />
Kristof mentioned a problem with extended type reference. This is a
valid remark. However, exactly the same problem exists with the anytype
where only top-level types can be referenced. I would keep this rule
valid for the decoded field reference in case the STF decides for the
extension of the dot notation rule.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014030)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-07-2016 14:24   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">We had a discussion and decided to got with the
syntax:<br />
"<br />
v_inner :=
outerPayload=&gt;OuterPayload1.innerPayload=&gt;InnerPayload1<br />
v_inner :=
outerPayload=&gt;("UTF-8")OuterPayload1.innerPayload=&gt;("UTF-8")InnerPayload1<br />
"<br />
<br />
Also the type reference must be restricted to pointing to a top-level
type definition, otherwise it would be impossible to separate it from
the proceeding field reference.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014032)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-07-2016 16:36   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Proposal uploaded. Please check.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014033)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">22-07-2016 08:20   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Minor modification in the proposal: terminals added to
the table A.2</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014034)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">22-07-2016 10:35   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">ExtendedFieldReference is used in many
locations.<br />
For example right now these seem to be syntactically OK:<br />
match(..,..) =&gt; type<br />
valueof(..,..) =&gt; type<br />
some_function(...) =&gt; type<br />
<br />
variable := field1 =&gt; (type) =&gt; (type) =&gt; (type)<br />
<br />
Wouldn't it be better to keep this separated from the generic reference,
somewhat like this?:<br />
338.SingleValueSpec ::= VariableRef [AssignmentChar [( DecodedModifier
["(" Expression] ")"]<br />
                                                     | DecodingOperation
)] FieldReference ExtendedFieldReference]<br />
<br />
??. DecodedOperation ::= {FieldReference "=&gt;"
DecodedFieldType}+<br />
??. DecodedFieldType ::= PredefinedType | Identifier | "(" Type [ ","
Expression ] ")"<br />
<br />
---<br />
<br />
shouldn't VariableAssignment be also updated for syntactic
consistency?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014194)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-08-2016 14:51   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I have uploaded a new version with minor typo
corrections.<br />
Please check/modifiy and assign to György (rapporteur)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014198)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-08-2016 11:02   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">looks good to me</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014392)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-12-2016 16:48   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Added to V4.8.2</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
