  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0006736</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">New Feature</td>
<td class="print">public</td>
<td class="print">22-04-2014 08:24</td>
<td class="print">04-01-2015 19:53</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Jacob Wieland - Spirent</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">major</td>
<td class="print-category">Reproducibility</td>
<td class="print">N/A</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.7.1 (published 2015-06)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.7.1 (published 2015-06)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">Appendix B</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Testing Technologies - Jacob Wieland</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0006736: new matching mechanism for binary
string types</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">Lots of protocols carry payloads. This
leads to complicated check(receive)-&gt;decvalue-&gt;match-&gt;receive
constructions which we encounter more and more frequently.<br />
<br />
Assuming, we have a type<br />
<br />
type record R {<br />
   // ... headers<br />
   // ...<br />
   octetstring payload<br />
}<br />
<br />
and we want to receive an R carrying a payload whose decoded value
matches a template t of type T.<br />
<br />
This can, at the moment, be achieved by something like the
following:<br />
<br />
template T t := ...;<br />
template R r := ...;<br />
<br />
var octetstring payload;<br />
var T decoded_payload;<br />
alt{<br />
[] p.check(receive(r)) -&gt; value (payload := payload) {<br />
   if (decvalue(oct2bit(payload), decoded_payload) == 0) {<br />
     if (match(decoded_payload, t) {<br />
       p.receive;<br />
     }<br />
   }<br />
}<br />
<br />
We propose a new matching mechanism which can achieve the same in a much
more convenient (and compositional manner, in case the payload again
contains a payload).<br />
<br />
The syntax of this new matching mechanism would be simply:<br />
<br />
match(t)<br />
<br />
where t is the template to be matched.<br />
<br />
This matching mechanism would be usable for all octetstring or bitstring
values/fields and would match if and only if the value can be decoded
successfully to the type of template t and the decoded value matches
template t.<br />
<br />
In that case, the above code can be shortened to:<br />
<br />
p.receive(modifies r := { payload := match(t) });<br />
<br />
For even more convenience, assignment of the decoded field could be
allowed to a variable of the same type as the matched template:<br />
<br />
p.receive(modifies r := { payload := match(t) }) -&gt; value
(decoded_payload := payload);</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0006697</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></span> </td>
<td class="print">Missing functionality to check absence of an
object </td>
</tr>
<tr class="even">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0006783</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></span> </td>
<td class="print">Wrong syntax to save exception parameters </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6736_v1.docx (80,093) <span class="italic">18-06-2014
15:18</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3055&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6736_v2.docx (83,724) <span class="italic">19-06-2014
08:10</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3056&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6736_v3.docx (87,440) <span class="italic">19-06-2014
15:35</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3059&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6736_v4.docx (89,856) <span class="italic">19-06-2014
17:00</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3063&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6736_v5.docx (118,934) <span class="italic">06-10-2014
14:43</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3084&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6736_v6.docx (120,760) <span class="italic">09-10-2014
12:20</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3128&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6736_v7.docx (126,123) <span class="italic">07-11-2014
11:48</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3184&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">22-04-2014 08:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-05-2014 14:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core
Language</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-05-2014 14:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.7.1 (published 2015-06)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-06-2014 11:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012100</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-06-2014 11:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-06-2014 11:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-06-2014 16:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0006697</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 13:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6673_v1.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 13:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012124</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 13:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 13:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 15:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Deleted: CR6673_v1.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 15:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6736_v1.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-06-2014 19:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012134</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-06-2014 19:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0012134</td>
<td class="print">bug_revision_view_page.php?bugnote_id=12134#r41</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-06-2014 08:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6736_v2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-06-2014 08:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012138</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-06-2014 15:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR6736_v3.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-06-2014 15:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012152</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-06-2014 15:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-06-2014 15:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-06-2014 15:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0012152</td>
<td class="print">bug_revision_view_page.php?bugnote_id=12152#r48</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-06-2014 16:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6736_v4.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-06-2014 17:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Deleted: CR6736_v4.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-06-2014 17:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6736_v4.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-06-2014 17:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012158</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-06-2014 17:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-06-2014 17:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-06-2014 08:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012169</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-06-2014 08:42</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012171</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-06-2014 14:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012189</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">06-10-2014 10:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">06-10-2014 10:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">06-10-2014 10:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012220</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">06-10-2014 14:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6736_v5.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">06-10-2014 14:42</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Deleted: CR6736_v5.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">06-10-2014 14:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR6736_v5.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">06-10-2014 14:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012232</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">06-10-2014 14:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">06-10-2014 14:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">06-10-2014 16:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012240</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 09:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 09:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012267</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 09:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0012267</td>
<td class="print">bug_revision_view_page.php?bugnote_id=12267#r75</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 14:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0012284</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 14:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2014 14:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2014 14:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 12:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Note Added: 0012317</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 12:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 12:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 12:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">File Added: CR6736_v6.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 12:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Note Added: 0012318</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 12:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 12:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Note Added: 0012319</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2014 12:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2014 14:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0006783</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2014 11:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo
Lauer</a></td>
<td class="print">Note Added: 0012360</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2014 12:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012362</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2014 12:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012363</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2014 12:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012364</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-10-2014 12:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0012364</td>
<td class="print">bug_revision_view_page.php?bugnote_id=12364#r87</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2014 13:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012366</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-11-2014 10:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012371</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">03-11-2014 10:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2014 11:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012393</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2014 12:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012394</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2014 16:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012407</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-11-2014 08:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012414</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-11-2014 08:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-11-2014 11:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012490</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-11-2014 11:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR6736_v7.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-11-2014 11:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-11-2014 12:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012491</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-11-2014 12:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-11-2014 12:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.7.1 (published 2015-06)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-11-2014 12:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-11-2014 12:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-11-2014 12:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-11-2014 12:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-11-2014 12:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2014 13:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012506</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2014 13:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2014 13:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2014 13:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-01-2015 19:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012607</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-01-2015 19:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012100)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-06-2014 11:35   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF discussion:<br />
The feature itself is useful. Reusing the match operation with a
different semantics is not supported. Instead the syntax like below
could be used.<br />
<br />
template R r:= {<br />
  headers :=....,<br />
  payload := @encoded (t)<br />
}<br />
<br />
template T t:= {....}<br />
var T v_t;<br />
<br />
function f() {<br />
P.receive(r) -&gt; value (v_t := @decoded(payload)); /*will match
decoded r, decode the payload field and match the decoded payload field
against t; decoded payload is stored*/</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012124)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-06-2014 13:40   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Proposal uploaded. There's slight change in the
syntax. The existing modifiers are typically used without parentheses
enclosing the object being modified, so I decided to use the same coding
style. I also added an optional encoding format parameter which is
useful for decoding character strings:<br />
<br />
template R r:= {<br />
  headers :=....,<br />
  bin_payload := @encoded t,<br />
  txt_payload := @encoded("UTF-8") t2<br />
}<br />
<br />
p.receive(r) -&gt; value (v_bin := @decoded bin_payload, v_txt :=
@decoded("UTF8") txt_payload);<br />
<br />
Please check.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0012134)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-06-2014 19:52   <br />
(edited on: 18-06-2014 19:56)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">there is a typo: hextring (occurring at least
twice)<br />
<br />
Also,<br />
<br />
( FieldOrTypeReference |<br />
  @decoded [ "(" Expression ")" ] FieldOrTypeReference [ "," ] )<br />
<br />
can be shortened to<br />
<br />
( [ @decoded [ "(" Expression ")" ] ] FieldOrTypeReference [ "," ]
)<br />
<br />
In B.1.2.9, the template to be matched is first called the "decoded
template" but later on is referenced as the "decoding target". It should
be called consistently the "decoding target".<br />
<br />
Otherwise, I'm very happy with the proposal.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012138)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-06-2014 08:12   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Jacob, thank you for noticing these problems. I
corrected the proposal accordingly.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0012152)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-06-2014 15:39   <br />
(edited on: 19-06-2014 15:40)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Technically OK with me.<br />
<br />
Results of my review and our verbal discussions with Tomas during it are
captured in CR6736_v3.docx. During the review - that was based on
CR6736_v1.docx - CR6736_v2.docx has been uploaded. Tomas, pls. review my
output document CR6736_v3.docx, and also merge the changes between
CR6736_v1.docx and CR6736_v2.docx into it.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012158)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-06-2014 17:01   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I merged the documents and made several minor changes
in the examples concerning the receive operation. Please check.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012169)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-06-2014 08:16   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Just to be thorough, isn't the @decoded access missing
for procedure-based communication (param assignments)? Sure, it's not as
likely that a parameter may contain an encoded payload, but it's not
impossible either.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012171)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-06-2014 08:42   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">It doesn't make much sence, because currently you
cannot assign a parameter field, only the whole parameter.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012189)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-06-2014 14:13   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">of course, even the whole parameter could be a
payload</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012220)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">06-10-2014 10:34   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">It sounds reasonable that a signature parameter and
also a return value may also contain encoded data.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012232)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">06-10-2014 14:44   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Support for @decoded in procedure-based communication
added to the proposal.<br />
Please check.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012240)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">06-10-2014 16:50   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Looks fine.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012267)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2014 09:23   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Jens, make final cross-check pls.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012284)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2014 14:08   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Ok for me</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012317)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2014 12:16   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">reopen to add correctioin/changes from CR6783</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012318)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2014 12:21   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">updated getreply syntax due to CR6783</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012319)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2014 12:22   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">updated after reopening due to CR6783
discussion/solution</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012360)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo
Lauer</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 11:52   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">TTCN-3 already contains anything you need to handle
payloads as shown below.<br />
<br />
Therefore we strongly oppose to the @<a
href="mailto:encode/@decode">encode/@decode</a> modifier solution,<br />
as it hides relevant issues from the TTCN-3 users (TTCN was originally
designed to make issues obvious. This was one reason why TTCN does not
has implicit type conversions e.g. when assigning an integer value to a
float variable)<br />
<br />
If you simply define an altstep e.g. matchPayload and a template e.g.
t_payload you get anything you need! And a few lines of TTCN-3 code make
it obvious for TTCN-3 users what is really happening!<br />
<br />
What is the need to make TTCN-3 more and more complex by @modifiers
???<br />
<br />
The modifiers @encode / @decode will add additional complexity to the
runtime system of compilers and it will require some effort to explain
it to normal TTCN-3 users.<br />
<br />
This code does the task pretty well - and it makes it obvious to the
TTCN-3 user, what is really done:<br />
<br />
type record R {<br />
   // ... headers<br />
   // ...<br />
   octetstring payload<br />
}<br />
<br />
template T t := ...;<br />
template R r := ...;<br />
template R r_payload(T t):= {<br />
   // ... headers<br />
   // ...<br />
   payload:=bit2oct(encvalue(t));<br />
}<br />
<br />
altstep matchPayload(R r, inout T t) runs on MyMTC<br />
{<br />
  var octetstring v_payload;<br />
  var T v_decoded_payload;<br />
  [] p.check(receive(r)) -&gt; value (v_payload := r.payload) {<br />
     if (decvalue(oct2bit(v_payload), v_decoded_payload) == 0) {<br />
       if (match(v_decoded_payload, t) {<br />
         p.receive;<br />
         t:=v_decoded_payload;<br />
       }<br />
     }<br />
}<br />
<br />
// use, send direction<br />
p.send(r_payload(t));<br />
<br />
// use, receive direction<br />
matchPayload(r,t);<br />
<br />
alt {<br />
    [] matchPayload(r,t) {...}<br />
}</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012362)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 12:02   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Forcing the user to write the same (obviously quite
complicated) function over and over again for every type is a clear sign
that the language is in need of a feature. This new feature shall be
introduced here. Of course, as with any feature, no one is forcing any
user to use it.<br />
<br />
Additionally, your approach is not compositional as the the proposal is.
(i.e. it cannot deal with multiple-envelope-layers in a simple,readable
way as the proposed feature does).</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012363)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 12:06   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">You forget to add repeat statement to your code:<br />
...<br />
       if (match(v_decoded_payload, t) {<br />
         p.receive;<br />
         t:=v_decoded_payload;<br />
       } else {<br />
         repeat;<br />
       }<br />
...<br />
<br />
Now compare it to the proposed solution:<br />
type record R {<br />
   // ... headers<br />
   // ...<br />
   octetstring payload<br />
}<br />
<br />
template T t := ...;<br />
template R r := ...;<br />
template R r_payload(T t):= {<br />
   // ... headers<br />
   // ...<br />
   payload := t ;<br />
}<br />
<br />
// use, send direction<br />
p.send(r_payload(encvalue(t)));<br />
<br />
// use, receive direction<br />
p.receive(r_payload(@encoded t))<br />
<br />
alt {<br />
    [] p.receive(r_payload(@encoded t)) {...}<br />
}<br />
<br />
We save a lot of code this way! Besides, I am quite sure that the
proposed solution produced much more readable solution.<br />
<br />
Your code also has a serious drawback. Activating the p.check branch
terminates processing of the snapshot, meaning that the following
branches and defaults of the alt statement cannot be processed at all.
That means that you cannot match any other payload types within this
alt. Our proposal doesn't suffer from this issue.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0012364)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 12:13   <br />
(edited on: 10-10-2014 12:15)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">small correction, it would need to be<br />
<br />
template R r_payload(template octetstring t) := ...<br />
<br />
and<br />
<br />
send(r_payload(bit2oct(encvalue(...)))<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012366)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2014 13:46   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Actually, in Thilos workaround-with-existing-features
proposal, you would need to disable the guard of the check-branch before
doing the repeat, as otherwise, for the next iteration the same code
would be called and you would have an endless loop. the value of that
guard would need to be added as an inout parameter to the altstep (and
you would need one flag for each such altstep).<br />
<br />
So, no, though it may be possible in a very complicated (and not quite
as powerful and non-composable) way to do the same things in TTCN-3
already, it is in no way near usable or readable.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012371)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">03-11-2014 10:23   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Please be the 'STF owner' of the issues, let we
discuss it at the afternoon.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012393)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-11-2014 11:46   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Result of STF discussion:<br />
We agree with Thilo that the current core language specification
contains enough features to handle encoded payloads. The proposed
solution doesn't impose any restrictions on these features and users can
still use them in their code (if they don't want to learn new features
or consider that the @<a
href="mailto:encoded/@decoded">encoded/@decoded</a> mechanism hides
something important).<br />
<br />
We disagree with the statement that the proposed feature "hides relevant
issues from the TTCN-3 users". Both the @encoded matching mechanism and
the @decoded modifier occuring in redirect assignments are precisely
specified and any user can check the specification to find out what
exactly these modifiers do. In case our description is not precise
enough or contains ambiguities, we would like to know where precisely
they are in order to correct them.<br />
<br />
We cannot accept the argument that "the modifiers @encode / @decode will
add additional complexity to the runtime system of compilers and it will
require some effort to explain it to normal TTCN-3 users". If we
accepted it, we couldn't add any new features to the language
specification, because any new addition suffer from this issue. Besides,
the proposed addition to the specification only formalizes what was
requested by TTCN-3 users. The author of the CR was not the only one who
requested a feature simplifying handling of encoded payloads.<br />
<br />
The main reason for the proposed change is code readability and
execution efficiency. It can be demonstrated on a simple example. In
this example, the testing code can receive two envelope messages
(Envelope1, Envelope2) with different payloads (Payload1 and Payload2 in
Envelope1, Payload3 and Payload4 in Envelope2). In order to make the
example more realistic, it contains a default reacting to unknown
messages and response timeout. The example contains a common part and
two variants of the testing code: the first one using the proposed
features and the second one using already existing features.<br />
<br />
// Common part<br />
module Common {<br />
<br />
  type record Envelope1 {<br />
     integer contentId,<br />
     octetstring payload<br />
  }<br />
<br />
  type record Envelope2 {<br />
     charstring contentId,<br />
     octetstring payload<br />
  }<br />
<br />
  type record Payload1 {}<br />
  type record Payload2 {}<br />
  type record Payload3 {}<br />
  type record Payload4 {}<br />
<br />
  template Payload1 m_payload1 := {}<br />
  template Payload2 m_payload2 := {}<br />
  template Payload3 m_payload3 := {}<br />
  template Payload4 m_payload4 := {}<br />
<br />
  type port P message {<br />
    in Envelope1, Envelope2<br />
  }<br />
<br />
  type component Comp {<br />
    port P p;<br />
    timer tc_maxWait := 10.0;<br />
  }<br />
<br />
  altstep a_default() runs on Comp {<br />
    [] tc_maxWait.timeout {<br />
       setverdict(fail, "No message");<br />
       mtc.stop;<br />
    }<br />
    [] p.receive {<br />
       setverdict(fail, "Unexpected message");<br />
       mtc.stop;<br />
    }<br />
  }<br />
}<br />
<br />
// Proposed solution<br />
module ProposedSolution {<br />
  import from Common all;<br />
<br />
  template Envelope1 m_envelope1(integer p_contentId, template
octetstring p_payload) {<br />
    contentId := p_contentId,<br />
    payload := p_payload<br />
  }<br />
<br />
  template Envelope2 m_envelope2(charstring p_contentId, template
octetstring p_payload) {<br />
    contentId = p_contentId,<br />
    payload := p_payload<br />
  }<br />
<br />
  testcase TC_01() runs on Comp {<br />
    var Payload1 v_payload1;<br />
    var Payload2 v_payload2;<br />
    var Payload3 v_payload3;<br />
    var Payload4 v_payload4;<br />
    activate(a_default());<br />
    tc_maxWait.start;<br />
    alt {<br />
      [] p.receive(m_envelope1(1, @encoded(m_payload1))) -&gt; value
(v_payload1 := @decoded payload) { }<br />
      [] p.receive(m_envelope1(2, @encoded(m_payload2))) -&gt; value
(v_payload2 := @decoded payload) { }<br />
      [] p.receive(m_envelope2("msg3", @encoded(m_payload3))) -&gt;
value (v_payload3 := @decoded payload) { }<br />
      [] p.receive(m_envelope2("msg4", @encoded(m_payload4))) -&gt;
value (v_payload4 := @decoded payload) { }<br />
    }<br />
  }<br />
}<br />
<br />
// Current solution<br />
module CurrentSolution {<br />
  import from Common all;<br />
<br />
  testcase TC_01() runs on Comp {<br />
    var Payload1 v_payload1;<br />
    var Payload2 v_payload2;<br />
    var Payload3 v_payload3;<br />
    var Payload4 v_payload4;<br />
    var octetstring v_encPayload;<br />
    var boolean v_guard := true;<br />
    var integer v_numContentId;<br />
    var charstring v_strContentId;<br />
    activate(a_default());<br />
    tc_maxWait.start;<br />
    alt {<br />
      [v_guard] p.check(receive(Envelope1:?)<br />
         -&gt; value (v_numContentId := contentId, v_encPayload :=
payload)) {<br />
         var Payload1 v_decodedPayload1;<br />
         var Payload2 v_decodedPayload2;<br />
         var bitstring v_payloadBits := oct2bit(v_encPayload);<br />
         if (v_numContentId == 1 and decvalue(v_payloadBits,
v_decodedPayload1) == 0) {<br />
           if (match(v_decodedPayload1, m_payload1)) {<br />
             p.receive;<br />
             v_payload1 := v_decodedPayload1;<br />
             v_guard := false;<br />
           }<br />
         } else if (v_numContentId == 2 and decvalue(v_payloadBits,
v_decodedPayload2) == 0) {<br />
           if (match(v_decodedPayload2, m_payload2)) {<br />
             p.receive;<br />
             v_payload2 := v_decodedPayload2;<br />
             v_guard := false;<br />
           }<br />
         }<br />
         if (v_guard) {<br />
            v_guard := false;<br />
            repeat;<br />
         }<br />
      }<br />
      [v_guard] p.check(receive(Envelope2:?)<br />
         -&gt; value (v_strContentId := contentId, v_encPayload :=
payload)) {<br />
         var Payload3 v_decodedPayload3;<br />
         var Payload4 v_decodedPayload4;<br />
         var bitstring v_payloadBits := oct2bit(v_encPayload);<br />
         if (v_strContentId == "msg3" and decvalue(v_payloadBits,
v_decodedPayload3) == 0) {<br />
           if (match(v_decodedPayload3, m_payload3)) {<br />
             p.receive;<br />
             v_payload3 := v_decodedPayload3;<br />
             v_guard := false;<br />
           }<br />
         } else if (v_strContentId == "msg4" and decvalue(v_payloadBits,
v_decodedPayload4) == 0) {<br />
           if (match(v_decodedPayload4, m_payload4)) {<br />
             p.receive;<br />
             v_payload2 := v_decodedPayload4;<br />
             v_guard := false;<br />
           }<br />
         }<br />
         if (v_guard) {<br />
            v_guard := false;<br />
            repeat;<br />
         }<br />
      }<br />
    }<br />
  }<br />
}</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012394)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-11-2014 12:00   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">The long version does not work with only one guard
flag. You need one guard per alternative.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012407)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-11-2014 16:24   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">It depends on encoding. In this particular example I
assumed that Envelope1 and Envelope2 have distinct encoding. Thus, if a
message is succesfully decoded as Envelope1, it cannot be decoded as
Envelope2 when repeat is called. However, I admit that in many cases you
will need one guard per alternative.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012414)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">05-11-2014 08:47   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Technically there doesn't seem to be any problem in
details anymore, but Thilo opposes the whole idea. As time is running
out, we should decide if we include the proposed changes to the standard
and risk that it won't pass the acceptance procedure or postpone it to
the next year. I personally think we have enough arguments to decide in
favour of the proposed solution.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012490)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">07-11-2014 11:46   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">As discussed with Tomas, a matching mechanism is more
appropriate as a modifier, as in fact we are not modifying an existing
matching but defining a new one. For the consistency the price will be a
new keyword. Also the name has been changed - after long discussion - to
decmatch. MatchingDecodedContent is the now name of the matching
mechanism.<br />
<br />
See updated resolution proposal in CR6736_v7.docx.<br />
<br />
Please review.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012491)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">07-11-2014 12:29   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Proposal reviewed. The proposed changes are ready to
be added to the next version of the core language specification.<br />
<br />
Note for Jacob: please check the text too if you have time.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012506)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-11-2014 13:51   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">In principle, it's fine with me. I still don"t like
the new keyword, but I can live with it.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012607)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-01-2015 19:53   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Added to draft V4.6.3</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
