  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 06: TTCN-3 Control Interface
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0005946</td>
<td class="print">Part 06: TTCN-3 Control Interface</td>
<td class="print">Technical</td>
<td class="print">public</td>
<td class="print">15-10-2011 18:03</td>
<td class="print">10-08-2012 12:08</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Mateusz Pusz</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">block</td>
<td class="print-category">Reproducibility</td>
<td class="print">N/A</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.5.1 (published 2013-04)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.5.1 (published 2013-04)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">TRI 8.5.2, TCI 10.5.2</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Mateusz Pusz/freettcn</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0005946: TRI &amp; TCI identifiers in C++
interface mapping wrongly defined</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">Some TRI and TCI interfaces C++ mappings
inherit privately from TRI::QualifiedName. That makes impossible to call
any of its interface methods. To make it straight lets assume that TM
just received TciTestCaseIdList from TciTmRequired::tciGetTestCases()
and wants to present the names to the user. How is it supposed to do it
if it does not have the access to private interface of TciTestCaseId
class (because public interface of QualifiedName ends as private one in
privately inherited child class)? I think that aggregation:<br />
<br />
class TciTestCaseId {<br />
.....<br />
const QualifiedName &amp;id() const;<br />
.....<br />
};<br />
<br />
or public inheritance if really needed:<br />
<br />
class TciTestCaseId : public QualifiedName {<br />
.....<br />
};<br />
<br />
should be used here to achieve the goal. Another issue here is the
existence of non-virtual cloneQualifiedName() method which makes it not
only unusable (no-one have access to it) but also unimplementable as you
cannot create the same object from that level in inheritance hierarchy
(object slicing).<br />
<br />
Even with above problem solved the class does not have any virtual
method which makes it really hard to implement its methods as the class
does not have any internal members. Because of that the developer is
forced to do some external database with contents of those classes (like
a map of QualifiedName pointers pointing to its content) and use it with
every access to the class interface. It is why I think all methods in
that class should be done pure virtual.<br />
<br />
I suggest:<br />
1. Making all methods in QualifiedName virtual and pure virtual (see <a
href="https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/types.h#L60">https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/types.h#L60</a>
[<a
href="https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/types.h#L60"
target="_blank">^</a>])<br />
2. Make IDs inherit (TTCN_ID_IFACE_FIXED_1) or aggregate
(TTCN_ID_IFACE_FIXED_2) QualifiedName (see <a
href="https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/tci.h">https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/tci.h</a>
[<a
href="https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/tci.h"
target="_blank">^</a>] and <a
href="https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/tri.h">https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/tri.h</a>
[<a
href="https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/tri.h"
target="_blank">^</a>])<br />
I personaly think that aggregation is better here and will make the
interface more consistent with other classes like TriComponentId (<a
href="https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/tri.h#L66">https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/tri.h#L66</a>
[<a
href="https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/etsi/tri.h#L66"
target="_blank">^</a>]). However both solutions will make the interface
implementable,<br />
<br />
Best<br />
<br />
Mat</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">parent of</span> </td>
<td class="print">0006257</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></span> </td>
<td class="print">Part 05: TTCN-3 Runtime Interface  </td>
<td class="print">TRI &amp; TCI identifiers in C++ interface mapping
wrongly defined </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR_5946_resolution_v1.docx (45,798) <span
class="italic">12-07-2012 16:32</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2692&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-10-2011 18:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz
Pusz</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-10-2011 18:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz
Pusz</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; TRI 8.5.2, TCI 10.5.2</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-10-2011 18:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz
Pusz</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; Mateusz Pusz/freettcn</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-10-2011 21:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz
Pusz</a></td>
<td class="print">Note Added: 0010322</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-10-2011 21:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz
Pusz</a></td>
<td class="print">Note Edited: 0010322</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-11-2011 16:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 06: TTCN-3 Control
Interface</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">28-11-2011 16:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010360</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-11-2011 11:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-11-2011 11:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-11-2011 11:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.7.1 (published 2015-06)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 14:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Assigned To</td>
<td class="print">Ina Schieferdecker =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 16:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR_5946_resolution_v1.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-07-2012 16:42</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0010898</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-07-2012 17:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">13-07-2012 12:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">13-07-2012 12:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-08-2012 14:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-08-2012 14:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-08-2012 14:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-08-2012 14:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0011009</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-08-2012 14:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-08-2012 14:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; open</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-08-2012 12:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Issue cloned: 0006257</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-08-2012 12:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Relationship added</td>
<td class="print">parent of 0006257</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-08-2012 12:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0011027</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-08-2012 12:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-08-2012 12:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-08-2012 12:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; Edition 4.5.1</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0010322)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz
Pusz</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-10-2011 21:05   <br />
(edited on: 15-10-2011 21:07)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">BTW example implementation for both approaches can be
found here: <a
href="https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/ttcn3/ttcnId.h">https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/ttcn3/ttcnId.h</a>
[<a
href="https://github.com/mpusz/FreeTTCN/blob/d2ff73bbb9f4bb5e49b5cabe2c156512e456056c/freettcn/lib/include/freettcn/ttcn3/ttcnId.h"
target="_blank">^</a>]<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010360)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">28-11-2011 16:17   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF discussion 28/11: Discuss it with tool
vendors.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010898)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-07-2012 16:42   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The proposed resolution is to change the methods of
QualifiedName to pure virtual and change the definition of the classes
derived from QualifiedName (i.e. TriFunctionId, TriSignatureId,
TriTestCaseId, TciBehaviourId, TciTestCaseId, TciModuleParameterId) so
that the inheritance is public.<br />
<br />
The changes were kept on the necessary minimum in order to preserve
backwards compatibility of the C++ mapping. For that reason, it was not
possible to opt for the aggregate solution or to unify naming of cloning
methods.<br />
<br />
Tool vendors will be notified about the change. Final decition about the
proposal shall be made based on the feedback from the vendors.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011009)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-08-2012 14:43   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">No significant feedback was received from the vendors,
so it seems we can go on with changing the standard.<br />
<br />
Ina, could you please check the proposed resolution?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011027)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-08-2012 12:08   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Implemented as proposed.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
