## Creating a Change Request

[Create a brief issue](https://labs.etsi.org/rep/mts/ttcn3/standard/-/issues/new)
describing desired change request and choose a template that fits your request
best:

![issue templates](assets/issue-templates.png)

The **Editorial Changes** template is used for changes that do not affect
meaning of the standard. For example, fixing typos, grammar, or formatting.

Create a **Bug Report** if the standard does not specify TTCN-3 as intended. For
example, if two specifications contradict each other, or if an example does not
reflect defined behavior.

**Clarification Needed** is used when the standard is unclear or ambiguous. For
example, if a term is not defined, or if an enumeration is missing a value and
it is unclear if this is on purpose.

A **Feature proposal** is used to suggest new features, interfaces, documents
or changes to existing ones.  
You do not need to provide a full specification document, yet. It is practice
to discuss the proposal first and create the document when the proposal is
accepted and all details are clear.


## The Process

### Overview

GitLab is a powerful tool that can be used in many ways, it is easy to get lost
in finding the perfect process. Therefore we deliberately keep it to a bare
minimum initially, and improve it later based on our experience and needs.


![sidebar](assets/gitlab-sidebar.png)

Everything sits in a single repository. Our GitLab project has a few major
sections, reachable via sidebar. Our main focus is on **Issuess**. The other
sections **Repository**, **Merge Requests**, **CI/CD**, **Deployments** are
related to version control and open source development processes, which we do
not use at the moment.


### Working on Change Requests


* der process ist wie bei mantis, aber andere oberfläche und andere begriffe
* Der state funktioniert via label (tags)



* kanban board
* columns
* label based


* issues are added and moved through the columns/stages

An Issue moves through the following stages:

### 1. Create Issue


### 2. To-Do

### 3. Work In Progress

### 4. Ready for Review

### 5. Done

### 6. Closed

Issues that are reviewed and do not need further refinement are moved to the "Done" column

Before you close an issue, make


**By Design**

This issue was examined and we decicded it wasn't a problem after all.

**Duplicate**

This issue already exists.

**Fixed**

This issue was fixed.

**Won't Fix**

This issue examined and we decided to live with it.


## Guidelines for Writing

* Use British English in normative Text. For example, use "colour" instead of
  "color", "behaviour" instead of "behavior".
* For normative text use *shall* and *shall not*. Inside informative text never
  use *shall*, use *must* instead.
* Use singular instead of plural.
* Don't say the same thing normatively in more than on place; say it once and
  point to that place, as needed.
* Normative text must be clear without examples and notes.
* A section should contain either subsections or text, but never both.
* Keep examples small, simple, and narrowly focused without using unnecessary
  features.
* Avoid using quoted text, as in "natural type". If it is a term, except for
  its first use, it should be in regular font without the quotes and defined in
  the Terms-and-definitions clause. If it is not a term use the right term or
  other English text.
* Technical terms should be defined in the Terms-and-definitions clause.
* Avoid enumerations where a term exists. For example, don't say



