  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 07: Using ASN.1 with TTCN-3
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0007805</td>
<td class="print">Part 07: Using ASN.1 with TTCN-3</td>
<td class="print">Technical</td>
<td class="print">public</td>
<td class="print">07-10-2018 11:52</td>
<td class="print">29-12-2019 14:22</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Wolfgang Seka</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">high</td>
<td class="print-category">Severity</td>
<td class="print">major</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print"></td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.8.1 (published 2020-05)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">ES 201 873-1 clause 15</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">     MCC160 (Wolfgang)</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0007805: Support of ASN.1 sequence with
extension containing mandatory fields</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">The extension of an ASN.1 sequence may
consist of optional and mandatory fields.<br />
Nevertheless even if it has mandatory fields the extension as a whole
need not to be present in a message.<br />
But it seems that TTCN-3 has no means to express this properly in
templates: There is no way to explicitly address an extension and
therefore no way to specify its presence.<br />
In addition at least some of the tools do not allow to omit the
mandatory fields of an extension (what could be considered as workaround
even though it is not really a solution).<br />
<br />
<br />
EXAMPLE:<br />
ASN.1 type definition<br />
    My-Field-Type ::= INTEGER (0..255)<br />
    My-Extended-Sequence ::= SEQUENCE {<br />
        field1 My-Field-Type,<br />
        ...<br />
        [[<br />
            field2 My-Field-Type,<br />
            field3 My-Field-Type OPTIONAL<br />
        ]]<br />
    }<br />
<br />
In TTCN there is no way to have a template explicitly specifying that
the extension with field2, field3 shall not be there in a message to be
sent out and there is no way to specify something like "{field2:=*,
field3:=?} ifpresent" in a receive template.</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7805.docx (158,802) <span class="italic">11-10-2018
15:20</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3804&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7805_v2.docx (158,108) <span class="italic">11-10-2018
16:43</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3807&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-10-2018 11:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-10-2018 12:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a></td>
<td class="print">Note Added: 0015195</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2018 11:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015196</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2018 11:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015197</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2018 11:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0015197</td>
<td class="print">bug_revision_view_page.php?bugnote_id=15197#r485</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2018 11:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a></td>
<td class="print">Note Added: 0015198</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2018 12:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015199</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2018 12:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Edited: 0015199</td>
<td class="print">bug_revision_view_page.php?bugnote_id=15199#r487</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2018 13:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a></td>
<td class="print">Note Added: 0015200</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2018 14:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2018 14:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-10-2018 14:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin
Hauch</a></td>
<td class="print">Note Added: 0015206</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-10-2018 15:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0015208</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2018 07:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015210</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2018 08:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015211</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2018 08:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015212</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2018 08:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin
Hauch</a></td>
<td class="print">Note Added: 0015213</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2018 09:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015214</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2018 09:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin
Hauch</a></td>
<td class="print">Note Added: 0015215</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2018 09:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015219</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-10-2018 10:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a></td>
<td class="print">Note Added: 0015221</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-10-2018 12:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin
Hauch</a></td>
<td class="print">Note Added: 0015226</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-10-2018 10:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0015239</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-10-2018 15:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7805.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-10-2018 15:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-10-2018 15:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0015258</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-10-2018 16:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7805_v2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-08-2019 12:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0015398</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-08-2019 12:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-08-2019 12:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-12-2019 11:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0015603</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-12-2019 11:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0015603</td>
<td class="print">bug_revision_view_page.php?bugnote_id=15603#r505</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-12-2019 14:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 07: Using ASN.1 with
TTCN-3</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-12-2019 14:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0015605</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-12-2019 14:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-12-2019 14:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.8.1 (published 2020-05)</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015195)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a>   </td>
</tr>
<tr class="odd">
<td class="print">07-10-2018 12:44   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Correction: In the example it shall be "{field2:=?,
field3:=*} ifpresent"</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015196)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2018 11:35   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The solution could be to map the type to a (private)
type with all extension fields optional and then derive a subtype of
that type with a restriction:<br />
<br />
({field2 := omit, field3 := omit},{field2 := ?})<br />
<br />
or to be general, if your extension fields are named f1 ... fn and of
those fields g1 .. gm are mandatory:<br />
<br />
({f1 := omit, ..., fn := omit},{g1 := ?, ..., gm := ?})</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0015197)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2018 11:36   <br />
(edited on: 08-10-2018 11:40)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The base type could simply be named like the original
type with an underscore added at the end. Since there's no hyphen
allowed at the end of ASN.1 identifiers, this can't clash with any other
mapped names.<br />
<br />
Thus, the whole mapping of your example would be:<br />
<br />
    type integer My_Field_Type (0..255);<br />
<br />
    private type record My_Extended_Sequence_ {<br />
        My_Field_Type field1,<br />
        My_Field_Type field2 optional,<br />
        My_Field_Type field3 optional<br />
    }<br />
    <br />
    type My_Extended_Sequence_ My_Extended_Sequence<br />
    ({field2:= omit, field3 := omit},<br />
     {field2:=?})<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015198)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2018 11:44   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">An important requirement which I've forgotten to
mention:<br />
Any potential solution needs to be backward compatible as we already
have hundreds of ASN.1 type definitions with extensions (but most of
them with all fields being optional).</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0015199)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2018 12:24   <br />
(edited on: 08-10-2018 12:25)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Well, I assumed that, which is why I proposed my
solution which should be fully backward compatible with former mapping
and all values that conform to the ASN.1 restrictions.<br />
<br />
The additional private type is just necessary because for now it is not
possible to add subtype restrictions directly to structured type
definitions.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015200)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2018 13:09   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">OK - with the proposed mapping it means that the
following templates are supported:<br />
<br />
    template (value) My_Extended_Sequence cs_My_Extended_Sequence1 :=
{<br />
      field1 := 42,<br />
      field2 := omit,<br />
      field3 := omit<br />
    };<br />
    template (value) My_Extended_Sequence cs_My_Extended_Sequence2 :=
{<br />
      field1 := 42,<br />
      field2 := 49,<br />
      field3 := omit // or any valid value<br />
    };<br />
    template (present) My_Extended_Sequence cr_My_Extended_Sequence1 :=
{<br />
      field1 := ?,<br />
      field2 := omit,<br />
      field3 := omit<br />
    };<br />
    template (present) My_Extended_Sequence cr_My_Extended_Sequence2 :=
{<br />
      field1 := ?,<br />
      field2 := *,<br />
      field3 := *<br />
    };<br />
the following template may/should cause a compiler error<br />
    template (present) My_Extended_Sequence cr_My_Extended_Sequence3 :=
{<br />
      field1 := ?,<br />
      field2 := *,<br />
      field3 := ?<br />
    };<br />
<br />
=&gt; there would be no issue for the TTCN-3 core language (part 1) but
a requirement for compilers what may need clarification in part 9 (as at
least for now there are compilers raising an error if field2 is
omitted).<br />
<br />
=&gt; even though it is not a perfect solution (as it may cause
confusions for TTCN writers and readers), assuming that mandatory fields
in ASN.1 extensions are an exceptional case, the proposed solution would
serve the purpose.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015206)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin
Hauch</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2018 14:23   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The mapping to a (new and different) private type
seems to be no solution, because the new defined type is not compatible
to the original type (see chapter 6.3.2 core language):<br />
<br />
record types are compatible if the number, and optional aspect of the
fields in the textual order of definition are identical, the types of
each field are compatible and the value of each existing field of the
value "b" is compatible with the type of its corresponding field in type
"A". The value of each field in the value "b" is assigned to the
corresponding field in the value of type "A".<br />
<br />
Also the encoding result (e.g. in PER encoding) is not the same for both
types.<br />
<br />
In my opinion the writing of templates for extended ASN.1 types must be
rendered more precisely to represent the ASN.1 semantic correctly. E.g.
in templates of types with extensions, the extended fields can be set to
omit or left out at all, although they are mandatory. This should be
posssible, because the import-statement from ASN.1 modules is like<br />
<br />
    import from EUTRA_RRC_ASN1_Definitions language "ASN.1:2002" all
with {encode "UNALIGNED_PER_OctetAligned"};<br />
<br />
This declares the semantic of types from this module kind and
corresponding templates!<br />
<br />
<br />
Templates of the protocol version1 of an extensible type cannot know
names of extension-fields and so fields of extensions cannot<br />
be assigned:<br />
<br />
// version1<br />
My-Extended-Sequence ::= SEQUENCE {<br />
    field1 My-Field-Type,<br />
    ...<br />
}<br />
<br />
template My_Extended_Sequence tVersion1:= { field1:=0 };<br />
<br />
<br />
In a later protocol version2 the type might be extended. But the old
template must still be valid.<br />
<br />
// version2<br />
My-Extended-Sequence ::= SEQUENCE {<br />
    field1 My-Field-Type,<br />
    ...<br />
    [[<br />
        field2 My-Field-Type,<br />
        field3 My-Field-Type OPTIONAL<br />
    ]]<br />
}<br />
<br />
// version2<br />
template My_Extended_Sequence tVersion2_2:= {<br />
    field1:=0,<br />
    field2:=1, // this field is mandatory if an extension is
present<br />
    field3:=omit<br />
}<br />
<br />
And if we receive a message with template tVersion2_2 from a version2
SUT by protocol version1, this should match template tVersion1, because
all conditions of protocol version1 are fulfilled!<br />
The received message might have additional extended information (which
will be skipped by protocol version1), but this was the reason to define
the type extensible!<br />
<br />
Also, a template definition like tVersion1 in version1 must be valid in
version2:<br />
<br />
// version2<br />
template My_Extended_Sequence tVersion2_1:= { field1:=0 };<br />
<br />
Because of the semantic for extensible ASN.1-types and the backwards
compatibility to previous protocol versions, this is a valid template!
The mandatory/optional semantic of TTCN-3 can only be applied<br />
for the root-fields of the sequence-type. Template definitions for
extended types have to respect the semantic of the ASN.1
definition.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015208)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-10-2018 15:23   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF proposal:<br />
Dedicated syntax for record and set types, some examples.<br />
<br />
type record MyRecord {<br />
 integer field1,<br />
 extension {<br />
   integer field2,<br />
   integer field3 optional<br />
 }<br />
}</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015210)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2018 07:57   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">In response to Martin Hauch's comment:<br />
<br />
First of all, type compatibility is given, have no idea what would
violate the rules. There's no new type introduced for protocol version
2, the old type is replaced and if you defined the templates properly
future-proof, they will be compatible with the new extended type without
any change.<br />
<br />
Second of all, if you want to have that kind of backward compatibility
for receive templates of extensible types, you need to define them
future-proof, for instance by using modifies:<br />
<br />
template My_Extended_Sequence tVersion1:= modifies ? := { field1:=0
};<br />
// will set all optional fields (of extensions) to *<br />
<br />
This will match both a message of protocol version 1 and will ignore
additional fields of newer protocol versions.<br />
<br />
For send templates, you need to declare them with the attribute optional
"implicit omit" to have that kind of backward compatibility.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015211)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2018 08:14   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">We propose to to simply change the extension mandatory
fields to TTCN-3 optional fields in the ASN.1 to TTCN-3 mapping and
tools should check for the addtional constraints concerning these
fields.<br />
<br />
This will allow defining templates in the way described above so that
they will work with all protocol versions.<br />
<br />
Also, if a tool doesn't check for the additional constraints, at least
it won't reject values/templates statically which define the mandatory
fields with omit anymore.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015212)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2018 08:38   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Regarding your question about how to express templates
that check for constraints on extensions only if they are there you can
use the following coding pattern for each extension:<br />
<br />
template My_Extended_Sequence ifpresentExt1(template
My_Extended_Sequence t) :=<br />
  (t, modifies ? := {field2 := omit, field3 := omit})<br />
<br />
Each template that checks just for some constraints on the extension
part should be formulated like this:<br />
<br />
template My_Extended_Sequence mwExt1 :=<br />
  modifies ? := { field2 := ..., field3 := ... }<br />
<br />
Then template ifpresentExt1(mwExt1) checks the constraints for extension
1 only if at least one of its fields is present.<br />
<br />
With advanced matching templates, you can then combine such templates
with other templates (say, if you want to check for constraints on
multiple extensions simultaneaously)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015213)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin
Hauch</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2018 08:47   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">RESPONSE to Jakob Wieland (15210,15211)<br />
<br />
The type<br />
    private type record My_Extended_Sequence_ {<br />
        My_Field_Type field1,<br />
        My_Field_Type field2 optional,<br />
        My_Field_Type field3 optional<br />
    }<br />
is not compatible to<br />
    My-Extended-Sequence ::= SEQUENCE {<br />
        field1 My-Field-Type,<br />
        ...<br />
        [[<br />
            field2 My-Field-Type,<br />
            field3 My-Field-Type OPTIONAL<br />
        ]]<br />
    }<br />
because field2 must be present if the extension group is used. The
TTCN-3 type also allows omit as value!<br />
The TTCN-3 type does not represent the extensions and groups, so
encoding and decoding cannot be handled correctly.<br />
<br />
template MyExtended_Sequence_ tInvalid:= {field1:=1, field2:=omit,
field3:=3};<br />
This is not a valid template for the original type definition
My-Extended-Sequence in the ASN.1-module, but for type
My_Extended_Sequence_!</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015214)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2018 09:04   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Sorry, the type is compatible with what is described
by the ASN.1 type. In general, the extension fields are all optional,
they just need to be present under some circumstances.<br />
<br />
There is no way in TTCN-3 to express such conditional optionality on the
type level (unless using subtype restrictions, as proposed in comment <a
href="http://oldforge.etsi.org/mantis/view.php?id=7805#c15197">http://oldforge.etsi.org/mantis/view.php?id=7805#c15197</a>
[<a href="http://oldforge.etsi.org/mantis/view.php?id=7805#c15197"
target="_blank">^</a>]).<br />
<br />
Subtype restrictions do not have an effect on type compatibility (other
than that empty types are not allowed).<br />
<br />
template MyExtended_Sequence_ tInvalid:= {field1:=1, field2:=omit,
field3:=3}<br />
<br />
is an invalid template as it would violate the subtyping constraints:
not both extension fields are omit, therefore, field2 must be matched by
? which is only the case if it is not omit, therefore, any tool that
would check for the proposed subtyping constraints would reject the
template as invalid.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015215)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin
Hauch</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2018 09:21   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">RESPONSE to Jens Grabowski (15208)<br />
<br />
Mapping the ASN.1 extensible types to a new type-definition does not
solve the problem.<br />
1. No backward compatibility, because definitions of templates for
existing extended types are no longer valid.<br />
2. The result of encoding a value of the new type is generally not the
same as the encoding of the original type.<br />
3. New rules for renaming fields have to be assigned, because
"extension" could also be the name of a root field or later defined
extensions.<br />
<br />
Again the definition of templates for extensible ASN.1 types simply has
to be described more precisely, and type mapping as proposed is not
necessary.<br />
<br />
Templates for extensible ASN.1 types allow to leave out mandatory fields
of extensions. This ensures the backward compatibility for<br />
templates that are defined using only root-fields (e.g. templates of the
1st version of the ASN.1 module definition). Semantic-Checker<br />
for TTCN-3 and ASN.1 should be able to recognize extended type-fields
and allow to leave out these fields in template definition. And
the<br />
semantic check should also be able to recognize incorrect templates for
an extended ASN.1 type.<br />
<br />
Look the following extended type:<br />
<br />
My-Extended-Sequence ::= SEQUENCE {<br />
    field1 My-Field-Type,<br />
    ...<br />
    [[<br />
        field2 My-Field-Type,<br />
        field3 My-Field-Type OPTIONAL<br />
    ]],<br />
    field4 My-Field-Type,<br />
    field5 MyField-Type OPTIONAL,<br />
    field6 My-Field-Type<br />
}<br />
<br />
<br />
template My_Extended_Sequence t1:={field1:=1};<br />
// is valid, all root-fields are assigned, the value is not extended in
case of sending.<br />
// an extended received value is not known in version 1 and the extended
fields cannot be checked (skipped).<br />
// an extended received value in a later version can be checked if the
template uses the extension-fields.<br />
// This template could be used for all current and future versions of
this type.<br />
<br />
template My_Extended_Sequence t2:={field1:=1, field2:= 2,
field3:=omit};<br />
// is valid,all root-fields are assigned, all fields of the first
group-extension are assigned.<br />
<br />
template My_Extended_Sequence t3_invalid:= {field1:=1, field4:=4};<br />
// is invalid because extension field4 is assigned and previous defined
extensions are missing.<br />
<br />
template My_Extended_Sequence t3:= {field1:=1, field2:= 2, field3:=omit,
field4:=4};<br />
// is valid, all root-fields are assigned, all fields of the first
group-extension are assigned, extension field4 is assigned.<br />
<br />
template MyExtended_Sequence t3:= {field1:=1, field2:= 2, field3:=omit,
field4:=4, field6:=6};<br />
// Either the template is valid, because field5 is optional (and is
handled implicit as omit),<br />
// or it is not valid because the template is not completely assigned (
omit must be assigned explicit to field5).<br />
<br />
template MyExtended_Sequence t4:= {field1:=1, field2:= 2, field3:=omit,
field4:=4, field5:= omit, field6:=6};<br />
// is valid, all root-fields are assigned, all extension-fields up to
field6 are assigned, omit is allowed for optional field5.<br />
<br />
template MyExtended_Sequence t5:= {field1:=1, field2:= 2, field3:=omit,
field4:=4, field5:= 5};<br />
// is valid, all root-fields are assigned, all extension-fields up to
field5 are assigned.<br />
<br />
This semantic has to be checked by the TTCN-3 compiler and ASN.1 tools.
This should be possible, as the<br />
TTCN-3 parser recognizes, that an imported module is an ASN.1 module
(from import statement in TTCN-3 module)!<br />
This is also completely backward compatible, because nothing has to be
changed in the syntax for templates.<br />
So simply, only the semantic for ASN.1 extensible type templates must be
defined more precisely.<br />
<br />
_</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015219)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2018 09:48   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">In response to <a
href="http://oldforge.etsi.org/mantis/view.php?id=7805#c15215">http://oldforge.etsi.org/mantis/view.php?id=7805#c15215</a>
[<a href="http://oldforge.etsi.org/mantis/view.php?id=7805#c15215"
target="_blank">^</a>]<br />
<br />
The templates t1, t2 are only valid, if you add the 'optional' attribute
as "implicit omit". Otherwise, they will be invalid. There is no way to
express non-root fields in TTCN-3 as you are suggesting. TTCN-3 does not
distinguish between root fields and extension fields. This would have to
be a completely new feature (with probably wide-ranging consequences for
type compatibility etc.).<br />
<br />
t3_invalid would be valid if optional "implicit omit" is added (This
should be done in general for templates of extensible types, that's what
we introduced the feature for).<br />
<br />
t3 (both versions) again is only valid if 'implicit omit' is given.
Otherwise, it's invalid as TTCN-3 forces you to give all fields
explicitly or leaves them uninitialized (which has a different semantic
than omit).<br />
<br />
t4 is valid<br />
<br />
t5 is invalid (see above)<br />
<br />
Also, the TTCN-3 abstracts from encoding, so dealing with the encoding
of extension fields is outside of the scope of the ASN.1 to TTCN-3
mapping. Codecs have to deal with it properly, of course (they need to
know which fields are root, which are non-root and which are extension).
This has no bearing on the mapping to TTCN-3 types and their
corresponding templates/values.<br />
<br />
Giving the proposed subtype constraints models the ASN.1 type semantics
on TTCN-3 values precisely (it accepts all valid, fully specified
values/templates and rejects all invalid ones).</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015221)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2018 10:20   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">First of all - as said already - I can live with the
approach to treat all fields of ASN.1 extensions as being optional in
the first place even though from TTCN-3 user's point of view this may be
confusing.<br />
Nevertheless there is another aspect:<br />
Assuming all fields on an extension being optional it may make a
difference whether the whole extension is not present or it is present
but all its fields are omitted.<br />
According to my knowledge this cannot be distinguished by current means
of TTCN.<br />
=&gt; in principle a notation as proposed by Jens would be the real and
easy-to-understand solution but I don't know how this approach could be
made backward compatible.<br />
(somehow an optional sub-grouping notation for templates would be needed
...)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015226)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin
Hauch</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-10-2018 12:52   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">RESPONSE to Wolfgang Seka (0015221):<br />
As far as I analyze the ASN.1 syntax, it is not possible to specify an
extended type value without defining at least one extension-field with a
value. As ASN.1 values could not assign omit to a field (omit is handled
by field is not assigned in value-notation) an extended message-value
without at least one extension field value, cannot be defined. If not at
least one exteded field is assigned, then the value is not extended
(e.g.only uses the root-fields of the type).<br />
The sub-grouping solution complicates the template-definitions, because
rules for field-renaming must be defined. Also this type-mapping does
not represent the ASN.1 semantic.<br />
Handling ASN.1 extensions as being optional is ok, but the name of the
type should be the original mapping of ASN.1 type identifier to TTCN-3
type identifier (without appending '_')!</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015239)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-10-2018 10:08   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Response to: <a
href="http://oldforge.etsi.org/mantis/view.php?id=7805#c15226">http://oldforge.etsi.org/mantis/view.php?id=7805#c15226</a>
[<a href="http://oldforge.etsi.org/mantis/view.php?id=7805#c15226"
target="_blank">^</a>]<br />
<br />
First of all, for the ASN.1 to TTCN-3 mapping, it is completely
irrelevant how values are represented in ASN.1 language notation or in
encodings. We are only concerned how they are represented in TTCN-3 and
that it is possible with the information contained in these values to
encode/decode them correctly according to the ASN.1 specification of
their type (and of course that the TTCN-3 value universe of the type is
isomorphic to the ASN.1 value universe of the corresponding ASN.1 type).
Thus, we do not distinguish on the TTCN-3 level between extended and
unextended values. All must conform to the same type
specification.<br />
<br />
The internal (hence, private!, i.e. invisible, inaccessible to the user)
name with the underscore is just a proposed workaround around the
syntactical TTCN-3 restriction that a subtype restriction cannot be
added directly to a record type definition.<br />
<br />
Ideally, of course, we would like to map it to a definition like
this:<br />
<br />
type record My_Extended_Type { ... }<br />
(extRestriction1)<br />
(extRestriction2)<br />
...<br />
(extRestrictionN)<br />
<br />
But, since that isn't allowed, a chain of type definitions needs to be
used ending with the non-internal type definition with the equivalent
semantic of the ASN.1 type.<br />
If there are several extensions, you need one subtyping definition for
each additional extension to get the final public type (with the proper
original name) to have a conjunction constraint of all the chained
subtyping constraints.<br />
Finally, subtypes are always type compatible with their supertypes and
the root type is obviously the one where all the extension fields are
optional.<br />
All values of these types would have the potential for all the extension
fields, it's just a matter of taste whether you define them with
implicit or explicit omits and whether you want to use refactoring on
old templates when the type system is updated with new extension or want
to use future-proof code instead (as has been outlined).<br />
<br />
The proposal with the new extension syntax given by Jens does not
introduce new fields with the name 'extension'. The proposed extension
keyword followed by a field declaration block would have exactly the
same syntactic and semantic function as the [[ ]] brackets in ASN.1,
i.e. it would introduce all the fields contained as optional fields of
the containing type while implicitly adding the proper constraints on
those fields to the type (i.e. mandatory fields present if one of the
fields contained is present). Therefore, there's no nameclashing
problem, as there is no new name introduced and also no new scope in the
value. That means, there is no complication added and the type mapping
is a 1-to-1 representation of the ASN.1 semantic.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015258)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-10-2018 15:21   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Gyorgy, please check the uploaded proposal.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015398)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">07-08-2019 12:25   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Please check it.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0015603)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-12-2019 11:34   <br />
(edited on: 29-12-2019 11:36)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Resolution is OK with me.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0015605)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-12-2019 14:22   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Included in final draft V4.7.2</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
