  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0007493</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">New Feature</td>
<td class="print">public</td>
<td class="print">16-08-2016 16:32</td>
<td class="print">12-12-2016 20:22</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Jacob Wieland - Spirent</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.9.1 (published 2017-05)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.9.1 (published 2017-05)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">6.2.5, 6.3.2.4, A.1.5.0</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Spirent - Jacob Wieland</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0007493: Add Wrapper-Union capability to
the standard</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">CR 7421 can be resolved if a special union
modifier is introduced which adds type compatibility between union types
and the type of one of their alternatives which is declared with this
modifier.<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007421</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></span> </td>
<td class="print">Part 09: Using XML with TTCN-3 </td>
<td class="print">How to achieve full backward compatibility in case of
element- and/or type-substitution </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7493.docx (172,624) <span class="italic">17-08-2016
10:01</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3467&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7493v2.docx (175,366) <span class="italic">19-08-2016
11:35</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3497&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7493v3.docx (178,269) <span class="italic">11-09-2016
17:13</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3509&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7493v4.docx (178,732) <span class="italic">19-10-2016
14:47</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3512&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7493v5.docx (178,706) <span class="italic">15-11-2016
10:03</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3517&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7493v6.docx (207,265) <span class="italic">15-11-2016
15:15</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3524&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-08-2016 16:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-08-2016 16:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007421</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-08-2016 16:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-08-2016 16:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 10:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR7493.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 10:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014122</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 10:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 10:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 10:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014127</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 10:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 10:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 10:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 10:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 10:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">closed =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 10:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 10:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 10:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 10:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 11:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core
Language</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 11:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 11:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 11:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.9.1 (published 2017-05)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 11:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 11:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.9.1 (published 2017-05)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 11:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-08-2016 08:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014163</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-08-2016 08:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-08-2016 08:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-08-2016 08:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-08-2016 08:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-08-2016 08:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-08-2016 08:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0014163</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14163#r317</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-08-2016 08:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0014163</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14163#r318</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-08-2016 08:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0014163</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14163#r319</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-08-2016 11:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR7493v2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-08-2016 11:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014176</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-08-2016 11:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-08-2016 11:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-08-2016 11:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">06-09-2016 07:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014200</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-09-2016 16:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-09-2016 16:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014204</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-09-2016 16:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-09-2016 16:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-09-2016 17:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7493v3.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-09-2016 17:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-09-2016 17:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-09-2016 10:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014205</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-09-2016 10:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-09-2016 10:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014206</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-09-2016 07:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014207</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-09-2016 09:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014208</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">25-09-2016 17:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014210</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">26-09-2016 09:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014211</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">26-09-2016 09:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014214</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-09-2016 13:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014215</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-09-2016 08:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014216</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-10-2016 14:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7493v4.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-10-2016 14:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014220</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-11-2016 12:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-11-2016 12:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014227</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-11-2016 10:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR7493v5.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-11-2016 10:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014239</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-11-2016 10:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-11-2016 10:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-11-2016 15:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR7493v6.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-11-2016 15:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014252</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-11-2016 15:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-11-2016 15:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-11-2016 15:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-12-2016 19:58</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014396</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-12-2016 20:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014397</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-12-2016 20:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-12-2016 20:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0014396</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14396#r342</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-12-2016 20:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Deleted: 0014397</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014122)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-08-2016 10:02   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">please review</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014127)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-08-2016 10:47   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">The proposed solution resolves the CR and it is ready
to be included into the next version of the core language
specification.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0014163)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-08-2016 08:31   <br />
(edited on: 19-08-2016 08:43)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">While the solution technically is fine, its
explanation is not aligned with the definitin how union is defined in
TTCN-3; we define union as a set of possible choices, and thus the
meaning of the sentence "declared as wrapped by using the @wrapped
modifier..." doesn't sound obvious. I would prefer "declared as the
default choice when no altetnative is explicitly identified by using the
@default modifier...".<br />
As you note in the example,<br />
v_age := 34; shall automatically select the choice "number" and thus is
the same as writing v_age := { number := 34 };<br />
<br />
The meaning of @default is also more intuitive when seen in a union type
declaration.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014176)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-08-2016 11:38   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF discussion: accept Gyorgy's proposal using
@default instead of @wrapped.<br />
<br />
I recoined the termini 'wrapped alternative' to 'default alternative'
and 'wrapped union' to 'union with default alternative' and reformulated
the text accordingly.<br />
<br />
Hopefully, this is now clearer.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014200)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">06-09-2016 07:37   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Am I correct that this also applies to
expressions?<br />
<br />
Like:<br />
type union U1 <a href="mailto:%7B@default">{@default</a> integer
i};<br />
type union U2 <a href="mailto:%7B@default">{@default</a> integer j,
boolean b};<br />
var U1 v_var1 := 1;<br />
var U2 v_var2 := 2;<br />
var integer v_var3 := v_var1 + v_var2; // this should be correct since
we are adding 2 integers (after the automatic unboxing).<br />
var bitstring v_var4 := v_var1 + "something"; // this should be an error
since an integer can not be added to a characterstring (v_var1 is an
integer after unboxing)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014204)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-09-2016 16:30   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Reopening: we should add some more examples for the
interesting cases.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014205)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-09-2016 10:49   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I take issue with two of the additional
examples:<br />
<br />
1)<br />
<br />
log(v_u4); // results in “true” instead of “{ b:=true}” logged,<br />
       // resolving to the long notation happens before parameter
passing.<br />
<br />
It should be the other way around. v_u4 *is* equal to { b := true } and
therefore, that is what is being logged. The shorthand was only used in
the assignment.<br />
<br />
2)<br />
<br />
log(v_u32); // test case error as “v_u32” would be treated as
v_u32.i,<br />
        // which is not the selected alternative<br />
<br />
This is in my opinion plainly wrong. v_u32 is a union and therefore,
whatever alternative is chosen in the union, that one will be reflected
when using it as rhs-expression or logging it. The implicit unwrapping
only happens when necessary,i.e. when the demanded type is only
compatible with the default alternative but not with the union. The
log-statement has no such restrictions.<br />
This example could be changed to:<br />
<br />
log(integer:v_u32)<br />
<br />
There, the demanded type becomes integer and thus forces unwrapping. If
the default alternative is not chosen, that would then lead to an error.
If it is chosen, then only the unwrapped value would be logged, not the
whole union.<br />
<br />
That means, this statement is equivalent to:<br />
<br />
log(integer:v_u32.i)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014206)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-09-2016 10:50   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">also, there is a v_u5 in the comment which should
probably v_u4, i.e. a typo</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014207)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-09-2016 07:24   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Could go that way too.<br />
We just need to clarify, what happens when.<br />
<br />
Log is just a good example as it is a notoriously hard situation for it
does not provide a context.<br />
Raising the question: is this really a short hand, or not, or just in
some cases and not in others.<br />
Do we want the to apply the short-hand resolution before the expression
is evaluated, or not.<br />
for example:<br />
- log(v_u32 + v_u32 + v_u32) is an integer because v_u32 is a shorthand
for an integer (and if the other branch is selected this results in
testcase error).<br />
- log(v_u32 + v_u32) ... still logs an integer as v_u32 is a shorthand
for an integer ...<br />
- log (v_u32) ... is a union ... inspite of being an integer everywhere
else?<br />
- log((v_u32)) ... is an integer because of the brackets?<br />
<br />
I believe we need to specify exactly when it is a shorthand and when it
is not, otherwise it leaves too much room for interpretation ... and
users will also not like if the code will work with unexpected
types.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014208)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-09-2016 09:28   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I would say that in an operand-position which implies
the type (or possible types) of the operand, it is a shorthand
notation.<br />
<br />
In a context-less position, it is never a shorthand notation.<br />
<br />
Basically, it is only a shorthand notation whenever it cannot be used as
the long value, i.e. either there is no context, then the long value is
applicable, or there is a type-context that demands the union type
itself, then it is the long version, otherwise, it is the
unwrapped/short version in case that is compatible with the demanded
type context.<br />
<br />
Since simple parantheses don't supply any additional type context, the
statements log(x) and log((x)) are semantically the same and will both
log the long version of x.<br />
<br />
Interesting are the comparison operators where you could get in very
complex situations. Here, it is imperative to first check for compatible
long-versions and, if they are not compatible, you need to check whether
there is an unambiguous interpretation of a combination of long/short,
short/long or short/short interpretations of the operands so that they
can actually be compared, i.e. have a compatible root type.<br />
<br />
All this is implicitly already described by the type-compatibility rules
and the operators that require them.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014210)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-09-2016 17:19   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Wouldn't it be more "KISS" compatible to simply say
that it is everywhere a shorthand notation, also noting that actual
implementation might optimize the unboxing-boxing when they can?<br />
<br />
That way:<br />
- the rules would be much simpler and general. The meaning of a
reference (for example v_u32) would be the same irrespective of what
happens to be the context, what happens to be the type of the formal
parameter, etc...<br />
- there would be no need for new type compatibility. Since consistent
unboxing-boxing does not need it (yet allows such implementation if that
is safe and better performing).<br />
- implementation itself would also be simpler, since there is no complex
logic needed to be checked based on context, types and type
compatibilities.<br />
- when the time comes for debugging/maintenance, this would be one thing
less to worry about: the same thing happens everywhere, while otherwise
one would also need to check the context, usage and in case it is used
in calling a function there would be no need to manually check the
formal parameter list of the function (in the current for we have to mix
and match the formal and actual parameters to understand where will the
boxing/unboxing happen).<br />
<br />
Admittedly this would mean that resolving the shorthand notation comes
first, before passing to the log statement, to make it work consistently
everywhere.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014211)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">26-09-2016 09:24   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">On the meta-level, I have no idea what
"KISS"-compatibility means.<br />
<br />
Also, I'm sorry, but I don't understand what you are proposing here, so
please read what I am writing next with that in mind.<br />
<br />
If a right-hand-side reference to a union variable v with a default
alternative a is ALWAYS expanded to its long form v.a, then how am I
supposed to access v.b? Same argument applies to the left-hand-side. If
it is always first expanded, then how am I supposed to set a different
alternative than a? If I wanted something that is always just the type
of a, I would use that type instead of the union with default
alternative.<br />
<br />
Also, it would be weird that a variable behaves differently in regard to
wrapping, depending on what alternative is chosen. Logging a union
variable should not fail if a non-default alternative is chosen in
it.<br />
<br />
So, while your proposal might make the life of the implementer simpler
(though I don't see yet, how), it will definitely make the life of the
user very much harder as these unions cannot be used in the normal way
that they are used to anymore, but behave totally differently.<br />
<br />
As the proposal is today, resolving where the short form is to be
expanded can be done statically from type-information at compile-time,
so the compiler will probably already replace all short-forms with their
respective long-forms before generating code and no additional
runtime-effort is needed at all.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014214)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">26-09-2016 09:44   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Now I have found out what the KISS-principle means and
I think my proposal is very much on par with it.<br />
<br />
Basically, the rule is pretty straightforward and simple:<br />
 <br />
A union with a default alternative behaves like every other union except
in those places where the usage of that union would be a semantic error
(under normal union rules), so these previous error-cases get a semantic
meaning.<br />
And in those cases, the usage is only allowed if the usage of the
default alternative would not be an error and then it is interpreted as
a short-form of the unwrapped default alternative.<br />
<br />
The first part of this is to adhere to the "principle of least
surprise". If a thing is defined as a union, that semantics should come
first.<br />
The next is semantic robustness: code that worked with a union type
without a default alternative will work the same way if one of the
alternatives is later changed to be default.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014215)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">28-09-2016 13:52   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">in the case of using variable v with a default
alternative I meant that "v.a" and "v.b" would still be possible, but
when there is only "v" as the whole reference it could be treated as
"v.a". So it would always be possible to reach other alternatives and
read/assign value to them.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014216)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-09-2016 08:38   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">But that does not work in those cases where v is used
in its capacity as a union value (i.e. assigned to a union variable,
used as actual union parameter, compared with another union
variable/constant, matched against union template, etc.).<br />
<br />
So, all these currently normal cases would suddenly become the
exceptional cases while the few instances (log, receive, send
statements) where no type is required would behave differently.<br />
<br />
Also, it would be weird that log(v) works differently in case that v.a
is chosen than when v.b is chosen. If you replace the v with v.a at
compile time, it would be an error, if actually b is chosen in v at
runtime. Otherwise, you obviously have to not replace it at compile-time
and do runtime-checking instead. The same applies for all other untyped
places. I really don't see the simplicity in that.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014220)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-10-2016 14:49   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Yes, we could have some special treatment for this in
log statements, when it is not used in an expression (that would force
the unwrapping).</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014227)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-11-2016 12:50   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">please review</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014239)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-11-2016 10:04   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">changed 'shall' in NOTE 3 to 'will'.<br />
<br />
Otherwise, ok, please review and resolve.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014252)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-11-2016 15:27   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I reviewed the proposal an made one cosmetic
correction. The proposal contains reasonable changes and can be added to
the next version of the core language standard.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0014396)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-12-2016 19:58   <br />
(edited on: 12-12-2016 20:22)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Added to V4.8.2.<br />
Note 2 of 6.3.2.4 is extracted to a mandatory text, as in fact it
specifies a requirement (order of using the rules for compatibility
checking).<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
