  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Ext Pack: Advanced Matching (ES 203 022)
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0007167</td>
<td class="print">Ext Pack: Advanced Matching (ES 203 022)</td>
<td class="print">New Feature</td>
<td class="print">public</td>
<td class="print">07-09-2015 10:53</td>
<td class="print">24-12-2016 12:59</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Tomas Urban</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Jens Grabowski</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v1.1.1 (published 2017-07)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v1.1.1 (published 2017-07)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">B.1.3</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Elvior</td>
<td></td>
</tr>
<tr class="even print">
<td class="print-category">TS version</td>
<td colspan="4" class="print"></td>
<td></td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0007167: Matching mechanism to match
multiple items in arrays, records and sets of single types</td>
</tr>
<tr class="odd print">
<td class="print-category">Description</td>
<td colspan="5" class="print">I one of our projects we had an
interesting problems with matching incoming messages. The message
contained a record of complex record entries and one of the string
fields of each record element was required to contain a certain
pattern.<br />
<br />
We ended up with using a rather complicated solution containing a check
procedure (for general acceptance), for-loop for element check and
continue statement + some guards for flow control.<br />
<br />
However, it would be nice if TTCN-3 contained a matching mechanism that
would allow to specify properties of SEVERAL record of, set of or array
items. Such a mechanism would be generally similar to AnyElementsOrNone
with that difference that it would impose additional restrictions on the
element content. Similarly to the AnyElementsOrNone, it could be
optionaly ammended with a length restriction.<br />
<br />
Possible syntactical solutions:<br />
The following type is used in examples:<br />
type record of record {<br />
   integer field1,<br />
   charstring field2<br />
} RoR;<br />
<br />
<br />
1. Extension of the AnyElementsOrNone mechanism:<br />
   a. using the with keyword:<br />
      {<br />
         // standard field match (fixed values)<br />
         { field1 := 3, field2 := pattern "test" },<br />
         // 0..N matches where field2 of each element has to start with
"abc"<br />
         * with { field1 := ?, field2 := pattern "abc*" }<br />
      }<br />
   b. using the pattern keyword:<br />
      {<br />
         // standard field match (fixed values)<br />
         { field1 := 3, field2 := pattern "test" },<br />
         // 0..N matches where field2 of each element has to start with
"abc"<br />
         * pattern { field1 := ?, field2 := pattern "abc*" }<br />
      }<br />
2. Using the any keyword:<br />
      {<br />
         // standard field match (fixed values)<br />
         { field1 := 3, field2 := pattern "test" },<br />
         // 0..N matches where field2 of each element has to start with
"abc"<br />
         any { field1 := ?, field2 := pattern "abc*" }<br />
      }<br />
</td>
</tr>
<tr class="even print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Tags</td>
<td colspan="5" class="print"><a
href="tag_view_page.php?tag_id=1">technically agreed</a></td>
</tr>
<tr class="odd print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007174</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></span> </td>
<td class="print">New matching mechanism: matching by function </td>
</tr>
<tr class="even">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007494</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></span> </td>
<td class="print">TRI and TCI extensions for advanced matching </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7167-1.docx (170,009) <span class="italic">15-11-2016
14:49</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3523&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7167-2.docx (156,818) <span class="italic">17-11-2016
09:54</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3548&amp;type=bug</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="odd print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-09-2015 10:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-09-2015 16:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013193</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-09-2015 10:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.8.1 (ongoing)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-09-2015 11:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007174</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-09-2015 11:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0013200</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-09-2015 11:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0013200</td>
<td class="print">bug_revision_view_page.php?bugnote_id=13200#r167</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">22-09-2015 09:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Tag Attached: technically agreed</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">22-09-2015 09:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0013232</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">22-09-2015 09:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">22-09-2015 09:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">23-09-2015 15:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013275</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-09-2015 15:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013276</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">23-09-2015 15:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-09-2015 15:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-11-2015 11:58</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0013466</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">03-11-2015 11:58</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">v4.8.1 (ongoing) =&gt; Next version (to be
defined)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-11-2015 11:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Project</td>
<td class="print">Part 01: TTCN-3 Core Language =&gt; Ext Pack: Advanced
Matching (ES 203 022)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-11-2015 11:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Product Version</td>
<td class="print">v4.7.1 (published 2015-06) =&gt;</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-11-2015 11:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">Next version (to be defined) =&gt; v1.1.1 (published
2017-07)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-12-2015 10:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-07-2016 14:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-07-2016 14:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-08-2016 13:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-11-2016 14:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR7167-1.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-11-2016 14:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014251</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-11-2016 14:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-11-2016 14:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-11-2016 14:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007494</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2016 09:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR7167-2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2016 09:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2016 09:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014290</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2016 09:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2016 09:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2016 12:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2016 12:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-12-2016 12:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-12-2016 12:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v1.1.1 (published 2017-07)</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013193)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">07-09-2015 16:23   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Obviously, every idea has its time. I have been
pondering the same problem for a while and wanted to propose some sort
of repeat-statement (where * is just a very special repeat of ? with no
length restriction.<br />
<br />
Ideas of mine were:<br />
<br />
A * [length(L..U)] (where A is a matching mechanism) - similar to
BNF<br />
<br />
or<br />
<br />
A repeat [length(L .. U)]<br />
<br />
or<br />
<br />
repeat (A1, ..., An) [length(L .. U)]<br />
<br />
<br />
The existing AnyElementsOrNone (*) would then just be a shorthand of ? *
(or the other ways).<br />
<br />
We could also borrow the #-repetition from the pattern-language (to have
in-language-familiarity for similar constructs), i.e.<br />
<br />
A # ([lower], [upper]) with A #(,) being the same as A*.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0013200)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-09-2015 11:49   <br />
(edited on: 21-09-2015 11:50)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">alternatively repetition of a template element could
be allowed, like:<br />
<br />
{{field1 := 3, field2 := pattern "test" }} this will match a record/set
of with one element only<br />
<br />
{{ field1 := 3, field2 := pattern "test"} length(0..infinity)} this will
match a record/set of with any number of elements, each obeying the
inline template.<br />
<br />
Please note, the syntax is already allowed, in this case we need to
amend only the text in clause B.1.4.1, especially Restriction a).<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013232)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">22-09-2015 09:38   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF discussion: to specify repetitions of record/set
of elements we shall reuse the #(n,m) [#(), #(n,)...) syntax from
patterns. This will be language consistent and also allows defining
different "subsets" of element repetitoons within a list. Exanmples of
the syntax to be prepared for te different cases, e.g. record of record
of record, combinations with length() etc.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013275)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">23-09-2015 15:15   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Syntactical Structure shall be:<br />
<br />
ArrayElementSpec ::= Minus |<br />
                          PermutationMatch |<br />
                          TemplateBody [Repetition]<br />
<br />
Repetition ::= "#" "(" [SingleExpression] ["," [SingleExpression]]
")"<br />
<br />
If Repetition is present, the TemplateBody must be of the same root
record of type as the surrounding template (i.e. if it is of root type
record of T, the repeated template must also be of root type record of
T).<br />
<br />
This allows (for the Repetition part):<br />
#() - 0 .. infinity,<br />
#(x) - x .. x,<br />
#(x,) - x .. infinity,<br />
#(x,y) - x .. y,<br />
#(,y) - 0 .. y,<br />
#(,) - 0 .. infinity (if we want to exclude this possibility, the rule
becomes more complicated)<br />
<br />
The special BNF constructs {}, [] and {}+ can be modeled with #(), #(,1)
and #(1,) respectively.<br />
<br />
EXAMPLE:<br />
<br />
type record of T S;<br />
template T a, b, c;<br />
template S s1 := { a, b, c }<br />
template S s2 := { permutation(a, *, c) length(5) }<br />
var integer x, y;<br />
<br />
template S t1 := { {a, b, c} #(x,y) }<br />
// matches any record of repeating elements matching a, b, c
consecutively<br />
// for at least x, at most y times.<br />
<br />
template S t2 := { s1 #(x,y) } // same as t1<br />
<br />
template S t3 := { { (a, b, c) } # (x) }<br />
// matches any repetition of length x where each element conforms
to<br />
// (a, b, c) (i.e. a or b or c).<br />
<br />
template S t4 := { (s1, s2) #(x,y) }<br />
// matches a sequence that can be partitioned into x up to y<br />
// sub-sequences where each sub-sequence matches s1 or s2.<br />
<br />
template S t5 := { p, {s1 #(0,1), s2 #(1,)} #(x), q }<br />
// matches a record of where first element matches p,<br />
// then is followed by a repetition of length x of a<br />
// repetition of an optional s1-sub-sequence followed by<br />
// a non-empty repetition of s2-sub-sequences and finally followed
by<br />
// an element matching q.<br />
<br />
template S t6 := { s1 &amp; s2 #(5) }<br />
// matches a record of which can be partititioned into 5
sub-sequences<br />
// where each-sub-sequence matches the concatenation-template s1 &amp;
s2.<br />
<br />
As we can see, it is very easy to compose such templates from other
templates and to combine it with existing matching mechanisms.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013276)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">23-09-2015 15:27   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">please review examples in my last note</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013466)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">03-11-2015 11:58   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">To be part of the new extension on advanced matching
mechanisms.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014251)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-11-2016 14:50   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Proposal uploaded. Please check.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014290)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-11-2016 09:55   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Please review.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
