  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 09: Using XML with TTCN-3
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0006752</td>
<td class="print">Part 09: Using XML with TTCN-3</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">25-04-2014 08:54</td>
<td class="print">20-12-2016 09:07</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Tomas Urban</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">N/A</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.5.1 (published 2013-04)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.8.1 (published 2017-05)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.8.1 (published 2017-05)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">7.5.3</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">For STF discussion</td>
<td colspan="4" class="print"></td>
<td></td>
</tr>
<tr class="even print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">STF 475</td>
<td></td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0006752: Rules for transformation of
enumerated facet applied to union content</td>
</tr>
<tr class="odd print">
<td class="print-category">Description</td>
<td colspan="5" class="print">It is not obvious what rules were applied
in the example 5 to generate the constraint. In particular, it seems
that the enumerated values are converted to random alternatives of the
union type that is being constrained. The textual order doesn't seem to
be used, because in that case all values would fit to the first
alternative, i.e. alt_ generated from xsd:string.<br />
<br />
However, even with correct textual order, the constraint is too
restrictive, because only one constraint item is generated per XSD
enumeration value. The correct approach would be to generate constraint
items for all alternatives for which the XSD enumeration value is
syntactically correct. In the given case transformation should
yield:<br />
<br />
type E21unnamed E22 ({alt_:="20"}, {alt_1:=20.0}, {alt_1:=20},
{alt_:="50"}, {alt_1:=50.0}, {alt_1:=50}, {alt_:="small"})<br />
with {<br />
    variant "name as uncapitalized"<br />
}<br />
<br />
In my opinion, this procedure is so complicated and includes certain
amount of interpretaion that it should be described in the specification
as a binding rule.<br />
<br />
Besides, the example itself is not a very good one since the processing
order requires that strings are always processed first meaning that
float and integer values cannot ever be successfully decoded. In order
to fix that, the order of items in the parent union should be
reversed.</td>
</tr>
<tr class="even print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="odd print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">has duplicate</span> </td>
<td class="print">0006766</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></span> </td>
<td class="print">enumeration facet applied to a
union-simple-type-derivation should yield an enumeration type </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6752_resolution_v1.doc (115,200) <span
class="italic">11-12-2014 13:27</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3195&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6752_resolution_v2.docx (72,576) <span
class="italic">06-11-2015 10:57</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3371&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6752_resolution_v3.docx (73,277) <span
class="italic">10-11-2015 15:28</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3372&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6752_resolution_v4.docx (74,058) <span
class="italic">22-12-2015 08:26</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3396&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6752_resolution_v5.docx (59,285) <span
class="italic">14-11-2016 10:00</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3514&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6752_resolution_v6.docx (61,056) <span
class="italic">15-11-2016 09:29</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3515&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR6752_resolution_v7.docx (61,755) <span
class="italic">16-11-2016 13:21</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3535&amp;type=bug</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="odd print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">25-04-2014 08:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">25-04-2014 09:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012054</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-06-2014 15:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0006766</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">13-06-2014 15:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.6.1 (published 2015-06)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-06-2014 17:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-06-2014 17:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-11-2014 09:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Relationship replaced</td>
<td class="print">has duplicate 0006766</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-12-2014 15:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012538</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-12-2014 13:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR6752_resolution_v1.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-12-2014 13:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012540</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-12-2014 13:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-12-2014 13:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-12-2014 22:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012542</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-12-2014 09:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012547</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-12-2014 09:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-12-2014 14:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012586</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-12-2014 14:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">v4.6.1 (published 2015-06) =&gt; v4.7.1 (published
2016-07)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-08-2015 12:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013083</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-08-2015 12:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-08-2015 14:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013150</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-08-2015 09:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013151</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-11-2015 08:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Axel Rennoch</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">06-11-2015 10:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">File Added: CR6752_resolution_v2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-11-2015 15:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">File Added: CR6752_resolution_v3.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-11-2015 15:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Note Added: 0013520</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-11-2015 15:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Assigned To</td>
<td class="print">Axel Rennoch =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-11-2015 15:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-11-2015 10:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013535</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">23-11-2015 10:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Axel Rennoch</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-11-2015 10:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">22-12-2015 08:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR6752_resolution_v4.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">22-12-2015 08:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">22-12-2015 12:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013647</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">22-12-2015 12:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">22-12-2015 12:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.7.1 (published 2016-07)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">22-12-2015 12:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">22-12-2015 12:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Axel Rennoch =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-01-2016 16:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0013657</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-01-2016 16:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-01-2016 08:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0013657</td>
<td class="print">bug_revision_view_page.php?bugnote_id=13657#r259</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-01-2016 08:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-01-2016 08:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-01-2016 08:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-01-2016 08:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0013657</td>
<td class="print">bug_revision_view_page.php?bugnote_id=13657#r260</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-01-2016 08:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0013657</td>
<td class="print">bug_revision_view_page.php?bugnote_id=13657#r261</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-01-2016 10:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013659</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-07-2016 11:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-07-2016 11:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 12:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Fixed in Version</td>
<td class="print">v4.7.1 (published 2016-07) =&gt;</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 12:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Target Version</td>
<td class="print">v4.7.1 (published 2016-07) =&gt; v4.8.1 (published
2017-05)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-11-2016 10:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR6752_resolution_v5.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-11-2016 09:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR6752_resolution_v6.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-11-2016 09:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Axel Rennoch</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-11-2016 09:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014234</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-11-2016 13:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">File Added: CR6752_resolution_v7.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-11-2016 13:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">File Deleted: CR6752_resolution_v7.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-11-2016 13:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">File Added: CR6752_resolution_v7.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-11-2016 13:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Note Added: 0014264</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-11-2016 13:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Assigned To</td>
<td class="print">Axel Rennoch =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-11-2016 13:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-12-2016 09:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014463</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-12-2016 09:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-12-2016 09:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.8.1 (published 2017-05)</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012054)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-04-2014 09:33   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">There is one additional problem with float values
occuring in the enumerated facets restricting union content. In this
particular case, the schema validation procedure expects exactly the
same value string as specified in the enumeration facet. This is
different from a enumerated facets restricting a float type where
validation is based on the value itself and the format doesn't
matter.<br />
<br />
The issue occurs in the moment when the XML codec tries to encode this
kind of union value. Since there's no encoding information regarding the
expected textual format of the produced float value, the codec can pick
any of the suitable float formats. This format doesn't have to match the
value defined in the enumeration facet and that will lead to an XML
document validation error. E.g. in the example 5, the required value is
without the decimal point (50), but XML codecs are likely to produce a
value with the decimal point (50.0).</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012538)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-12-2014 15:35   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The comment is correct. I think that the example
itself is an exotic case, therefore we need to seek for the simplest
solution. From this point of view, defining extra conversion rules, as
proposed in CR6766 (at least one for enumeration restrictions containing
a string alternative and one for the restrictions not containing a
string alternative), would overdo it.<br />
<br />
Tomas is correct, in the TTCN-3 type restriction we need to store the
syntax in the enumeration facets and leave the rest for the codec. This
would make it easer for the user as well, as the decoder, after
validation, can put the received value into the alternative in the type
restriction. I'm going to write a proposal and add one more example,
where numeric alternatives are the first.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012540)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-12-2014 13:28   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Please review: CR6752_resolution_v1.doc.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012542)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-12-2014 22:27   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I still don't see the merit of this over-complicated
mapping. If the range of values the type is being restricted to is a
simple enumeration, why not map it to an enumeration type? Just because
there is a subtyping relationship inside XSD does not mean there has to
be one in XML and since the enumeration facets do not carry the type
information (which union variant they belong to), this does not even
have to be transported into TTCN-3.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012547)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-12-2014 09:11   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">The proposal is technically correct and could be added
into the next version of the specification. However, I think that before
we make a final decision, we should consider Jacob's proposal as well.
In my opinion, it would be indeed more suitable to transforms unions
restricted with the enumeration facet into a simple enumerated type
using the string values. That would be much easier to implement and
simpler to understand from the user point of view.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012586)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-12-2014 14:59   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">OK, in this case we have to shift the CR to the next
version in 2015.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013083)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">05-08-2015 12:00   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I'll just unconfirm this CR and assign it to Gyorgy to
respawn the discussion.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013150)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">07-08-2015 14:34   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Augmenting my proposal, I propose to map a union with
an enumeration facet to the following structure:<br />
<br />
type record {<br />
  enumerated { noType, &lt;member_type_1_id&gt;, ...,
&lt;member_type_n_id&gt; } xsiType,<br />
  enumerated { &lt;enum_value_1&gt;, ..., &lt;enum_value_m&gt; }
content<br />
}<br />
<br />
This way, the respresentation of an xsd union value is a pair { xsiType
:= id, content := id2 }<br />
<br />
By giving a type enum value other than noType, the encoder will use the
corresponding type in the xsi:type attribute of the element containing
content of this simple type.<br />
<br />
For matching, ? can be used if the type is irrelevant.<br />
<br />
This mapping solves the problem of normalization (if a float is
restricted to a certain representation via the enumeration facet, the
decoder knows for every such representation which enumeration value to
map it to or from).<br />
<br />
The corresponding templates look very similar if given in list
form:<br />
<br />
{ t, v } instead of { t := v }</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013151)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-08-2015 09:00   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">even better would be, of course:<br />
<br />
type record {<br />
  enumerated { &lt;member_type_1_id&gt;, ..., &lt;member_type_n_id&gt; }
xsiType optional,<br />
  enumerated { &lt;enum_value_1&gt;, ..., &lt;enum_value_m&gt; }
content<br />
}<br />
<br />
The presence of the xsiType field would then indicate also the presence
of the xsd:type attribute.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013520)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-11-2015 15:30   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Please have a look to the modified text and example in
resolution_v3.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013535)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">23-11-2015 10:47   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">sorry, but I think it needs more elaboration.<br />
<br />
The names of the xsiType enumerated values should be the same names as
the alternatives in the other union-mappings (i.e. if it is a union
containing anonymous simple types, it should be alt_1 etc. for these,
only for referenced types (in the memberTypes attribute), the referenced
type names shall be used - same as in other union).<br />
<br />
This, of course, will also change the example.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013647)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">22-12-2015 12:01   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">For me, the text is ok.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0013657)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-01-2016 16:46   <br />
(edited on: 05-01-2016 08:40)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I have found a problem with this resolution: in this
mapping:<br />
type record E22 {<br />
  enumerated {alt_, alt_1, alt_2} xsiType optional,<br />
  enumerated {x20, x50_0, small_1} content<br />
}<br />
with {<br />
    variant "name as uncapitalized";<br />
    variant "element";<br />
    variant "useUnion";<br />
    variant(alt_, alt_1, alt_2) "name as ''";<br />
}<br />
<br />
there is no implicit or explicit reference to the base type e21unnamed;
therefore the XSD types of the enumerated names alt_, alt_1_ &amp; alt_2
are not known at encoding, while they are needed for the xsi:type
attribute of the XML value.<br />
<br />
An option could be to use the XSD type names directly as enumeration
names; Also, the exact names of the XSD enumeration values should be
given explicitly, where the TTCN-3 name mangling changes them,
e.g.:<br />
type record E22 {<br />
  enumerated {float_, integer_, string} xsiType optional,<br />
  enumerated {x20, x50_0, small_1} content<br />
}<br />
with {<br />
    variant "name as uncapitalized";<br />
    variant "element";<br />
    variant "useUnion";<br />
    variant (xsiType) "text 'float_' as 'float'";<br />
    variant (xsiType) "text 'integer_' as 'integer'";<br />
    variant (content) "text 'x20' as '20'";<br />
    variant (content) "text 'x50_0' as '50.0'";<br />
    variant (content) "text ' small_1' as ' small-1'";<br />
}<br />
<br />
In this case the useUnion instruction shall behave quite differently
from the "basic case", specified currently in clause B.3.16. Thus B.3.16
shall be revised and extended with the description of this specific
case.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013659)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">05-01-2016 10:29   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I agree, this would be a good approach.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014234)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-11-2016 09:31   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">please review</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014264)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel
Rennoch</a>   </td>
</tr>
<tr class="odd">
<td class="print">16-11-2016 13:21   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">correction of example 5</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014463)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-12-2016 09:07   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Added to draft V4.7.2</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
