  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0006690</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">New Feature</td>
<td class="print">public</td>
<td class="print">17-02-2014 16:01</td>
<td class="print">28-07-2014 16:43</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Wolfgang Seka</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">urgent</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.6.1 (published 2014-06)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.6.2 (interim 2014)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.6.2 (interim 2014)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">B.1.5, C.4.1</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">MCC160 - Wolfgang</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0006690: Case insensitive pattern
matching</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">there is an issue with text based
protocols:<br />
<br />
E.g. SIP is widely case insensitive. But when looking at existing
implementation this is not handled in TTCN.<br />
Of course it could be handled by codec (e.g. by converting all case
insensitive strings to lower case) but that seems to be not the best
solution as there are still case sensitve strings and it may be hard to
find generic criteria for the codec implementation. Furthermore it seems
to be not a good design decision to mandate manipulation of received
strings by codec.<br />
<br />
=&gt; it seems to be better to add means for case insensitive pattern
matching to the TTCN language:<br />
This may be e.g. by enhancement of the "pattern" keyword:<br />
  template (present) charstring v_MyPattern := pattern caseinsensitive
"*AB*"; /* shall match any string containing "AB", "Ab", "aB", "ab"
*/<br />
(Of course this is just an example for how it could be expressed).<br />
<br />
In addition the regexp function may be enhanced by a new parameter as
well to allow case insensitive regular expressions.<br />
 <br />
My questions to you:<br />
1. Can you acknowledge the issue as such ??<br />
2. Is it feasable to add support of case insensitive pattern matching to
the TTCN-3 language ??<br />
3. Assuming the answer to 1./2. is "yes" what can be the time schedule
??</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/generic.gif"
alt="?" /> CaseInsensitivePattern.ttcn (1,054) <span
class="italic">10-04-2014 08:58</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2988&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6690_caseInsensitivePattern_resolution_v1.doc (762,880)
<span class="italic">11-04-2014 11:21</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3014&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6690_caseInsensitivePattern_resolution_v2.doc (763,904)
<span class="italic">11-04-2014 12:35</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3015&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6690_caseInsensitivePattern_resolution_v3.doc (764,416)
<span class="italic">16-06-2014 09:13</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3028&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR6690_caseInsensitivePattern_resolution_v4.doc (764,416)
<span class="italic">17-06-2014 15:42</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3038&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-02-2014 16:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang
Seka</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-02-2014 09:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0011925</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-04-2014 13:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core
Language</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-04-2014 14:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0011939</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">07-04-2014 14:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">07-04-2014 14:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-04-2014 13:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0011958</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-04-2014 13:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-04-2014 17:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Product Version</td>
<td class="print">=&gt; v4.6.1 (published 2014-06)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-04-2014 17:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.7.1 (published 2015-06)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-04-2014 12:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Priority</td>
<td class="print">high =&gt; urgent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">09-04-2014 13:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011972</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">09-04-2014 13:33</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0011972</td>
<td class="print">bug_revision_view_page.php?bugnote_id=11972#r6</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-04-2014 08:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011980</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-04-2014 08:42</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011981</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-04-2014 08:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0011981</td>
<td class="print">bug_revision_view_page.php?bugnote_id=11981#r8</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-04-2014 08:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011982</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-04-2014 08:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CaseInsensitivePattern.ttcn</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-04-2014 08:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Deleted: CaseInsensitivePattern.ttcn</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-04-2014 08:58</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CaseInsensitivePattern.ttcn</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-04-2014 10:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0011958</td>
<td class="print">bug_revision_view_page.php?bugnote_id=11958#r10</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-04-2014 10:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011988</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-04-2014 11:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011989</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-04-2014 11:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0011990</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-04-2014 11:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0011990</td>
<td class="print">bug_revision_view_page.php?bugnote_id=11990#r12</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-04-2014 11:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012022</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-04-2014 11:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added:
CR6690_caseInsensitivePattern_resolution_v1.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-04-2014 11:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012023</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-04-2014 11:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-04-2014 11:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-04-2014 12:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added:
CR6690_caseInsensitivePattern_resolution_v2.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-04-2014 12:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012024</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-04-2014 12:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-04-2014 12:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-04-2014 12:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-04-2014 14:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0012040</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-04-2014 14:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-04-2014 14:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-04-2014 08:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-04-2014 08:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-06-2014 09:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added:
CR6690_caseInsensitivePattern_resolution_v3.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-06-2014 09:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-06-2014 09:13</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-06-2014 09:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0012074</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-06-2014 09:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-06-2014 15:42</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added:
CR6690_caseInsensitivePattern_resolution_v4.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-06-2014 15:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">v4.7.1 (published 2015-06) =&gt; v4.6.2 (interim
2014)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-06-2014 15:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012109</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-06-2014 15:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-06-2014 15:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.6.2 (interim 2014)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-06-2014 15:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-06-2014 11:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">v4.6.2 (interim 2014) =&gt;</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">28-07-2014 16:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0012207</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">28-07-2014 16:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">28-07-2014 16:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.6.2 (interim 2014)</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011925)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-02-2014 09:25   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Testing Tech agrees that such a feature is necessary.
We have similar problems in other text-based protocols.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011939)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">07-04-2014 14:05   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF agreed, syntactical alternatives will be
investigated by Tomas.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0011958)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-04-2014 13:14   <br />
(edited on: 10-04-2014 10:28)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Possible solutions:<br />
<br />
1. Using an additional modifier after "pattern". The solution is similar
to what was proposed by the reported, but a modifier is used instead of
a keyword in order to avoid problems with name clashes in the existing
test suites. The proposed keyword (caseinsensitive) seems to be too
long, maybe something shorter would be more feasible, e.g. insensitive
or nocase:<br />
pattern @caseinsensitive "*AB*"<br />
pattern @insensitive "*AB*"<br />
pattern @nocase "*AB*"<br />
<br />
//need to be decided if this reference inherits the
case-insensitive-ness or not? If no inheritance, the same template can
be matched both in a case-sensitive and case-insensitive ways:<br />
pattern "{t_pattern}";<br />
pattern @nocase "{t_pattern}";<br />
<br />
Advantages:<br />
- short syntax<br />
- it is obvious from the code what should be achieved<br />
Disadvantages:<br />
- adds a new modifier<br />
- static construction, not possible to insert the modifier
dynamically<br />
<br />
2. Using a dedicated escape sequence in the beginning of the pattern
string, e.g. "\I":<br />
pattern "\I*AB*"<br />
Advantages:<br />
- the shortest alternative to write<br />
- no changes in the general TTCN-3 syntax<br />
- the escape sequence can be added dynamically to the pattern<br />
Disadvantages:<br />
- meaning is not obvious without detailed knowledge of TTCN-3 regular
expression syntax<br />
- possibility of backwards compatibility issues (although \I doesn't
represent any metacharacter, it might still be present in existing
patterns being interpreted as "I")<br />
<br />
3. Using additional parameter of a chosen type (e.g. of a bitstring type
restricted to certain length) following the pattern string:<br />
pattern "*AB*" variant CASE_INSENSITIVE; // where CASE_INSENSITIVE is
defined as const bitstring CASE_INSENSITIVE := '10000000'B;<br />
Advantages:<br />
- the content of the parameter part can be dynamic<br />
- allows future extensions and combinations of parameters using bitwise
logic (similar to regular expressions in java, C#): pattern "*AB*"
variant CASE_INSENSITIVE or4b FUTURE_PARAMETER<br />
- with parameters defined as useful values (similar to port status
strings defined in E.2.2.4), the meaning is obvious to unskilled
reader<br />
- no new keyword/modifier<br />
Disadvantages:<br />
- long syntax<br />
- adding new useful values poses a risk of name clashes<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0011972)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">09-04-2014 13:19   <br />
(edited on: 09-04-2014 13:33)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Thanks for the good analysis. I agree with it, just
some additions:<br />
<br />
Option 1, Disadvantages<br />
in all cases it is possible to reference a case insensitive pattern from
a case sensitive one, and vice versa; in option 1 its semantic is a
matter of decision, but because of e.g. email addresses, URN-s embedded
in a case sensitive environment, probably we will need to preserve the
case sensitive-ness of the referenced patterns. (Btw. it may become a
problem, how to identify case-insensitive fragments of patterns in
logs)<br />
Do we need a more dynamic construction mechanism than this?<br />
Please note, that in POSIX(like) regex implementations case
sensitive-ness causes additional complications, therefore dynamic
construction should be kept at the minimum necessary level.<br />
<br />
Option 3, +Disadvantage<br />
Would overload the meaning of "variant" that is a sub-attribute of the
encode attribute currently.<br />
Or, using the current syntax, it would be<br />
pattern "*AB*" with { variant "CASE_INSENSITIVE" }<br />
that looks less nice and would mix the rather special variant
overwriting rules into the picture.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011980)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-04-2014 08:01   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Mail from Wolfgang (2014-04-09):<br />
Hi György,<br />
<br />
I don't have a strong preference from stf160 point of view:<br />
- in general I'll try to encapsulate issues like case-sensitivity<br />
- I would not expect any name clashes with our test suite (and if so we
can solve them - we don't have frozen code)<br />
- I general I don't have problems with long expressions<br />
<br />
but what is important for me is that we can e.g. define a string as base
to be used in an expression for case sensitive pattern as well as for
case insensitive.<br />
<br />
A typical use case for stf160 would be the GenericParam of ETSI's
"LibSip" which represents the generic-param definition of RFC
3261:<br />
generic-param = token [ EQUAL gen-value ]<br />
gen-value = token / host / quoted-string<br />
and in TTCN:<br />
  type record GenericParam<br />
  {<br />
    charstring id,<br />
    charstring paramValue optional<br />
  }<br />
For this in TTCN we need some generic receive template which currently
is:<br />
  template (present) GenericParam cr_GenericParam(template (present)
charstring p_Id,<br />
                                                  template charstring
p_ParamValue := omit) :=<br />
  {<br />
    id := p_Id, // needs to be declared as case-insensitive<br />
    paramValue := p_ParamValue // needs to be declared as
case-insensitive or quoted string (case-sensitive)<br />
  };<br />
<br />
When looking at the above example it seems to be useful that a given
pattern can be further declared as case-insensitive i.e. that it is not
necessary to declare a pattern as case-insensitive from the
beginning.<br />
So for the above example we would need to "convert" p_Id to be
case-insensitive and to assign to paramValue something like (&lt;case
insensitive variant of p_ParamValue&gt;, """" &amp; p_ParamValue &amp;
"""") =&gt; another aspect could be whether we will have an "inline"
solution or whether we need to go for an explicit definition in which
case we may need to define wrapper functions in TTCN (as e.g. we cannot
define variables in templates)<br />
<br />
Please note that regarding definition of GenericParam we have on-going
discussions to change paramValue to a union of token and quotedString to
avoid dealing with double quotes in TTCN (but that's a different
story)<br />
<br />
Best regards<br />
Wolfgang</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0011981)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-04-2014 08:42   <br />
(edited on: 10-04-2014 08:50)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Gyorgy's answer (2014-04-10):<br />
Hi Wolfgang,<br />
<br />
Thanks for the explanation. It seems that you may possibly need
something to switch the case-insensitive-ness. One problem with this
that, as we discussed up to know, embedding case insensitive fragments
into case sensitive patterns (e.g. email-addresses, URN-s into a case
sensitive string environment) may be needed. But control of
case-sensitiveness could be achieved when referencing values from a
pattern.<br />
<br />
If taking your example, it could be changed to:<br />
<br />
  template (present) GenericParam cr_GenericParam( charstring
p_Id,<br />
                                                  template charstring
p_ParamValue := omit) :=<br />
  {<br />
    id := pattern @nocase "{p_Id}", // "converted to needs to be
declared as case-insensitive<br />
    paramValue := f_processParamValue(p_ParamValue) // needs to be
declared as case-insensitive or quoted string (case-sensitive)<br />
// choice between case sensitive and insensitive matching would need an
additional parameter<br />
  };<br />
<br />
function f_processParamValue(template charstring p_ParamValue) return
template charstring {<br />
   if (ispresent(p_ParamValue)) {<br />
     var charstring t_tmp := valueof(p_ParamValue);<br />
     return pattern @nocase "{t_tmp}"<br />
  }<br />
  else {return omit}<br />
}<br />
<br />
Would something like this be OK with you?<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011982)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-04-2014 08:55   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Wolfgang's example - extended w. switching between
case sensitive and insensitive matching is attached in
CaseInsensitivePattern.ttcn</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011988)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-04-2014 10:35   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF discussion:<br />
at this stage go for the pattern @nocase solution without inhering
case-sensitive-ness property of referenced patterns.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0011989)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-04-2014 11:13   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Mail from Wolfgang (2014-04-10):<br />
<br />
Hi György,<br />
<br />
yes - would be ok for me.<br />
<br />
Best regards<br />
Wolfgang</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0011990)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-04-2014 11:18   <br />
(edited on: 11-04-2014 11:20)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF discussion: The @nocase has to be added to regexp
as well, with the same semantics!<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012022)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-04-2014 11:20   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Fists draft resolution text is in
CR6690_caseInsensitivePattern_resolution_v1.doc.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012023)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-04-2014 11:22   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Pls. review proposed resolution.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012024)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-04-2014 12:37   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The proposed resolution checked. I have found no major
issues, only two small text corrections were made (updated draft
uploaded).<br />
The resolution is ready to be included in the next version of the
language standard.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012040)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-04-2014 14:07   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">there are two typos:<br />
<br />
derefencing (should be dereferencing) and<br />
<br />
'the whole resulted pattern' (must be 'the whole resulting
pattern')</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012074)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">16-06-2014 09:14   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Updated according to Jacob's comments.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012109)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-06-2014 15:59   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Final check OK</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0012207)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">28-07-2014 16:43   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Added to master copy of V4.6.2 (interim 2014)</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
