  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0005671</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">30-08-2010 10:28</td>
<td class="print">20-05-2011 15:51</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">low</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">won't fix</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.1.1 (published 2009-06)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.3.2 (interim 2011)</td>
<td class="print-category">Fixed in Version</td>
<td class="print"></td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">general</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">L.M.Ericssson</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0005671: Bound-unbound should be handled
in a consistent way</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">Curently "boundness" and "unboundness" is
not handled consistently in case of record/set and record/set of
types:<br />
- record ofs with a whole is handled as completely initialized<br />
- records with a "whole" (field is uninitialized) is partly
initialized<br />
<br />
- constants needs not be completely initialized (to be checked and
discus if this was the intention or should be changed)<br />
<br />
- unclear if a not-completely-initialized value/template can be assigned
to a variable (directly, i.e. not participating in an expresion)</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR5671.doc (110,592) <span class="italic">02-09-2010
11:02</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2436&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2010 10:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2010 10:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; general</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2010 10:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; L.M.Ericssson</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2010 11:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2010 11:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">31-08-2010 10:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0009660</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">02-09-2010 10:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR5671.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">02-09-2010 10:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0009694</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">02-09-2010 10:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Deleted: CR5671.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">02-09-2010 10:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR5671.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">02-09-2010 11:00</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Deleted: CR5671.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">02-09-2010 11:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR5671.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">02-09-2010 11:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-09-2010 09:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.3.1 (not yet published)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">26-11-2010 15:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0009809</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">26-11-2010 15:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0009810</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-11-2010 09:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0009817</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-11-2010 10:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0009821</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-11-2010 10:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Priority</td>
<td class="print">normal =&gt; low</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-12-2010 10:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">Edition 4.3.1 (not yet published) =&gt; Edition 4.3.2
(interim)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-05-2011 15:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010002</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-05-2011 15:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-05-2011 15:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; won't fix</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009660)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">31-08-2010 10:39   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Regarding the record ofs:<br />
<br />
Section 3.1 (completely initialized) states:<br />
<br />
Values and templates of structured types and arrays are completely
initialized if all their fields and elements are completely
initialized.<br />
<br />
Although it should probably be 'variables' instead of 'values'. This
error continues in the whole section.<br />
<br />
The question where a not completely initialized variable can be used is
answered in section 11.1.<br />
<br />
d) Use of uninitialized or not completely initialized value variables at
other places than the left hand side of assignments or as actual
parameters passed to inout or out formal parameters shall cause an
error.<br />
<br />
The same restriction is reiterated for template variables.<br />
<br />
For operation expressions, function calls and predefined function calls,
this restriction is also reiterated for the operands (i.e. have to be
completely initialized).<br />
<br />
=============================================================================<br />
Regarding the constants:<br />
<br />
Constants are assigned a VALUE (see section 10). Since only VARIABLES
can be unbound or partially initialized, values are always fully
initialized structures and therefore a constant is also always fully
initialized.<br />
<br />
==============================================================================<br />
<br />
Regarding the unbound-assignment question, section 19.1 states
clearly:<br />
<br />
"During execution of an assignment, the right-hand side of the
assignment shall evaluate to a value or template. The effect of an
assignment is to bind the variable to the value of the expression or to
a template. The expression shall contain no unbound variables."<br />
<br />
===============================================================================<br />
Unfortunately, there is no clear definition what a value actually is,
although lots of definitions depend on that. Thus, I think a definition
like:<br />
<br />
A value is either<br />
- a basic value (string, integer, float, enumerated) or<br />
- a structured value (record, set, union) where all mandatory fields
contain values and all optional fields contain either values or are
omitted. For union values exactly one variant must be chosen and contain
a value.<br />
<br />
Also, the term evaluation is used frequently in the standard but also
not defined. So, maybe another definition needs to be added here.<br />
<br />
The evaluation of a value expression yields a value.<br />
The evaluation of a template expression yields a template.<br />
An expression is evaluated by evaluating all operation expressions and
replacing them with the result of the evaluation. The order of
evaluation is left-to-right-inside-out. An operation expression is
evaluated by performing the operation on its evaluated operands.<br />
<br />
==============================================================================<br />
SUMMARY:<br />
<br />
in essence, the standard is consistent and the CR is moot. The only
problem that I could find is the missing definitions of value and
evaluate (and the mentioning of values instead of variables in the
initialized definitions).<br />
<br />
Therefore, the questions could be clarified by fixing this.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009694)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">02-09-2010 10:53   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I've added the following definitions:<br />
<br />
value, reference, evaluation (and they should be read in that order
because evaluation depends on value and reference)<br />
<br />
I've changed some definitions, especially 'partially initialized' and
'completely initialized' to use these terms.<br />
<br />
I've also changed the definition of value notation as it didn't make any
sense to me whatsoever.<br />
<br />
I hope this is clarification enough for this CR.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009809)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">26-11-2010 15:17   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Just a few examples of inconsistency:<br />
<br />
type record Record { integer x1, integer x2}<br />
const Record cg_rec := { x2 := 5 } //allowed!? (not forbidden)<br />
function f1(in Record pl_rec) {<br />
  var integer vl_int := pl_rec.x2<br />
}<br />
function f3() {<br />
  var integer vl_int;<br />
  var Record vl_rec := {x2:=5} //partly initialized<br />
  f1(cg_rec)} //allowed!?<br />
  f1({x2 := 5}) //allowed!<br />
  vl_int := vl_rec.f2 //allowed, but not allowed to do the same within a
function by passing vl_rec as in parameter<br />
  f1(vl_rec)} //not allowed!<br />
}<br />
        <br />
function f4(inout Record pl_rec) {...}<br />
function f5() {<br />
  var Record vl_rec := {x2:=5} //partly initialized<br />
  var template Record vt_rec := {x2:=5} //partly initialized<br />
  f4(vl_rec)} //allowed!<br />
  f4(vt_rec)} //not allowed!<br />
}<br />
<br />
We can argue if const Record cg_rec := { x2 := 5 } is allowed or not; I
know the general theory on type/value systems and saying myself that a
valid/legal value of a type shall be a complete instance of the type.
However, "value" is not defined in the standard and its also talks about
"variable value"s in contexts, when the content of a variable is not
necessary completely initialized. Therefore, what a "variable value" and
a "constant value" exactly means, is not clearly defined. Hence, if a
tool allows partly initialized constants, it cannot be claimed to be
non-conformant to the standard.<br />
<br />
And whatever is the decision regarding constants, there is still the
case of literal values(inline templates) vs. constants and
variables.<br />
<br />
Probably it is just due to the incompleteness of the text, that
incomplete value variables can be passed to inout parameters, while
incomplete template variables cannot. But still, these are
inconsistencies.<br />
<br />
Btw., it is unclear, why we mix the direction of the "content flow" with
the completeness of this content. In another words, why partly
initialized values (or how to call it?)cannot be passed to in
parameters? This has several use cases:<br />
a) during testing, the database containing data of the simulated users
is typically being completed step-by-step or some data (fields) may even
remain unbound all the time (e.g. redirected_to_number)). Currently it
is not possible to write a function to process part of the data AND to
assure that the function only reads but not changes the data in the
database. This is because incomplete data cannot be passed to in
parameters.<br />
b) during constracting a message the user need to calculate some
parameter by using a few already available other parameters from the
partly constructed message. Again, it is not possible to assure, that
the function making the calculation is not changing the content, because
no partly initialized data can be passed to in parameters.<br />
<br />
Pls. note, that in both cases above, passing the fields used within the
called function one-by-one as separate parameters is not possible:<br />
 - maintenance and backward compatibility: changes within the function
could change the function interface (new data required) that would break
existing "user" code and<br />
 - convenience, efficiency and readibility: the number of such
parameters is often quite significant.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009810)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">26-11-2010 15:18   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Just a few examples of inconsistency:<br />
<br />
type record Record { integer x1, integer x2}<br />
const Record cg_rec := { x2 := 5 } //allowed!? (not forbidden)<br />
function f1(in Record pl_rec) {<br />
  var integer vl_int := pl_rec.x2<br />
}<br />
function f3() {<br />
  var integer vl_int;<br />
  var Record vl_rec := {x2:=5} //partly initialized<br />
  f1(cg_rec)} //allowed!?<br />
  f1({x2 := 5}) //allowed!<br />
  vl_int := vl_rec.f2 //allowed, but not allowed to do the same within a
function by passing vl_rec as in parameter<br />
  f1(vl_rec)} //not allowed!<br />
}<br />
        <br />
function f4(inout Record pl_rec) {...}<br />
function f5() {<br />
  var Record vl_rec := {x2:=5} //partly initialized<br />
  var template Record vt_rec := {x2:=5} //partly initialized<br />
  f4(vl_rec)} //allowed!<br />
  f4(vt_rec)} //not allowed!<br />
}<br />
<br />
We can argue if const Record cg_rec := { x2 := 5 } is allowed or not; I
know the general theory on type/value systems and saying myself that a
valid/legal value of a type shall be a complete instance of the type.
However, "value" is not defined in the standard and its also talks about
"variable value"s in contexts, when the content of a variable is not
necessary completely initialized. Therefore, what a "variable value" and
a "constant value" exactly means, is not clearly defined. Hence, if a
tool allows partly initialized constants, it cannot be claimed to be
non-conformant to the standard.<br />
<br />
And whatever is the decision regarding constants, there is still the
case of literal values(inline templates) vs. constants and
variables.<br />
<br />
Probably it is just due to the incompleteness of the text, that
incomplete value variables can be passed to inout parameters, while
incomplete template variables cannot. But still, these are
inconsistencies.<br />
<br />
Btw., it is unclear, why we mix the direction of the "content flow" with
the completeness of this content. In another words, why partly
initialized values (or how to call it?)cannot be passed to in
parameters? This has several use cases:<br />
a) during testing, the database containing data of the simulated users
is typically being completed step-by-step or some data (fields) may even
remain unbound all the time (e.g. redirected_to_number)). Currently it
is not possible to write a function to process part of the data AND to
assure that the function only reads but not changes the data in the
database. This is because incomplete data cannot be passed to in
parameters.<br />
b) during constracting a message the user need to calculate some
parameter by using a few already available other parameters from the
partly constructed message. Again, it is not possible to assure, that
the function making the calculation is not changing the content, because
no partly initialized data can be passed to in parameters.<br />
<br />
Pls. note, that in both cases above, passing the fields used within the
called function one-by-one as separate parameters is not possible:<br />
 - maintenance and backward compatibility: changes within the function
could change the function interface (new data required) that would break
existing "user" code and<br />
 - convenience, efficiency and readibility: the number of such
parameters is often quite significant.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009817)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-11-2010 09:29   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Here's my opinion on what should be consistently
allowed/disallowed:<br />
<br />
type record Record { integer x1, integer x2}<br />
const Record cg_rec := { x2 := 5 } //allowed!? (not forbidden)<br />
<br />
FORBIDDEN<br />
<br />
function f1(in Record pl_rec) {<br />
  var integer vl_int := pl_rec.x2<br />
}<br />
function f3() {<br />
  var integer vl_int;<br />
  var Record vl_rec := {x2:=5} //partly initialized<br />
<br />
ALLOWED (although I still would forbid this syntax and allow only
assignment using dotted notation to avoid confusion with the whole
implicit/explicit omit issue)<br />
<br />
  f1(cg_rec)} //allowed!?<br />
<br />
FORBIDDEN<br />
<br />
  f1({x2 := 5}) //allowed!<br />
<br />
FORBIDDEN (not completely initialized in parameter)<br />
<br />
  vl_int := vl_rec.f2 //allowed, but not allowed to do the same within a
function by passing vl_rec as in parameter<br />
<br />
FORBIDDEN (dottet notation on right-hand-side should only work on
completely initialized variables)<br />
<br />
  f1(vl_rec)} //not allowed!<br />
<br />
FORBIDDEN (not completely initialized in parameter)<br />
}<br />
        <br />
function f4(inout Record pl_rec) {...}<br />
function f5() {<br />
  var Record vl_rec := {x2:=5} //partly initialized<br />
<br />
ALLOWED (although should be forbidden, see above)<br />
<br />
  var template Record vt_rec := {x2:=5} //partly initialized<br />
<br />
ALLOWED (althoudh should also be forbidden, see above)<br />
<br />
  f4(vl_rec)} //allowed!<br />
<br />
ALLOWED<br />
<br />
  f4(vt_rec)} //not allowed!<br />
<br />
FORBIDDEN (but only because of missing template modifier in formal
parameter in f4, otherwise should also be allowed)<br />
}<br />
<br />
The reasoning behind forbidding not completely initialzed variables as
r-values is that this allows tools to generate efficient code (not
having to do lots of is-this-field-initialized-checking at runtime which
is time-consuming)/catch user errors already at compile time to prevent
costly error-finding in the running code.<br />
<br />
So, while it might be appealing to allow the users the freedom to leave
everything partially initialized, this will always backfire later on as
the two above problems cannot be avoided otherwise.<br />
<br />
If you need to pass data structures around that you need to initialize
part-by-part, you should use optional fields for the parts that you want
to initialize later on. That way, it in in the hands of the user to know
(or ask, if necessary) if a field is already initialized before usage.
So, the language already allows your use-cases by usage of that
feature.<br />
<br />
The argument of the breaking of existing code because of additional
parameters is moot because that has been solved with the feature of the
parameters with default values. This feature (together with the
name-assignment-parameter-syntax) also pretty much solves the issue of
the a-lot-of-parameters problem.<br />
<br />
For these reasons, in my opinion we should clarify the standard in such
a way that<br />
<br />
a) a value is a completely initialized construct<br />
b) a constant is initialized with a value at declaration<br />
c) all variables can be partially initialized<br />
d) partially initialized variables can only be used on the
left-hand-side of an assignment (or as an out-parameter which is the
same as left-hand-side of an assigment).<br />
<br />
If this in the real world leads to unmanageably clumsy code, we should
think of shorthand notations which do not imply performance/maintenance
issues as allowing partially initialized constructs everywhere
does.<br />
<br />
Personally, for the same reasons and from a compiler-constructor's point
of view, I would even forbid partially initialized variables as that is
a feature which has no place in a type-safe language.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009821)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-11-2010 10:50   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I propose to put aside this CR as we cannot even agree
what is allowed today and what is not (I'm talking about the actual
text, not about what should be or not should be; but seems text itself
should be analysed in more detail). This week we shall concentrate on
CRs that have the chance to be resolved.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010002)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-05-2011 15:51   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">CR is withdrawn.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
