  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0005587</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">01-07-2010 15:10</td>
<td class="print">15-12-2010 00:02</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.3.1 (published 2011-06)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.3.1 (published 2011-06)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">???</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">STF160</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0005587: Clarification in using functions
in special places</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">Dear stf393,<br />
<br />
another question for clarification:<br />
we have several places in our test suite where in a receive event the
return value of a function is used as parameter of the receive
template,<br />
e.g.<br />
   myPCO.receive(cr_Mytemplate(f_MyFunction(), ...))<br />
<br />
Now in some cases f_MyFunction assigns a verdict and kills the
PTC.<br />
<br />
Even though this is not explicitly listed in 16.1.4 (or is this
considered as a special case of inline template ??) acc. to the
philosophy of 16.1.4 I tend to agree that this is not allowed.<br />
Bute there are some thoughts which may be taken into
consideration:<br />
- When we have a variable getting assigned the function just before the
receive statement and use this variable in the receive statement:<br />
    var MyType v_MyVar := f_MyFunction();<br />
    myPCO.receive(cr_Mytemplate(v_MyVar, ...))<br />
<br />
  That should work anyway - BUT "normal" programmers may not understand
the difference and consider this as equivalent.<br />
<br />
- Regarding the above examples: Is is it clearly specified (e.g. in part
4) at which point in time the function is performed when being parameter
in the receive statement ??<br />
<br />
- Currently there is poor support by tools to find this issues; just IBM
raises an error<br />
<br />
So as a summary: when there are restrictions on functions being used as
parameters in receive statements acc. to 16.1.4 how can we achieve that
people don't do it wrong ??<br />
Please note, that this is also an issue of tool compatibility.<br />
<br />
Thanks and regards<br />
Wolfgang<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-07-2010 15:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-07-2010 15:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; ???</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-07-2010 15:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; STF160</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-07-2010 15:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.3.1 (not yet published)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-07-2010 17:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0009457</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-07-2010 17:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0009457</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-07-2010 17:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0009457</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2010 12:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2010 12:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2010 13:55</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0009655</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-08-2010 17:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0009658</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-08-2010 17:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-09-2010 11:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0009671</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">02-09-2010 09:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">02-09-2010 09:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">02-09-2010 09:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-12-2010 00:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0009974</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-12-2010 00:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">15-12-2010 00:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; Edition 4.3.1 (not yet published)</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0009457)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">01-07-2010 17:18   <br />
(edited on: 01-07-2010 17:20)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF discussion result is:<br />
Passing a function as actual parameter to an object used in a receive
statement is a use of the function at a special place just like the
function was called directly in the receiving statement. Hence
restrictions of $16.1.4 apply.<br />
<br />
The STF agreed that the standard should be checked if all and every such
cases are handled adequately.<br />
<br />
"Is is it clearly specified (e.g. in part 4) at which point in time the
function is performed when being parameter in the receive statement ??"
-&gt; it is not defined, as functions called during snapshot evaluation
shall not change the snapshot, the exact time of evaluating the
functions has no significance. Hence the restrictions of 16.1.4.<br />
<br />
Checking those restrictions statically is not easy (for tool
implementations). So, the STF should use the IBM tool for checking the
quality of the code.<br />
<br />
Even if "normal" programmers may not understand the difference, the
case<br />
    var MyType v_MyVar := f_MyFunction();<br />
    myPCO.receive(cr_Mytemplate(v_MyVar, ...))<br />
essentially differs from calling the function in the receive statement
directly. A stand-alone receive is a shorthand for an alt with one
receiving branch plus the activated defaults, thus stimulates a
snapshot, while during a simple assignment there is no snapshot
involved, i.e. no risk of side effects.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009655)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-08-2010 13:55   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The following sentence in section 16.1.4<br />
<br />
"Value returning functions can be called during communication operations
(in templates, template fields or in-line templates)"<br />
<br />
should be changed to<br />
<br />
"Value returning functions can be called during communication operations
(in templates, template fields, in-line templates or as actual
parameters)"<br />
<br />
This way, all function calls that are used as actual parameters during
communication operations must adhere to the non-side-effect
restrictions.<br />
<br />
(Actually, I think the already existent restriction 'in templates or
in-line templates' already covers this as cr_Mytemplate(f_MyFunction(),
...) is a template and the f_MyFunction() call is part of that template
expression, but being a bit more explicit doesn't hurt here,
either)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009658)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-08-2010 17:22   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">please review</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009671)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">01-09-2010 11:15   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Ok for me.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009974)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-12-2010 00:01   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Implemented as proposed.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
