  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 06: TTCN-3 Control Interface
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0005220</td>
<td class="print">Part 06: TTCN-3 Control Interface</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">02-06-2009 14:44</td>
<td class="print">18-03-2010 07:40</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">N/A</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.2.1 (published 2010-07)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.2.1 (published 2010-07)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">TCI C++ mapping clause</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">INRIA, France</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0005220: TCI C++ Mapping Issues</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">1. The C++ mapping introduced in this new
version of the interface uses<br />
design conventions that are Java-like and are not easily
interoperable<br />
with the C++ standard libraries.<br />
eg:<br />
<br />
&gt; class TciModuleIdList {<br />
&gt; public:<br />
&gt; virtual ~TciModuleIdList();<br />
&gt; virtual Tsize size () const =0;<br />
&gt; virtual Tboolean isEmpty () const =0;<br />
--&gt; should be virtual Tboolean empty() const =0;<br />
<br />
&gt; virtual const std::vector&lt; const TciModuleId * &gt; &amp;
getComponents ()<br />
&gt; const =0;<br />
--&gt; this puts too much design constaints on the implementation of the
interface<br />
    (especially the TciModuleId needs to be stored in a vector of
pointers)<br />
<br />
&gt; virtual const TciModuleId &amp;get (Tsize p_index) const =0;<br />
--&gt; should be :<br />
    virtual const TciModuleId &amp;at (Tsize p_index) const =0;<br />
    virtual const TciModuleId operator[] (Tsize p_index) const =0;<br />
<br />
&gt; virtual void clear ()=0;<br />
&gt; virtual void add (const TciModuleId &amp;comp)=0;<br />
--&gt; should be :<br />
    virtual void push_back (const TciModuleId &amp;comp)=0;<br />
<br />
&gt; virtual Tboolean equals (const TciModuleIdList &amp;midList) const
=0;<br />
--&gt; should be :<br />
    virtual Tboolean operator== (const TciModuleIdList &amp;midList)
const =0;<br />
<br />
&gt; virtual TciModuleIdList * cloneModuleIdList () const =0;<br />
--&gt; should be : virtual TciModuleIdList * clone () const =0;<br />
<br />
&gt; virtual Tboolean operator&lt; (const TciModuleIdList &amp;midList)
const =0;<br />
&gt; }<br />
<br />
2. Section 10.5 is self-contradictory<br />
&gt; Pure virtual classes have been used, following the concept of an
interface.<br />
&gt; The Standard Template Library (STL) has been used as it is a
standardized<br />
&gt; way of using container classes, and iterators, such as lists. All
classes<br />
&gt; define the operator "&lt;" for easy insertion in STL
containers.<br />
<br />
The STL containers require that the contained class is<br />
copy-constructible. However the classes in the C++ mapping are not<br />
copy-constructible (the are abstract base classes containing pure<br />
virtual functions), therefore they cannot be used in STL
containers.<br />
Moreover, some STL containers require the operator '==' instead of
'&lt;'<br />
(eg: unordered_set and unordered_map)<br />
<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif"
alt="zip" /> es_20187306v040102.zip (1,317,758) <span
class="italic">18-03-2010 07:40</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2340&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">02-06-2009 14:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">02-06-2009 14:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">02-06-2009 14:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">02-06-2009 14:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; TCI C++ mapping clause</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">02-06-2009 14:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; INRIA, France</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-06-2009 11:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony
Baire</a></td>
<td class="print">Note Added: 0008724</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-06-2009 11:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony
Baire</a></td>
<td class="print">Note Added: 0008725</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-06-2009 13:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=552">JesÃºs
DomÃ­nguez</a></td>
<td class="print">Note Added: 0008730</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-06-2009 18:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony
Baire</a></td>
<td class="print">Note Added: 0008738</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">15-06-2009 14:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=556">Raul
Alfonso</a></td>
<td class="print">Note Added: 0008770</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-06-2009 10:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Project</td>
<td class="print">TTCN-3 Change Requests =&gt; Part 06: TTCN-3 Control
Interface</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-06-2009 10:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Category</td>
<td class="print">TCI =&gt; Clarification</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-06-2009 10:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.2.1 (not yet published)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">06-07-2009 15:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony
Baire</a></td>
<td class="print">Note Added: 0008847</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">06-07-2009 15:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony
Baire</a></td>
<td class="print">Note Edited: 0008847</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-03-2010 07:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-03-2010 07:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-03-2010 07:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; Edition 4.2.1 (not yet published)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-03-2010 07:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">File Added: es_20187306v040102.zip</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-03-2010 07:40</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0008724)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony
Baire</a>   </td>
</tr>
<tr class="odd">
<td class="print">05-06-2009 11:40   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Here is a proposal for the replacement for the
getComponents() function (and the similar function founds in other
container classes)<br />
&gt; virtual const std::vector&lt; const TciModuleId * &gt; &amp;
getComponents () const =0;<br />
<br />
As stated before, this function should be removed because it puts too
much design constaints on the implementation of the interface (it
mandates that the object stores the TciModuleId list in a vector of
pointers).<br />
<br />
In order to provide similar features, all the interface classes that
provide access to a list of elements should support the Range concept,
i.e: provide the following definitions:<br />
<br />
    typedef ##implementation_defined## const_iterator;<br />
    const_iterator begin() const;<br />
    const_iterator end() const;<br />
<br />
    The type of const_iterator is implementation defined. It shall
comply with the InputIterator concept (<a
href="http://www.cplusplus.com/reference/std/iterator/InputIterator/">http://www.cplusplus.com/reference/std/iterator/InputIterator/</a>
[<a
href="http://www.cplusplus.com/reference/std/iterator/InputIterator/"
target="_blank">^</a>]) and the dereferencement operator shall return a
const reference on the contained object.<br />
    eg: - TciModuleList::const_iterator::operator*() shall return const
TciModuleId&amp;<br />
        - TciModuleList::const_iterator::operator-&gt;() shall return
const TciModuleId*<br />
    <br />
<br />
<br />
Supporting the range concept allows inspecting easily the content of the
objects using itarators.<br />
    eg. using the boost foreach library<br />
        #include &lt;boost/foreach.hpp&gt;<br />
        ...<br />
        TciModuleIdList&amp; m_list;<br />
        ...<br />
        BOOST_FOREACH (const TciModuleId&amp; id, m_list) {<br />
            ...<br />
        }<br />
    eg. using the range-based loops in the upcoming version of the c++
standard<br />
        TciModuleIdList&amp; m_list;<br />
        ...<br />
        for (const TciModuleId&amp; id : m_list) {<br />
            ...<br />
        }</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0008725)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony
Baire</a>   </td>
</tr>
<tr class="odd">
<td class="print">05-06-2009 11:52   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Regarding section 10.5, the following text should be
removed (or possibly replaced with a paragraphe about the Range concept
above if accepted):<br />
<br />
&gt; The Standard Template Library (STL) has been used as it is a
standardized<br />
&gt; way of using container classes, and iterators, such as lists. All
classes<br />
&gt; define the operator "&lt;" for easy insertion in STL
containers<br />
<br />
<br />
The rationale for the deletion is that this paragraph is confusing since
it is not possible to insert objects that are not copy-constructible
into STL containers.<br />
<br />
[Actually this would be useable with a poiner container (eg. <a
href="http://www.boost.org/doc/libs/1_39_0/libs/ptr_container/doc/ptr_container.html">http://www.boost.org/doc/libs/1_39_0/libs/ptr_container/doc/ptr_container.html</a>
[<a
href="http://www.boost.org/doc/libs/1_39_0/libs/ptr_container/doc/ptr_container.html"
target="_blank">^</a>]). But since pointer containers are not yet
standardised, I think it's better just not to mention it and remove the
paragraph]</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0008730)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=552">JesÃºs
DomÃ­nguez</a>   </td>
</tr>
<tr class="odd">
<td class="print">08-06-2009 13:54   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">After discussion on the phone with Anthony we
understand the following things were agreed:<br />
<br />
- method "isEmpty" should be renamed to "empty"<br />
<br />
- method "getComponents" should be removed<br />
<br />
- method "get" to be changed to return a pointer (to use NULL if
"p_index" is out of bounds)<br />
virtual const TciModuleId *get (Tsize p_index) const =0;<br />
<br />
- method "add" to be renamed to "push_back"<br />
<br />
- method "equals" to be substituted with operator "=="<br />
virtual Tboolean operator== (const TciModuleIdList &amp;midList) const
=0;<br />
<br />
- method "cloneXXX" to be renamed to "clone"<br />
<br />
- section 10.5 to be changed to give a better explanation<br />
<br />
<br />
About the begin,end methods we don't agree with adding them. It was
mentioned with the getComponents method that we should not add design
constraints. But if we add the "begin","end" or more C++ standard
library methods we will obly to implement them (they are pure virtual),
making them exactly like the STL containers. Wouldn't it be easier in
that case to make directly a typedef to an STL class?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0008738)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony
Baire</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-06-2009 18:44   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Hi Jesus,<br />
<br />
<br />
defining some iterators is not a design constraint is the sense that it
does not dictate the internal structure of the class.<br />
<br />
<br />
For example to implement TciModuleIdList a developper will have to
represent internally this module list. There are lots of different ways
he may want to do that (depending on the internal design of his runtime
system) for example:<br />
<br />
* by storing references to a TciModuleId base object<br />
        std::vector&lt;TciModuleId*&gt; mModuleIdList; // -&gt; using a
STL vector of pointers<br />
    boost::ptr_vector&lt;TciModuleId&gt; mModuleIdList; // -&gt; using a
pointer container<br />
<br />
* by storing objects inherited from TciModuleId (eg. MyModuleId)<br />
    std::vector&lt;MyModuleId&gt; mModuleIdList // -&gt; using a STL
vector of MyModuleId<br />
        std::vector&lt;MyModuleId*&gt; mModuleIdList; // -&gt; using a
STL vector of pointers<br />
    boost::ptr_vector&lt;MyModuleId&gt; mModuleIdList; // -&gt; using a
pointer container<br />
<br />
* also if he's concerned by the execution speed, he may want no to use
the default allocator so as to optimise memory allocations<br />
      std::vector&lt;MyModuleId,
boost::fast_pool_allocator&lt;MyModuleId&gt; &gt; mModuleIdList;<br />
<br />
This is the reason why the getComponent() function is a strong design
constraint, because it forces the developer to store the list as a
std::vector&lt;TciModuleId*&gt;<br />
<br />
<br />
By opposition the iterators can be flexibly defined regardless the
internal design of the class, and they don't introduce any overhead in
the execution.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0008770)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=556">Raul
Alfonso</a>   </td>
</tr>
<tr class="odd">
<td class="print">15-06-2009 14:15   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Hi Anthony,<br />
<br />
getComponents() or iterators (begin &amp; end) isnâ€™t the issue.
Weâ€™re agreed with you about design restrictions in getComponents
methods and defining some iterators isnâ€™t a design restriction, but we
arenâ€™t agreed with you about add iterators (and begin and end methods)
to the interface. Why? If these methods are included we are forcing to
implement them and we think that the tci-inteface should only have
methods to use in tci context, not in other context (stl algorithms). We
use these objects with stl algorithms, but other implementations of
these interfaces may not use the stl algorithms. We think that we
shouldnâ€™t force to someone to implement this methods.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0008847)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony
Baire</a>   </td>
</tr>
<tr class="odd">
<td class="print">06-07-2009 15:48   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">getComponents() puts a constraint on the internal
design of the class: this affects the operation of the class as a whole.
Adding iterators does not affect the internal design of the class but
only its interfaces: other operations are not affected.<br />
<br />
<br />
Anyway, just removing getComponents() and not adding the iterators is an
acceptable solution for us.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
