/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE V2X Information Service REST API
 *
 * V2X Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC030 V2XI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/030/02.02.01_60/gs_MEC030v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-vis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-vis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Note**<br>AdvantEDGE supports a selected subset of RNI API endpoints (see below) and a subset of subscription types.
 *
 * API version: 2.2.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

// MsgType : Published V2X message type. Its value is defined by the standardization organization indicated by the attribute stdOrganization. See note 2. − denm(1): Decentralized Environmental Notification Message (DENM) as specified in ETSI EN 302 637-3, − cam(2): Cooperative Awareness Message (CAM) as specified in ETSI EN 302 637-2, − poi(3): Point of Interest message as specified in ETSI TS 101 556-1, − spatem(4): Signal Phase And Timing (SPAT) message as specified in SAE J2735 and in ETSI TS 103 301, − mapem(5): MAP message as specified in SAE J2735 and in ETSI TS 103 301, − ivim(6): In Vehicle Information (IVI) message as defined in ISO TS 19321, − ev-rsr(7): Electric vehicle recharging spot reservation message, as defined in ETSI TS 101 556-3, − tistpgtransaction(8): messages for Tyre Information System (TIS) and Tyre Pressure Gauge (TPG) interoperability, as specified in ETSI TS 101 556-2, − srem(9): Traffic light Signal Request Message as specified in ETSI TS 103 301, − ssem(10): Traffic Light Signal Request Status Message as specified in ETSI TS 103 301. − evcsn(11): Electrical Vehicle Charging Spot Notification message as specified in ETSI TS 101 556-1, − saem(12): Services Announcement Extended Message as specified in ETSI TS 102 890-1, − rtcmem(13): Radio Technical Commission for Maritime Services (RTCM) Message as specified in ETSI TS 103 301,
type MsgType int32

// List of MsgType
const (
	DENM              MsgType = 1
	CAM               MsgType = 2
	POI               MsgType = 3
	SPATEM            MsgType = 4
	MAPEM             MsgType = 5
	IVIM              MsgType = 6
	EV_RSR            MsgType = 7
	TISTPGTRANSACTION MsgType = 8
	SREM              MsgType = 9
	SSEM              MsgType = 10
	EVCSN             MsgType = 11
	SAEM              MsgType = 12
	RTCMEM            MsgType = 13
)
