/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE WLAN Access Information API
 *
 * WLAN Access Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC028 WAI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/028/02.02.01_60/gs_MEC028v020201p.pdf) <p>[Copyright (c) ETSI 2020](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-wais](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-wais) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about WLAN access information in the network <p>**Note**<br>AdvantEDGE supports a selected subset of WAI API subscription types. <p>Supported subscriptions: <p> - AssocStaSubscription <p> - StaDataRateSubscription
 *
 * API version: 2.2.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

type CivicLocation struct {
	// Language
	Ca0 string `json:"ca0,omitempty"`
	// National subdivisions (state, canton, region, province, prefecture)
	Ca1 string `json:"ca1,omitempty"`
	// Script
	Ca128 string `json:"ca128,omitempty"`
	// Leading street direction
	Ca16 string `json:"ca16,omitempty"`
	// Trailing street suffix
	Ca17 string `json:"ca17,omitempty"`
	// Street suffix or type
	Ca18 string `json:"ca18,omitempty"`
	// House number
	Ca19 string `json:"ca19,omitempty"`
	// County, parish, gun (JP), district (IN)
	Ca2 string `json:"ca2,omitempty"`
	// House number suffix
	Ca20 string `json:"ca20,omitempty"`
	// Landmark of vanity address
	Ca21 string `json:"ca21,omitempty"`
	// Additional location information
	Ca22 string `json:"ca22,omitempty"`
	// Name (residence and office occupant)
	Ca23 string `json:"ca23,omitempty"`
	// Postal/zip code
	Ca24 string `json:"ca24,omitempty"`
	// Building (structure)
	Ca25 string `json:"ca25,omitempty"`
	// Unit (apartment/suite)
	Ca26 string `json:"ca26,omitempty"`
	// Floor
	Ca27 string `json:"ca27,omitempty"`
	// Room
	Ca28 string `json:"ca28,omitempty"`
	// Type of place
	Ca29 string `json:"ca29,omitempty"`
	// City, township, shi (JP)
	Ca3 string `json:"ca3,omitempty"`
	// Postal community name
	Ca30 string `json:"ca30,omitempty"`
	// Post office box
	Ca31 string `json:"ca31,omitempty"`
	// Additional code
	Ca32 string `json:"ca32,omitempty"`
	// Seat (desk.cubicle, workstation)
	Ca33 string `json:"ca33,omitempty"`
	// Primary road name
	Ca34 string `json:"ca34,omitempty"`
	// Road section
	Ca35 string `json:"ca35,omitempty"`
	// Branch road name
	Ca36 string `json:"ca36,omitempty"`
	// Sub-branch road name
	Ca37 string `json:"ca37,omitempty"`
	// Street name pre-modifier
	Ca38 string `json:"ca38,omitempty"`
	// Street name post-modifier
	Ca39 string `json:"ca39,omitempty"`
	// City division, borough, city district, ward, chou (JP)
	Ca4 string `json:"ca4,omitempty"`
	// Neighborhood, block
	Ca5 string `json:"ca5,omitempty"`
	// Group of streets below the neighborhood level
	Ca6 string `json:"ca6,omitempty"`
	// The two-letter ISO 3166 [i.9] country code in capital ASCII letters, e.g. DE or US, as per ISO 3166 [i.9]
	Country string `json:"country"`
}
