/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Sandbox Controller REST API
 *
 * This API is the main Sandbox Controller API for scenario deployment & event injection <p>**Micro-service**<br>[meep-sandbox-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-sandbox-ctrl) <p>**Type & Usage**<br>Platform runtime interface to manage active scenarios and inject events in AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
	"strings"

	"github.com/antihax/optional"
)

// Linger please
var (
	_ context.Context
)

type ActiveScenarioApiService service

/*
ActiveScenarioApiService Deploy a scenario
Deploy a scenario present in the platform scenario store
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param name Scenario name
 * @param optional nil or *ActivateScenarioOpts - Optional Parameters:
     * @param "ActivationInfo" (optional.Interface of ActivationInfo) -  Activation information


*/

type ActivateScenarioOpts struct {
	ActivationInfo optional.Interface
}

func (a *ActiveScenarioApiService) ActivateScenario(ctx context.Context, name string, localVarOptionals *ActivateScenarioOpts) (*http.Response, error) {
	var (
		localVarHttpMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/active/{name}"
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", fmt.Sprintf("%v", name), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHttpContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	// body params
	if localVarOptionals != nil && localVarOptionals.ActivationInfo.IsSet() {

		localVarOptionalActivationInfo, localVarOptionalActivationInfook := localVarOptionals.ActivationInfo.Value().(ActivationInfo)
		if !localVarOptionalActivationInfook {
			return nil, reportError("activationInfo should be ActivationInfo")
		}
		localVarPostBody = &localVarOptionalActivationInfo
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		return localVarHttpResponse, newErr
	}

	return localVarHttpResponse, nil
}

/*
ActiveScenarioApiService Get deployed scenario&#39;s port mapping
Returns the deployed scenario&#39;s port mapping&lt;p&gt; &lt;li&gt;Ports are used by external nodes to access services internal to the platform &lt;li&gt;Port mapping concept for external nodes is available [here](https://github.com/InterDigitalInc/AdvantEDGE/wiki/external-ue#port-mapping)
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param optional nil or *GetActiveNodeServiceMapsOpts - Optional Parameters:
     * @param "Node" (optional.String) -  Unique node identifier
     * @param "Type_" (optional.String) -  Exposed service type (ingress or egress)
     * @param "Service" (optional.String) -  Exposed service name

@return []NodeServiceMaps
*/

type GetActiveNodeServiceMapsOpts struct {
	Node    optional.String
	Type_   optional.String
	Service optional.String
}

func (a *ActiveScenarioApiService) GetActiveNodeServiceMaps(ctx context.Context, localVarOptionals *GetActiveNodeServiceMapsOpts) ([]NodeServiceMaps, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue []NodeServiceMaps
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/active/serviceMaps"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.Node.IsSet() {
		localVarQueryParams.Add("node", parameterToString(localVarOptionals.Node.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Type_.IsSet() {
		localVarQueryParams.Add("type", parameterToString(localVarOptionals.Type_.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Service.IsSet() {
		localVarQueryParams.Add("service", parameterToString(localVarOptionals.Service.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		if err == nil {
			return localVarReturnValue, localVarHttpResponse, err
		}
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v []NodeServiceMaps
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
ActiveScenarioApiService Get the deployed scenario
Get the scenario currently deployed on the platform
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param optional nil or *GetActiveScenarioOpts - Optional Parameters:
     * @param "Minimize" (optional.Bool) -  Return minimized scenario element content

@return Scenario
*/

type GetActiveScenarioOpts struct {
	Minimize optional.Bool
}

func (a *ActiveScenarioApiService) GetActiveScenario(ctx context.Context, localVarOptionals *GetActiveScenarioOpts) (Scenario, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue Scenario
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/active"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.Minimize.IsSet() {
		localVarQueryParams.Add("minimize", parameterToString(localVarOptionals.Minimize.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		if err == nil {
			return localVarReturnValue, localVarHttpResponse, err
		}
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v Scenario
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
ActiveScenarioApiService Get domain elements from the deployed scenario
Returns a filtered list of domain elements from the deployed scenario using the provided query parameters
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param optional nil or *GetActiveScenarioDomainOpts - Optional Parameters:
     * @param "Domain" (optional.String) -  Domain name
     * @param "DomainType" (optional.String) -  Domain type
     * @param "Zone" (optional.String) -  Zone name
     * @param "NetworkLocation" (optional.String) -  Network Location name
     * @param "NetworkLocationType" (optional.String) -  Network Location type
     * @param "PhysicalLocation" (optional.String) -  Physical Location name
     * @param "PhysicalLocationType" (optional.String) -  Physical Location type
     * @param "Process" (optional.String) -  Process name
     * @param "ProcessType" (optional.String) -  Process type
     * @param "ExcludeChildren" (optional.Bool) -  Include child elements in response
     * @param "Minimize" (optional.Bool) -  Return minimized scenario element content

@return Domains
*/

type GetActiveScenarioDomainOpts struct {
	Domain               optional.String
	DomainType           optional.String
	Zone                 optional.String
	NetworkLocation      optional.String
	NetworkLocationType  optional.String
	PhysicalLocation     optional.String
	PhysicalLocationType optional.String
	Process              optional.String
	ProcessType          optional.String
	ExcludeChildren      optional.Bool
	Minimize             optional.Bool
}

func (a *ActiveScenarioApiService) GetActiveScenarioDomain(ctx context.Context, localVarOptionals *GetActiveScenarioDomainOpts) (Domains, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue Domains
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/active/domains"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.Domain.IsSet() {
		localVarQueryParams.Add("domain", parameterToString(localVarOptionals.Domain.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DomainType.IsSet() {
		localVarQueryParams.Add("domainType", parameterToString(localVarOptionals.DomainType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Zone.IsSet() {
		localVarQueryParams.Add("zone", parameterToString(localVarOptionals.Zone.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NetworkLocation.IsSet() {
		localVarQueryParams.Add("networkLocation", parameterToString(localVarOptionals.NetworkLocation.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NetworkLocationType.IsSet() {
		localVarQueryParams.Add("networkLocationType", parameterToString(localVarOptionals.NetworkLocationType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.PhysicalLocation.IsSet() {
		localVarQueryParams.Add("physicalLocation", parameterToString(localVarOptionals.PhysicalLocation.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.PhysicalLocationType.IsSet() {
		localVarQueryParams.Add("physicalLocationType", parameterToString(localVarOptionals.PhysicalLocationType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Process.IsSet() {
		localVarQueryParams.Add("process", parameterToString(localVarOptionals.Process.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ProcessType.IsSet() {
		localVarQueryParams.Add("processType", parameterToString(localVarOptionals.ProcessType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ExcludeChildren.IsSet() {
		localVarQueryParams.Add("excludeChildren", parameterToString(localVarOptionals.ExcludeChildren.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Minimize.IsSet() {
		localVarQueryParams.Add("minimize", parameterToString(localVarOptionals.Minimize.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		if err == nil {
			return localVarReturnValue, localVarHttpResponse, err
		}
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v Domains
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
ActiveScenarioApiService Get network location elements from the deployed scenario
Returns a filtered list of network location elements from the deployed scenario using the provided query parameters
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param optional nil or *GetActiveScenarioNetworkLocationOpts - Optional Parameters:
     * @param "Domain" (optional.String) -  Domain name
     * @param "DomainType" (optional.String) -  Domain type
     * @param "Zone" (optional.String) -  Zone name
     * @param "NetworkLocation" (optional.String) -  Network Location name
     * @param "NetworkLocationType" (optional.String) -  Network Location type
     * @param "PhysicalLocation" (optional.String) -  Physical Location name
     * @param "PhysicalLocationType" (optional.String) -  Physical Location type
     * @param "Process" (optional.String) -  Process name
     * @param "ProcessType" (optional.String) -  Process type
     * @param "ExcludeChildren" (optional.Bool) -  Include child elements in response
     * @param "Minimize" (optional.Bool) -  Return minimized scenario element content

@return NetworkLocations
*/

type GetActiveScenarioNetworkLocationOpts struct {
	Domain               optional.String
	DomainType           optional.String
	Zone                 optional.String
	NetworkLocation      optional.String
	NetworkLocationType  optional.String
	PhysicalLocation     optional.String
	PhysicalLocationType optional.String
	Process              optional.String
	ProcessType          optional.String
	ExcludeChildren      optional.Bool
	Minimize             optional.Bool
}

func (a *ActiveScenarioApiService) GetActiveScenarioNetworkLocation(ctx context.Context, localVarOptionals *GetActiveScenarioNetworkLocationOpts) (NetworkLocations, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue NetworkLocations
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/active/networkLocations"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.Domain.IsSet() {
		localVarQueryParams.Add("domain", parameterToString(localVarOptionals.Domain.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DomainType.IsSet() {
		localVarQueryParams.Add("domainType", parameterToString(localVarOptionals.DomainType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Zone.IsSet() {
		localVarQueryParams.Add("zone", parameterToString(localVarOptionals.Zone.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NetworkLocation.IsSet() {
		localVarQueryParams.Add("networkLocation", parameterToString(localVarOptionals.NetworkLocation.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NetworkLocationType.IsSet() {
		localVarQueryParams.Add("networkLocationType", parameterToString(localVarOptionals.NetworkLocationType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.PhysicalLocation.IsSet() {
		localVarQueryParams.Add("physicalLocation", parameterToString(localVarOptionals.PhysicalLocation.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.PhysicalLocationType.IsSet() {
		localVarQueryParams.Add("physicalLocationType", parameterToString(localVarOptionals.PhysicalLocationType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Process.IsSet() {
		localVarQueryParams.Add("process", parameterToString(localVarOptionals.Process.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ProcessType.IsSet() {
		localVarQueryParams.Add("processType", parameterToString(localVarOptionals.ProcessType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ExcludeChildren.IsSet() {
		localVarQueryParams.Add("excludeChildren", parameterToString(localVarOptionals.ExcludeChildren.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Minimize.IsSet() {
		localVarQueryParams.Add("minimize", parameterToString(localVarOptionals.Minimize.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		if err == nil {
			return localVarReturnValue, localVarHttpResponse, err
		}
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v NetworkLocations
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
ActiveScenarioApiService Get physical location elements from the deployed scenario
Returns a filtered list of physical location elements from the deployed scenario using the provided query parameters
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param optional nil or *GetActiveScenarioPhysicalLocationOpts - Optional Parameters:
     * @param "Domain" (optional.String) -  Domain name
     * @param "DomainType" (optional.String) -  Domain type
     * @param "Zone" (optional.String) -  Zone name
     * @param "NetworkLocation" (optional.String) -  Network Location name
     * @param "NetworkLocationType" (optional.String) -  Network Location type
     * @param "PhysicalLocation" (optional.String) -  Physical Location name
     * @param "PhysicalLocationType" (optional.String) -  Physical Location type
     * @param "Process" (optional.String) -  Process name
     * @param "ProcessType" (optional.String) -  Process type
     * @param "ExcludeChildren" (optional.Bool) -  Include child elements in response
     * @param "Minimize" (optional.Bool) -  Return minimized scenario element content

@return PhysicalLocations
*/

type GetActiveScenarioPhysicalLocationOpts struct {
	Domain               optional.String
	DomainType           optional.String
	Zone                 optional.String
	NetworkLocation      optional.String
	NetworkLocationType  optional.String
	PhysicalLocation     optional.String
	PhysicalLocationType optional.String
	Process              optional.String
	ProcessType          optional.String
	ExcludeChildren      optional.Bool
	Minimize             optional.Bool
}

func (a *ActiveScenarioApiService) GetActiveScenarioPhysicalLocation(ctx context.Context, localVarOptionals *GetActiveScenarioPhysicalLocationOpts) (PhysicalLocations, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue PhysicalLocations
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/active/physicalLocations"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.Domain.IsSet() {
		localVarQueryParams.Add("domain", parameterToString(localVarOptionals.Domain.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DomainType.IsSet() {
		localVarQueryParams.Add("domainType", parameterToString(localVarOptionals.DomainType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Zone.IsSet() {
		localVarQueryParams.Add("zone", parameterToString(localVarOptionals.Zone.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NetworkLocation.IsSet() {
		localVarQueryParams.Add("networkLocation", parameterToString(localVarOptionals.NetworkLocation.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NetworkLocationType.IsSet() {
		localVarQueryParams.Add("networkLocationType", parameterToString(localVarOptionals.NetworkLocationType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.PhysicalLocation.IsSet() {
		localVarQueryParams.Add("physicalLocation", parameterToString(localVarOptionals.PhysicalLocation.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.PhysicalLocationType.IsSet() {
		localVarQueryParams.Add("physicalLocationType", parameterToString(localVarOptionals.PhysicalLocationType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Process.IsSet() {
		localVarQueryParams.Add("process", parameterToString(localVarOptionals.Process.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ProcessType.IsSet() {
		localVarQueryParams.Add("processType", parameterToString(localVarOptionals.ProcessType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ExcludeChildren.IsSet() {
		localVarQueryParams.Add("excludeChildren", parameterToString(localVarOptionals.ExcludeChildren.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Minimize.IsSet() {
		localVarQueryParams.Add("minimize", parameterToString(localVarOptionals.Minimize.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		if err == nil {
			return localVarReturnValue, localVarHttpResponse, err
		}
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v PhysicalLocations
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
ActiveScenarioApiService Get process elements from the deployed scenario
Returns a filtered list of process elements from the deployed scenario using the provided query parameters
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param optional nil or *GetActiveScenarioProcessOpts - Optional Parameters:
     * @param "Domain" (optional.String) -  Domain name
     * @param "DomainType" (optional.String) -  Domain type
     * @param "Zone" (optional.String) -  Zone name
     * @param "NetworkLocation" (optional.String) -  Network Location name
     * @param "NetworkLocationType" (optional.String) -  Network Location type
     * @param "PhysicalLocation" (optional.String) -  Physical Location name
     * @param "PhysicalLocationType" (optional.String) -  Physical Location type
     * @param "Process" (optional.String) -  Process name
     * @param "ProcessType" (optional.String) -  Process type
     * @param "ExcludeChildren" (optional.Bool) -  Include child elements in response
     * @param "Minimize" (optional.Bool) -  Return minimized scenario element content

@return Processes
*/

type GetActiveScenarioProcessOpts struct {
	Domain               optional.String
	DomainType           optional.String
	Zone                 optional.String
	NetworkLocation      optional.String
	NetworkLocationType  optional.String
	PhysicalLocation     optional.String
	PhysicalLocationType optional.String
	Process              optional.String
	ProcessType          optional.String
	ExcludeChildren      optional.Bool
	Minimize             optional.Bool
}

func (a *ActiveScenarioApiService) GetActiveScenarioProcess(ctx context.Context, localVarOptionals *GetActiveScenarioProcessOpts) (Processes, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue Processes
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/active/processes"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.Domain.IsSet() {
		localVarQueryParams.Add("domain", parameterToString(localVarOptionals.Domain.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DomainType.IsSet() {
		localVarQueryParams.Add("domainType", parameterToString(localVarOptionals.DomainType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Zone.IsSet() {
		localVarQueryParams.Add("zone", parameterToString(localVarOptionals.Zone.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NetworkLocation.IsSet() {
		localVarQueryParams.Add("networkLocation", parameterToString(localVarOptionals.NetworkLocation.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NetworkLocationType.IsSet() {
		localVarQueryParams.Add("networkLocationType", parameterToString(localVarOptionals.NetworkLocationType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.PhysicalLocation.IsSet() {
		localVarQueryParams.Add("physicalLocation", parameterToString(localVarOptionals.PhysicalLocation.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.PhysicalLocationType.IsSet() {
		localVarQueryParams.Add("physicalLocationType", parameterToString(localVarOptionals.PhysicalLocationType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Process.IsSet() {
		localVarQueryParams.Add("process", parameterToString(localVarOptionals.Process.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ProcessType.IsSet() {
		localVarQueryParams.Add("processType", parameterToString(localVarOptionals.ProcessType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ExcludeChildren.IsSet() {
		localVarQueryParams.Add("excludeChildren", parameterToString(localVarOptionals.ExcludeChildren.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Minimize.IsSet() {
		localVarQueryParams.Add("minimize", parameterToString(localVarOptionals.Minimize.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		if err == nil {
			return localVarReturnValue, localVarHttpResponse, err
		}
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v Processes
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
ActiveScenarioApiService Get zone elements from the deployed scenario
Returns a filtered list of zone elements from the deployed scenario using the provided query parameters
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param optional nil or *GetActiveScenarioZoneOpts - Optional Parameters:
     * @param "Domain" (optional.String) -  Domain name
     * @param "DomainType" (optional.String) -  Domain type
     * @param "Zone" (optional.String) -  Zone name
     * @param "NetworkLocation" (optional.String) -  Network Location name
     * @param "NetworkLocationType" (optional.String) -  Network Location type
     * @param "PhysicalLocation" (optional.String) -  Physical Location name
     * @param "PhysicalLocationType" (optional.String) -  Physical Location type
     * @param "Process" (optional.String) -  Process name
     * @param "ProcessType" (optional.String) -  Process type
     * @param "ExcludeChildren" (optional.Bool) -  Include child elements in response
     * @param "Minimize" (optional.Bool) -  Return minimized scenario element content

@return Zones
*/

type GetActiveScenarioZoneOpts struct {
	Domain               optional.String
	DomainType           optional.String
	Zone                 optional.String
	NetworkLocation      optional.String
	NetworkLocationType  optional.String
	PhysicalLocation     optional.String
	PhysicalLocationType optional.String
	Process              optional.String
	ProcessType          optional.String
	ExcludeChildren      optional.Bool
	Minimize             optional.Bool
}

func (a *ActiveScenarioApiService) GetActiveScenarioZone(ctx context.Context, localVarOptionals *GetActiveScenarioZoneOpts) (Zones, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue Zones
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/active/zones"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.Domain.IsSet() {
		localVarQueryParams.Add("domain", parameterToString(localVarOptionals.Domain.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DomainType.IsSet() {
		localVarQueryParams.Add("domainType", parameterToString(localVarOptionals.DomainType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Zone.IsSet() {
		localVarQueryParams.Add("zone", parameterToString(localVarOptionals.Zone.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NetworkLocation.IsSet() {
		localVarQueryParams.Add("networkLocation", parameterToString(localVarOptionals.NetworkLocation.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NetworkLocationType.IsSet() {
		localVarQueryParams.Add("networkLocationType", parameterToString(localVarOptionals.NetworkLocationType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.PhysicalLocation.IsSet() {
		localVarQueryParams.Add("physicalLocation", parameterToString(localVarOptionals.PhysicalLocation.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.PhysicalLocationType.IsSet() {
		localVarQueryParams.Add("physicalLocationType", parameterToString(localVarOptionals.PhysicalLocationType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Process.IsSet() {
		localVarQueryParams.Add("process", parameterToString(localVarOptionals.Process.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ProcessType.IsSet() {
		localVarQueryParams.Add("processType", parameterToString(localVarOptionals.ProcessType.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ExcludeChildren.IsSet() {
		localVarQueryParams.Add("excludeChildren", parameterToString(localVarOptionals.ExcludeChildren.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Minimize.IsSet() {
		localVarQueryParams.Add("minimize", parameterToString(localVarOptionals.Minimize.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		if err == nil {
			return localVarReturnValue, localVarHttpResponse, err
		}
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v Zones
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
ActiveScenarioApiService Terminate the deployed scenario
Terminate the scenario currently deployed on the platform
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().


*/
func (a *ActiveScenarioApiService) TerminateScenario(ctx context.Context) (*http.Response, error) {
	var (
		localVarHttpMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/active"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHttpContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		return localVarHttpResponse, newErr
	}

	return localVarHttpResponse, nil
}
